/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing;

import biz.netup.swing.JSideMenuItem;
import biz.netup.swing.plaf.SideMenuGroupUI;
import biz.netup.utmutils.control.Utils;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.UIManager;

public class JSideMenuGroup
extends AbstractButton
implements Accessible {
    private static final String uiClassID = "SideMenuGroupUI";
    private boolean minimized = true;
    private HashMap<Component, Boolean> savedVisibility = new HashMap();
    private Color borderColor = Color.BLACK;

    @Override
    public Component add(Component component) {
        if (component instanceof JSideMenuItem && ((JSideMenuItem)component).getTab() != null && Utils.isAdmin() && !((JSideMenuItem)component).getTab().isAllowedRefresh()) {
            return null;
        }
        return super.add(component);
    }

    public JSideMenuGroup() {
        this(null);
    }

    public JSideMenuGroup(String string) {
        if (string != null) {
            this.setText(string);
        }
        this.setFocusable(true);
        this.updateUI();
    }

    @Override
    public void updateUI() {
        this.setUI((SideMenuGroupUI)UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    public void setMinimized(boolean bl) {
        if (this.minimized != bl) {
            int n;
            Object object;
            if (bl) {
                object = this.getComponents();
                for (n = 0; n < ((Component[])object).length; ++n) {
                    this.savedVisibility.put(object[n], new Boolean(object[n].isVisible()));
                    object[n].setVisible(false);
                }
            } else {
                object = this.getComponents();
                for (n = 0; n < ((Component[])object).length; ++n) {
                    Boolean bl2 = this.savedVisibility.get(object[n]);
                    object[n].setVisible(bl2 == null ? true : bl2);
                }
                this.savedVisibility.clear();
            }
            this.minimized = bl;
            this.revalidate();
            this.repaint();
            if (null != this.getParent() && null != this.getParent().getParent() && this.getParent().getParent().getParent() instanceof JScrollPane) {
                double d;
                object = (JViewport)this.getParent().getParent();
                JScrollPane jScrollPane = (JScrollPane)this.getParent().getParent().getParent();
                double d2 = ((JComponent)object).getPreferredSize().getHeight();
                if (d2 < (d = jScrollPane.getSize().getHeight())) {
                    return;
                }
            }
            if (!this.minimized) {
                for (int i = 0; i < this.getParent().getComponentCount(); ++i) {
                    Component component = this.getParent().getComponent(i);
                    if (this == component || !(component instanceof JSideMenuGroup)) continue;
                    JSideMenuGroup jSideMenuGroup = (JSideMenuGroup)component;
                    jSideMenuGroup.setMinimized(true);
                }
            }
        }
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJSideMenuGroup();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJSideMenuGroup
    extends AbstractButton.AccessibleAbstractButton {
        protected AccessibleJSideMenuGroup() {
            super(JSideMenuGroup.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TOGGLE_BUTTON;
        }
    }
}

