/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing;

import biz.netup.swing.plaf.looks.plastic.theme.ExperienceBlue;
import biz.netup.swing.plaf.utm.UtmLookAndFeel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class AutoCompletionExt
extends PlainDocument {
    JComboBox comboBox;
    AutoCompletionComboBoxModel model;
    JTextComponent editor;
    boolean isAppendable = true;
    boolean selecting = false;
    boolean filtering = false;
    boolean hidePopupOnFocusLoss;
    boolean hitBackspace = false;
    boolean hitBackspaceOnSelection;
    KeyListener editorKeyListener;
    FocusListener editorFocusListener;

    public AutoCompletionExt(JComboBox jComboBox) {
        this(jComboBox, true);
    }

    public AutoCompletionExt(final JComboBox jComboBox, boolean bl) {
        this.comboBox = jComboBox;
        this.isAppendable = bl;
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AutoCompletionExt.this.selecting) {
                    AutoCompletionExt.this.highlightCompletedText(0);
                }
            }
        });
        jComboBox.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("editor")) {
                    AutoCompletionExt.this.configureEditor((ComboBoxEditor)propertyChangeEvent.getNewValue());
                }
            }
        });
        MutableComboBoxModel mutableComboBoxModel = (MutableComboBoxModel)jComboBox.getModel();
        this.model = new AutoCompletionComboBoxModel();
        jComboBox.setModel(this.model);
        this.editorKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (jComboBox.isDisplayable()) {
                    jComboBox.setPopupVisible(true);
                }
                AutoCompletionExt.this.hitBackspace = false;
                switch (keyEvent.getKeyCode()) {
                    case 8: {
                        AutoCompletionExt.this.hitBackspace = true;
                        AutoCompletionExt.this.hitBackspaceOnSelection = AutoCompletionExt.this.editor.getSelectionStart() != AutoCompletionExt.this.editor.getSelectionEnd();
                        break;
                    }
                    case 127: {
                        if (!AutoCompletionExt.this.isAppendable) {
                            keyEvent.consume();
                            jComboBox.getToolkit().beep();
                            break;
                        }
                        AutoCompletionExt.this.model.setAutoCompletionPrefix("");
                    }
                }
            }
        };
        this.hidePopupOnFocusLoss = System.getProperty("java.version").startsWith("1.5");
        this.editorFocusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                AutoCompletionExt.this.highlightCompletedText(0);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (AutoCompletionExt.this.hidePopupOnFocusLoss) {
                    jComboBox.setPopupVisible(false);
                }
                try {
                    AutoCompletionExt.this.setPrefix(0);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        };
        this.configureEditor(jComboBox.getEditor());
        Object object = jComboBox.getSelectedItem();
        if (object != null) {
            this.setText(object.toString());
        }
        this.highlightCompletedText(0);
        for (int i = 0; i < mutableComboBoxModel.getSize(); ++i) {
            this.model.addElement(mutableComboBoxModel.getElementAt(i));
        }
    }

    public static void enable(JComboBox jComboBox) {
        AutoCompletionExt.enable(jComboBox, true);
    }

    public static void enable(JComboBox jComboBox, boolean bl) {
        jComboBox.setEditable(true);
        new AutoCompletionExt(jComboBox, bl);
    }

    void configureEditor(ComboBoxEditor comboBoxEditor) {
        if (this.editor != null) {
            this.editor.removeKeyListener(this.editorKeyListener);
            this.editor.removeFocusListener(this.editorFocusListener);
        }
        if (comboBoxEditor != null) {
            this.editor = (JTextComponent)comboBoxEditor.getEditorComponent();
            this.editor.addKeyListener(this.editorKeyListener);
            this.editor.addFocusListener(this.editorFocusListener);
            this.editor.setDocument(this);
        }
    }

    @Override
    public void remove(int n, int n2) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        if (this.filtering) {
            return;
        }
        if (this.hitBackspace) {
            if (n > 0) {
                if (this.hitBackspaceOnSelection) {
                    --n;
                }
            } else {
                this.comboBox.getToolkit().beep();
            }
            this.setPrefix(n);
            Object object = this.lookupItem(this.getText(0, this.getLength()));
            if (object != null) {
                this.setText(object.toString());
                this.highlightCompletedText(n);
                this.setPrefix(n);
            } else {
                super.remove(n, n2);
                object = this.lookupItem(this.getText(0, this.getLength()));
                if (object != null) {
                    this.setText(object.toString());
                    this.highlightCompletedText(n);
                }
            }
        } else {
            super.remove(n, n2);
        }
    }

    private void setPrefix(int n) throws BadLocationException {
        this.filtering = true;
        this.model.setAutoCompletionPrefix(this.getText(0, n));
        this.filtering = false;
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        if (this.filtering) {
            return;
        }
        super.insertString(n, string, attributeSet);
        if (string.length() > 1) {
            return;
        }
        Object object = this.lookupItem(this.getText(0, this.getLength()));
        if (object != null) {
            this.setSelectedItem(object);
        } else {
            if (this.isAppendable) {
                this.setPrefix(n + 1);
                return;
            }
            object = this.comboBox.getSelectedItem();
            n -= string.length();
            this.comboBox.getToolkit().beep();
        }
        this.setText(object.toString());
        this.highlightCompletedText(n + string.length());
        this.setPrefix(n + 1);
    }

    private void setText(String string) {
        try {
            super.remove(0, this.getLength());
            super.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException(badLocationException.toString());
        }
    }

    private void highlightCompletedText(int n) {
        this.editor.setCaretPosition(this.getLength());
        this.editor.moveCaretPosition(n);
    }

    private void setSelectedItem(Object object) {
        this.selecting = true;
        this.model.setSelectedItem(object);
        this.comboBox.repaint();
        this.selecting = false;
    }

    private Object lookupItem(String string) {
        Object object = this.model.getSelectedItem();
        if (object != null && this.startsWithIgnoreCase(object.toString(), string)) {
            return object;
        }
        int n = this.model.data.size();
        for (int i = 0; i < n; ++i) {
            Object e = this.model.data.get(i);
            if (e == null || !this.startsWithIgnoreCase(e.toString(), string)) continue;
            return e;
        }
        return null;
    }

    private boolean startsWithIgnoreCase(String string, String string2) {
        if (null == string) {
            return false;
        }
        return string.toUpperCase().startsWith(string2.toUpperCase());
    }

    private static void createAndShowGUI() {
        Serializable serializable;
        try {
            serializable = new UtmLookAndFeel();
            UtmLookAndFeel.setMyCurrentTheme(new ExperienceBlue());
            UIManager.setLookAndFeel((LookAndFeel)((Object)serializable));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        serializable = new JComboBox();
        AutoCompletionExt.enable((JComboBox)serializable, true);
        ((JComboBox)serializable).removeAllItems();
        ((JComboBox)serializable).addItem("asdf");
        ((JComboBox)serializable).addItem("asdf1");
        ((JComboBox)serializable).addItem("asdf2");
        ((JComboBox)serializable).addItem("asdf3");
        ((JComboBox)serializable).addItem("asdf4");
        ((JComboBox)serializable).addItem("asdf5");
        ((JComboBox)serializable).addItem("asdf6");
        ((JComboBox)serializable).addItem("asdf7");
        ((JComboBox)serializable).addItem("asdf8");
        ((JComboBox)serializable).addItem("asdf9");
        ((JComboBox)serializable).addItem("asdf10");
        ((JComboBox)serializable).addItem("asdf0");
        ((JComboBox)serializable).addItem("aszx1");
        ((JComboBox)serializable).addItem("aszx2");
        ((JComboBox)serializable).addItem("test");
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add((Component)serializable);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AutoCompletionExt.createAndShowGUI();
            }
        });
    }

    public static class AutoCompletionComboBoxModel
    extends AbstractListModel
    implements MutableComboBoxModel {
        public ArrayList data = new ArrayList();
        protected Object[] cache;
        protected TreeSet cachet;
        protected Object[] filtered_cache;
        protected int size = -1;
        protected int filtered_size = -1;
        protected Object selected;
        protected String prefix = "";

        AutoCompletionComboBoxModel() {
        }

        public void removeAll() {
            this.size = -1;
            this.data.clear();
            this.fireContentsChanged(this, -1, -1);
        }

        public void setAutoCompletionPrefix(String string) {
            if (this.prefix.equals(string)) {
                return;
            }
            this.prefix = string;
            if (this.filtered_size > 0) {
                this.fireIntervalRemoved(this, 0, this.filtered_size - 1);
            }
            this.filtered_size = -1;
            this.getSize();
            if (this.filtered_size > 0) {
                this.fireIntervalAdded(this, 0, this.filtered_size - 1);
            }
        }

        public final void addElement(Object object) {
            if (this.data.contains(object)) {
                return;
            }
            this.size = -1;
            this.data.add(object);
            this.fireIntervalAdded(this, this.data.size() - 1, this.data.size() - 1);
            if (this.selected == null && this.data.size() == 1 && object != null) {
                this.setSelectedItem(object);
            }
        }

        public final void insertElementAt(Object object, int n) {
            this.addElement(object);
        }

        @Override
        public final void removeElement(Object object) {
            this.size = -1;
            this.data.remove(object);
        }

        @Override
        public final void removeElementAt(int n) {
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        @Override
        public final void setSelectedItem(Object object) {
            if (this.selected != null && !this.selected.equals(object) || this.selected == null && object != null) {
                this.selected = object;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public final Object getElementAt(int n) {
            this.getSize();
            return this.filtered_cache[n];
        }

        private boolean startsWithIgnoreCase(String string, String string2) {
            if (null == string) {
                return false;
            }
            return string.toUpperCase().startsWith(string2.toUpperCase());
        }

        @Override
        public final int getSize() {
            if (this.size < 0) {
                this.cache = this.data.toArray();
                Comparator comparator = new Comparator(){

                    public int compare(Object object, Object object2) {
                        if (null == object) {
                            if (null == object2) {
                                return 0;
                            }
                            return -1;
                        }
                        return object.toString().toLowerCase().compareTo(object2.toString().toLowerCase());
                    }
                };
                Arrays.sort(this.cache, comparator);
                this.size = this.cache.length;
                this.filtered_size = -1;
            }
            if (this.filtered_size < 0) {
                int n;
                int n2 = this.cache.length;
                for (n = 0; n < n2 && !this.startsWithIgnoreCase(this.cache[n].toString(), this.prefix); ++n) {
                }
                while (n < n2 && !this.startsWithIgnoreCase(this.cache[n2 - 1].toString(), this.prefix)) {
                    --n2;
                }
                this.filtered_cache = new Object[n2 - n];
                if (n2 - n > 0) {
                    System.arraycopy(this.cache, n, this.filtered_cache, 0, n2 - n);
                }
                this.filtered_size = this.filtered_cache.length;
            }
            return this.filtered_size;
        }
    }
}

