/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmcashier.gui.mainframe.forms.cashier;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaAddPaymentForAccountNotify;
import biz.netup.control.transport.urfa.functions.UrfaGetAccountinfo;
import biz.netup.control.transport.urfa.functions.UrfaGetCasierSettings;
import biz.netup.control.transport.urfa.functions.UrfaGetCurrencyList;
import biz.netup.control.transport.urfa.functions.UrfaGetUserAccountList;
import biz.netup.control.transport.urfa.functions.UrfaGetUserByAccount;
import biz.netup.control.transport.urfa.functions.UrfaGetUserinfo;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.dealer.main.usersandgroups.users.UsersFunctions;
import biz.netup.projects.utmadmin.functions.dealer.user.doc.DocFunctions;
import biz.netup.projects.utmadmin.functions.objects.SearchConditions;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.TablePanelAdapter;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.control.TZ;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.tab.TabPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CashierPaymentTab
extends TabPanel {
    private JPanel panel;
    private JButton findNowButton;
    private JTextField accountIDTextField;
    private JButton addButton;
    private JTextField amountInCurrencyTextField;
    private JComboBox currencyComboBox;
    private JTextField statusTextField;
    private JTextField userIDTextField;
    private JTextField loginTextField;
    private JTextField fullNameTextField;
    private JPanel fullNamePanel;
    private JPanel userIdPanel;
    private JPanel loginPanel;
    private JPanel accountIdPanel;
    private TablePanelImpl usersTablePanel;
    private JComboBox accountIdComboBox;
    private JTextField fullNameTextFieldResult;
    private JCheckBox writeOutAReceiptCheckBox;
    private JTextField commentTextField;
    private JPanel commentSpacerPanel;
    private JLabel commentLabel;
    private JPanel userDataPanel;
    private Map<String, Integer> currencyMap;
    private Map<String, String> attributes;

    @Override
    public int getTabType() {
        return 1;
    }

    public CashierPaymentTab() {
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/tariff/currency_24.png")));
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/tariff/currency.png")));
        this.$$$setupUI$$$();
        this.findNowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CashierPaymentTab.this.find();
            }
        });
        this.accountIDTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CashierPaymentTab.this.find();
            }
        });
        this.fullNameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CashierPaymentTab.this.find();
            }
        });
        this.userIDTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CashierPaymentTab.this.find();
            }
        });
        this.loginTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CashierPaymentTab.this.find();
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CashierPaymentTab.this.add();
            }
        });
        this.amountInCurrencyTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CashierPaymentTab.this.add();
            }
        });
    }

    private void add() {
        try {
            double d = Double.parseDouble(this.amountInCurrencyTextField.getText());
            UrfaAddPaymentForAccountNotify urfaAddPaymentForAccountNotify = new UrfaAddPaymentForAccountNotify(UrfaManagerImpl.getInstance());
            urfaAddPaymentForAccountNotify.setAccountId((Integer)this.accountIdComboBox.getSelectedItem());
            urfaAddPaymentForAccountNotify.setAdminComment(this.commentTextField.getText());
            urfaAddPaymentForAccountNotify.setBurnTime(0);
            urfaAddPaymentForAccountNotify.setCurrencyId(this.currencyMap.get(this.currencyComboBox.getSelectedItem()));
            urfaAddPaymentForAccountNotify.setPaymentIncurrency(d);
            urfaAddPaymentForAccountNotify.setMethod(1);
            urfaAddPaymentForAccountNotify.setPaymentExtNumber("");
            urfaAddPaymentForAccountNotify.setActualDate((int)(TZ.getCoreTime().getTime() / 1000L));
            urfaAddPaymentForAccountNotify.setPaymentToInvoice(0);
            urfaAddPaymentForAccountNotify.setTurnOnInet(1);
            urfaAddPaymentForAccountNotify.setHash("");
            urfaAddPaymentForAccountNotify.setComment("");
            urfaAddPaymentForAccountNotify.setNotify(0);
            urfaAddPaymentForAccountNotify.call();
            if (this.writeOutAReceiptCheckBox.isSelected()) {
                int n = urfaAddPaymentForAccountNotify.getPaymentTransactionId();
                UrfaGetUserByAccount urfaGetUserByAccount = new UrfaGetUserByAccount(UrfaManagerImpl.getInstance());
                urfaGetUserByAccount.setAccountId((Integer)this.accountIdComboBox.getSelectedItem());
                urfaGetUserByAccount.call();
                DocFunctions.openDocument(urfaGetUserByAccount.getUserId(), 5, n);
            }
            this.refresh();
            this.statusTextField.setText(this.resource.getString("Payment successful"));
        }
        catch (NumberFormatException numberFormatException) {
            this.log.log(1, "Amount format is incorect");
        }
        catch (UrfaException urfaException) {
            this.log.error("Urfa error", urfaException);
        }
    }

    private void find() {
        block12: {
            this.usersTablePanel.getTableModel().removeAllRows();
            if (this.accountIdPanel.isVisible() && !this.accountIDTextField.getText().isEmpty()) {
                try {
                    int n = Integer.parseInt(this.accountIDTextField.getText());
                    this.refresh();
                    UrfaGetUserByAccount urfaGetUserByAccount = new UrfaGetUserByAccount(UrfaManagerImpl.getInstance());
                    urfaGetUserByAccount.setAccountId(n);
                    urfaGetUserByAccount.call();
                    if (urfaGetUserByAccount.getUserId() == 0) {
                        this.statusTextField.setText(this.resource.getString("User not found"));
                        break block12;
                    }
                    int n2 = urfaGetUserByAccount.getUserId();
                    UrfaGetUserinfo urfaGetUserinfo = new UrfaGetUserinfo(UrfaManagerImpl.getInstance());
                    urfaGetUserinfo.setUserId(n2);
                    urfaGetUserinfo.call();
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("full_name", urfaGetUserinfo.getFullName());
                    hashMap.put("uid", n2);
                    hashMap.put("id", n2);
                    hashMap.put("login", urfaGetUserinfo.getLogin());
                    hashMap.put("address", urfaGetUserinfo.getActAddress());
                    UrfaGetAccountinfo urfaGetAccountinfo = new UrfaGetAccountinfo(UrfaManagerImpl.getInstance());
                    urfaGetAccountinfo.setAccountId(urfaGetUserinfo.getBasicAccount());
                    urfaGetAccountinfo.call();
                    hashMap.put("balance", Resolve.roundValue(urfaGetAccountinfo.getBalance()));
                    this.usersTablePanel.getTableModel().addRow(hashMap);
                }
                catch (NumberFormatException numberFormatException) {
                    this.log.log(1, "Account ID format is incorect");
                }
                catch (UrfaException urfaException) {
                    this.log.error("Urfa error", urfaException);
                }
            } else {
                int n = 0;
                int n3 = 1;
                boolean bl = true;
                if (this.attributes.containsKey("users_count")) {
                    n3 = Integer.parseInt(this.attributes.get("users_count"));
                    bl = n3 != 0;
                }
                for (Map<String, Object> map : UsersFunctions.searchUsers(this.getSearchCriteria())) {
                    if (bl && n++ >= n3) break;
                    if (!map.containsKey("uid")) continue;
                    int n4 = (Integer)map.get("uid");
                    UrfaGetUserinfo urfaGetUserinfo = new UrfaGetUserinfo(UrfaManagerImpl.getInstance());
                    urfaGetUserinfo.setUserId(n4);
                    try {
                        urfaGetUserinfo.call();
                    }
                    catch (UrfaException urfaException) {
                        this.log.error("Urfa error", urfaException);
                    }
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("full_name", urfaGetUserinfo.getFullName());
                    hashMap.put("uid", n4);
                    hashMap.put("id", n4);
                    hashMap.put("login", urfaGetUserinfo.getLogin());
                    hashMap.put("address", urfaGetUserinfo.getActAddress());
                    UrfaGetAccountinfo urfaGetAccountinfo = new UrfaGetAccountinfo(UrfaManagerImpl.getInstance());
                    urfaGetAccountinfo.setAccountId(urfaGetUserinfo.getBasicAccount());
                    try {
                        urfaGetAccountinfo.call();
                    }
                    catch (UrfaException urfaException) {
                        this.log.error("Urfa error", urfaException);
                    }
                    hashMap.put("balance", Resolve.roundValue(urfaGetAccountinfo.getBalance()));
                    this.usersTablePanel.getTableModel().addRow(hashMap);
                }
            }
        }
    }

    private SearchConditions getSearchCriteria() {
        SearchConditions searchConditions = new SearchConditions();
        searchConditions.selectType = 0;
        if (this.loginPanel.isVisible() && !this.loginTextField.getText().isEmpty()) {
            searchConditions.addCondition(2, 1, this.loginTextField.getText());
        }
        if (this.fullNamePanel.isVisible() && !this.fullNameTextField.getText().isEmpty()) {
            searchConditions.addCondition(5, 1, this.fullNameTextField.getText());
        }
        if (this.userIdPanel.isVisible() && !this.userIDTextField.getText().isEmpty()) {
            searchConditions.addCondition(1, 1, this.userIDTextField.getText());
        }
        searchConditions.addPole(this.resource.getString("Actual address"));
        return searchConditions;
    }

    @Override
    public String getTabName() {
        return "Add payment";
    }

    @Override
    public String getGroupName() {
        return "Cashier";
    }

    @Override
    protected void refreshTab() throws UrfaException {
        this.fullNameTextFieldResult.setText("");
        this.accountIdComboBox.removeAllItems();
        this.accountIdComboBox.setEnabled(false);
        this.amountInCurrencyTextField.setText("");
        this.statusTextField.setText("");
        this.amountInCurrencyTextField.setEditable(false);
        this.commentTextField.setText("");
        this.commentTextField.setEditable(false);
        this.currencyComboBox.setEnabled(false);
        this.addButton.setEnabled(false);
        this.writeOutAReceiptCheckBox.setEnabled(false);
    }

    @Override
    public char getShortcut() {
        return 'P';
    }

    @Override
    protected void init() {
        super.init();
        try {
            this.loadCurrency();
        }
        catch (UrfaException urfaException) {
            this.log.error("Cannot load currency list", urfaException);
        }
        this.commentLabel.setVisible(false);
        this.commentTextField.setVisible(false);
        this.commentSpacerPanel.setVisible(false);
        if (this.attributes == null) {
            this.userIdPanel.setVisible(false);
            this.loginPanel.setVisible(false);
            this.fullNamePanel.setVisible(false);
        } else {
            if (this.attributes.containsKey("search_account_id") && this.attributes.get("search_account_id").compareTo("0") == 0) {
                this.accountIdPanel.setVisible(false);
            }
            if (!this.attributes.containsKey("search_user_id") || this.attributes.get("search_user_id").compareTo("0") == 0) {
                this.userIdPanel.setVisible(false);
            }
            if (!this.attributes.containsKey("search_login") || this.attributes.get("search_login").compareTo("0") == 0) {
                this.loginPanel.setVisible(false);
            }
            if (!this.attributes.containsKey("search_full_name") || this.attributes.get("search_full_name").compareTo("0") == 0) {
                this.fullNamePanel.setVisible(false);
            }
            if (this.attributes.containsKey("add_comment") && this.attributes.get("add_comment").compareTo("1") == 0) {
                this.commentLabel.setVisible(true);
                this.commentTextField.setVisible(true);
                this.commentSpacerPanel.setVisible(true);
            }
            if (this.attributes.containsKey("default_receipt") && this.attributes.get("default_receipt").compareTo("1") == 0) {
                this.writeOutAReceiptCheckBox.setSelected(true);
            } else {
                this.writeOutAReceiptCheckBox.setSelected(false);
            }
        }
    }

    private void loadCurrency() throws UrfaException {
        this.currencyMap = new HashMap<String, Integer>();
        this.currencyComboBox.removeAllItems();
        UrfaGetCurrencyList urfaGetCurrencyList = new UrfaGetCurrencyList(UrfaManagerImpl.getInstance());
        urfaGetCurrencyList.call();
        for (int i = 0; i < urfaGetCurrencyList.getCurrencySize(); ++i) {
            this.currencyMap.put(urfaGetCurrencyList.getCurrencyFullName1()[i] + " (" + urfaGetCurrencyList.getId1()[i] + ")", urfaGetCurrencyList.getId1()[i]);
        }
        if (this.attributes == null || !this.attributes.containsKey("currency") || this.attributes.containsKey("currency") && this.attributes.get("currency").equals("")) {
            for (String string : this.currencyMap.keySet()) {
                this.currencyComboBox.addItem(string);
            }
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(this.attributes.get("currency"));
            HashSet<Integer> hashSet = new HashSet<Integer>();
            while (stringTokenizer.hasMoreTokens()) {
                int n = Integer.parseInt(stringTokenizer.nextToken());
                hashSet.add(n);
            }
            for (String string : this.currencyMap.keySet()) {
                if (!hashSet.contains(this.currencyMap.get(string))) continue;
                this.currencyComboBox.addItem(string);
            }
        }
    }

    @Override
    protected Component getMainPanel() {
        return this.panel;
    }

    private void createUIComponents() {
        this.updateAttributes();
        this.createTable();
    }

    private void updateAttributes() {
        UrfaGetCasierSettings urfaGetCasierSettings = new UrfaGetCasierSettings(UrfaManagerImpl.getInstance());
        try {
            urfaGetCasierSettings.call();
            this.attributes = new HashMap<String, String>();
            for (int i = 0; i < urfaGetCasierSettings.getCount(); ++i) {
                this.attributes.put(urfaGetCasierSettings.getAttribute1()[i], urfaGetCasierSettings.getValue1()[i]);
            }
        }
        catch (UrfaException urfaException) {
            // empty catch block
        }
    }

    private void createTable() {
        this.usersTablePanel = new TablePanelImpl(this.getClass().getName() + "_banks", true);
        MapTableModel mapTableModel = this.usersTablePanel.getTableModel();
        if (this.attributes == null) {
            mapTableModel.addColumn("id", "User ID", true, false);
            mapTableModel.addColumn("login", "Login", true, false);
        } else {
            if (!this.attributes.containsKey("users_list_id") || this.attributes.get("users_list_id").compareTo("1") == 0) {
                mapTableModel.addColumn("id", "User ID", true, false);
            }
            if (!this.attributes.containsKey("users_list_login") || this.attributes.get("users_list_login").compareTo("1") == 0) {
                mapTableModel.addColumn("login", "Login", true, false);
            }
            if (this.attributes.containsKey("users_list_full_name") && this.attributes.get("users_list_full_name").compareTo("1") == 0) {
                mapTableModel.addColumn("full_name", "Full name", true, false);
            }
            if (this.attributes.containsKey("users_list_address") && this.attributes.get("users_list_address").compareTo("1") == 0) {
                mapTableModel.addColumn("address", "Address", true, false);
            }
            if (this.attributes.containsKey("users_list_balance") && this.attributes.get("users_list_balance").compareTo("1") == 0) {
                mapTableModel.addColumn("balance", "Balance", true, false);
            }
        }
        this.usersTablePanel.setEditable(false);
        this.usersTablePanel.setAppendable(false);
        this.usersTablePanel.applyTableSettings();
        this.usersTablePanel.setTablePanelListener(new TablePanelAdapter(){

            @Override
            public void performSelectionChanged(Map<String, Object>[] mapArray) {
                CashierPaymentTab.this.selectUser();
            }
        });
    }

    private void selectUser() {
        if (this.usersTablePanel.getSelectedTableRows().length == 1) {
            this.accountIdComboBox.removeAllItems();
            try {
                UrfaGetUserAccountList urfaGetUserAccountList = new UrfaGetUserAccountList(UrfaManagerImpl.getInstance());
                urfaGetUserAccountList.setUserId((Integer)this.usersTablePanel.getSelectedTableRows()[0].get("uid"));
                urfaGetUserAccountList.call();
                for (int n : urfaGetUserAccountList.getAccount1()) {
                    this.accountIdComboBox.addItem(n);
                }
                if (!this.accountIDTextField.getText().isEmpty()) {
                    try {
                        this.accountIdComboBox.setSelectedItem(Integer.parseInt(this.accountIDTextField.getText()));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            catch (UrfaException urfaException) {
                this.accountIdComboBox.addItem((Integer)this.usersTablePanel.getSelectedTableRows()[0].get("master_account"));
            }
            this.accountIdComboBox.setEnabled(true);
            this.fullNameTextFieldResult.setText("" + this.usersTablePanel.getSelectedTableRows()[0].get("full_name"));
            this.amountInCurrencyTextField.setEditable(true);
            this.currencyComboBox.setEnabled(true);
            this.addButton.setEnabled(true);
            this.writeOutAReceiptCheckBox.setEnabled(true);
            this.commentTextField.setEditable(true);
        } else {
            this.refresh();
        }
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        this.userDataPanel = new JPanel();
        this.userDataPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.panel.add((Component)this.userDataPanel, gridBagConstraints);
        this.userDataPanel.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("User")));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Account ID"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.userDataPanel.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Full name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.userDataPanel.add((Component)jLabel2, gridBagConstraints);
        this.fullNameTextFieldResult = new JTextField();
        this.fullNameTextFieldResult.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.userDataPanel.add((Component)this.fullNameTextFieldResult, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Amount in currency"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.userDataPanel.add((Component)jLabel3, gridBagConstraints);
        this.amountInCurrencyTextField = new JTextField();
        this.amountInCurrencyTextField.setEditable(false);
        this.amountInCurrencyTextField.setEnabled(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.userDataPanel.add((Component)this.amountInCurrencyTextField, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Currency"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.userDataPanel.add((Component)jLabel4, gridBagConstraints);
        this.currencyComboBox = new JComboBox();
        this.currencyComboBox.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.userDataPanel.add((Component)this.currencyComboBox, gridBagConstraints);
        this.addButton = new JButton();
        this.addButton.setEnabled(false);
        this.$$$loadButtonText$$$(this.addButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add payment"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.userDataPanel.add((Component)this.addButton, gridBagConstraints);
        JPanel jPanel = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.userDataPanel.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.userDataPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.userDataPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        this.userDataPanel.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.userDataPanel.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.userDataPanel.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.userDataPanel.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.userDataPanel.add((Component)jPanel8, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        this.userDataPanel.add((Component)jPanel9, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Status"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        this.userDataPanel.add((Component)jLabel5, gridBagConstraints);
        this.statusTextField = new JTextField();
        this.statusTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.userDataPanel.add((Component)this.statusTextField, gridBagConstraints);
        this.accountIdComboBox = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.userDataPanel.add((Component)this.accountIdComboBox, gridBagConstraints);
        this.writeOutAReceiptCheckBox = new JCheckBox();
        this.writeOutAReceiptCheckBox.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.userDataPanel.add((Component)this.writeOutAReceiptCheckBox, gridBagConstraints);
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Write out a receipt"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.userDataPanel.add((Component)jLabel6, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        this.userDataPanel.add((Component)jPanel10, gridBagConstraints);
        this.commentTextField = new JTextField();
        this.commentTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.userDataPanel.add((Component)this.commentTextField, gridBagConstraints);
        this.commentLabel = new JLabel();
        this.$$$loadLabelText$$$(this.commentLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Comment"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.userDataPanel.add((Component)this.commentLabel, gridBagConstraints);
        this.commentSpacerPanel = new JPanel();
        this.commentSpacerPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.userDataPanel.add((Component)this.commentSpacerPanel, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.commentSpacerPanel.add((Component)jPanel11, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)jPanel12, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)jPanel13, gridBagConstraints);
        this.accountIdPanel = new JPanel();
        this.accountIdPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        jPanel13.add((Component)this.accountIdPanel, gridBagConstraints);
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Account ID"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.accountIdPanel.add((Component)jLabel7, gridBagConstraints);
        this.accountIDTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.accountIdPanel.add((Component)this.accountIDTextField, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.accountIdPanel.add((Component)jPanel14, gridBagConstraints);
        JPanel jPanel15 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.accountIdPanel.add((Component)jPanel15, gridBagConstraints);
        this.loginPanel = new JPanel();
        this.loginPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        jPanel13.add((Component)this.loginPanel, gridBagConstraints);
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Login"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.loginPanel.add((Component)jLabel8, gridBagConstraints);
        this.loginTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.loginPanel.add((Component)this.loginTextField, gridBagConstraints);
        JPanel jPanel16 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.loginPanel.add((Component)jPanel16, gridBagConstraints);
        JPanel jPanel17 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.loginPanel.add((Component)jPanel17, gridBagConstraints);
        this.userIdPanel = new JPanel();
        this.userIdPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        jPanel13.add((Component)this.userIdPanel, gridBagConstraints);
        JLabel jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("User ID"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.userIdPanel.add((Component)jLabel9, gridBagConstraints);
        this.userIDTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.userIdPanel.add((Component)this.userIDTextField, gridBagConstraints);
        JPanel jPanel18 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.userIdPanel.add((Component)jPanel18, gridBagConstraints);
        JPanel jPanel19 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.userIdPanel.add((Component)jPanel19, gridBagConstraints);
        this.fullNamePanel = new JPanel();
        this.fullNamePanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        jPanel13.add((Component)this.fullNamePanel, gridBagConstraints);
        JLabel jLabel10 = new JLabel();
        this.$$$loadLabelText$$$(jLabel10, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Full name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.fullNamePanel.add((Component)jLabel10, gridBagConstraints);
        this.fullNameTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.fullNamePanel.add((Component)this.fullNameTextField, gridBagConstraints);
        JPanel jPanel20 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.fullNamePanel.add((Component)jPanel20, gridBagConstraints);
        JPanel jPanel21 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.fullNamePanel.add((Component)jPanel21, gridBagConstraints);
        this.findNowButton = new JButton();
        this.$$$loadButtonText$$$(this.findNowButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Find now"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel13.add((Component)this.findNowButton, gridBagConstraints);
        JPanel jPanel22 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        jPanel13.add((Component)jPanel22, gridBagConstraints);
        JPanel jPanel23 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)jPanel23, gridBagConstraints);
        JPanel jPanel24 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 3;
        this.panel.add((Component)jPanel24, gridBagConstraints);
        JPanel jPanel25 = new JPanel();
        jPanel25.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.panel.add((Component)jPanel25, gridBagConstraints);
        jPanel25.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Users")));
        jPanel25.add((Component)this.usersTablePanel, "Center");
        JPanel jPanel26 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 3;
        this.panel.add((Component)jPanel26, gridBagConstraints);
        JPanel jPanel27 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)jPanel27, gridBagConstraints);
        jLabel2.setLabelFor(this.fullNameTextFieldResult);
        jLabel3.setLabelFor(this.amountInCurrencyTextField);
        jLabel4.setLabelFor(this.currencyComboBox);
        jLabel5.setLabelFor(this.statusTextField);
        jLabel7.setLabelFor(this.accountIDTextField);
        jLabel8.setLabelFor(this.loginTextField);
        jLabel9.setLabelFor(this.userIDTextField);
        jLabel10.setLabelFor(this.fullNameTextField);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

