/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmcashier.gui.mainframe.forms.cashier;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetCasierSettings;
import biz.netup.control.transport.urfa.functions.UrfaGetUserByAccount;
import biz.netup.control.transport.urfa.functions.UrfaPaymentsReportOwnerEx;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.dealer.user.doc.DocFunctions;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.tab.ReportTab;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

public class CashierPaymentReport
extends ReportTab {
    private Map<String, String> attributes;

    public CashierPaymentReport() {
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/payments_report_24.png")));
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/payments_report.png")));
    }

    @Override
    protected JMenuItem[] getMenuItems(final Map<String, Object>[] mapArray) {
        JMenuItem jMenuItem = new JMenuItem(this.resource.getString("Print receipt"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CashierPaymentReport.this.receipt(mapArray);
            }
        });
        if (mapArray.length == 1 && mapArray[0].get("id") != null) {
            return new JMenuItem[]{jMenuItem};
        }
        return new JMenuItem[0];
    }

    private void receipt(Map<String, Object>[] mapArray) {
        try {
            UrfaGetUserByAccount urfaGetUserByAccount = new UrfaGetUserByAccount(UrfaManagerImpl.getInstance());
            urfaGetUserByAccount.setAccountId((Integer)mapArray[0].get("account_id"));
            urfaGetUserByAccount.call();
            DocFunctions.openDocument(urfaGetUserByAccount.getUserId(), 5, (Integer)mapArray[0].get("id"));
        }
        catch (UrfaException urfaException) {
            this.log.error(urfaException);
            return;
        }
    }

    @Override
    public int getMode() {
        return 1;
    }

    @Override
    public int getTabType() {
        return 1;
    }

    @Override
    public char getShortcut() {
        return 'R';
    }

    @Override
    public String getGroupName() {
        return "Cashier";
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (this.attributes == null) {
            linkedHashMap.put("account_id", "Account ID");
            linkedHashMap.put("login", "Login");
            linkedHashMap.put("date_of_payment", "Time of payment");
            linkedHashMap.put("amount_(in_currency)", "Amount (in currency)");
            linkedHashMap.put("currency", "Currency");
        } else {
            if (!this.attributes.containsKey("report_account_id") || this.attributes.get("report_account_id").compareTo("1") == 0) {
                linkedHashMap.put("account_id", "Account ID");
            }
            if (!this.attributes.containsKey("report_login") || this.attributes.get("report_login").compareTo("1") == 0) {
                linkedHashMap.put("login", "Login");
            }
            if (this.attributes.containsKey("report_full_name") && this.attributes.get("report_full_name").compareTo("1") == 0) {
                linkedHashMap.put("full_name", "Full name");
            }
            if (this.attributes.containsKey("report_user_id") && this.attributes.get("report_user_id").compareTo("1") == 0) {
                linkedHashMap.put("user_id", "User ID");
            }
            if (!this.attributes.containsKey("report_date") || this.attributes.get("report_date").compareTo("1") == 0) {
                linkedHashMap.put("date_of_payment", "Time of payment");
            }
            if (!this.attributes.containsKey("report_amount") || this.attributes.get("report_amount").compareTo("1") == 0) {
                linkedHashMap.put("amount_(in_currency)", "Amount (in currency)");
            }
            if (!this.attributes.containsKey("report_currency") || this.attributes.get("report_currency").compareTo("1") == 0) {
                linkedHashMap.put("currency", "Currency");
            }
        }
        return linkedHashMap;
    }

    @Override
    public void setTableData() throws UrfaException {
        Resolve.updateCurList();
        UrfaPaymentsReportOwnerEx urfaPaymentsReportOwnerEx = new UrfaPaymentsReportOwnerEx(UrfaManagerImpl.getInstance(), this);
        urfaPaymentsReportOwnerEx.setTimeStart(this.getStartTime());
        urfaPaymentsReportOwnerEx.setTimeEnd(this.getEndTime());
        urfaPaymentsReportOwnerEx.call();
    }

    @Override
    public String getTabName() {
        return "Report on Payments";
    }

    @Override
    public void addSummaryRows() {
        HashMap<String, Object> hashMap;
        HashMap<String, Double> hashMap2 = new HashMap<String, Double>();
        HashMap<String, Double> hashMap3 = new HashMap<String, Double>();
        Double d = 0.0;
        Double d2 = 0.0;
        String string = "payment_method";
        String string2 = "currency";
        for (Map<String, Object> object : this.getReportTablePanel().getTableModel().data) {
            d = d + (Double)object.get("volume");
            d2 = d2 + (Double)object.get("amount_(in_currency)");
            if (hashMap2.containsKey("" + object.get(string) + "@#$" + object.get(string2))) {
                hashMap2.put("" + object.get(string) + "@#$" + object.get(string2), (Double)hashMap2.get("" + object.get(string) + "@#$" + object.get(string2)) + (Double)object.get("volume"));
                hashMap3.put("" + object.get(string) + "@#$" + object.get(string2), (Double)hashMap3.get("" + object.get(string) + "@#$" + object.get(string2)) + (Double)object.get("amount_(in_currency)"));
                continue;
            }
            hashMap2.put("" + object.get(string) + "@#$" + object.get(string2), (Double)object.get("volume"));
            hashMap3.put("" + object.get(string) + "@#$" + object.get(string2), (Double)object.get("amount_(in_currency)"));
        }
        for (String string3 : hashMap2.keySet()) {
            hashMap = new HashMap();
            hashMap.put("account_id", this.resource.getString("Summary"));
            hashMap.put("volume", hashMap2.get(string3));
            hashMap.put("amount_(in_currency)", hashMap3.get(string3));
            hashMap.put(string, string3.substring(0, string3.lastIndexOf("@#$")));
            hashMap.put(string2, string3.substring(string3.lastIndexOf("@#$") + 3));
            hashMap.put("X-SORT", "NO_SORT");
            this.getReportTablePanel().getTableModel().addRow(hashMap);
        }
        hashMap = new HashMap<String, Object>();
        hashMap.put("account_id", this.resource.getString("Total"));
        hashMap.put("volume", d);
        hashMap.put("amount_(in_currency)", d2);
        hashMap.put("X-SORT", "NO_SORT");
    }

    @Override
    protected void init() {
        UrfaGetCasierSettings urfaGetCasierSettings = new UrfaGetCasierSettings(UrfaManagerImpl.getInstance());
        try {
            urfaGetCasierSettings.call();
            this.attributes = new HashMap<String, String>();
            for (int i = 0; i < urfaGetCasierSettings.getCount(); ++i) {
                this.attributes.put(urfaGetCasierSettings.getAttribute1()[i], urfaGetCasierSettings.getValue1()[i]);
            }
        }
        catch (UrfaException urfaException) {
            // empty catch block
        }
        super.init();
    }
}

