/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmcashier.gui.mainframe;

import biz.netup.control.storage.impl.StorageImpl;
import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.UrfaManagerException;
import biz.netup.control.transport.urfa.functions.UrfaGetCasierSettings;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmcashier.Start;
import biz.netup.projects.utmcashier.gui.custom.properties.PropertiesDialog;
import biz.netup.projects.utmcashier.gui.mainframe.forms.about.AboutDialog;
import biz.netup.projects.utmcashier.gui.mainframe.forms.cashier.CashierPaymentReport;
import biz.netup.projects.utmcashier.gui.mainframe.forms.cashier.CashierPaymentTab;
import biz.netup.utmutils.control.TZ;
import biz.netup.utmutils.control.shortcuts.ShortcutsDialog;
import biz.netup.utmutils.swing.tab.TabPanel;
import biz.netup.utmutils.swing.tabbedwindow.MainTabbedWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.Timer;

public class MainFrame
extends MainTabbedWindow {
    private static MainFrame instance = null;
    private JLabel timeLabel;
    TabPanel cashierPayment;
    TabPanel paymentsReport;
    private Timer timer;
    private Map<String, String> attributes;

    @Override
    protected Component getBottomPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel.add((Component)jPanel2, "East");
        JLabel jLabel = new JLabel(this.resource.getString("Server time:"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.timeLabel = new JLabel();
        this.timeLabel.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.timeLabel, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        return jPanel;
    }

    private void generateTimePanel() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        final SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        final String string = TimeZone.getDefault().getDisplayName();
        this.timeLabel.setText(simpleDateFormat.format(TZ.getCoreTime().getTime()) + " " + string);
        this.timer = new Timer(60000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.timeLabel.setText(simpleDateFormat.format(TZ.getCoreTime().getTime()) + " " + string);
                MainFrame.this.timeLabel.repaint();
            }
        });
        this.timer.start();
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            try {
                UrfaManagerImpl.getInstance().disconnect();
            }
            catch (UrfaManagerException urfaManagerException) {
                log.log(2, urfaManagerException.getMessage());
            }
            finally {
                ((StorageImpl)StorageImpl.getInstance()).saveSettings();
            }
            System.exit(0);
        }
        super.processWindowEvent(windowEvent);
    }

    public static MainFrame getInstance() {
        if (instance == null) {
            instance = new MainFrame();
        }
        return instance;
    }

    private MainFrame() {
        TZ.setTimeZone();
        this.generateTimePanel();
    }

    @Override
    protected void init() {
        this.cashierPayment = new CashierPaymentTab();
        this.paymentsReport = new CashierPaymentReport();
        UrfaGetCasierSettings urfaGetCasierSettings = new UrfaGetCasierSettings(UrfaManagerImpl.getInstance());
        try {
            urfaGetCasierSettings.call();
            this.attributes = new HashMap<String, String>();
            for (int i = 0; i < urfaGetCasierSettings.getCount(); ++i) {
                this.attributes.put(urfaGetCasierSettings.getAttribute1()[i], urfaGetCasierSettings.getValue1()[i]);
            }
        }
        catch (UrfaException urfaException) {
            // empty catch block
        }
    }

    @Override
    protected Dimension getWindowSize() {
        return new Dimension(810, 600);
    }

    @Override
    protected JMenuBar getWindowMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setBorderPainted(false);
        JMenu jMenu = new JMenu(this.resource.getString("System"));
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu(this.resource.getString("Options"));
        jMenuBar.add(jMenu2);
        JMenu jMenu3 = new JMenu(this.resource.getString("Help"));
        jMenuBar.add(jMenu3);
        JMenuItem jMenuItem = new JMenuItem(this.resource.getString("About"));
        jMenu3.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(this.resource.getString("Properties"));
        JMenuItem jMenuItem3 = new JMenuItem(this.resource.getString("Shortcuts"));
        jMenu2.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem(this.resource.getString("Reconnect"));
        jMenu.add(jMenuItem4);
        jMenu.addSeparator();
        JMenuItem jMenuItem5 = new JMenuItem(this.resource.getString("Exit"));
        jMenu.add(jMenuItem5);
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.showProperties();
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.showShortcuts();
            }
        });
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.showAbout();
            }
        });
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.reconnect();
            }
        });
        return jMenuBar;
    }

    private void showShortcuts() {
        new ShortcutsDialog(null).run(null);
    }

    private void reconnect() {
        instance = null;
        this.dispose();
        try {
            UrfaManagerImpl.getInstance().disconnect();
        }
        catch (UrfaManagerException urfaManagerException) {
            log.error(urfaManagerException);
        }
        finally {
            ((StorageImpl)StorageImpl.getInstance()).saveSettings();
        }
        Start.run(null);
    }

    private void showAbout() {
        AboutDialog aboutDialog = new AboutDialog(null);
        aboutDialog.setReadOnly();
        aboutDialog.linkButton.setEnabled(true);
        aboutDialog.load();
    }

    private void showProperties() {
        new PropertiesDialog(null).load();
    }

    @Override
    protected String getWindowTitle() {
        return "UTM5";
    }

    @Override
    protected Vector<TabPanel> getTabPanels() {
        Vector<TabPanel> vector = new Vector<TabPanel>();
        if (this.attributes == null) {
            vector.add(this.cashierPayment);
            vector.add(this.paymentsReport);
        } else {
            if (!this.attributes.containsKey("show_user_search") || this.attributes.get("show_user_search").compareTo("1") == 0) {
                vector.add(this.cashierPayment);
            }
            if (!this.attributes.containsKey("show_payment_report") || this.attributes.get("show_payment_report").compareTo("1") == 0) {
                vector.add(this.paymentsReport);
            }
        }
        return vector;
    }
}

