/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmcashier.gui.logindialog;

import biz.netup.control.storage.Storage;
import biz.netup.control.storage.impl.StorageImpl;
import biz.netup.control.transport.ssl.impl.SSLManagerImpl;
import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.UrfaManagerException;
import biz.netup.control.transport.urfa.functions.UrfaCoreBuild;
import biz.netup.control.transport.urfa.functions.UrfaCoreVersion;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmcashier.gui.logindialog.DialogSplash;
import biz.netup.projects.utmcashier.gui.logindialog.LoginData;
import biz.netup.projects.utmcashier.gui.mainframe.MainFrame;
import biz.netup.swing.RollPane;
import biz.netup.utmutils.control.Logger;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.trayicon.UTMTrayIcon;
import biz.netup.utmutils.control.types.UtmSetting;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class LoginDialog
extends JDialog {
    private JButton okButton;
    private JPanel topPanel;
    private JPanel mainPanel;
    private JPasswordField passwordPasswordField;
    private JPanel settingsPanel;
    private JPanel setPanel;
    private JComboBox languageComboBox;
    private JComboBox hostPortComboBox;
    private JComboBox loginComboBox;
    private JCheckBox saveOptionsCheckBox;
    private JCheckBox savePasswordCheckBox;
    private JButton cancelButton;
    private boolean reconnectDialog;
    private SSLManagerImpl sslManager;
    private RollPane setRP;
    UrfaManagerImpl urfaManager;
    DialogSplash dlg;
    Vector<String> logins;
    Vector<String> servers;
    Vector<String> langs;
    Vector<Integer> ports;
    String pass;
    String savePass;
    private static final Logger logger = Utils.getLogger();
    private LinkedHashMap<String, LoginData> loginInfo;
    private LoginData activeLD;

    private void createUI() {
        this.setPanel.remove(this.settingsPanel);
        this.setRP = new RollPane(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Settings"), this.settingsPanel, true);
        this.setPanel.add(this.setRP);
        this.setRP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoginDialog.this.changeDlgSize();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoginDialog.this.login();
            }
        });
        URL uRL = this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/logo32.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.setSize(300, 205);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.setResizable(false);
        this.setTitle("UTM5 " + Utils.getResource().getString("Login dialog"));
        this.setIconImage(imageIcon.getImage());
        this.add(this.mainPanel);
    }

    private void changeDlgSize() {
        if (this.setRP.isRolled()) {
            this.setSize(300, 205);
        } else {
            this.setSize(300, 268);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void login() {
        if (this.loginComboBox.getSelectedItem() == null) {
            return;
        }
        if (this.loginComboBox.getSelectedItem().toString().isEmpty()) {
            return;
        }
        this.urfaManager = UrfaManagerImpl.getInstance();
        this.sslManager = new SSLManagerImpl();
        try {
            this.sslManager.init();
        }
        catch (Exception exception) {
            this.sslManager = null;
        }
        this.urfaManager.setSSLManager(this.sslManager);
        try {
            Object object;
            int n;
            String string;
            String string2 = this.hostPortComboBox.getSelectedItem().toString().trim();
            if (string2.lastIndexOf(93) != -1) {
                if (string2.charAt(0) != '[') throw new UrfaManagerException("Incorrect [host]:port field");
                if (string2.length() != string2.lastIndexOf(93) + 1 && string2.substring(string2.lastIndexOf(93) + 1).charAt(0) == ':') {
                    string = string2.substring(1, string2.indexOf(93));
                    n = Integer.parseInt(string2.substring(string2.lastIndexOf(58) + 1));
                } else {
                    string = string2.substring(1, string2.indexOf(93));
                    n = 11758;
                }
            } else if (string2.lastIndexOf(46) != -1 && string2.lastIndexOf(58) != -1) {
                string = string2.substring(0, string2.indexOf(58));
                n = Integer.parseInt(string2.substring(string2.lastIndexOf(58) + 1));
            } else {
                string = string2;
                n = 11758;
            }
            String string3 = this.loginComboBox.getSelectedItem() == null ? "" : this.loginComboBox.getSelectedItem().toString();
            this.setVisible(false);
            try {
                if ("RU".compareTo(this.languageComboBox.getSelectedItem().toString()) == 0) {
                    Locale.setDefault(new Locale("RU", "RU", "UTF-8"));
                    this.dlg = new DialogSplash("RU");
                } else {
                    Locale.setDefault(new Locale("EN", "EN", "UTF-8"));
                    this.dlg = new DialogSplash("EN");
                }
            }
            catch (Exception exception) {
                Locale.setDefault(new Locale("EN", "EN", "UTF-8"));
                this.dlg = new DialogSplash("EN");
            }
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = this.dlg.getSize();
            this.dlg.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
            this.dlg.setVisible(true);
            this.urfaManager.connect(string, n, string3, new String(this.passwordPasswordField.getPassword()));
            if (Utils.isAdmin()) {
                object = new UrfaCoreVersion(this.urfaManager);
                UrfaCoreBuild urfaCoreBuild = new UrfaCoreBuild(this.urfaManager);
                try {
                    ((UrfaCoreVersion)object).call();
                    urfaCoreBuild.call();
                }
                catch (UrfaException urfaException) {
                    throw new UrfaManagerException("Unable to get UTM5 core version");
                }
            }
            object = MainFrame.getInstance();
            string = string2.lastIndexOf(46) != -1 ? (string2.lastIndexOf(58) != -1 ? string2 : string2 + ":11758") : (string2.lastIndexOf(93) != -1 && string2.length() != string2.lastIndexOf(93) + 1 && string2.substring(string2.lastIndexOf(93) + 1).charAt(0) == ':' ? string2 : string2 + ":11758");
            ((Frame)object).setTitle(Utils.getResource().getString("Cashier interface"));
            this.dlg.setVisible(false);
            UTMTrayIcon.getInstance().setToolTip(Utils.getResource().getString("Cashier interface"));
            UTMTrayIcon.getInstance().show();
            ((Window)object).setVisible(true);
            this.prepareSave2();
            return;
        }
        catch (UrfaManagerException urfaManagerException) {
            this.dlg.setVisible(false);
            this.dlg.dispose();
            logger.error("Login error", urfaManagerException);
            this.setVisible(true);
        }
    }

    private void prepareSave2() {
        Storage storage = StorageImpl.getInstance();
        Iterator<UtmSetting> iterator = StorageImpl.getInstance().select(UtmSetting.class, "name='Language'");
        if (iterator.hasNext()) {
            storage.remove(iterator.next());
        }
        UtmSetting utmSetting = new UtmSetting("Language", this.languageComboBox.getSelectedItem().toString());
        storage.add(utmSetting);
        iterator = StorageImpl.getInstance().select(UtmSetting.class, "name='SavePassword'");
        if (iterator.hasNext()) {
            storage.remove(iterator.next());
        }
        UtmSetting utmSetting2 = new UtmSetting("SavePassword", this.savePasswordCheckBox.isSelected() ? "1" : "0");
        storage.add(utmSetting2);
        iterator = StorageImpl.getInstance().select(UtmSetting.class, "name='SaveSettings'");
        if (iterator.hasNext()) {
            storage.remove(iterator.next());
        }
        UtmSetting utmSetting3 = new UtmSetting("SaveSettings", this.saveOptionsCheckBox.isSelected() ? "1" : "0");
        storage.add(utmSetting3);
        if (this.saveOptionsCheckBox.isSelected()) {
            int n;
            String string;
            String string2 = this.hostPortComboBox.getSelectedItem().toString().trim();
            if (string2.lastIndexOf(93) != -1) {
                if (string2.charAt(0) == '[') {
                    if (string2.length() != string2.lastIndexOf(93) + 1 && string2.substring(string2.lastIndexOf(93) + 1).charAt(0) == ':') {
                        string = string2.substring(1, string2.indexOf(93));
                        n = Integer.parseInt(string2.substring(string2.lastIndexOf(58) + 1));
                    } else {
                        string = string2.substring(1, string2.indexOf(93));
                        n = 11758;
                    }
                } else {
                    string = "Unknown";
                    n = 11758;
                }
            } else if (string2.lastIndexOf(46) != -1 && string2.lastIndexOf(58) != -1) {
                string = string2.substring(0, string2.indexOf(58));
                n = Integer.parseInt(string2.substring(string2.lastIndexOf(58) + 1));
            } else {
                string = string2;
                n = 11758;
            }
            String string3 = this.loginComboBox.getSelectedItem().toString();
            String string4 = this.savePasswordCheckBox.isSelected() ? new String(this.passwordPasswordField.getPassword()) : "";
            LoginData loginData = new LoginData();
            Iterator<LoginData> iterator2 = storage.select(LoginData.class, "host='" + string + "'");
            if (iterator2.hasNext()) {
                LoginData loginData2 = iterator2.next();
                storage.remove(loginData2);
                loginData.host = string;
                loginData.port = "" + n;
                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                for (int i = 0; i < loginData2.login.length; ++i) {
                    linkedHashMap.put(loginData2.login[i], loginData2.password[i]);
                }
                if (linkedHashMap.containsKey(string3)) {
                    linkedHashMap.remove(string3);
                }
                linkedHashMap.put(string3, string4);
                loginData.login = linkedHashMap.keySet().toArray(new String[linkedHashMap.size()]);
                loginData.password = linkedHashMap.values().toArray(new String[linkedHashMap.size()]);
            } else {
                loginData.host = string;
                loginData.port = "" + n;
                loginData.login = new String[1];
                loginData.password = new String[1];
                loginData.login[0] = string3;
                loginData.password[0] = string4;
            }
            storage.add(loginData);
        }
        storage.commit();
        ((StorageImpl)storage).saveSettings();
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            System.exit(0);
        }
        super.processWindowEvent(windowEvent);
    }

    public LoginDialog(Frame frame) {
        this.$$$setupUI$$$();
        this.init();
        this.reconnectDialog = true;
        this.setSize(300, 215);
        this.setModal(true);
        this.setVisible(true);
    }

    public LoginDialog() {
        this.$$$setupUI$$$();
        this.init();
        this.reconnectDialog = false;
    }

    public void init() {
        String string = "EN";
        Iterator<UtmSetting> iterator = StorageImpl.getInstance().select(UtmSetting.class, "name='Language'");
        if (iterator.hasNext() && "RU".compareTo(iterator.next().getValue()) == 0) {
            Locale.setDefault(new Locale("RU", "RU", "UTF-8"));
            string = "RU";
        } else {
            Locale.setDefault(new Locale("EN", "EN", "UTF-8"));
        }
        this.$$$setupUI$$$();
        this.languageComboBox.setSelectedItem(string);
        this.createUI();
        this.loadParams();
        this.getRootPane().setDefaultButton(this.okButton);
        this.prepareLoad2();
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoginDialog.this.onCancel();
            }
        });
        this.saveOptionsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (LoginDialog.this.saveOptionsCheckBox.isSelected()) {
                    LoginDialog.this.savePasswordCheckBox.setEnabled(true);
                } else {
                    LoginDialog.this.savePasswordCheckBox.setEnabled(false);
                    LoginDialog.this.savePasswordCheckBox.setSelected(false);
                }
            }
        });
    }

    private void loadParams() {
        Iterator<UtmSetting> iterator = StorageImpl.getInstance().select(UtmSetting.class, "name='SavePassword'");
        if (iterator.hasNext() && "1".compareTo(iterator.next().getValue()) == 0) {
            this.savePasswordCheckBox.setSelected(true);
        } else {
            this.savePasswordCheckBox.setSelected(false);
        }
        iterator = StorageImpl.getInstance().select(UtmSetting.class, "name='SaveSettings'");
        if (iterator.hasNext() && "1".compareTo(iterator.next().getValue()) == 0) {
            this.saveOptionsCheckBox.setSelected(true);
        } else {
            this.saveOptionsCheckBox.setSelected(false);
            this.savePasswordCheckBox.setEnabled(false);
            this.savePasswordCheckBox.setSelected(false);
        }
    }

    private void onCancel() {
        if (this.reconnectDialog) {
            System.exit(0);
        }
        this.dispose();
    }

    private void prepareLoad2() {
        this.loginInfo = new LinkedHashMap();
        Storage storage = StorageImpl.getInstance();
        Iterator<LoginData> iterator = storage.getEntities(LoginData.class);
        String string = "";
        while (iterator.hasNext()) {
            LoginData loginData = iterator.next();
            this.loginInfo.put("[" + loginData.host + "]:" + loginData.port, loginData);
            this.hostPortComboBox.addItem("[" + loginData.host + "]:" + loginData.port);
            this.hostPortComboBox.setSelectedItem("[" + loginData.host + "]:" + loginData.port);
            string = "[" + loginData.host + "]:" + loginData.port;
        }
        this.initLoginPass(string);
        this.hostPortComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = LoginDialog.this.hostPortComboBox.getSelectedItem().toString().trim();
                String string2 = string.lastIndexOf(46) != -1 ? (string.lastIndexOf(58) != -1 ? string : string + ":11758") : (string.lastIndexOf(93) != -1 && string.length() != string.lastIndexOf(93) + 1 && string.substring(string.lastIndexOf(93) + 1).charAt(0) == ':' ? string : string + ":11758");
                LoginDialog.this.initLoginPass(string2);
            }
        });
        this.loginComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (LoginDialog.this.activeLD != null && LoginDialog.this.loginComboBox.getSelectedItem() != null) {
                    for (int i = 0; i < ((LoginDialog)LoginDialog.this).activeLD.login.length; ++i) {
                        if (((LoginDialog)LoginDialog.this).activeLD.login[i].compareTo(LoginDialog.this.loginComboBox.getSelectedItem().toString()) != 0) continue;
                        LoginDialog.this.passwordPasswordField.setText(((LoginDialog)LoginDialog.this).activeLD.password[i]);
                        return;
                    }
                }
            }
        });
    }

    private void initLoginPass(String string) {
        if (!string.isEmpty() && this.loginInfo.containsKey(string)) {
            this.loginComboBox.removeAllItems();
            this.activeLD = this.loginInfo.get(string);
            for (int i = 0; i < this.activeLD.login.length; ++i) {
                this.loginComboBox.addItem(this.activeLD.login[i]);
                this.loginComboBox.setSelectedItem(this.activeLD.login[i]);
                this.passwordPasswordField.setText(this.activeLD.password[i]);
            }
        } else {
            this.activeLD = null;
            this.loginComboBox.removeAllItems();
            this.passwordPasswordField.setText("");
        }
    }

    private void $$$setupUI$$$() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new FlowLayout(1, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mainPanel.add((Component)this.topPanel, gridBagConstraints);
        this.okButton = new JButton();
        this.$$$loadButtonText$$$(this.okButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Ok"));
        this.topPanel.add(this.okButton);
        this.cancelButton = new JButton();
        this.cancelButton.setText("Cancel");
        this.topPanel.add(this.cancelButton);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mainPanel.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Host port"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Login"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Password"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        this.passwordPasswordField = new JPasswordField();
        this.passwordPasswordField.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.passwordPasswordField, gridBagConstraints);
        this.hostPortComboBox = new JComboBox();
        this.hostPortComboBox.setEditable(true);
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        this.hostPortComboBox.setModel(defaultComboBoxModel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.hostPortComboBox, gridBagConstraints);
        this.loginComboBox = new JComboBox();
        this.loginComboBox.setEditable(true);
        DefaultComboBoxModel defaultComboBoxModel2 = new DefaultComboBoxModel();
        this.loginComboBox.setModel(defaultComboBoxModel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.loginComboBox, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel7, gridBagConstraints);
        this.setPanel = new JPanel();
        this.setPanel.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.setPanel, gridBagConstraints);
        this.settingsPanel = new JPanel();
        this.settingsPanel.setLayout(new GridBagLayout());
        this.setPanel.add((Component)this.settingsPanel, "Center");
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Language"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.settingsPanel.add((Component)jLabel4, gridBagConstraints);
        this.languageComboBox = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel3 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel3.addElement("EN");
        defaultComboBoxModel3.addElement("RU");
        this.languageComboBox.setModel(defaultComboBoxModel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.settingsPanel.add((Component)this.languageComboBox, gridBagConstraints);
        this.saveOptionsCheckBox = new JCheckBox();
        this.saveOptionsCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(this.saveOptionsCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Save options"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.settingsPanel.add((Component)this.saveOptionsCheckBox, gridBagConstraints);
        this.savePasswordCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.savePasswordCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Save password"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.settingsPanel.add((Component)this.savePasswordCheckBox, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.settingsPanel.add((Component)jPanel8, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel9, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel10, gridBagConstraints);
        jLabel.setLabelFor(this.hostPortComboBox);
        jLabel2.setLabelFor(this.loginComboBox);
        jLabel3.setLabelFor(this.passwordPasswordField);
        jLabel4.setLabelFor(this.languageComboBox);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

