/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmcashier;

import biz.netup.control.storage.impl.StorageImpl;
import biz.netup.projects.utmcashier.gui.logindialog.LoginDialog;
import biz.netup.swing.plaf.looks.plastic.theme.ExperienceBlue;
import biz.netup.swing.plaf.utm.UtmLookAndFeel;
import biz.netup.utmutils.control.Settings;
import biz.netup.utmutils.swing.context.MyEventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class Start {
    private static final Logger logger = Logger.getLogger(Start.class);

    private static void createAndShowGUI() {
        LoginDialog loginDialog = new LoginDialog();
        loginDialog.setDefaultCloseOperation(1);
        loginDialog.setVisible(true);
    }

    private static void initLogger() {
        File file = new File("logger.cfg");
        if (file.exists()) {
            PropertyConfigurator.configure("logger.cfg");
            Logger.getRootLogger().info("Using logger configuration from external file");
        } else {
            InputStream inputStream = Start.class.getResourceAsStream("logger.cfg");
            if (inputStream == null) {
                BasicConfigurator.configure();
                Logger.getRootLogger().setLevel(Level.ERROR);
            } else {
                Properties properties = new Properties();
                try {
                    properties.load(inputStream);
                    PropertyConfigurator.configure(properties);
                    Logger.getRootLogger().info("Using logger configuration from internal resource");
                }
                catch (IOException iOException) {
                    BasicConfigurator.configure();
                    Logger.getRootLogger().setLevel(Level.ERROR);
                }
            }
        }
    }

    public static void setLookAndFeel() throws ClassNotFoundException, UnsupportedLookAndFeelException, IllegalAccessException, InstantiationException {
        Object var0 = null;
        UtmLookAndFeel utmLookAndFeel = new UtmLookAndFeel();
        UtmLookAndFeel.setMyCurrentTheme(new ExperienceBlue());
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        UIManager.setLookAndFeel(utmLookAndFeel);
        Font font = UIManager.getFont("TextField.font");
        UIManager.put("FormattedTextField.font", font);
    }

    public static void run(String[] stringArray) {
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(new MyEventQueue());
        StorageImpl.init();
        Settings.verify();
        Start.initLogger();
        try {
            Start.setLookAndFeel();
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.error(classNotFoundException);
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            logger.error(unsupportedLookAndFeelException);
        }
        catch (InstantiationException instantiationException) {
            logger.error(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.error(illegalAccessException);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Start.createAndShowGUI();
            }
        });
    }
}

