/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.userframe.forms.user;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetContract;
import biz.netup.control.transport.urfa.functions.UrfaGetContractList;
import biz.netup.control.transport.urfa.functions.UrfaRemoveContract;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.dealer.user.doc.DocFunctions;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.templates.PrintEditDialog;
import biz.netup.projects.utmadmin.gui.userframe.forms.user.contact.UserDocumentDialog;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;

public class UserDocumentsTab
extends TabPanelWithTable {
    private int uid;

    @Override
    public int getTabType() {
        return 2;
    }

    @Override
    public String getGroupName() {
        return "User";
    }

    public UserDocumentsTab(int n) {
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/user/contracts_24.png")));
        this.setRefreshPermission(new int[]{17937});
        this.setAddPermission(new int[]{17939, 17940, 17926});
        this.setReadPermission(new int[]{17938});
        this.setDeletePermission(new int[]{17941});
        this.uid = n;
    }

    @Override
    public String getTabName() {
        return "Documents";
    }

    @Override
    public int getMode() {
        return 5;
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("doc_id", "Document ID");
        linkedHashMap.put("template_id", "Template ID");
        linkedHashMap.put("created", "Date of creation");
        linkedHashMap.put("name", "Name");
        linkedHashMap.put("path", "Path");
        linkedHashMap.put("type", "Type");
        linkedHashMap.put("uploaded", "Uploaded");
        return linkedHashMap;
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        UrfaGetContractList urfaGetContractList = new UrfaGetContractList(UrfaManagerImpl.getInstance());
        urfaGetContractList.setUserId(this.uid);
        urfaGetContractList.call();
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        for (int i = 0; i < urfaGetContractList.getCnt(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("doc_id", urfaGetContractList.getContractIdArray1()[i]);
            hashMap.put("template_id", urfaGetContractList.getTemplateIdArray1()[i]);
            hashMap.put("created", new Date((long)urfaGetContractList.getCreatedArray1()[i] * 1000L));
            hashMap.put("name", urfaGetContractList.getNameArray1()[i]);
            hashMap.put("path", urfaGetContractList.getPathArray1()[i]);
            hashMap.put("type", urfaGetContractList.getIsOldArray1()[i] == 0 ? "ODF" : "HTML");
            hashMap.put("uploaded", urfaGetContractList.getTemplateIdArray1()[i] == 0);
            vector.add(hashMap);
        }
        return vector;
    }

    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
        UrfaRemoveContract urfaRemoveContract = new UrfaRemoveContract(UrfaManagerImpl.getInstance());
        urfaRemoveContract.setContractId((Integer)map.get("doc_id"));
        urfaRemoveContract.call();
    }

    @Override
    public DFModel getItemDialog(Map<String, Object> map) {
        return new UserDocumentDialog(map, this.uid);
    }

    @Override
    protected void init() {
        super.init();
        this.addButton.setText(this.resource.getString("Create"));
        this.readButton.setText(this.resource.getString("Download"));
        this.readButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/forwarded16.png")));
        this.getReadPanel().setVisible(true);
    }

    @Override
    protected void read() {
        UrfaGetContract urfaGetContract = new UrfaGetContract(UrfaManagerImpl.getInstance());
        urfaGetContract.setContractId((Integer)this.mainTablePanel.getSelectedTableRows()[0].get("doc_id"));
        urfaGetContract.setDontDonv(1);
        try {
            urfaGetContract.call();
        }
        catch (UrfaException urfaException) {
            this.log.log(1, this.resource.getString("Unable to open document"));
            return;
        }
        if (urfaGetContract.getResult() == 0) {
            this.log.log(1, this.resource.getString("Document not found"));
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        String string = (String)this.mainTablePanel.getSelectedTableRows()[0].get("path");
        if (string.compareTo("") == 0 || urfaGetContract.getIsOdt() == 0) {
            string = "contract.html";
        }
        jFileChooser.setSelectedFile(new File(string));
        if (jFileChooser.showSaveDialog(this.mainPanel) == 0) {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(jFileChooser.getSelectedFile());
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.log.error(fileNotFoundException);
                return;
            }
            try {
                fileOutputStream.write(urfaGetContract.getData());
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                this.log.error(iOException);
            }
        }
    }

    @Override
    protected void doubleClick() {
        if (UrfaManagerImpl.getInstance().isPermitted(new int[]{17938})) {
            UrfaGetContract urfaGetContract = new UrfaGetContract(UrfaManagerImpl.getInstance());
            urfaGetContract.setContractId((Integer)this.mainTablePanel.getSelectedTableRows()[0].get("doc_id"));
            urfaGetContract.setDontDonv(0);
            try {
                urfaGetContract.call();
            }
            catch (UrfaException urfaException) {
                this.log.log(1, this.resource.getString("Unable to open document"));
                return;
            }
            if (urfaGetContract.getResult() == 0) {
                this.log.log(1, this.resource.getString("Document not found"));
                return;
            }
            if (urfaGetContract.getIsOdt() == 0) {
                byte[] byArray = urfaGetContract.getData();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("edit", "edit");
                try {
                    hashMap.put("text", new String(byArray, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.log.log(1, this.resource.getString("Unsupported text encoding"));
                    return;
                }
                PrintEditDialog printEditDialog = new PrintEditDialog(hashMap);
                printEditDialog.setReadMode();
                printEditDialog.run();
            } else {
                DocFunctions.openDocument(urfaGetContract.getData());
            }
        }
    }
}

