/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.userframe.forms.tarification.tl.tldialogs;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.projects.utmadmin.functions.dealer.custom.ServiceFunctions;
import biz.netup.projects.utmadmin.functions.dealer.custom.TPFunctions;
import biz.netup.projects.utmadmin.functions.dealer.user.tarification.tl.TLFunctions;
import biz.netup.projects.utmadmin.functions.objects.TL;
import biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.ap.MainAPTab;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.AddDialupServiceLinkDialog;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.AddHotspotServiceLinkDialog;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.AddIPServiceLinkDialog;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.AddIptvServiceLinkDialog;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.AddOnceServiceLinkDialog;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.AddPeriodicServiceLinkDialog;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.AddTelServiceLinkDialog;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.AddVodServiceLinkDialog;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.SelectServiceInTariffDialog;
import biz.netup.swing.AutoCompletionExt;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.permissions.Permissions;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.control.types.ServiceType;
import biz.netup.utmutils.swing.dialog.DialogModel;
import biz.netup.utmutils.swing.dialog.SelectFromTableDialogModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TLDialog
extends DialogModel {
    private JComboBox previousTPComboBox;
    private JComboBox nextTPComboBox;
    private JTextField accountingPeriodTextField;
    private JButton selectButton;
    private JButton createServiceLinkButton;
    private JPanel panel;
    private JButton immediatelyChangeTPBtn;
    private Map<String, Integer> tpMap;
    private boolean TPFounded = false;
    private int ap;
    private int aid;
    private int uid;
    private int tlId;
    private TL tl;

    public TLDialog() {
        this.$$$setupUI$$$();
    }

    public TLDialog(Map<String, Object> map) {
        super(map);
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        this.immediatelyChangeTPBtn.setEnabled(false);
        this.nextTPComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1 && !TLDialog.this.isAddMode()) {
                    TLDialog.this.checkChangeButtonEnable();
                }
            }
        });
        final TLDialog tLDialog = this;
        this.immediatelyChangeTPBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = TLDialog.this.resource.getString("Warning");
                String string2 = TLDialog.this.resource.getString("Immediately change TP warning");
                if (JOptionPane.showConfirmDialog(tLDialog, string2, string, 0) == 1) {
                    return;
                }
                Integer n = (Integer)TLDialog.this.tpMap.get(TLDialog.this.previousTPComboBox.getSelectedItem().toString());
                Integer n2 = (Integer)TLDialog.this.tpMap.get(TLDialog.this.nextTPComboBox.getSelectedItem().toString());
                try {
                    if (!Resolve.checkTP(n, n2) && JOptionPane.showConfirmDialog(tLDialog, TLDialog.this.resource.getString("Change TP warning"), TLDialog.this.resource.getString("Warning"), 0) != 0) {
                        return;
                    }
                }
                catch (UrfaException urfaException) {
                    // empty catch block
                }
                try {
                    TLFunctions.addTL(TLDialog.this.uid, TLDialog.this.aid, n, n2, TLDialog.this.ap, TLDialog.this.tlId, 1);
                    TLDialog.this.tp.refresh();
                    tLDialog.dispose();
                }
                catch (UrfaException urfaException) {
                    Dialogs.showErrorDialog("cant change tariff");
                }
            }
        });
        return this.panel;
    }

    private void checkChangeButtonEnable() {
        String string = (String)this.nextTPComboBox.getSelectedItem();
        String string2 = (String)this.previousTPComboBox.getSelectedItem();
        String string3 = Utils.getResource().getString("Current");
        String string4 = Utils.getResource().getString("Disable TP");
        boolean bl = !string.equals(string2) && !string.equals(string3) && !string.equals(string4);
        this.immediatelyChangeTPBtn.setEnabled(bl);
    }

    @Override
    public String getItemName() {
        return "Tariff link";
    }

    @Override
    protected void loadInfo() throws UrfaException {
        if (this.item.get("tlink_id") == null) {
            this.setAddMode(true);
        } else {
            this.tlId = (Integer)this.item.get("tlink_id");
        }
        this.aid = (Integer)this.item.get("aid");
        this.uid = (Integer)this.item.get("uid");
        this.fillComboBoxes();
        Permissions.apply((JComponent)this.createServiceLinkButton, "add_sl_tl");
        if (this.isAddMode()) {
            this.createServiceLinkButton.setEnabled(false);
        } else {
            this.selectButton.setEnabled(false);
            this.previousTPComboBox.setEnabled(false);
            this.loadTLdetails();
        }
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TLDialog.this.selectPeriod();
            }
        });
        this.createServiceLinkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TLDialog.this.selectService();
            }
        });
    }

    private void loadTLdetails() throws UrfaException {
        this.tl = TLFunctions.getTL(this.uid, this.aid, this.tlId);
        for (String string : this.tpMap.keySet()) {
            if (this.tpMap.get(string).intValue() == this.tl.getTariffCurrent()) {
                this.previousTPComboBox.setSelectedItem(string);
            }
            if (this.tpMap.get(string).intValue() != this.tl.getTariffNext()) continue;
            this.nextTPComboBox.setSelectedItem(string);
        }
        this.ap = this.tl.getDiscountPeriodId();
        this.accountingPeriodTextField.setText(Resolve.getAPName(this.tl.getDiscountPeriodId()));
        this.checkChangeButtonEnable();
    }

    private void selectService() {
        SelectServiceInTariffDialog selectServiceInTariffDialog = new SelectServiceInTariffDialog(this.uid, this.aid, this.tlId, this.tl.getTariffCurrent(), this.tl.getDiscountPeriodId());
        selectServiceInTariffDialog.setVisible(true);
    }

    private void addDefaultServices(int n) {
        for (Map<String, Object> map : ServiceFunctions.getTlinkServicesList(this.uid, this.aid, n)) {
            JDialog jDialog;
            String string = (String)map.get("service_type");
            Integer n2 = (Integer)map.get("service_id");
            String string2 = (String)map.get("service_name");
            Integer n3 = this.ap;
            if (string.equals(ServiceType.getName(1)) && ServiceFunctions.isLinkByDefault(n2, 1)) {
                jDialog = new AddOnceServiceLinkDialog(this.uid, this.aid, n2, string2, 0, n, n3);
                jDialog.setVisible(true);
            }
            if (string.equals(ServiceType.getName(2)) && ServiceFunctions.isLinkByDefault(n2, 2)) {
                jDialog = new AddPeriodicServiceLinkDialog(this.uid, this.aid, n2, string2, 0, n, n3);
                jDialog.setVisible(true);
            }
            if (string.equals(ServiceType.getName(3)) && ServiceFunctions.isLinkByDefault(n2, 3)) {
                jDialog = new AddIPServiceLinkDialog(this.uid, this.aid, n2, string2, 0, n, n3);
                jDialog.setVisible(true);
            }
            if (string.equals(ServiceType.getName(4)) && ServiceFunctions.isLinkByDefault(n2, 4)) {
                jDialog = new AddHotspotServiceLinkDialog(this.uid, this.aid, n2, string2, 0, n, n3);
                jDialog.setVisible(true);
            }
            if (string.equals(ServiceType.getName(5)) && ServiceFunctions.isLinkByDefault(n2, 5)) {
                jDialog = new AddDialupServiceLinkDialog(this.uid, this.aid, n2, string2, 0, n, n3);
                jDialog.setVisible(true);
            }
            if (string.equals(ServiceType.getName(6)) && ServiceFunctions.isLinkByDefault(n2, 6)) {
                jDialog = new AddTelServiceLinkDialog(this.uid, this.aid, n2, string2, 0, n, n3);
                jDialog.setVisible(true);
            }
            if (string.equals(ServiceType.getName(8)) && ServiceFunctions.isLinkByDefault(n2, 8)) {
                jDialog = new AddIptvServiceLinkDialog(this.uid, this.aid, n2, string2, 0, n, n3);
                jDialog.setVisible(true);
            }
            if (!string.equals(ServiceType.getName(9)) || !ServiceFunctions.isLinkByDefault(n2, 9)) continue;
            jDialog = new AddVodServiceLinkDialog(this.uid, this.aid, n2, string2, 0, n, n3);
            jDialog.setVisible(true);
        }
    }

    private void selectPeriod() {
        SelectFromTableDialogModel selectFromTableDialogModel = new SelectFromTableDialogModel(new MainAPTab());
        selectFromTableDialogModel.setVisible(true);
        if (selectFromTableDialogModel.isOkPressed()) {
            this.ap = (Integer)selectFromTableDialogModel.getItem().get("serial_id");
            this.accountingPeriodTextField.setText(Resolve.getAPName(this.ap));
        }
    }

    public boolean isTPFounded() {
        return this.TPFounded;
    }

    private void fillComboBoxes() throws UrfaException {
        this.tpMap = TPFunctions.getTPMap();
        boolean bl = this.TPFounded = this.tpMap.size() != 0;
        if (this.isAddMode()) {
            this.nextTPComboBox.addItem(Utils.getResource().getString("Current"));
        } else {
            this.nextTPComboBox.addItem(Utils.getResource().getString("Disable TP"));
        }
        for (String string : this.tpMap.keySet()) {
            this.previousTPComboBox.addItem(string);
            this.nextTPComboBox.addItem(string);
        }
        this.tpMap.put(Utils.getResource().getString("Current"), 0);
        this.tpMap.put(Utils.getResource().getString("Disable TP"), 0);
        new AutoCompletionExt(this.previousTPComboBox);
        new AutoCompletionExt(this.nextTPComboBox);
    }

    @Override
    protected void saveInfo() throws UrfaException {
        if (this.isAddMode()) {
            this.tlId = TLFunctions.addTL(this.uid, this.aid, this.tpMap.get(this.previousTPComboBox.getSelectedItem().toString()), this.tpMap.get(this.nextTPComboBox.getSelectedItem().toString()), this.ap, 0, 0);
            if (this.tlId != 0) {
                this.addDefaultServices(this.tlId);
            }
        } else {
            TLFunctions.addTL(this.uid, this.aid, this.tpMap.get(this.previousTPComboBox.getSelectedItem().toString()), this.tpMap.get(this.nextTPComboBox.getSelectedItem().toString()), this.ap, this.tlId, 0);
        }
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
        if (!this.settingListeners) {
            if (!this.TPFounded) {
                this.log.log(1, this.resource.getString("No TP found"));
                throw new IllegalArgumentException("No TP found");
            }
            try {
                if (this.tpMap.get(this.previousTPComboBox.getSelectedItem().toString()) != this.tpMap.get(this.nextTPComboBox.getSelectedItem().toString()) && !Resolve.checkTP(this.tpMap.get(this.previousTPComboBox.getSelectedItem().toString()), this.tpMap.get(this.nextTPComboBox.getSelectedItem().toString())) && JOptionPane.showConfirmDialog(this, this.resource.getString("Change TP warning"), this.resource.getString("Warning"), 0) != 0) {
                    throw new IllegalArgumentException("TP doesn't match");
                }
            }
            catch (UrfaException urfaException) {
                // empty catch block
            }
            if (!this.isAddMode() && this.tpMap.get(this.nextTPComboBox.getSelectedItem().toString()) == 0 && JOptionPane.showConfirmDialog(this, this.resource.getString("Disable TP warning"), this.resource.getString("Warning"), 0) != 0) {
                throw new IllegalArgumentException("Disable TP");
            }
        }
        this.checkName(this.accountingPeriodTextField, "Accounting period");
    }

    private void $$$setupUI$$$() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.panel, "Center");
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Current TP name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.panel.add((Component)jLabel, gridBagConstraints);
        this.previousTPComboBox = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)this.previousTPComboBox, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Next TP name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.panel.add((Component)jLabel2, gridBagConstraints);
        this.nextTPComboBox = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)this.nextTPComboBox, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Accounting period"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.panel.add((Component)jLabel3, gridBagConstraints);
        this.accountingPeriodTextField = new JTextField();
        this.accountingPeriodTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)this.accountingPeriodTextField, gridBagConstraints);
        this.selectButton = new JButton();
        this.selectButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/configure16.png")));
        this.$$$loadButtonText$$$(this.selectButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Select"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)this.selectButton, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        this.panel.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        this.panel.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        this.panel.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        this.panel.add((Component)jPanel8, gridBagConstraints);
        this.createServiceLinkButton = new JButton();
        this.createServiceLinkButton.setEnabled(true);
        this.createServiceLinkButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/network16.png")));
        this.$$$loadButtonText$$$(this.createServiceLinkButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add service"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weighty = 1.0;
        this.panel.add((Component)this.createServiceLinkButton, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)jPanel9, gridBagConstraints);
        this.immediatelyChangeTPBtn = new JButton();
        this.immediatelyChangeTPBtn.setEnabled(false);
        this.immediatelyChangeTPBtn.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/ok16.png")));
        this.$$$loadButtonText$$$(this.immediatelyChangeTPBtn, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Change now"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)this.immediatelyChangeTPBtn, gridBagConstraints);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

