/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.userframe.forms.tarification.tl;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.projects.utmadmin.functions.dealer.user.tarification.tl.TLFunctions;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.accountpanel.AccountComboBox;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.tl.tldialogs.HistoryDialog;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.tl.tldialogs.TLDialog;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.permissions.Permissions;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;

public class UserTLinksTab
extends TabPanelWithTable {
    private JButton historyButton = new JButton();
    AccountComboBox acb;
    private int uid;

    @Override
    public JComponent getPanel() {
        if (this.init) {
            this.acb.refresh();
        }
        return super.getPanel();
    }

    @Override
    protected void applyPermissions() {
        Permissions.apply((JComponent)this.historyButton, "history_tl");
    }

    public UserTLinksTab(int n) {
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/user/tariff_links_24.png")));
        this.setRefreshPermission(new int[]{12311, 8243});
        this.setAddPermission(new int[]{12324, 9728, 12319, 12314, 8460});
        this.setEditPermission(new int[]{12319});
        this.setReadPermission(new int[]{12324, 9728, 12311});
        this.setDeletePermission(new int[]{12313});
        this.uid = n;
        this.acb = new AccountComboBox(n, this);
        this.acb.refresh();
        this.getAdditionalButtonPanel2().add(this.historyButton);
        this.getBottomPanel().add((Component)this.acb.getPanel(), "South");
    }

    @Override
    public int getTabType() {
        return 2;
    }

    @Override
    public String getGroupName() {
        return "Tariffication";
    }

    @Override
    public String getTabName() {
        return "Tariff links";
    }

    @Override
    public int getMode() {
        return 1;
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("tlink_id", "Tlink ID");
        linkedHashMap.put("current_tp_id", "Current TP ID");
        linkedHashMap.put("current_tp_name", "Current TP name");
        linkedHashMap.put("next_tp_id", "Next TP ID");
        linkedHashMap.put("next_tp_name", "Next TP name");
        linkedHashMap.put("accounting_period", "Accounting period");
        return linkedHashMap;
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        return TLFunctions.getTL(this.uid, this.acb.getAid());
    }

    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
        TLFunctions.deleteTL(this.uid, this.acb.getAid(), (Integer)map.get("tlink_id"));
    }

    @Override
    public DFModel getItemDialog(Map<String, Object> map) {
        return null;
    }

    @Override
    protected void edit() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("uid", this.uid);
        hashMap.put("aid", this.acb.getAid());
        hashMap.put("tlink_id", this.mainTablePanel.getSelectedTableRows()[0].get("tlink_id"));
        TLDialog tLDialog = new TLDialog(hashMap);
        tLDialog.run(this);
    }

    @Override
    protected void add() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("uid", this.uid);
        hashMap.put("aid", this.acb.getAid());
        TLDialog tLDialog = new TLDialog(hashMap);
        tLDialog.run(this);
    }

    @Override
    protected void read() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("uid", this.uid);
        hashMap.put("aid", this.acb.getAid());
        hashMap.put("tlink_id", this.mainTablePanel.getSelectedTableRows()[0].get("tlink_id"));
        TLDialog tLDialog = new TLDialog(hashMap);
        tLDialog.setReadOnly();
        tLDialog.run(this);
    }

    @Override
    protected void init() {
        super.init();
        this.historyButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/history16.png")));
        this.historyButton.setText(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("History"));
        if (Utils.isAdmin()) {
            this.historyButton.setEnabled(true);
            this.historyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("aid", UserTLinksTab.this.acb.getAid());
                    HistoryDialog historyDialog = new HistoryDialog(hashMap);
                    historyDialog.load();
                }
            });
        } else {
            this.historyButton.setEnabled(false);
        }
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserTLinksTab.this.acb.refresh();
            }
        });
    }
}

