/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs;

import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.resolvers.Resolve;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class PeriodicStatsDialog
extends JDialog {
    private JCheckBox isActiveCB;
    private JTextField feeRecalcStartCB;
    private JTextField feeRecalcDurationCB;
    private JTextField telRecalcStartTB;
    private JTextField telRecalcDurationTB;
    private JTextField chargedTB;
    private JTextField trafficRecalcDurationTB;
    private JTextField trafficRecalcStartTB;
    private JTextField repaidTB;
    private JButton buttonOK;
    private JPanel mainPanel;

    private String getDurationString(int n) {
        int n2 = n / 86400;
        int n3 = n % 86400 / 3600;
        int n4 = n % 3600 / 60;
        return n2 + Utils.getResource().getString("abbreviatedDays") + " " + n3 + Utils.getResource().getString("abbreviatedHours") + " " + n4 + Utils.getResource().getString("abbreviatedMinutes") + " ";
    }

    private void setText(JComponent jComponent, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        if (jComponent instanceof JLabel) {
            JLabel jLabel = (JLabel)jComponent;
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        } else if (jComponent instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)jComponent;
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private GridBagConstraints getConstraints(int n, int n2, int n3, int n4) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        if (n3 != 0) {
            gridBagConstraints.anchor = n3;
        }
        if (n4 != 0) {
            gridBagConstraints.fill = n4;
        }
        return gridBagConstraints;
    }

    private GridBagConstraints getConstraints(int n, int n2, double d, double d2, int n3, int n4) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        if (n3 != 0) {
            gridBagConstraints.anchor = n3;
        }
        if (n4 != 0) {
            gridBagConstraints.fill = n4;
        }
        return gridBagConstraints;
    }

    private void setupUI(SlinkType slinkType) {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        this.setText(jLabel, Utils.getResource().getString("Is link active"));
        JLabel jLabel2 = new JLabel();
        this.setText(jLabel2, Utils.getResource().getString("Fee recalc start"));
        JLabel jLabel3 = new JLabel();
        this.setText(jLabel3, Utils.getResource().getString("Fee recalc duration"));
        JLabel jLabel4 = new JLabel();
        this.setText(jLabel4, Utils.getResource().getString("Traffic recalc start"));
        JLabel jLabel5 = new JLabel();
        this.setText(jLabel5, Utils.getResource().getString("Traffic recalc duration"));
        JLabel jLabel6 = new JLabel();
        this.setText(jLabel6, Utils.getResource().getString("Calls recalc start"));
        JLabel jLabel7 = new JLabel();
        this.setText(jLabel7, Utils.getResource().getString("Calls recalc duration"));
        JLabel jLabel8 = new JLabel();
        this.setText(jLabel8, Utils.getResource().getString("Repaid"));
        JLabel jLabel9 = new JLabel();
        this.setText(jLabel9, Utils.getResource().getString("Charged"));
        this.isActiveCB = new JCheckBox("");
        this.isActiveCB.setEnabled(false);
        this.feeRecalcStartCB = new JTextField("");
        this.feeRecalcStartCB.setEditable(false);
        this.feeRecalcStartCB.setEnabled(true);
        this.feeRecalcDurationCB = new JTextField("");
        this.feeRecalcDurationCB.setEditable(false);
        this.trafficRecalcStartTB = new JTextField("");
        this.trafficRecalcStartTB.setEditable(false);
        this.trafficRecalcDurationTB = new JTextField("");
        this.trafficRecalcDurationTB.setEditable(false);
        this.telRecalcStartTB = new JTextField("");
        this.telRecalcStartTB.setEditable(false);
        this.telRecalcDurationTB = new JTextField("");
        this.telRecalcDurationTB.setEditable(false);
        this.chargedTB = new JTextField("");
        this.chargedTB.setEditable(false);
        this.repaidTB = new JTextField("");
        this.repaidTB.setEditable(false);
        this.buttonOK = new JButton();
        this.buttonOK.setHorizontalAlignment(0);
        this.buttonOK.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/ok16.png")));
        this.setText(this.buttonOK, Utils.getResource().getString("OK"));
        this.mainPanel.add((Component)new JPanel(), this.getConstraints(0, 0, 0, 2));
        this.mainPanel.add((Component)new JPanel(), this.getConstraints(4, 0, 0, 2));
        this.mainPanel.add((Component)new JPanel(), this.getConstraints(3, 0, 0, 3));
        this.mainPanel.add((Component)new JPanel(), this.getConstraints(2, 0, 0, 2));
        this.mainPanel.add((Component)jLabel, this.getConstraints(1, 1, 13, 0));
        this.mainPanel.add((Component)this.isActiveCB, this.getConstraints(3, 1, 17, 0));
        this.mainPanel.add((Component)new JPanel(), this.getConstraints(1, 2, 0, 3));
        this.mainPanel.add((Component)jLabel2, this.getConstraints(1, 3, 13, 0));
        this.mainPanel.add((Component)this.feeRecalcStartCB, this.getConstraints(3, 3, 0.5, 0.0, 17, 2));
        this.mainPanel.add((Component)new JPanel(), this.getConstraints(1, 4, 0, 3));
        this.mainPanel.add((Component)jLabel3, this.getConstraints(1, 5, 13, 0));
        this.mainPanel.add((Component)this.feeRecalcDurationCB, this.getConstraints(3, 5, 17, 2));
        if (slinkType == SlinkType.IpTraffic) {
            this.mainPanel.add((Component)new JPanel(), this.getConstraints(1, 6, 0, 3));
            this.mainPanel.add((Component)this.trafficRecalcStartTB, this.getConstraints(3, 7, 0.5, 0.0, 17, 2));
            this.mainPanel.add((Component)jLabel4, this.getConstraints(1, 7, 13, 0));
            this.mainPanel.add((Component)new JPanel(), this.getConstraints(1, 8, 0, 3));
            this.mainPanel.add((Component)jLabel5, this.getConstraints(1, 9, 13, 0));
            this.mainPanel.add((Component)this.trafficRecalcDurationTB, this.getConstraints(3, 9, 0.5, 0.0, 17, 2));
        }
        if (slinkType == SlinkType.Telephony) {
            this.mainPanel.add((Component)new JPanel(), this.getConstraints(1, 10, 0, 3));
            this.mainPanel.add((Component)jLabel6, this.getConstraints(1, 11, 13, 0));
            this.mainPanel.add((Component)this.telRecalcStartTB, this.getConstraints(3, 11, 0.5, 0.0, 17, 2));
            this.mainPanel.add((Component)new JPanel(), this.getConstraints(1, 12, 0, 3));
            this.mainPanel.add((Component)jLabel7, this.getConstraints(1, 13, 13, 0));
            this.mainPanel.add((Component)this.telRecalcDurationTB, this.getConstraints(3, 13, 0.5, 0.0, 17, 2));
        }
        this.mainPanel.add((Component)new JPanel(), this.getConstraints(1, 14, 0, 3));
        this.mainPanel.add((Component)jLabel9, this.getConstraints(1, 15, 13, 0));
        this.mainPanel.add((Component)this.chargedTB, this.getConstraints(3, 15, 0.5, 0.0, 17, 2));
        this.mainPanel.add((Component)new JPanel(), this.getConstraints(1, 16, 0, 3));
        this.mainPanel.add((Component)jLabel8, this.getConstraints(1, 17, 13, 0));
        this.mainPanel.add((Component)this.repaidTB, this.getConstraints(3, 17, 0.5, 0.0, 17, 2));
        this.mainPanel.add((Component)new JPanel(), this.getConstraints(2, 18, 0, 3));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        this.mainPanel.add((Component)jPanel, gridBagConstraints);
        jPanel.add((Component)this.buttonOK, this.getConstraints(0, 0, 11, 2));
    }

    private String printDate(int n) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(new Date((long)n * 1000L));
    }

    public void setActive(boolean bl) {
        this.isActiveCB.setSelected(bl);
    }

    public void setFeeRecalcStart(int n) {
        this.feeRecalcStartCB.setText(n == 0 ? Utils.getResource().getString("NA") : this.printDate(n));
    }

    public void setFeeRecalcDuration(int n) {
        this.feeRecalcDurationCB.setText(this.getDurationString(n));
    }

    public void setTelRecalcStart(int n) {
        this.telRecalcStartTB.setText(n == 0 ? Utils.getResource().getString("NA") : this.printDate(n));
    }

    public void setTelRecalcDuration(int n) {
        this.telRecalcDurationTB.setText(this.getDurationString(n));
    }

    public void setTrafficRecalcStart(int n) {
        this.trafficRecalcStartTB.setText(n == 0 ? Utils.getResource().getString("NA") : this.printDate(n));
    }

    public void setTrafficRecalcDuration(int n) {
        this.trafficRecalcDurationTB.setText(this.getDurationString(n));
    }

    public void setCharged(double d) {
        this.chargedTB.setText("" + Resolve.roundValue(d));
    }

    public void setRepaid(double d) {
        this.repaidTB.setText("" + Resolve.roundValue(d));
    }

    public PeriodicStatsDialog(SlinkType slinkType) {
        this.setupUI(slinkType);
        this.setTitle(Utils.getResource().getString("Periodic service statistics"));
        this.setModal(true);
        this.setContentPane(this.mainPanel);
        this.setSize(400, 300);
        this.setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PeriodicStatsDialog.this.dispose();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PeriodicStatsDialog.this.dispose();
            }
        });
        this.mainPanel.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PeriodicStatsDialog.this.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    public static enum SlinkType {
        Hotspot,
        Dialup,
        IpTraffic,
        Telephony,
        Periodic;

    }
}

