/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetSwitch;
import biz.netup.control.transport.urfa.functions.UrfaGetSwitch;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.objects.AddressWithMask;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.IpGroupDialogTabs.IpGroupAdditionalTab;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.IpGroupDialogTabs.IpGroupDhcpTab;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.IpGroupDialogTabs.IpGroupISGAttrs;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.IpGroupDialogTabs.IpGroupIpSettingsTab;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.IpGroupDialogTabs.IpGroupRadiusTab;
import biz.netup.utmutils.control.Settings;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.swing.dialog.DialogModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class IpGroupDialog
extends DialogModel {
    private JPanel mainPanel;
    private JTabbedPane tabbedPane;
    private IpGroupAdditionalTab additionalTab;
    private IpGroupDhcpTab dhcpTab;
    private IpGroupIpSettingsTab ipSettingsTab;
    private IpGroupRadiusTab radiusTab;
    private IpGroupISGAttrs isgAttrsTab;
    private int id;

    public IpGroupDialog(Map<String, Object> map) {
        super(map);
        this.getSurroundPanel().setBorder(BorderFactory.createEmptyBorder());
    }

    @Override
    public Component getForm() {
        this.ipSettingsTab = new IpGroupIpSettingsTab();
        this.radiusTab = new IpGroupRadiusTab();
        this.dhcpTab = new IpGroupDhcpTab();
        this.additionalTab = new IpGroupAdditionalTab();
        this.isgAttrsTab = new IpGroupISGAttrs();
        this.ipSettingsTab.init(this.dhcpTab);
        this.dhcpTab.init(this.ipSettingsTab, this.radiusTab);
        this.radiusTab.init(this.ipSettingsTab, this.dhcpTab);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab(this.resource.getString(this.ipSettingsTab.getTabName()), this.ipSettingsTab.getMainPanel());
        this.tabbedPane.addTab(this.resource.getString(this.radiusTab.getTabName()), this.radiusTab.getMainPanel());
        this.tabbedPane.addTab(this.resource.getString(this.dhcpTab.getTabName()), this.dhcpTab.getMainPanel());
        this.tabbedPane.addTab(this.resource.getString(this.additionalTab.getTabName()), this.additionalTab.getMainPanel());
        this.tabbedPane.addTab(this.resource.getString(this.isgAttrsTab.getTabName()), this.isgAttrsTab.getMainPanel());
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.tabbedPane, "Center");
        this.mainPanel.setMinimumSize(new Dimension(550, 230));
        this.mainPanel.setPreferredSize(new Dimension(550, 230));
        return this.mainPanel;
    }

    @Override
    public String getItemName() {
        return "IP group";
    }

    @Override
    protected void loadInfo() throws UrfaException {
        this.setAddMode(!this.item.containsKey("ip4_subnet") && !this.item.containsKey("ip6_subnet") && !this.item.containsKey("pool_id"));
        this.additionalTab.load();
        this.ipSettingsTab.load((Integer)this.item.get("uid"), (Integer)this.item.get("house_id"));
        this.dhcpTab.load();
        this.radiusTab.load();
        if (!this.isAddMode()) {
            Object object;
            this.id = (Integer)this.item.get("id");
            this.dhcpTab.setIpGroupId(this.id);
            if (Utils.isAdmin()) {
                this.additionalTab.setFirewallId((Integer)this.item.get("router_id"));
            }
            Integer n = (Integer)this.item.get("switch_id");
            String string = "";
            int n2 = 0;
            if (n != 0) {
                object = new int[]{Utils.isAdmin() ? 4432 : 0x70000071};
                if (UrfaManagerImpl.getInstance().isPermitted((int[])object)) {
                    if (Utils.isAdmin()) {
                        UrfaGetSwitch urfaGetSwitch = new UrfaGetSwitch(UrfaManagerImpl.getInstance());
                        urfaGetSwitch.setId(n);
                        urfaGetSwitch.call();
                        string = urfaGetSwitch.getName();
                        n2 = urfaGetSwitch.getPortsCount();
                    } else {
                        UrfaDealerGetSwitch urfaDealerGetSwitch = new UrfaDealerGetSwitch(UrfaManagerImpl.getInstance());
                        urfaDealerGetSwitch.setId(n);
                        urfaDealerGetSwitch.call();
                        string = urfaDealerGetSwitch.getName();
                        n2 = urfaDealerGetSwitch.getPortsCount();
                    }
                }
            }
            this.isgAttrsTab.setIsgAttrsData(this.item.get("isgAttrsData"));
            this.dhcpTab.setMACAddress((String)this.item.get("mac"));
            this.dhcpTab.setPortId((Integer)this.item.get("port_id"));
            this.dhcpTab.setSwitch(n, n2, string);
            this.dhcpTab.setVlanId((Integer)this.item.get("vlan_id"));
            this.dhcpTab.setDhcpPool((Integer)this.item.get("pool_id"));
            this.dhcpTab.setDhcpOptionsData((Vector)this.item.get("dhcpOptionsData"));
            this.radiusTab.setLogin((String)this.item.get("login"));
            this.radiusTab.setPassword((String)this.item.get("password"));
            this.radiusTab.setAllowedCID((String)this.item.get("allowed_cid"));
            this.radiusTab.setPoolName((String)this.item.get("pool_name"));
            this.additionalTab.setIsNotVPNStatus((Integer)this.item.get("not_vpn") == 1);
            this.additionalTab.setIsNotAffectFWStatus((Integer)this.item.get("do_not_affect_firewall") == 1);
            this.ipSettingsTab.setIsDynamic((Integer)this.item.get("is_dynamic") == 1);
            if (this.item.get("ip4_subnet") != null) {
                object = (AddressWithMask)this.item.get("ip4_subnet");
                this.ipSettingsTab.setIPv4Subnet(new AddressWithMask(object.address, object.mask));
            }
            if (this.item.get("ip6_subnet") != null) {
                object = (AddressWithMask)this.item.get("ip6_subnet");
                this.ipSettingsTab.setIPv6Subnet(new AddressWithMask(object.address, object.mask));
            }
        } else {
            this.isgAttrsTab.load(this.id);
            this.additionalTab.setIsNotVPNStatus("1".compareToIgnoreCase(Settings.getValueFromPerst("NotVPN")) == 0);
            this.additionalTab.setIsNotAffectFWStatus("1".compareToIgnoreCase(Settings.getValueFromPerst("DoNotAffectFW")) == 0);
        }
        if (this.isAddMode() || ((String)this.item.get("login")).isEmpty()) {
            this.radiusTab.setLoginListener();
        }
    }

    @Override
    protected void saveInfo() throws UrfaException {
        AddressWithMask addressWithMask;
        this.item.remove("ip4_subnet");
        this.item.remove("ip6_subnet");
        AddressWithMask addressWithMask2 = this.ipSettingsTab.getIPv4Subnet();
        if (addressWithMask2 != null) {
            this.item.put("ip4_subnet", addressWithMask2);
        }
        if ((addressWithMask = this.ipSettingsTab.getIPv6Subnet()) != null) {
            this.item.put("ip6_subnet", addressWithMask);
        }
        this.item.put("id", this.id);
        this.item.put("login", this.radiusTab.getLogin());
        this.item.put("password", this.radiusTab.getPassword());
        this.item.put("allowed_cid", this.radiusTab.getAllowedCID());
        this.item.put("pool_name", this.radiusTab.getPoolName());
        this.item.put("mac", this.dhcpTab.getMACAddress());
        this.item.put("switch_id", this.dhcpTab.getSwitchId());
        this.item.put("port_id", this.dhcpTab.getPortId());
        this.item.put("vlan_id", this.dhcpTab.getVlanId());
        this.item.put("pool_id", this.dhcpTab.getDhcpPool());
        this.item.put("not_vpn", this.additionalTab.isNotVPN() ? 1 : 0);
        this.item.put("do_not_affect_firewall", this.additionalTab.isNotAffectFW() ? 1 : 0);
        this.item.put("is_dynamic", this.ipSettingsTab.getIsDynamic() ? 1 : 0);
        this.item.put("dhcpOptionsData", this.dhcpTab.getDhcpOptionsData());
        this.item.put("isgAttrsData", this.isgAttrsTab.getAttrsData());
        if (Utils.isAdmin()) {
            this.item.put("router_id", this.additionalTab.getFirewallId());
        } else {
            this.item.put("router_id", 0);
        }
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
        try {
            if (!this.settingListeners && this.dhcpTab.getDhcpPool() == 0 && this.radiusTab.isPoolEmpty()) {
                this.ipSettingsTab.checkNotEmpty();
            }
            this.ipSettingsTab.checkData();
            this.radiusTab.checkData();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.tabbedPane.setSelectedIndex(0);
            this.log.log(1, illegalArgumentException.getMessage());
            throw illegalArgumentException;
        }
        if (!this.settingListeners) {
            try {
                this.dhcpTab.check();
            }
            catch (IllegalStateException illegalStateException) {
                this.tabbedPane.setSelectedIndex(2);
                this.log.log(1, illegalStateException.getMessage());
                throw new IllegalArgumentException(illegalStateException.getMessage());
            }
        }
        Set set = (Set)this.item.get("ips");
        AddressWithMask[] addressWithMaskArray = new AddressWithMask[]{this.ipSettingsTab.getIPv4Subnet(), this.ipSettingsTab.getIPv6Subnet()};
        for (int i = 0; i < addressWithMaskArray.length; ++i) {
            if (addressWithMaskArray[i] == null) continue;
            String string = addressWithMaskArray[i].toString();
            for (AddressWithMask addressWithMask : set) {
                if (!addressWithMask.toString().equals(string)) continue;
                this.log.log(1, this.resource.getString("Attempt to add one more ip / mask item"));
                throw new IllegalArgumentException();
            }
        }
    }
}

