/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetChargePolicyForService;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetChargePolicyList;
import biz.netup.control.transport.urfa.functions.UrfaGetChargePolicyForService;
import biz.netup.control.transport.urfa.functions.UrfaGetChargePolicyList;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.chargepolicy.ChargePolicy;
import biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.chargepolicy.ChargePolicyDialog;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;

public class ChargePolicyElements {
    private boolean isLoaded;
    private JComboBox chargePolicyCB;
    private ButtonListener buttonListener;
    private int policiesSize;
    private int[] policiesId;
    private int[] flags;
    private String[] name;
    private int[][] tm;

    public ChargePolicyElements(JComboBox jComboBox, JButton jButton) {
        this.chargePolicyCB = jComboBox;
        try {
            Object object;
            if (Utils.isAdmin()) {
                object = new UrfaGetChargePolicyList(UrfaManagerImpl.getInstance());
                ((UrfaGetChargePolicyList)object).call();
                this.policiesSize = ((UrfaGetChargePolicyList)object).getPolicyCount();
                this.policiesId = ((UrfaGetChargePolicyList)object).getPolicyIdArray1();
                this.flags = ((UrfaGetChargePolicyList)object).getFlagsArray1();
                this.name = ((UrfaGetChargePolicyList)object).getNameArray1();
                this.tm = ((UrfaGetChargePolicyList)object).getTimemark2();
            } else {
                object = new UrfaDealerGetChargePolicyList(UrfaManagerImpl.getInstance());
                ((UrfaDealerGetChargePolicyList)object).call();
                this.policiesSize = ((UrfaDealerGetChargePolicyList)object).getPoliciesSize();
                this.policiesId = ((UrfaDealerGetChargePolicyList)object).getPolicyId();
                this.flags = ((UrfaDealerGetChargePolicyList)object).getFlags();
                this.name = ((UrfaDealerGetChargePolicyList)object).getName();
                this.tm = ((UrfaDealerGetChargePolicyList)object).getTimeMarks();
            }
            for (int i = 0; i < this.policiesSize; ++i) {
                jComboBox.addItem(new Item(this.policiesId[i], this.name[i]));
            }
            this.isLoaded = true;
        }
        catch (UrfaException urfaException) {
            Dialogs.showErrorDialog("cant get charge policies");
            jComboBox.setEnabled(false);
            jButton.setEnabled(false);
            this.isLoaded = false;
        }
        this.buttonListener = new ButtonListener();
        jButton.addActionListener(this.buttonListener);
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                Item item = (Item)jComboBox.getSelectedItem();
                ChargePolicyElements.this.buttonListener.setPolicyId(item.id);
            }
        });
    }

    public void setPolicy(int n) {
        if (!this.isLoaded) {
            return;
        }
        for (int i = 0; i < this.chargePolicyCB.getItemCount(); ++i) {
            Item item = (Item)this.chargePolicyCB.getItemAt(i);
            if (item.id != n) continue;
            this.chargePolicyCB.setSelectedItem(item);
        }
    }

    public void setDefaultPolicy(int n) {
        if (!this.isLoaded) {
            return;
        }
        int n2 = -1;
        try {
            Object object;
            if (Utils.isAdmin()) {
                object = new UrfaGetChargePolicyForService(UrfaManagerImpl.getInstance());
                ((UrfaGetChargePolicyForService)object).setServiceId(n);
                ((UrfaGetChargePolicyForService)object).call();
                n2 = ((UrfaGetChargePolicyForService)object).getChargePolicyId();
            } else {
                object = new UrfaDealerGetChargePolicyForService(UrfaManagerImpl.getInstance());
                ((UrfaDealerGetChargePolicyForService)object).setServiceId(n);
                ((UrfaDealerGetChargePolicyForService)object).call();
                n2 = ((UrfaDealerGetChargePolicyForService)object).getChargePolicyId();
            }
        }
        catch (UrfaException urfaException) {
            return;
        }
        for (int i = 0; i < this.chargePolicyCB.getItemCount(); ++i) {
            Item item = (Item)this.chargePolicyCB.getItemAt(i);
            if (item.id != n2) continue;
            this.chargePolicyCB.setSelectedItem(item);
        }
    }

    public int getPolicy() {
        if (!this.isLoaded) {
            return -1;
        }
        Item item = (Item)this.chargePolicyCB.getSelectedItem();
        return item.id;
    }

    private class ButtonListener
    implements ActionListener {
        private int policyId;

        private ButtonListener() {
        }

        public void setPolicyId(int n) {
            this.policyId = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = -1;
            for (int i = 0; i < ChargePolicyElements.this.policiesSize; ++i) {
                if (ChargePolicyElements.this.policiesId[i] != this.policyId) continue;
                n = i;
                break;
            }
            if (n == -1) {
                Dialogs.showErrorDialog("cant get charge policy");
                return;
            }
            Vector<Integer> vector = new Vector<Integer>();
            for (int i = 0; i < ChargePolicyElements.this.tm[n].length; ++i) {
                vector.add(ChargePolicyElements.this.tm[n][i]);
            }
            ChargePolicy chargePolicy = new ChargePolicy();
            chargePolicy.id = this.policyId;
            chargePolicy.flags = ChargePolicyElements.this.flags[n];
            chargePolicy.name = ChargePolicyElements.this.name[n];
            chargePolicy.timemarks = vector;
            ChargePolicyDialog chargePolicyDialog = new ChargePolicyDialog(chargePolicy);
            chargePolicyDialog.setReadOnly(true);
            chargePolicyDialog.setVisible(true);
        }
    }

    private class Item {
        public int id;
        public String name;

        Item(int n, String string) {
            this.id = n;
            this.name = string;
        }

        public String toString() {
            return this.name + " (" + this.id + ")";
        }
    }
}

