/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetCoeffScheduleLinkList;
import biz.netup.control.transport.urfa.functions.UrfaDelCoeffScheduleLink;
import biz.netup.control.transport.urfa.functions.UrfaGetCoeffScheduleLinkList;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.dealer.custom.HouseFunctions;
import biz.netup.projects.utmadmin.functions.dealer.user.tarification.sl.SLFunctions;
import biz.netup.projects.utmadmin.functions.dealer.user.user.UserFunctions;
import biz.netup.projects.utmadmin.functions.objects.PeriodicSL;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.buildings.MainBuildingsTab;
import biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.ap.MainAPTab;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.ChargePolicyElements;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.PeriodicStats;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.PeriodicStatsDialog;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.ScheduleLink.AddScheduleLinkDialog;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.SchemeComboBoxWrapper;
import biz.netup.swing.datetime.JDateTime;
import biz.netup.utmutils.control.Logger;
import biz.netup.utmutils.control.TZ;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialog.DialogModel;
import biz.netup.utmutils.swing.dialog.SelectFromTableDialogModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class AddPeriodicServiceLinkDialog
extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JTextField serviceNameTextField;
    private JTextField accountingPeriodTextField;
    private JButton selectDiscountPeriodButton;
    private JLabel accountingPeriodLabel;
    private JDateTime startDateDateTime;
    private JDateTime expireDateDateTime;
    private JTextField costCoefTextField;
    private JComboBox chargePolicyCB;
    private JButton detailsButton;
    private JTextField chargedTB;
    private JButton periodicStatsButton;
    private JPanel mainBorder;
    private JLabel buildingIDLabel;
    private JTextField buildingIDTextField;
    private JButton selectBuildingIDButton;
    private JButton clearButton;
    private JTextField commentTextField;
    private JButton selectScheduleButton;
    private JButton clearScheduleButton;
    private JDateTime startScheduleDateDateTime;
    private JComboBox schemeCB;
    private JLabel startScheduleDateLabel = new JLabel();
    private JLabel schemeForScheduleLabel = new JLabel();
    private JTextField houseCommentTextField;
    private int discountPeriod;
    private int uid;
    private int aid;
    private int serviceId;
    protected int slinkId = 0;
    private int tariffLinkId = 0;
    private int buildingId;
    PeriodicSL psl;
    ChargePolicyElements chargePolicy;
    PeriodicStats periodicStats;
    SchemeComboBoxWrapper schemeCBWrapper;
    private static final Logger logger = Utils.getLogger();

    public AddPeriodicServiceLinkDialog(int n, int n2, int n3, String string) {
        this(n, n2, n3, string, 0, 0, 0);
    }

    public void setReadOnly() {
        DialogModel.setReadOnlyForComponent(this.contentPane);
        this.buttonOK.setVisible(false);
        this.buttonCancel.setText(Utils.getResource().getString("Close"));
        this.buttonCancel.setEnabled(true);
    }

    public AddPeriodicServiceLinkDialog(int n, int n2, final int n3, String string, final int n4, int n5, int n6) {
        this();
        this.uid = n;
        this.aid = n2;
        this.serviceId = n3;
        this.tariffLinkId = n5;
        this.slinkId = n4;
        this.discountPeriod = n6;
        this.periodicStats.Attach(this.chargedTB, this.periodicStatsButton, n4, PeriodicStatsDialog.SlinkType.Periodic);
        this.chargePolicy.setDefaultPolicy(n3);
        this.serviceNameTextField.setText(string);
        if (n4 == 0) {
            this.psl = new PeriodicSL();
            this.startDateDateTime.setDate(TZ.getCoreTime());
            this.expireDateDateTime.setDate(new Date(2000000000000L));
            this.setBuildingIDTextField(0);
            this.selectScheduleButton.setEnabled(false);
            this.clearScheduleButton.setEnabled(false);
            this.startScheduleDateDateTime.setDate(TZ.getCoreTime());
            this.schemeCBWrapper.setSchemeIdByServiceId(n3);
        } else {
            this.loadPSL();
            this.schemeCBWrapper.setSchemeIdBySlinkId(n4);
            this.disableSelectElements();
        }
        if (n5 != 0) {
            this.disableDiscountElements();
        }
        this.selectBuildingIDButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectFromTableDialogModel selectFromTableDialogModel = new SelectFromTableDialogModel(new MainBuildingsTab());
                Dimension dimension = new Dimension(600, 500);
                Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
                selectFromTableDialogModel.setSize(dimension);
                selectFromTableDialogModel.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
                selectFromTableDialogModel.setVisible(true);
                if (selectFromTableDialogModel.isOkPressed()) {
                    AddPeriodicServiceLinkDialog.this.buildingId = (Integer)selectFromTableDialogModel.getItem().get("id");
                    AddPeriodicServiceLinkDialog.this.setBuildingId(AddPeriodicServiceLinkDialog.this.buildingId);
                }
            }
        });
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddPeriodicServiceLinkDialog.this.setBuildingIDTextField(0);
            }
        });
        this.selectScheduleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddScheduleLinkDialog addScheduleLinkDialog = new AddScheduleLinkDialog(n4, n3);
                addScheduleLinkDialog.setVisible(true);
                if (addScheduleLinkDialog.isOkPressed()) {
                    try {
                        AddPeriodicServiceLinkDialog.this.costCoefTextField.setText(String.valueOf(AddPeriodicServiceLinkDialog.this.loadData().getCostCoef() * 100.0));
                    }
                    catch (UrfaException urfaException) {
                        logger.error(urfaException);
                    }
                }
            }
        });
        this.clearScheduleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                block5: {
                    try {
                        if (Utils.isAdmin()) {
                            UrfaGetCoeffScheduleLinkList urfaGetCoeffScheduleLinkList = new UrfaGetCoeffScheduleLinkList(UrfaManagerImpl.getInstance());
                            urfaGetCoeffScheduleLinkList.call();
                            for (int i = 0; i < urfaGetCoeffScheduleLinkList.getListSize(); ++i) {
                                if (urfaGetCoeffScheduleLinkList.getSlinkId1()[i] != n4) continue;
                                UrfaDelCoeffScheduleLink urfaDelCoeffScheduleLink = new UrfaDelCoeffScheduleLink(UrfaManagerImpl.getInstance());
                                urfaDelCoeffScheduleLink.setId(urfaGetCoeffScheduleLinkList.getId1()[i]);
                                urfaDelCoeffScheduleLink.call();
                                AddPeriodicServiceLinkDialog.this.costCoefTextField.setText(String.valueOf(AddPeriodicServiceLinkDialog.this.loadData().getCostCoef() * 100.0));
                                break block5;
                            }
                            break block5;
                        }
                        UrfaDealerGetCoeffScheduleLinkList urfaDealerGetCoeffScheduleLinkList = new UrfaDealerGetCoeffScheduleLinkList(UrfaManagerImpl.getInstance());
                        urfaDealerGetCoeffScheduleLinkList.call();
                        for (int i = 0; i < urfaDealerGetCoeffScheduleLinkList.getListSize(); ++i) {
                            if (urfaDealerGetCoeffScheduleLinkList.getSlinkId1()[i] != n4) continue;
                            UrfaDelCoeffScheduleLink urfaDelCoeffScheduleLink = new UrfaDelCoeffScheduleLink(UrfaManagerImpl.getInstance());
                            urfaDelCoeffScheduleLink.setId(urfaDealerGetCoeffScheduleLinkList.getId1()[i]);
                            urfaDelCoeffScheduleLink.call();
                            AddPeriodicServiceLinkDialog.this.costCoefTextField.setText(String.valueOf(AddPeriodicServiceLinkDialog.this.loadData().getCostCoef() * 100.0));
                            break;
                        }
                    }
                    catch (UrfaException urfaException) {
                        logger.error(urfaException);
                    }
                }
            }
        });
    }

    private void setBuildingId(int n) {
        if (n != 0) {
            this.buildingIDTextField.setText(HouseFunctions.getHouseName(n) + " (" + n + ")");
        } else {
            this.buildingIDTextField.setText("");
        }
    }

    public void setBuildingIDTextField(int n) {
        this.buildingId = n;
        this.setBuildingId(n);
    }

    protected PeriodicSL loadData() throws UrfaException {
        return SLFunctions.getPeriodicSL(this.slinkId);
    }

    protected void saveData(PeriodicSL periodicSL) throws UrfaException {
        if (this.slinkId == 0) {
            this.slinkId = SLFunctions.addPeriodicSL(periodicSL);
        } else {
            SLFunctions.editPeriodicSL(periodicSL);
        }
    }

    protected void setMainBorderText(String string) {
        this.mainBorder.setBorder(BorderFactory.createTitledBorder(Utils.getResource().getString(string)));
    }

    private void disableSelectElements() {
        this.selectDiscountPeriodButton.setEnabled(false);
        this.startDateDateTime.setEnabled(false);
        this.startScheduleDateDateTime.setEnabled(false);
        this.startScheduleDateDateTime.setVisible(false);
        this.startScheduleDateLabel.setVisible(false);
        this.schemeCB.setEnabled(false);
        this.schemeCBWrapper.setEnabled(false);
    }

    private void disableDiscountElements() {
        this.accountingPeriodTextField.setText(Resolve.getAPName(this.discountPeriod));
        this.selectDiscountPeriodButton.setEnabled(false);
    }

    private void loadPSL() {
        try {
            this.psl = this.loadData();
            this.startDateDateTime.setDate(new Date((long)this.psl.getStartDate() * 1000L));
            this.expireDateDateTime.setDate(new Date((long)this.psl.getExpireDate() * 1000L));
            this.discountPeriod = this.psl.getDiscountPeriodId();
            this.accountingPeriodTextField.setText(Resolve.getAPName(this.discountPeriod));
            this.costCoefTextField.setText(String.valueOf(this.psl.getCostCoef() * 100.0));
            this.buildingId = this.psl.getHouseId();
            this.setBuildingId(this.buildingId);
            this.commentTextField.setText(this.psl.getComment());
            this.houseCommentTextField.setText(this.psl.getHouseComment());
            this.chargePolicy.setPolicy(this.psl.getPolicyId());
            this.startScheduleDateDateTime.setDate(new Date((long)this.psl.getStartDate() * 1000L));
        }
        catch (UrfaException urfaException) {
            logger.error(urfaException);
        }
    }

    public AddPeriodicServiceLinkDialog() {
        this.$$$setupUI$$$();
        this.setContentPane(this.contentPane);
        this.setModal(true);
        URL uRL = this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/logo32.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.setSize(400, this.getPreferredSize().height + 30);
        this.setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.setTitle(Utils.getResource().getString("Periodic service link"));
        this.setIconImage(imageIcon.getImage());
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddPeriodicServiceLinkDialog.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddPeriodicServiceLinkDialog.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AddPeriodicServiceLinkDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddPeriodicServiceLinkDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.selectDiscountPeriodButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddPeriodicServiceLinkDialog.this.selectDiscountPeriod();
            }
        });
        this.chargePolicy = new ChargePolicyElements(this.chargePolicyCB, this.detailsButton);
        this.periodicStats = new PeriodicStats();
        this.schemeCBWrapper = new SchemeComboBoxWrapper(this.startScheduleDateDateTime, this.schemeCB);
    }

    private void selectDiscountPeriod() {
        SelectFromTableDialogModel selectFromTableDialogModel = new SelectFromTableDialogModel(new MainAPTab());
        selectFromTableDialogModel.setVisible(true);
        if (selectFromTableDialogModel.isOkPressed()) {
            this.buttonOK.setEnabled(true);
            this.discountPeriod = (Integer)selectFromTableDialogModel.getItem().get("serial_id");
            this.accountingPeriodTextField.setText(Resolve.getAPName(this.discountPeriod));
        }
    }

    private void onOK() {
        if (this.discountPeriod == 0) {
            Dialogs.showErrorDialog("Discount period doesn't selected");
            return;
        }
        int n = this.chargePolicy.getPolicy();
        if (n == -1) {
            n = this.psl.getPolicyId();
        }
        this.psl.setAccountId(this.aid);
        this.psl.setUserId(this.uid);
        this.psl.setDiscountPeriodId(this.discountPeriod);
        this.psl.setExpireDate((int)(this.expireDateDateTime.getDate().getTime() / 1000L));
        this.psl.setServiceId(this.serviceId);
        this.psl.setServiceType(2);
        this.psl.setTariffLinkId(this.tariffLinkId);
        this.psl.setStartDate((int)(this.startDateDateTime.getDate().getTime() / 1000L));
        this.psl.setPolicyId(n);
        this.psl.setTariffId(this.tariffLinkId);
        this.psl.setSlinkId(this.slinkId);
        double d = this.schemeCBWrapper.getCostCoefficient();
        if (d != -1.0) {
            this.psl.setCostCoef(d);
        } else {
            this.psl.setCostCoef(Double.valueOf(this.costCoefTextField.getText()) / 100.0);
        }
        try {
            if (UserFunctions.getUser((int)this.uid).houseId == this.buildingId) {
                this.setBuildingIDTextField(0);
            }
        }
        catch (UrfaException urfaException) {
            urfaException.printStackTrace();
        }
        this.psl.setHouseId(this.buildingId);
        this.psl.setHouseComment(this.houseCommentTextField.getText());
        this.psl.setComment(this.commentTextField.getText());
        try {
            this.saveData(this.psl);
            if (this.schemeCBWrapper.isEnabled()) {
                this.schemeCBWrapper.CreateScheduleLink(this.slinkId);
            }
        }
        catch (UrfaException urfaException) {
            logger.error(urfaException);
        }
        this.dispose();
    }

    private void onCancel() {
        this.dispose();
    }

    private void createUIComponents() {
        this.startDateDateTime = new JDateTime();
        this.startDateDateTime.getButton().setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/down16.png")));
        this.startDateDateTime.getButton().setText("");
        this.expireDateDateTime = new JDateTime();
        this.expireDateDateTime.getButton().setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/up16.png")));
        this.expireDateDateTime.getButton().setText("");
        this.expireDateDateTime.setInfinity(true);
        this.startScheduleDateDateTime = new JDateTime();
        this.startScheduleDateDateTime.getButton().setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/down16.png")));
        this.startScheduleDateDateTime.getButton().setText("");
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.contentPane.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel.add((Component)jPanel2, "East");
        this.buttonOK = new JButton();
        this.buttonOK.setEnabled(true);
        this.buttonOK.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/ok16.png")));
        this.$$$loadButtonText$$$(this.buttonOK, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Ok"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.buttonOK, gridBagConstraints);
        this.buttonCancel = new JButton();
        this.buttonCancel.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/cancel16.png")));
        this.$$$loadButtonText$$$(this.buttonCancel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Cancel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.buttonCancel, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel5, gridBagConstraints);
        this.mainBorder = new JPanel();
        this.mainBorder.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.contentPane.add((Component)this.mainBorder, gridBagConstraints);
        this.mainBorder.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Periodic service link parameters")));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Service name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainBorder.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("End date"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainBorder.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Start date"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainBorder.add((Component)jLabel3, gridBagConstraints);
        this.accountingPeriodLabel = new JLabel();
        this.$$$loadLabelText$$$(this.accountingPeriodLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Accounting period"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainBorder.add((Component)this.accountingPeriodLabel, gridBagConstraints);
        this.serviceNameTextField = new JTextField();
        this.serviceNameTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)this.serviceNameTextField, gridBagConstraints);
        this.accountingPeriodTextField = new JTextField();
        this.accountingPeriodTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)this.accountingPeriodTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.mainBorder.add((Component)this.startDateDateTime, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.mainBorder.add((Component)this.expireDateDateTime, gridBagConstraints);
        this.selectDiscountPeriodButton = new JButton();
        this.selectDiscountPeriodButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/configure16.png")));
        this.$$$loadButtonText$$$(this.selectDiscountPeriodButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Select"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)this.selectDiscountPeriodButton, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)jPanel8, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)jPanel9, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        this.mainBorder.add((Component)jPanel10, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        this.mainBorder.add((Component)jPanel11, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.mainBorder.add((Component)jPanel12, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        this.mainBorder.add((Component)jPanel13, gridBagConstraints);
        this.costCoefTextField = new JTextField();
        this.costCoefTextField.setText("100");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)this.costCoefTextField, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)jPanel14, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Cost_%"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainBorder.add((Component)jLabel4, gridBagConstraints);
        this.chargePolicyCB = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)this.chargePolicyCB, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Charge policy"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 13;
        this.mainBorder.add((Component)jLabel5, gridBagConstraints);
        JPanel jPanel15 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)jPanel15, gridBagConstraints);
        this.detailsButton = new JButton();
        this.$$$loadButtonText$$$(this.detailsButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Details"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)this.detailsButton, gridBagConstraints);
        JPanel jPanel16 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)jPanel16, gridBagConstraints);
        JPanel jPanel17 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)jPanel17, gridBagConstraints);
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Charged"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 13;
        this.mainBorder.add((Component)jLabel6, gridBagConstraints);
        this.periodicStatsButton = new JButton();
        this.$$$loadButtonText$$$(this.periodicStatsButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Details"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)this.periodicStatsButton, gridBagConstraints);
        this.buildingIDLabel = new JLabel();
        this.$$$loadLabelText$$$(this.buildingIDLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("House"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainBorder.add((Component)this.buildingIDLabel, gridBagConstraints);
        this.buildingIDTextField = new JTextField();
        this.buildingIDTextField.setEditable(false);
        this.buildingIDTextField.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)this.buildingIDTextField, gridBagConstraints);
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Comment"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 26;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainBorder.add((Component)jLabel7, gridBagConstraints);
        this.commentTextField = new JTextField();
        this.commentTextField.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 26;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)this.commentTextField, gridBagConstraints);
        this.selectBuildingIDButton = new JButton();
        this.selectBuildingIDButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/configure16.png")));
        this.$$$loadButtonText$$$(this.selectBuildingIDButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Select"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 22;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)this.selectBuildingIDButton, gridBagConstraints);
        JPanel jPanel18 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 21;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)jPanel18, gridBagConstraints);
        JPanel jPanel19 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 25;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)jPanel19, gridBagConstraints);
        this.clearButton = new JButton();
        this.clearButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/delete16.png")));
        this.$$$loadButtonText$$$(this.clearButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Clear"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 22;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)this.clearButton, gridBagConstraints);
        this.chargedTB = new JTextField();
        this.chargedTB.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)this.chargedTB, gridBagConstraints);
        this.$$$loadLabelText$$$(this.startScheduleDateLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Start schedule date"));
        this.startScheduleDateLabel.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainBorder.add((Component)this.startScheduleDateLabel, gridBagConstraints);
        this.startScheduleDateDateTime.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.mainBorder.add((Component)this.startScheduleDateDateTime, gridBagConstraints);
        JPanel jPanel20 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)jPanel20, gridBagConstraints);
        this.$$$loadLabelText$$$(this.schemeForScheduleLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Scheme for schedule"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 17;
        this.mainBorder.add((Component)this.schemeForScheduleLabel, gridBagConstraints);
        this.schemeCB = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)this.schemeCB, gridBagConstraints);
        JPanel jPanel21 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)jPanel21, gridBagConstraints);
        this.selectScheduleButton = new JButton();
        this.selectScheduleButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/configure16.png")));
        this.$$$loadButtonText$$$(this.selectScheduleButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Select"));
        this.selectScheduleButton.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)this.selectScheduleButton, gridBagConstraints);
        this.clearScheduleButton = new JButton();
        this.clearScheduleButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/delete16.png")));
        this.$$$loadButtonText$$$(this.clearScheduleButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Clear"));
        this.clearScheduleButton.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)this.clearScheduleButton, gridBagConstraints);
        JPanel jPanel22 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)jPanel22, gridBagConstraints);
        this.houseCommentTextField = new JTextField();
        this.houseCommentTextField.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 24;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)this.houseCommentTextField, gridBagConstraints);
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Address comment"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 24;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainBorder.add((Component)jLabel8, gridBagConstraints);
        JPanel jPanel23 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 23;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)jPanel23, gridBagConstraints);
        JPanel jPanel24 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.contentPane.add((Component)jPanel24, gridBagConstraints);
        JPanel jPanel25 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.contentPane.add((Component)jPanel25, gridBagConstraints);
        JPanel jPanel26 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.contentPane.add((Component)jPanel26, gridBagConstraints);
        jLabel.setLabelFor(this.serviceNameTextField);
        this.accountingPeriodLabel.setLabelFor(this.accountingPeriodTextField);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

