/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaAddIptvServiceLink;
import biz.netup.control.transport.urfa.functions.UrfaCreateAccessCard;
import biz.netup.control.transport.urfa.functions.UrfaDealerAddIptvServiceLink;
import biz.netup.control.transport.urfa.functions.UrfaDealerEditIptvServiceLink;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetIptvServiceLink;
import biz.netup.control.transport.urfa.functions.UrfaDealerSetIptvCustomData;
import biz.netup.control.transport.urfa.functions.UrfaEditIptvServiceLink;
import biz.netup.control.transport.urfa.functions.UrfaGetAccessCardStatus;
import biz.netup.control.transport.urfa.functions.UrfaGetIptvCustomData;
import biz.netup.control.transport.urfa.functions.UrfaGetIptvService;
import biz.netup.control.transport.urfa.functions.UrfaGetIptvServiceLink;
import biz.netup.control.transport.urfa.functions.UrfaSetIptvCustomData;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.objects.PeriodicSL;
import biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.ap.MainAPTab;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.ChargePolicyElements;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.PeriodicStats;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.PeriodicStatsDialog;
import biz.netup.swing.datetime.JDateTime;
import biz.netup.utmutils.control.Logger;
import biz.netup.utmutils.control.TZ;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialog.DialogModel;
import biz.netup.utmutils.swing.dialog.SelectFromTableDialogModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class AddIptvServiceLinkDialog
extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JTextField serviceNameTextField;
    private JTextField accountingPeriodTextField;
    private JButton selectDiscountPeriodButton;
    private JLabel accountingPeriodLabel;
    private JDateTime startDateDateTime;
    private JDateTime expireDateDateTime;
    private JTextField costCoefTextField;
    private JComboBox chargePolicyCB;
    private JButton detailsButton;
    private JTextField chargedTB;
    private JButton periodicStatsButton;
    private JPanel mainBorder;
    private int discountPeriod;
    private int uid;
    private int aid;
    private int serviceId;
    protected int slinkId = 0;
    private int tariffLinkId = 0;
    private static final int TV_TYPE_NETUP = 0;
    private static final int TV_TYPE_OTHER = 3;
    private int type;
    PeriodicSL psl;
    ChargePolicyElements chargePolicy;
    PeriodicStats periodicStats;
    private static final Logger logger = Utils.getLogger();
    private JTextField accessCardTextField;
    private JButton createButton;
    private JLabel accessCardLabel;

    public AddIptvServiceLinkDialog(int n, int n2, int n3, String string) {
        this(n, n2, n3, string, 0, 0, 0);
    }

    public void setReadOnly() {
        DialogModel.setReadOnlyForComponent(this.contentPane);
        this.buttonOK.setVisible(false);
        this.buttonCancel.setText(Utils.getResource().getString("Close"));
        this.buttonCancel.setEnabled(true);
    }

    public AddIptvServiceLinkDialog(int n, int n2, int n3, String string, int n4, int n5, int n6) {
        this();
        this.uid = n;
        this.aid = n2;
        this.serviceId = n3;
        this.tariffLinkId = n5;
        this.slinkId = n4;
        this.discountPeriod = n6;
        this.periodicStats.Attach(this.chargedTB, this.periodicStatsButton, n4, PeriodicStatsDialog.SlinkType.Periodic);
        this.chargePolicy.setDefaultPolicy(n3);
        this.serviceNameTextField.setText(string);
        if (n4 == 0) {
            this.psl = new PeriodicSL();
            this.startDateDateTime.setDate(TZ.getCoreTime());
            this.expireDateDateTime.setDate(new Date(2000000000000L));
        } else {
            this.loadPSL();
            this.disableSelectElements();
        }
        if (n5 != 0) {
            this.disableDiscountElements();
        }
        if (UrfaManagerImpl.getInstance().isPermitted(new int[]{17698, 17674})) {
            UrfaGetIptvService urfaGetIptvService = new UrfaGetIptvService(UrfaManagerImpl.getInstance());
            urfaGetIptvService.setServiceId(n3);
            try {
                urfaGetIptvService.call();
            }
            catch (UrfaException urfaException) {
                return;
            }
            this.type = urfaGetIptvService.getTvType();
            if (this.type != 0) {
                this.buttonOK.setEnabled(true);
                this.createButton.setVisible(false);
                if (this.type == 3) {
                    this.accessCardLabel.setText(Utils.getResource().getString("Custom options"));
                    if (UrfaManagerImpl.getInstance().isPermitted(new int[]{17688})) {
                        this.accessCardTextField.setEditable(true);
                    }
                    if (UrfaManagerImpl.getInstance().isPermitted(new int[]{17687}) && n4 != 0) {
                        try {
                            UrfaGetIptvCustomData urfaGetIptvCustomData = new UrfaGetIptvCustomData(UrfaManagerImpl.getInstance());
                            urfaGetIptvCustomData.setSlinkId(n4);
                            urfaGetIptvCustomData.call();
                            this.accessCardTextField.setText(urfaGetIptvCustomData.getData());
                        }
                        catch (UrfaException urfaException) {
                            logger.error(urfaException);
                        }
                    }
                }
                return;
            }
            UrfaGetAccessCardStatus urfaGetAccessCardStatus = new UrfaGetAccessCardStatus(UrfaManagerImpl.getInstance());
            urfaGetAccessCardStatus.setAccountId(n2);
            try {
                urfaGetAccessCardStatus.call();
            }
            catch (UrfaException urfaException) {
                return;
            }
            if (urfaGetAccessCardStatus.getStatus() > 0) {
                this.accessCardTextField.setText(new Integer(urfaGetAccessCardStatus.getStatus()).toString());
            } else if (urfaGetAccessCardStatus.getStatus() == 0) {
                this.createButton.setEnabled(true);
            }
            if (this.accessCardTextField.getText().isEmpty()) {
                this.buttonOK.setEnabled(false);
            }
        }
    }

    private void disableSelectElements() {
        this.selectDiscountPeriodButton.setEnabled(false);
        this.startDateDateTime.setEnabled(false);
    }

    private void disableDiscountElements() {
        this.accountingPeriodTextField.setText(Resolve.getAPName(this.discountPeriod));
        this.selectDiscountPeriodButton.setEnabled(false);
    }

    private void loadPSL() {
        try {
            this.psl = this.loadData();
            this.startDateDateTime.setDate(new Date((long)this.psl.getStartDate() * 1000L));
            this.expireDateDateTime.setDate(new Date((long)this.psl.getExpireDate() * 1000L));
            this.discountPeriod = this.psl.getDiscountPeriodId();
            this.accountingPeriodTextField.setText(Resolve.getAPName(this.discountPeriod));
            this.costCoefTextField.setText(String.valueOf(this.psl.getCostCoef() * 100.0));
            this.chargePolicy.setPolicy(this.psl.getPolicyId());
        }
        catch (UrfaException urfaException) {
            logger.error(urfaException);
        }
    }

    public AddIptvServiceLinkDialog() {
        this.$$$setupUI$$$();
        this.setContentPane(this.contentPane);
        this.setModal(true);
        URL uRL = this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/logo32.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.setSize(450, this.getPreferredSize().height + 30);
        this.setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.setTitle(Utils.getResource().getString("IPTV service link"));
        this.setIconImage(imageIcon.getImage());
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddIptvServiceLinkDialog.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddIptvServiceLinkDialog.this.onCancel();
            }
        });
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddIptvServiceLinkDialog.this.createAccessCard();
            }
        });
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AddIptvServiceLinkDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddIptvServiceLinkDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.selectDiscountPeriodButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddIptvServiceLinkDialog.this.selectDiscountPeriod();
            }
        });
        this.chargePolicy = new ChargePolicyElements(this.chargePolicyCB, this.detailsButton);
        this.periodicStats = new PeriodicStats();
    }

    private void selectDiscountPeriod() {
        SelectFromTableDialogModel selectFromTableDialogModel = new SelectFromTableDialogModel(new MainAPTab());
        selectFromTableDialogModel.setVisible(true);
        if (selectFromTableDialogModel.isOkPressed()) {
            if (!this.accessCardTextField.getText().isEmpty()) {
                this.buttonOK.setEnabled(true);
            }
            this.discountPeriod = (Integer)selectFromTableDialogModel.getItem().get("serial_id");
            this.accountingPeriodTextField.setText(Resolve.getAPName(this.discountPeriod));
        }
    }

    private void onOK() {
        if (this.discountPeriod == 0) {
            Dialogs.showErrorDialog("Discount period doesn't selected");
            return;
        }
        int n = this.chargePolicy.getPolicy();
        if (n == -1) {
            n = this.psl.getPolicyId();
        }
        this.psl.setAccountId(this.aid);
        this.psl.setUserId(this.uid);
        this.psl.setDiscountPeriodId(this.discountPeriod);
        this.psl.setExpireDate((int)(this.expireDateDateTime.getDate().getTime() / 1000L));
        this.psl.setServiceId(this.serviceId);
        this.psl.setServiceType(2);
        this.psl.setTariffLinkId(this.tariffLinkId);
        this.psl.setStartDate((int)(this.startDateDateTime.getDate().getTime() / 1000L));
        this.psl.setPolicyId(n);
        this.psl.setTariffId(this.tariffLinkId);
        this.psl.setSlinkId(this.slinkId);
        this.psl.setCostCoef(Double.valueOf(this.costCoefTextField.getText()) / 100.0);
        this.psl.setComment(this.accessCardTextField.getText());
        try {
            this.saveData(this.psl);
        }
        catch (UrfaException urfaException) {
            logger.error(urfaException);
        }
        this.dispose();
    }

    private void onCancel() {
        this.dispose();
    }

    private void createUIComponents() {
        this.startDateDateTime = new JDateTime();
        this.startDateDateTime.getButton().setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/down16.png")));
        this.startDateDateTime.getButton().setText("");
        this.expireDateDateTime = new JDateTime();
        this.expireDateDateTime.getButton().setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/up16.png")));
        this.expireDateDateTime.getButton().setText("");
        this.expireDateDateTime.setInfinity(true);
    }

    private void createAccessCard() {
        UrfaCreateAccessCard urfaCreateAccessCard = new UrfaCreateAccessCard(UrfaManagerImpl.getInstance());
        urfaCreateAccessCard.setAccountId(this.aid);
        try {
            urfaCreateAccessCard.call();
        }
        catch (UrfaException urfaException) {
            urfaException.printStackTrace();
        }
        if (urfaCreateAccessCard.getResult() == 0) {
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                AddIptvServiceLinkDialog.this.buttonOK.setEnabled(false);
                AddIptvServiceLinkDialog.this.createButton.setEnabled(false);
                AddIptvServiceLinkDialog.this.createButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/refresh16.png")));
                for (int i = 0; i < 10; ++i) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    UrfaGetAccessCardStatus urfaGetAccessCardStatus = new UrfaGetAccessCardStatus(UrfaManagerImpl.getInstance());
                    urfaGetAccessCardStatus.setAccountId(AddIptvServiceLinkDialog.this.aid);
                    try {
                        urfaGetAccessCardStatus.call();
                    }
                    catch (UrfaException urfaException) {
                        break;
                    }
                    if (urfaGetAccessCardStatus.getStatus() <= 0) continue;
                    AddIptvServiceLinkDialog.this.accessCardTextField.setText(new Integer(urfaGetAccessCardStatus.getStatus()).toString());
                    break;
                }
                AddIptvServiceLinkDialog.this.createButton.setIcon(null);
                if (AddIptvServiceLinkDialog.this.accessCardTextField.getText().isEmpty()) {
                    AddIptvServiceLinkDialog.this.createButton.setEnabled(true);
                }
                if (!AddIptvServiceLinkDialog.this.accessCardTextField.getText().isEmpty() && !AddIptvServiceLinkDialog.this.accountingPeriodTextField.getText().isEmpty()) {
                    AddIptvServiceLinkDialog.this.buttonOK.setEnabled(true);
                }
            }
        };
        thread.start();
    }

    protected PeriodicSL loadData() throws UrfaException {
        PeriodicSL periodicSL = new PeriodicSL();
        if (Utils.isAdmin()) {
            UrfaGetIptvServiceLink urfaGetIptvServiceLink = new UrfaGetIptvServiceLink(UrfaManagerImpl.getInstance());
            urfaGetIptvServiceLink.setSlinkId(this.slinkId);
            urfaGetIptvServiceLink.call();
            periodicSL.setDiscountPeriodId(urfaGetIptvServiceLink.getApId());
            periodicSL.setStartDate(urfaGetIptvServiceLink.getStartDate());
            periodicSL.setExpireDate(urfaGetIptvServiceLink.getExpireDate());
            periodicSL.setPolicyId(urfaGetIptvServiceLink.getPolicyId());
            periodicSL.setCostCoef(urfaGetIptvServiceLink.getCostCoef());
        } else {
            UrfaDealerGetIptvServiceLink urfaDealerGetIptvServiceLink = new UrfaDealerGetIptvServiceLink(UrfaManagerImpl.getInstance());
            urfaDealerGetIptvServiceLink.setSlinkId(this.slinkId);
            urfaDealerGetIptvServiceLink.call();
            periodicSL.setDiscountPeriodId(urfaDealerGetIptvServiceLink.getApId());
            periodicSL.setStartDate(urfaDealerGetIptvServiceLink.getStartDate());
            periodicSL.setExpireDate(urfaDealerGetIptvServiceLink.getExpireDate());
            periodicSL.setPolicyId(urfaDealerGetIptvServiceLink.getPolicyId());
            periodicSL.setCostCoef(urfaDealerGetIptvServiceLink.getCostCoef());
        }
        return periodicSL;
    }

    protected void saveData(PeriodicSL periodicSL) throws UrfaException {
        Object object;
        if (this.slinkId == 0) {
            if (Utils.isAdmin()) {
                object = new UrfaAddIptvServiceLink(UrfaManagerImpl.getInstance());
                ((UrfaAddIptvServiceLink)object).setUserId(periodicSL.getUserId());
                ((UrfaAddIptvServiceLink)object).setAccountId(periodicSL.getAccountId());
                ((UrfaAddIptvServiceLink)object).setServiceId(periodicSL.getServiceId());
                ((UrfaAddIptvServiceLink)object).setTpLinkId(periodicSL.getTariffLinkId());
                ((UrfaAddIptvServiceLink)object).setApId(periodicSL.getDiscountPeriodId());
                ((UrfaAddIptvServiceLink)object).setStartDate(periodicSL.getStartDate());
                ((UrfaAddIptvServiceLink)object).setExpireDate(periodicSL.getExpireDate());
                ((UrfaAddIptvServiceLink)object).setPolicyId(periodicSL.getPolicyId());
                ((UrfaAddIptvServiceLink)object).setCostCoef(periodicSL.getCostCoef());
                ((UrfaAddIptvServiceLink)object).setComment(periodicSL.getComment());
                ((UrfaAddIptvServiceLink)object).call();
                this.slinkId = ((UrfaAddIptvServiceLink)object).getSlinkId();
                if (this.slinkId == -3) {
                    Dialogs.showErrorDialog(Utils.getResource().getString("Check service link uniqueness"));
                } else if (this.slinkId < 0) {
                    throw new UrfaException(Utils.getResource().getString("Cant add IPTV service link"));
                }
            } else {
                object = new UrfaDealerAddIptvServiceLink(UrfaManagerImpl.getInstance());
                ((UrfaDealerAddIptvServiceLink)object).setUserId(periodicSL.getUserId());
                ((UrfaDealerAddIptvServiceLink)object).setAccountId(periodicSL.getAccountId());
                ((UrfaDealerAddIptvServiceLink)object).setServiceId(periodicSL.getServiceId());
                ((UrfaDealerAddIptvServiceLink)object).setTpLinkId(periodicSL.getTariffLinkId());
                ((UrfaDealerAddIptvServiceLink)object).setApId(periodicSL.getDiscountPeriodId());
                ((UrfaDealerAddIptvServiceLink)object).setStartDate(periodicSL.getStartDate());
                ((UrfaDealerAddIptvServiceLink)object).setExpireDate(periodicSL.getExpireDate());
                ((UrfaDealerAddIptvServiceLink)object).setPolicyId(periodicSL.getPolicyId());
                ((UrfaDealerAddIptvServiceLink)object).setCostCoef(periodicSL.getCostCoef());
                ((UrfaDealerAddIptvServiceLink)object).setComment(periodicSL.getComment());
                ((UrfaDealerAddIptvServiceLink)object).call();
                this.slinkId = ((UrfaDealerAddIptvServiceLink)object).getSlinkId();
                if (this.slinkId == -3) {
                    Dialogs.showErrorDialog(Utils.getResource().getString("Check service link uniqueness"));
                } else if (this.slinkId < 0) {
                    throw new UrfaException(Utils.getResource().getString("Cant add IPTV service link"));
                }
            }
        } else if (Utils.isAdmin()) {
            object = new UrfaEditIptvServiceLink(UrfaManagerImpl.getInstance());
            ((UrfaEditIptvServiceLink)object).setSlinkId(this.slinkId);
            ((UrfaEditIptvServiceLink)object).setApId(periodicSL.getTariffLinkId());
            ((UrfaEditIptvServiceLink)object).setStartDate(periodicSL.getStartDate());
            ((UrfaEditIptvServiceLink)object).setExpireDate(periodicSL.getExpireDate());
            ((UrfaEditIptvServiceLink)object).setPolicyId(periodicSL.getPolicyId());
            ((UrfaEditIptvServiceLink)object).setCostCoef(periodicSL.getCostCoef());
            ((UrfaEditIptvServiceLink)object).setComment(periodicSL.getComment());
            ((UrfaEditIptvServiceLink)object).call();
            if (((UrfaEditIptvServiceLink)object).getSlinkId() < 0) {
                throw new UrfaException(Utils.getResource().getString("Cant edit IPTV service link"));
            }
        } else {
            object = new UrfaDealerEditIptvServiceLink(UrfaManagerImpl.getInstance());
            ((UrfaDealerEditIptvServiceLink)object).setSlinkId(this.slinkId);
            ((UrfaDealerEditIptvServiceLink)object).setApId(periodicSL.getTariffLinkId());
            ((UrfaDealerEditIptvServiceLink)object).setStartDate(periodicSL.getStartDate());
            ((UrfaDealerEditIptvServiceLink)object).setExpireDate(periodicSL.getExpireDate());
            ((UrfaDealerEditIptvServiceLink)object).setPolicyId(periodicSL.getPolicyId());
            ((UrfaDealerEditIptvServiceLink)object).setCostCoef(periodicSL.getCostCoef());
            ((UrfaDealerEditIptvServiceLink)object).setComment(periodicSL.getComment());
            ((UrfaDealerEditIptvServiceLink)object).call();
            if (((UrfaDealerEditIptvServiceLink)object).getSlinkId() < 0) {
                throw new UrfaException(Utils.getResource().getString("Cant edit IPTV service link"));
            }
        }
        if (this.type == 3 && this.slinkId > 0) {
            if (Utils.isAdmin()) {
                object = new UrfaSetIptvCustomData(UrfaManagerImpl.getInstance());
                ((UrfaSetIptvCustomData)object).setSlinkId(this.slinkId);
                ((UrfaSetIptvCustomData)object).setData(this.accessCardTextField.getText());
                ((UrfaSetIptvCustomData)object).call();
                if (((UrfaSetIptvCustomData)object).getResult() != 0) {
                    throw new UrfaException(Utils.getResource().getString("Cant set IPTV service link custom data"));
                }
            } else {
                object = new UrfaDealerSetIptvCustomData(UrfaManagerImpl.getInstance());
                ((UrfaDealerSetIptvCustomData)object).setSlinkId(this.slinkId);
                ((UrfaDealerSetIptvCustomData)object).setData(this.accessCardTextField.getText());
                ((UrfaDealerSetIptvCustomData)object).call();
                if (((UrfaDealerSetIptvCustomData)object).getResult() != 0) {
                    throw new UrfaException(Utils.getResource().getString("Cant set IPTV service link custom data"));
                }
            }
        }
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.contentPane.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel.add((Component)jPanel2, "East");
        this.buttonOK = new JButton();
        this.buttonOK.setEnabled(true);
        this.buttonOK.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/ok16.png")));
        this.$$$loadButtonText$$$(this.buttonOK, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Ok"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.buttonOK, gridBagConstraints);
        this.buttonCancel = new JButton();
        this.buttonCancel.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/cancel16.png")));
        this.$$$loadButtonText$$$(this.buttonCancel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Cancel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.buttonCancel, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel5, gridBagConstraints);
        this.mainBorder = new JPanel();
        this.mainBorder.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.contentPane.add((Component)this.mainBorder, gridBagConstraints);
        this.mainBorder.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("IPTV service link parameters")));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Service name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainBorder.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("End date"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainBorder.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Start date"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainBorder.add((Component)jLabel3, gridBagConstraints);
        this.accountingPeriodLabel = new JLabel();
        this.$$$loadLabelText$$$(this.accountingPeriodLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Accounting period"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainBorder.add((Component)this.accountingPeriodLabel, gridBagConstraints);
        this.serviceNameTextField = new JTextField();
        this.serviceNameTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)this.serviceNameTextField, gridBagConstraints);
        this.accountingPeriodTextField = new JTextField();
        this.accountingPeriodTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)this.accountingPeriodTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.mainBorder.add((Component)this.startDateDateTime, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.mainBorder.add((Component)this.expireDateDateTime, gridBagConstraints);
        this.selectDiscountPeriodButton = new JButton();
        this.selectDiscountPeriodButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/configure16.png")));
        this.$$$loadButtonText$$$(this.selectDiscountPeriodButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Select"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)this.selectDiscountPeriodButton, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)jPanel8, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)jPanel9, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)jPanel10, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        this.mainBorder.add((Component)jPanel11, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        this.mainBorder.add((Component)jPanel12, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.mainBorder.add((Component)jPanel13, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        this.mainBorder.add((Component)jPanel14, gridBagConstraints);
        this.costCoefTextField = new JTextField();
        this.costCoefTextField.setText("100");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)this.costCoefTextField, gridBagConstraints);
        JPanel jPanel15 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)jPanel15, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Cost_%"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainBorder.add((Component)jLabel4, gridBagConstraints);
        this.chargePolicyCB = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)this.chargePolicyCB, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Charge policy"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 13;
        this.mainBorder.add((Component)jLabel5, gridBagConstraints);
        JPanel jPanel16 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)jPanel16, gridBagConstraints);
        this.detailsButton = new JButton();
        this.$$$loadButtonText$$$(this.detailsButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Details"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)this.detailsButton, gridBagConstraints);
        JPanel jPanel17 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)jPanel17, gridBagConstraints);
        JPanel jPanel18 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)jPanel18, gridBagConstraints);
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Charged"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 13;
        this.mainBorder.add((Component)jLabel6, gridBagConstraints);
        this.chargedTB = new JTextField();
        this.chargedTB.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)this.chargedTB, gridBagConstraints);
        this.periodicStatsButton = new JButton();
        this.$$$loadButtonText$$$(this.periodicStatsButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Details"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)this.periodicStatsButton, gridBagConstraints);
        this.accessCardLabel = new JLabel();
        this.$$$loadLabelText$$$(this.accessCardLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("IPTV access card"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 17;
        this.mainBorder.add((Component)this.accessCardLabel, gridBagConstraints);
        JPanel jPanel19 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)jPanel19, gridBagConstraints);
        this.accessCardTextField = new JTextField();
        this.accessCardTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)this.accessCardTextField, gridBagConstraints);
        this.createButton = new JButton();
        this.createButton.setEnabled(false);
        this.$$$loadButtonText$$$(this.createButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Create"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        this.mainBorder.add((Component)this.createButton, gridBagConstraints);
        JPanel jPanel20 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.contentPane.add((Component)jPanel20, gridBagConstraints);
        JPanel jPanel21 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.contentPane.add((Component)jPanel21, gridBagConstraints);
        JPanel jPanel22 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.contentPane.add((Component)jPanel22, gridBagConstraints);
        jLabel.setLabelFor(this.serviceNameTextField);
        this.accountingPeriodLabel.setLabelFor(this.accountingPeriodTextField);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

