/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.userframe.forms.tarification.account.accountsdialogs;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaCreateAccessCard;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetRequirementPayment;
import biz.netup.control.transport.urfa.functions.UrfaGetAccessCardStatus;
import biz.netup.control.transport.urfa.functions.UrfaGetRegistryForm;
import biz.netup.control.transport.urfa.functions.UrfaGetRequirementPayment;
import biz.netup.control.transport.urfa.functions.UrfaIsAccountExternalIdUsed;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.dealer.user.tarification.accounts.AccountFunctions;
import biz.netup.projects.utmadmin.functions.objects.Account;
import biz.netup.swing.datetime.JDateTime;
import biz.netup.utmutils.control.TZ;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.permissions.PermissionTextField;
import biz.netup.utmutils.swing.dialog.DialogModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class UserAccountEditDialog
extends DialogModel {
    private JPanel contentPane;
    private JTextField accountIdTextField;
    private JComboBox blockedComboBox;
    private JTextField vatRateTextField;
    private JTextField saleTaxRateTextField;
    private JTextField creditTextField;
    private JTextField balanceTextField;
    private JComboBox internetStatusComboBox;
    private JCheckBox blockPeriodCheckBox;
    private JDateTime startPeriodDateTime;
    private JDateTime endPeriodDateTime;
    private JCheckBox unlimitedModeCheckBox;
    private JLabel accountLabel;
    private JLabel balanceLabel;
    private JTextField textField1;
    private PermissionTextField externalIdTextField;
    private JLabel externalIdLabel;
    private JCheckBox autoInetEnableCheckBox;
    private JLabel autoInetEnableLabel;
    private JLabel unlimitedModeLabel;
    private JTextField accessCardTextField;
    private JButton createButton;
    private JTextField requirementPaymentTextField;
    private JTextField irdetoAccessCardTextField;
    private JTextField irdetoSTBSerialNumberField;
    private JButton queriesButton;
    private int aid;
    private int uid;
    private String externalIdStart = "";
    private int prevBlockState = -1;

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.contentPane.add((Component)jPanel, "Center");
        this.accountIdTextField = new JTextField();
        this.accountIdTextField.setEditable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.accountIdTextField, gridBagConstraints);
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Block type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.accountLabel = new JLabel();
        this.$$$loadLabelText$$$(this.accountLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Account"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.accountLabel, gridBagConstraints);
        this.blockedComboBox = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.blockedComboBox, gridBagConstraints);
        this.creditTextField = new JTextField();
        this.creditTextField.setText("0.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.creditTextField, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Credit"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.balanceLabel = new JLabel();
        this.$$$loadLabelText$$$(this.balanceLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Ballance"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.balanceLabel, gridBagConstraints);
        this.balanceTextField = new JTextField();
        this.balanceTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.balanceTextField, gridBagConstraints);
        this.textField1 = new JTextField();
        this.textField1.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.textField1, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Block period"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.startPeriodDateTime, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.endPeriodDateTime, gridBagConstraints);
        this.blockPeriodCheckBox = new JCheckBox();
        this.blockPeriodCheckBox.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.blockPeriodCheckBox, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("VAT rate"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel4, gridBagConstraints);
        this.vatRateTextField = new JTextField();
        this.vatRateTextField.setText("0.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.vatRateTextField, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Sale tax rate"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel5, gridBagConstraints);
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("%");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jLabel6, gridBagConstraints);
        this.saleTaxRateTextField = new JTextField();
        this.saleTaxRateTextField.setText("0.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.saleTaxRateTextField, gridBagConstraints);
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("%");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jLabel7, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel7, gridBagConstraints);
        this.unlimitedModeLabel = new JLabel();
        this.$$$loadLabelText$$$(this.unlimitedModeLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Unlimited account"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.unlimitedModeLabel, gridBagConstraints);
        this.unlimitedModeCheckBox = new JCheckBox();
        this.unlimitedModeCheckBox.setText("");
        this.unlimitedModeCheckBox.setToolTipText(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Unlimited mode hint"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.unlimitedModeCheckBox, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel8, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel9, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel10, gridBagConstraints);
        this.internetStatusComboBox = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.internetStatusComboBox, gridBagConstraints);
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Internet status"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.externalIdTextField, gridBagConstraints);
        this.externalIdLabel = new JLabel();
        this.$$$loadLabelText$$$(this.externalIdLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("External account ID"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.externalIdLabel, gridBagConstraints);
        this.autoInetEnableLabel = new JLabel();
        this.$$$loadLabelText$$$(this.autoInetEnableLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Auto enable inet"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.autoInetEnableLabel, gridBagConstraints);
        this.autoInetEnableCheckBox = new JCheckBox();
        this.autoInetEnableCheckBox.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.autoInetEnableCheckBox, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel11, gridBagConstraints);
        JLabel jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("IPTV access card"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel9, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel12, gridBagConstraints);
        this.accessCardTextField = new JTextField();
        this.accessCardTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel12.add((Component)this.accessCardTextField, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel12.add((Component)jPanel13, gridBagConstraints);
        this.createButton = new JButton();
        this.createButton.setEnabled(false);
        this.$$$loadButtonText$$$(this.createButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Create"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel12.add((Component)this.createButton, gridBagConstraints);
        JLabel jLabel10 = new JLabel();
        this.$$$loadLabelText$$$(jLabel10, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Requirement payment"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel10, gridBagConstraints);
        this.requirementPaymentTextField = new JTextField();
        this.requirementPaymentTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.requirementPaymentTextField, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel14, gridBagConstraints);
        JLabel jLabel11 = new JLabel();
        this.$$$loadLabelText$$$(jLabel11, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Irdeto IPTV access card"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel11, gridBagConstraints);
        JPanel jPanel15 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel15, gridBagConstraints);
        JPanel jPanel16 = new JPanel();
        jPanel16.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel16, gridBagConstraints);
        this.irdetoAccessCardTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel16.add((Component)this.irdetoAccessCardTextField, gridBagConstraints);
        this.queriesButton = new JButton();
        this.$$$loadButtonText$$$(this.queriesButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Queries"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel16.add((Component)this.queriesButton, gridBagConstraints);
        JPanel jPanel17 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel17, gridBagConstraints);
        JLabel jLabel12 = new JLabel();
        jLabel12.setText("Irdeto IPTV STB");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel12, gridBagConstraints);
        JPanel jPanel18 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel18, gridBagConstraints);
        JPanel jPanel19 = new JPanel();
        jPanel19.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel19, gridBagConstraints);
        this.irdetoSTBSerialNumberField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel19.add((Component)this.irdetoSTBSerialNumberField, gridBagConstraints);
        JPanel jPanel20 = new JPanel();
        jPanel20.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel20, gridBagConstraints);
        jLabel.setLabelFor(this.blockedComboBox);
        this.accountLabel.setLabelFor(this.accountIdTextField);
        jLabel2.setLabelFor(this.creditTextField);
        this.balanceLabel.setLabelFor(this.balanceTextField);
        jLabel4.setLabelFor(this.vatRateTextField);
        jLabel5.setLabelFor(this.saleTaxRateTextField);
        jLabel8.setLabelFor(this.internetStatusComboBox);
        jLabel10.setLabelFor(this.balanceTextField);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private void changeBlockStatus() {
        if (this.blockPeriodCheckBox.isSelected()) {
            this.startPeriodDateTime.setEnabled(true);
            this.endPeriodDateTime.setEnabled(true);
        } else {
            this.startPeriodDateTime.setEnabled(false);
            this.endPeriodDateTime.setEnabled(false);
        }
    }

    private void initFields() throws UrfaException {
        this.blockedComboBox.addItem(new BlockTypeItem(0, Utils.getResource().getString("Not blocked")));
        this.blockedComboBox.addItem(new BlockTypeItem(256, Utils.getResource().getString("Administrative block")));
        if (this.aid == 0) {
            this.blockPeriodCheckBox.setEnabled(false);
            this.balanceLabel.setEnabled(false);
            this.accountLabel.setEnabled(false);
            if (Utils.isAdmin()) {
                UrfaGetRegistryForm urfaGetRegistryForm = new UrfaGetRegistryForm(UrfaManagerImpl.getInstance());
                urfaGetRegistryForm.setGroupId(9);
                urfaGetRegistryForm.setObjectId(0);
                urfaGetRegistryForm.call();
                for (int i = 0; i < urfaGetRegistryForm.getCount(); ++i) {
                    if (!urfaGetRegistryForm.getDescriptionArray1()[i].equalsIgnoreCase("Default vat rate")) continue;
                    try {
                        this.vatRateTextField.setText("" + Double.parseDouble(urfaGetRegistryForm.getValueArray2()[i][0]) * 100.0);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.log.log(2, "default_vat_rate format is incorrect");
                    }
                    break;
                }
            }
        } else {
            int n;
            Account account = AccountFunctions.getAccount(this.aid);
            this.accountIdTextField.setText("" + account.getAccountId());
            this.internetStatusComboBox.setSelectedIndex(account.getIntStatus());
            this.irdetoAccessCardTextField.setText(account.getIrdetoAccessCard());
            this.irdetoSTBSerialNumberField.setText(account.getIrdetoSTBSerialNumber());
            this.prevBlockState = n = account.getBlocked();
            if (n == 0) {
                this.blockedComboBox.setSelectedIndex(0);
                this.blockPeriodCheckBox.setEnabled(false);
            } else if ((n & 0x100) != 0) {
                this.blockedComboBox.setSelectedIndex(1);
            } else if ((n & 1) != 0) {
                this.blockedComboBox.addItem(new BlockTypeItem(1, Utils.getResource().getString("User block")));
                this.blockedComboBox.setSelectedIndex(2);
            } else {
                this.blockedComboBox.addItem(new BlockTypeItem(n, Utils.getResource().getString("Yes (non admin block)")));
                this.blockedComboBox.setSelectedIndex(2);
            }
            this.vatRateTextField.setText("" + (double)((long)(account.getVatRate() * 10000.0)) / 100.0);
            this.creditTextField.setText("" + (double)((long)(account.getCredit() * 1000.0)) / 1000.0);
            this.saleTaxRateTextField.setText("" + (double)((long)(account.getSaleTaxRate() * 10000.0)) / 100.0);
            this.balanceTextField.setText("" + (double)((long)(account.getBalance() * 1000.0)) / 1000.0);
            if (Utils.isAdmin()) {
                Object object;
                if (account.getUnlimited() == 1) {
                    this.unlimitedModeCheckBox.setSelected(true);
                }
                if (account.getAutoEnableInet() != 0) {
                    this.autoInetEnableCheckBox.setSelected(true);
                }
                this.externalIdTextField.setText(account.getExternalId());
                this.externalIdStart = account.getExternalId();
                if (UrfaManagerImpl.getInstance().isPermitted(new int[]{17674})) {
                    object = new UrfaGetAccessCardStatus(UrfaManagerImpl.getInstance());
                    ((UrfaGetAccessCardStatus)object).setAccountId(this.aid);
                    ((UrfaGetAccessCardStatus)object).call();
                    if (((UrfaGetAccessCardStatus)object).getStatus() > 0) {
                        this.accessCardTextField.setText(new Integer(((UrfaGetAccessCardStatus)object).getStatus()).toString());
                    } else if (((UrfaGetAccessCardStatus)object).getStatus() == 0) {
                        this.createButton.setEnabled(true);
                    }
                }
                object = new UrfaGetRequirementPayment(UrfaManagerImpl.getInstance());
                ((UrfaGetRequirementPayment)object).setAccountId(account.getAccountId());
                ((UrfaGetRequirementPayment)object).call();
                this.requirementPaymentTextField.setText("" + ((UrfaGetRequirementPayment)object).getResult());
            } else {
                UrfaDealerGetRequirementPayment urfaDealerGetRequirementPayment = new UrfaDealerGetRequirementPayment(UrfaManagerImpl.getInstance());
                urfaDealerGetRequirementPayment.setAccountId(account.getAccountId());
                urfaDealerGetRequirementPayment.call();
                this.requirementPaymentTextField.setText("" + urfaDealerGetRequirementPayment.getResult());
            }
        }
    }

    private int createAccount() throws UrfaException {
        return AccountFunctions.addAccount(this.uid);
    }

    private void saveAccount() throws UrfaException {
        Account account = new Account();
        account.setAccountId(this.aid);
        int n = ((BlockTypeItem)this.blockedComboBox.getSelectedItem()).typeVal;
        if (this.prevBlockState == n) {
            n |= 0x2000;
        }
        account.setBlocked(n);
        if (this.blockPeriodCheckBox.isSelected()) {
            account.setStartDate((int)(this.startPeriodDateTime.getDate().getTime() / 1000L));
            account.setEndDate((int)(this.endPeriodDateTime.getDate().getTime() / 1000L));
        }
        account.setCredit(Double.parseDouble(this.creditTextField.getText()));
        account.setIntStatus(this.internetStatusComboBox.getSelectedIndex());
        account.setSaleTaxRate(Double.parseDouble(this.saleTaxRateTextField.getText()) / 100.0);
        account.setVatRate(Double.parseDouble(this.vatRateTextField.getText()) / 100.0);
        if (Utils.isAdmin()) {
            account.setUnlimited(this.unlimitedModeCheckBox.isSelected() ? 1 : 0);
            account.setAutoEnableInet(this.autoInetEnableCheckBox.isSelected() ? 1 : 0);
            account.setExternalId(this.externalIdTextField.getText());
        }
        account.setIrdetoAccessCard(this.irdetoAccessCardTextField.getText());
        account.setIrdetoSTBSerialNumber(this.irdetoSTBSerialNumberField.getText());
        AccountFunctions.editAccount(account);
    }

    public UserAccountEditDialog() {
        this.$$$setupUI$$$();
    }

    public UserAccountEditDialog(Map<String, Object> map) {
        super(map);
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        return this.contentPane;
    }

    @Override
    public String getItemName() {
        return "Account";
    }

    @Override
    protected void loadInfo() throws UrfaException {
        this.aid = (Integer)this.item.get("aid");
        this.uid = (Integer)this.item.get("uid");
        if (!Utils.isAdmin()) {
            this.unlimitedModeCheckBox.setVisible(false);
            this.unlimitedModeLabel.setVisible(false);
            this.externalIdTextField.setVisible(false);
            this.externalIdLabel.setVisible(false);
            this.autoInetEnableCheckBox.setVisible(false);
            this.autoInetEnableLabel.setVisible(false);
        }
        this.internetStatusComboBox.addItem(this.resource.getString("Off"));
        this.internetStatusComboBox.addItem(this.resource.getString("On"));
        this.initFields();
        this.blockPeriodCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserAccountEditDialog.this.changeBlockStatus();
            }
        });
        this.blockedComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (UserAccountEditDialog.this.blockedComboBox.getSelectedIndex() == 0) {
                    UserAccountEditDialog.this.blockPeriodCheckBox.setSelected(false);
                    UserAccountEditDialog.this.blockPeriodCheckBox.setEnabled(false);
                } else {
                    UserAccountEditDialog.this.blockPeriodCheckBox.setEnabled(true);
                }
            }
        });
        this.unlimitedModeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (UserAccountEditDialog.this.unlimitedModeCheckBox.isSelected() && !Dialogs.showYesNoDialog(UserAccountEditDialog.this.resource.getString("Unlimited warning"))) {
                    UserAccountEditDialog.this.unlimitedModeCheckBox.setSelected(false);
                }
            }
        });
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserAccountEditDialog.this.createAccessCard(UserAccountEditDialog.this.aid);
            }
        });
        final JFrame jFrame = new JFrame();
        jFrame.setPreferredSize(new Dimension(600, 400));
        JToolBar jToolBar = new JToolBar();
        final JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new JMenuItem(new AbstractAction(this.resource.getString("Activate card")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                try {
                    string = AccountFunctions.irdetoActivateCard(UserAccountEditDialog.this.irdetoAccessCardTextField.getText());
                }
                catch (UrfaException urfaException) {
                    string = urfaException.getMessage();
                }
                JOptionPane.showMessageDialog(jFrame, string);
            }
        }));
        jPopupMenu.add(new JMenuItem(new AbstractAction(this.resource.getString("Deactivate card")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                try {
                    string = AccountFunctions.irdetoDeactivateCard(UserAccountEditDialog.this.irdetoAccessCardTextField.getText());
                }
                catch (UrfaException urfaException) {
                    string = urfaException.getMessage();
                }
                JOptionPane.showMessageDialog(jFrame, string);
            }
        }));
        jPopupMenu.add(new JMenuItem(new AbstractAction(this.resource.getString("Pair chipset")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                try {
                    string = AccountFunctions.irdetoPairChipset(UserAccountEditDialog.this.irdetoAccessCardTextField.getText(), UserAccountEditDialog.this.irdetoSTBSerialNumberField.getText());
                }
                catch (UrfaException urfaException) {
                    string = urfaException.getMessage();
                }
                JOptionPane.showMessageDialog(jFrame, string);
            }
        }));
        jPopupMenu.add(new JMenuItem(new AbstractAction(this.resource.getString("Unpair all chipsets")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                try {
                    string = AccountFunctions.irdetoUnpairAllChipsets(UserAccountEditDialog.this.irdetoAccessCardTextField.getText());
                }
                catch (UrfaException urfaException) {
                    string = urfaException.getMessage();
                }
                JOptionPane.showMessageDialog(jFrame, string);
            }
        }));
        jPopupMenu.add(new JMenuItem(new AbstractAction(this.resource.getString("Reset PIN")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                try {
                    string = AccountFunctions.irdetoOverwriteParentalPinCode(UserAccountEditDialog.this.irdetoAccessCardTextField.getText());
                }
                catch (UrfaException urfaException) {
                    string = urfaException.getMessage();
                }
                JOptionPane.showMessageDialog(jFrame, string);
            }
        }));
        jPopupMenu.add(new JMenuItem(new AbstractAction(this.resource.getString("Synchronize")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                try {
                    string = AccountFunctions.irdetoSynchronize(UserAccountEditDialog.this.irdetoAccessCardTextField.getText());
                }
                catch (UrfaException urfaException) {
                    string = urfaException.getMessage();
                }
                JOptionPane.showMessageDialog(jFrame, string);
            }
        }));
        this.queriesButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        });
    }

    @Override
    protected void saveInfo() throws UrfaException {
        if (this.aid == 0) {
            this.aid = this.createAccount();
            if (this.aid != 0) {
                this.saveAccount();
            }
        } else {
            this.saveAccount();
        }
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
        this.checkDouble(this.vatRateTextField, "VAT rate");
        this.checkDouble(this.saleTaxRateTextField, "Sale tax rate");
        this.checkDouble(this.creditTextField, "Credit");
        if (!this.settingListeners) {
            if (Double.parseDouble(this.vatRateTextField.getText()) != 0.0 && (Double.parseDouble(this.vatRateTextField.getText()) < 1.0 || Double.parseDouble(this.vatRateTextField.getText()) > 100.0) && JOptionPane.showConfirmDialog(this, this.resource.getString("Are you sure") + " \"" + this.resource.getString("VAT rate") + "\" = " + this.vatRateTextField.getText() + "%?", "Warning", 2) != 0) {
                throw new IllegalArgumentException("");
            }
            if (Double.parseDouble(this.saleTaxRateTextField.getText()) != 0.0 && (Double.parseDouble(this.saleTaxRateTextField.getText()) < 1.0 || Double.parseDouble(this.saleTaxRateTextField.getText()) > 100.0) && JOptionPane.showConfirmDialog(this, this.resource.getString("Are you sure") + " \"" + this.resource.getString("Sale tax rate") + "\" = " + this.saleTaxRateTextField.getText() + "%?", "Warning", 2) != 0) {
                throw new IllegalArgumentException("");
            }
            if (!this.externalIdStart.equals(this.externalIdTextField.getText())) {
                try {
                    if (UrfaManagerImpl.getInstance().isPermitted(new int[]{8248, 8250})) {
                        UrfaIsAccountExternalIdUsed urfaIsAccountExternalIdUsed = new UrfaIsAccountExternalIdUsed(UrfaManagerImpl.getInstance());
                        urfaIsAccountExternalIdUsed.setExternalId(this.externalIdTextField.getText());
                        urfaIsAccountExternalIdUsed.call();
                        if (urfaIsAccountExternalIdUsed.getAid() != 0 && urfaIsAccountExternalIdUsed.getAid() != this.aid) {
                            this.log.log(1, this.resource.getString("External account ID") + " - " + this.resource.getString("already exists"));
                            this.externalIdTextField.requestFocus();
                            this.externalIdTextField.setBackground(new Color(255, 204, 204));
                            throw new IllegalArgumentException();
                        }
                    }
                }
                catch (UrfaException urfaException) {
                    this.log.log(1, urfaException);
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    private void createAccessCard(final Integer n) {
        UrfaCreateAccessCard urfaCreateAccessCard = new UrfaCreateAccessCard(UrfaManagerImpl.getInstance());
        urfaCreateAccessCard.setAccountId(n);
        try {
            urfaCreateAccessCard.call();
        }
        catch (UrfaException urfaException) {
            urfaException.printStackTrace();
        }
        if (urfaCreateAccessCard.getResult() == 0) {
            this.log.log(1, this.resource.getString("Failed to create IPTV access card"));
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                UserAccountEditDialog.this.createButton.setEnabled(false);
                UserAccountEditDialog.this.createButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/refresh16.png")));
                for (int i = 0; i < 10; ++i) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    UrfaGetAccessCardStatus urfaGetAccessCardStatus = new UrfaGetAccessCardStatus(UrfaManagerImpl.getInstance());
                    urfaGetAccessCardStatus.setAccountId(n);
                    try {
                        urfaGetAccessCardStatus.call();
                    }
                    catch (UrfaException urfaException) {
                        break;
                    }
                    if (urfaGetAccessCardStatus.getStatus() <= 0) continue;
                    UserAccountEditDialog.this.accessCardTextField.setText(new Integer(urfaGetAccessCardStatus.getStatus()).toString());
                    break;
                }
                UserAccountEditDialog.this.createButton.setIcon(null);
                if (UserAccountEditDialog.this.accessCardTextField.getText().isEmpty()) {
                    UserAccountEditDialog.this.createButton.setEnabled(true);
                }
            }
        };
        thread.start();
    }

    private void createUIComponents() {
        this.startPeriodDateTime = new JDateTime();
        this.startPeriodDateTime.setDate(TZ.getCoreTime());
        this.startPeriodDateTime.setEnabled(false);
        this.endPeriodDateTime = new JDateTime();
        this.endPeriodDateTime.setDate(new Date(2000000000000L));
        this.endPeriodDateTime.setEnabled(false);
        this.externalIdTextField = new PermissionTextField(new int[]{8249, 8248});
    }

    private class BlockTypeItem {
        public int typeVal;
        public String typeString;

        public BlockTypeItem(int n, String string) {
            this.typeVal = n;
            this.typeString = string;
        }

        public String toString() {
            return this.typeString;
        }
    }
}

