/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.userframe.forms.tarification.account;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetAccountExternalId;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.dealer.user.tarification.accounts.AccountFunctions;
import biz.netup.projects.utmadmin.functions.objects.Account;
import biz.netup.projects.utmadmin.gui.custom.newpayment.NewPaymentDialog;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.account.accountsdialogs.BalanceEditingDialog;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.account.accountsdialogs.UserAccountEditDialog;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.permissions.Permissions;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;

public class UserAccountsTab
extends TabPanelWithTable {
    private JButton newPaymentButton = new JButton();
    private int uid;
    private int primary_account;

    @Override
    public int getTabType() {
        return 2;
    }

    @Override
    public String getGroupName() {
        return "Tariffication";
    }

    @Override
    protected void applyPermissions() {
        Permissions.apply((JComponent)this.newPaymentButton, "new_payment");
    }

    @Override
    public String getTabName() {
        return "Accounts";
    }

    @Override
    public int getMode() {
        return 1;
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("aid", "AID");
        linkedHashMap.put("block_id", "Block ID");
        linkedHashMap.put("internet_status", "Internet status");
        linkedHashMap.put("vat_rate", "VAT rate");
        linkedHashMap.put("credit", "Credit");
        linkedHashMap.put("sale_tax_rate", "Sale tax rate");
        linkedHashMap.put("ballance", "Ballance");
        linkedHashMap.put("requirement_payment", "Requirement payment");
        if (UrfaManagerImpl.getInstance().isPermitted(8249)) {
            linkedHashMap.put("external_id", "External account ID");
        }
        return linkedHashMap;
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        Vector<Map<String, Object>> vector = AccountFunctions.getAccountsDetailed(this.uid);
        if (UrfaManagerImpl.getInstance().isPermitted(8249)) {
            for (Map<String, Object> map : vector) {
                UrfaGetAccountExternalId urfaGetAccountExternalId = new UrfaGetAccountExternalId(UrfaManagerImpl.getInstance());
                urfaGetAccountExternalId.setAid((Integer)map.get("aid"));
                urfaGetAccountExternalId.call();
                map.put("external_id", urfaGetAccountExternalId.getExternalId());
            }
        }
        return vector;
    }

    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
        int n = (Integer)map.get("aid");
        if (this.primary_account != n) {
            AccountFunctions.deleteAccount(n);
        }
    }

    @Override
    protected void init() {
        super.init();
        this.newPaymentButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/money16.png")));
        this.newPaymentButton.setText(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("New payment"));
        this.getAdditionalButtonPanel2().add(this.newPaymentButton);
        this.mainTablePanel.registerOneRowButton(this.newPaymentButton);
        this.mainTablePanel.registerFieldButtonBlock(this.deleteButton, "aid", this.primary_account);
        this.newPaymentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserAccountsTab.this.newPayment();
            }
        });
    }

    public UserAccountsTab(int n, int n2) {
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/user/account_24.png")));
        if (Utils.isAdmin()) {
            this.setRefreshPermission(new int[]{8243, 86281, 86289});
            this.setAddPermission(new int[]{69906, 17412, 86282, 86283, 8248, 8250});
            this.setDeletePermission(new int[]{8244});
            this.setEditPermission(new int[]{69906, 86281, 86283, 8248, 8249, 8250});
        }
        this.setUseThread(false);
        this.uid = n;
        this.primary_account = n2;
    }

    private void newPayment() {
        NewPaymentDialog newPaymentDialog = new NewPaymentDialog(this.uid, (Integer)this.mainTablePanel.getSelectedTableRows()[0].get("aid"));
        newPaymentDialog.setVisible(true);
        if (newPaymentDialog.isOkPressed()) {
            this.refresh();
        }
    }

    @Override
    public DFModel getItemDialog(Map<String, Object> map) {
        return new UserAccountEditDialog(map);
    }

    @Override
    protected void add() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("aid", 0);
        hashMap.put("uid", this.uid);
        new UserAccountEditDialog(hashMap).run(this);
    }

    private void turnInternetOn() {
        try {
            for (Map<String, Object> map : this.mainTablePanel.getSelectedTableRows()) {
                Account account = AccountFunctions.getAccount((Integer)map.get("aid"));
                account.setIntStatus(1);
                AccountFunctions.editAccount(account);
            }
        }
        catch (UrfaException urfaException) {
            this.log.error("Error updating accounts list", urfaException);
        }
        this.refresh();
    }

    private void turnInternetOff() {
        try {
            for (Map<String, Object> map : this.mainTablePanel.getSelectedTableRows()) {
                Account account = AccountFunctions.getAccount((Integer)map.get("aid"));
                account.setIntStatus(0);
                AccountFunctions.editAccount(account);
            }
        }
        catch (UrfaException urfaException) {
            this.log.error("Error updating accounts list", urfaException);
        }
        this.refresh();
    }

    @Override
    protected JMenuItem[] getMenuItems(Map<String, Object>[] mapArray) {
        final Map<String, Object> map = mapArray[0];
        final UserAccountsTab userAccountsTab = this;
        JMenuItem jMenuItem = new JMenuItem(this.resource.getString("Turn Internet on"));
        JMenuItem jMenuItem2 = new JMenuItem(this.resource.getString("Turn Internet off"));
        JMenuItem jMenuItem3 = new JMenuItem(this.resource.getString("Balance correction"));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserAccountsTab.this.turnInternetOff();
            }
        });
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserAccountsTab.this.turnInternetOn();
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BalanceEditingDialog balanceEditingDialog = new BalanceEditingDialog(userAccountsTab, map);
                balanceEditingDialog.setVisible(true);
            }
        });
        if (mapArray.length > 1) {
            return new JMenuItem[]{jMenuItem, jMenuItem2};
        }
        if (mapArray.length == 1) {
            Boolean bl = (Boolean)mapArray[0].get("internet_status");
            JMenuItem jMenuItem4 = bl != false ? jMenuItem2 : jMenuItem;
            return new JMenuItem[]{jMenuItem4, jMenuItem3};
        }
        return null;
    }
}

