/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.usersettings.voluntaryblocking;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaDeleteVoluntarySuspensionSettings;
import biz.netup.control.transport.urfa.functions.UrfaEditVoluntarySuspensionSettings;
import biz.netup.control.transport.urfa.functions.UrfaGetVoluntarySuspensionSettings;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.usersettings.UpDownButtons;
import biz.netup.projects.utmadmin.gui.mainframe.forms.usersettings.voluntaryblocking.VoluntaryBlockingDialog;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class VoluntaryBlockingTab
extends TabPanelWithTable {
    private int priority = 0;
    private Set<Integer> groups;

    public VoluntaryBlockingTab() {
        this.setRefreshPermission(new int[]{86032});
        this.setAddPermission(new int[]{86033, 9216});
        this.setEditPermission(new int[]{86034});
        this.setDeletePermission(new int[]{86035});
    }

    @Override
    public String getTabName() {
        return "Voluntary suspension";
    }

    @Override
    public int getTabType() {
        return 1;
    }

    @Override
    public String getGroupName() {
        return "User settings";
    }

    @Override
    public int getMode() {
        return 1;
    }

    @Override
    public Map<String, String> getColumnNames() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("id", "ID");
        hashMap.put("group_id", "Group ID");
        hashMap.put("group_name", "Group name");
        hashMap.put("priority", "Priority");
        hashMap.put("is_enabled", "Is enabled");
        hashMap.put("min_duration", "Min duration");
        hashMap.put("max_duration", "Max duration");
        hashMap.put("interval_duration", "Interval duration");
        hashMap.put("self_unlock", "Self unlock");
        hashMap.put("min_balance", "Min balance");
        hashMap.put("use_min_balance", "Use min balance");
        hashMap.put("free_balance", "Free balance");
        hashMap.put("use_free_balance", "Use free balance");
        hashMap.put("service_name", "Service");
        return hashMap;
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        this.priority = 0;
        UrfaGetVoluntarySuspensionSettings urfaGetVoluntarySuspensionSettings = new UrfaGetVoluntarySuspensionSettings(UrfaManagerImpl.getInstance());
        urfaGetVoluntarySuspensionSettings.call();
        this.groups = new HashSet<Integer>();
        for (int n : urfaGetVoluntarySuspensionSettings.getGroupId1()) {
            this.groups.add(n);
        }
        for (int i = 0; i < urfaGetVoluntarySuspensionSettings.getCount(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", urfaGetVoluntarySuspensionSettings.getId1()[i]);
            hashMap.put("group_id", urfaGetVoluntarySuspensionSettings.getGroupId1()[i]);
            if (urfaGetVoluntarySuspensionSettings.getGroupId1()[i] != 0) {
                hashMap.put("group_name", Resolve.getGroupName(urfaGetVoluntarySuspensionSettings.getGroupId1()[i]));
                hashMap.put("delete", 1);
            } else {
                hashMap.put("group_name", this.resource.getString("All"));
                hashMap.put("delete", 0);
            }
            hashMap.put("is_enabled", urfaGetVoluntarySuspensionSettings.getIsEnabled1()[i]);
            hashMap.put("priority", urfaGetVoluntarySuspensionSettings.getPriopity1()[i]);
            if (i < urfaGetVoluntarySuspensionSettings.getCount() - 2) {
                hashMap.put("down", 1);
            } else {
                hashMap.put("down", 0);
            }
            if (i < urfaGetVoluntarySuspensionSettings.getCount() - 1 && i != 0) {
                hashMap.put("up", 1);
            } else {
                hashMap.put("up", 0);
            }
            hashMap.put("min_duration", urfaGetVoluntarySuspensionSettings.getMinDuration1()[i] / 86400);
            hashMap.put("max_duration", urfaGetVoluntarySuspensionSettings.getMaxDuration1()[i] / 86400);
            hashMap.put("interval_duration", urfaGetVoluntarySuspensionSettings.getIntervalDuration1()[i] / 86400);
            hashMap.put("self_unlock", urfaGetVoluntarySuspensionSettings.getSelfUnlock1()[i]);
            hashMap.put("min_balance", urfaGetVoluntarySuspensionSettings.getMinBalance1()[i]);
            hashMap.put("use_min_balance", urfaGetVoluntarySuspensionSettings.getUseMinBalance1()[i]);
            hashMap.put("free_balance", urfaGetVoluntarySuspensionSettings.getFreeBalance1()[i]);
            hashMap.put("use_free_balance", urfaGetVoluntarySuspensionSettings.getUseFreeBalance1()[i]);
            hashMap.put("service_id", urfaGetVoluntarySuspensionSettings.getServiceId1()[i]);
            hashMap.put("service_name", Resolve.getServiceName(urfaGetVoluntarySuspensionSettings.getServiceId1()[i]));
            if (this.priority < urfaGetVoluntarySuspensionSettings.getPriopity1()[i] + 1) {
                this.priority = urfaGetVoluntarySuspensionSettings.getPriopity1()[i] + 1;
            }
            vector.add(hashMap);
        }
        return vector;
    }

    @Override
    protected void init() {
        super.init();
        UpDownButtons upDownButtons = new UpDownButtons();
        this.getAdditionalButtonPanel2().add(upDownButtons.getButtonPanel());
        this.mainTablePanel.registerFieldButtonBlock(this.deleteButton, "delete", 0);
        this.mainTablePanel.registerFieldButtonBlock(upDownButtons.getUpButton(), "up", 0);
        this.mainTablePanel.registerFieldButtonBlock(upDownButtons.getDownButton(), "down", 0);
        this.mainTablePanel.registerOneRowButton(upDownButtons.getUpButton());
        this.mainTablePanel.registerOneRowButton(upDownButtons.getDownButton());
        upDownButtons.getUpButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VoluntaryBlockingTab.this.up();
            }
        });
        upDownButtons.getDownButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VoluntaryBlockingTab.this.down();
            }
        });
    }

    private void change(Map<String, Object> map, Map<String, Object> map2) {
        try {
            UrfaEditVoluntarySuspensionSettings urfaEditVoluntarySuspensionSettings = new UrfaEditVoluntarySuspensionSettings(UrfaManagerImpl.getInstance());
            urfaEditVoluntarySuspensionSettings.setId((Integer)map.get("id"));
            urfaEditVoluntarySuspensionSettings.setGroupId((Integer)map.get("group_id"));
            urfaEditVoluntarySuspensionSettings.setIsEnabled((Integer)map.get("is_enabled"));
            urfaEditVoluntarySuspensionSettings.setIntervalDuration((Integer)map.get("interval_duration"));
            urfaEditVoluntarySuspensionSettings.setMaxDuration((Integer)map.get("max_duration"));
            urfaEditVoluntarySuspensionSettings.setMinDuration((Integer)map.get("min_duration"));
            urfaEditVoluntarySuspensionSettings.setSelfUnlock((Integer)map.get("self_unlock"));
            urfaEditVoluntarySuspensionSettings.setMinBalance((Double)map.get("min_balance"));
            urfaEditVoluntarySuspensionSettings.setFreeBalance((Double)map.get("free_balance"));
            urfaEditVoluntarySuspensionSettings.setUseMinBalance((Integer)map.get("use_min_balance"));
            urfaEditVoluntarySuspensionSettings.setUseFreeBalance((Integer)map.get("use_free_balance"));
            urfaEditVoluntarySuspensionSettings.setServiceId((Integer)map.get("service_id"));
            urfaEditVoluntarySuspensionSettings.setPriopity((Integer)map2.get("priority"));
            urfaEditVoluntarySuspensionSettings.call();
            urfaEditVoluntarySuspensionSettings = new UrfaEditVoluntarySuspensionSettings(UrfaManagerImpl.getInstance());
            urfaEditVoluntarySuspensionSettings.setId((Integer)map2.get("id"));
            urfaEditVoluntarySuspensionSettings.setGroupId((Integer)map2.get("group_id"));
            urfaEditVoluntarySuspensionSettings.setIsEnabled((Integer)map2.get("is_enabled"));
            urfaEditVoluntarySuspensionSettings.setIntervalDuration((Integer)map2.get("interval_duration"));
            urfaEditVoluntarySuspensionSettings.setMaxDuration((Integer)map2.get("max_duration"));
            urfaEditVoluntarySuspensionSettings.setMinDuration((Integer)map2.get("min_duration"));
            urfaEditVoluntarySuspensionSettings.setSelfUnlock((Integer)map2.get("self_unlock"));
            urfaEditVoluntarySuspensionSettings.setMinBalance((Double)map2.get("min_balance"));
            urfaEditVoluntarySuspensionSettings.setFreeBalance((Double)map2.get("free_balance"));
            urfaEditVoluntarySuspensionSettings.setUseMinBalance((Integer)map2.get("use_min_balance"));
            urfaEditVoluntarySuspensionSettings.setUseFreeBalance((Integer)map2.get("use_free_balance"));
            urfaEditVoluntarySuspensionSettings.setServiceId((Integer)map2.get("service_id"));
            urfaEditVoluntarySuspensionSettings.setPriopity((Integer)map.get("priority"));
            urfaEditVoluntarySuspensionSettings.call();
        }
        catch (UrfaException urfaException) {
            // empty catch block
        }
    }

    private void up() {
        Map<String, Object> map = this.mainTablePanel.getSelectedTableRows()[0];
        Map<String, Object> map2 = null;
        for (int i = 0; i < this.mainTablePanel.getTableModel().data.size(); ++i) {
            if (this.mainTablePanel.getTableModel().data.get(i) != map || i <= 0) continue;
            map2 = this.mainTablePanel.getTableModel().data.get(i - 1);
        }
        if (map2 == null) {
            return;
        }
        this.change(map, map2);
        this.refresh();
    }

    private void down() {
        Map<String, Object> map = this.mainTablePanel.getSelectedTableRows()[0];
        Map<String, Object> map2 = null;
        for (int i = 0; i < this.mainTablePanel.getTableModel().data.size(); ++i) {
            if (this.mainTablePanel.getTableModel().data.get(i) != map || i >= this.mainTablePanel.getTableModel().data.size() - 2) continue;
            map2 = this.mainTablePanel.getTableModel().data.get(i + 1);
        }
        if (map2 == null) {
            return;
        }
        this.change(map, map2);
        this.refresh();
    }

    @Override
    protected void add() {
        this.log.log(10, "Add element - " + this.getTabName());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("groups", this.groups);
        hashMap.put("priority", this.priority);
        this.getItemDialog(hashMap).run(this);
    }

    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
        UrfaDeleteVoluntarySuspensionSettings urfaDeleteVoluntarySuspensionSettings = new UrfaDeleteVoluntarySuspensionSettings(UrfaManagerImpl.getInstance());
        urfaDeleteVoluntarySuspensionSettings.setId((Integer)map.get("id"));
        urfaDeleteVoluntarySuspensionSettings.call();
        if (urfaDeleteVoluntarySuspensionSettings.getResult() == -1) {
            throw new UrfaException(this.resource.getString(this.getTabName()) + ": " + this.resource.getString("Cannot delete item(s)"));
        }
    }

    @Override
    public DFModel getItemDialog(Map<String, Object> map) {
        return new VoluntaryBlockingDialog(map);
    }
}

