/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.usersettings.voluntaryblocking;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaAddVoluntarySuspensionSettings;
import biz.netup.control.transport.urfa.functions.UrfaEditVoluntarySuspensionSettings;
import biz.netup.control.transport.urfa.functions.UrfaGetGroupsList;
import biz.netup.control.transport.urfa.functions.UrfaGetServicesList;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.utmutils.control.permissions.PermissionComboBox;
import biz.netup.utmutils.swing.dialog.DialogModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class VoluntaryBlockingDialog
extends DialogModel {
    private JPanel mainPanel;
    private JTextField IDTextField;
    private JComboBox groupComboBox;
    private JCheckBox isEnableCheckBox;
    private JTextField maxDurationTextField;
    private JTextField minDurationTextField;
    private JCheckBox selfUnlockCheckBox;
    private JTextField intervalDurationTextField;
    private JTextField minBalanceTextField;
    private JTextField freeBalanceTextField;
    private JCheckBox useMinBalanceCheckBox;
    private JCheckBox useFreeBalanceCheckBox;
    private PermissionComboBox serviceComboBox;
    private Map<String, Integer> servicesMap;
    private Map<String, Integer> groupsMap;
    private Map<String, Integer> bloksMap;

    public VoluntaryBlockingDialog() {
        this.$$$setupUI$$$();
    }

    public VoluntaryBlockingDialog(Map<String, Object> map) {
        super(map);
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        return this.mainPanel;
    }

    @Override
    public String getItemName() {
        return "Voluntary suspension";
    }

    private void fillServices() throws UrfaException {
        this.serviceComboBox.removeAllItems();
        this.servicesMap = new LinkedHashMap<String, Integer>();
        this.servicesMap.put("---", 0);
        if (UrfaManagerImpl.getInstance().isPermitted(8449)) {
            UrfaGetServicesList urfaGetServicesList = new UrfaGetServicesList(UrfaManagerImpl.getInstance());
            urfaGetServicesList.setWhichService(1);
            urfaGetServicesList.call();
            for (int i = 0; i < urfaGetServicesList.getServicesCount(); ++i) {
                if (urfaGetServicesList.getServiceTypeArray1()[i] != 1) continue;
                this.servicesMap.put(urfaGetServicesList.getServiceNameArray1()[i] + " (" + urfaGetServicesList.getServiceIdArray1()[i] + ")", urfaGetServicesList.getServiceIdArray1()[i]);
            }
            for (String string : this.servicesMap.keySet()) {
                this.serviceComboBox.addItem(string);
            }
        }
    }

    @Override
    protected void loadInfo() throws UrfaException {
        if (this.item.get("id") == null) {
            this.setAddMode(true);
        }
        this.fillServices();
        if (this.isAddMode()) {
            this.loadGroups();
        } else {
            this.groupComboBox.addItem(this.item.get("group_name") + " (" + this.item.get("group_id") + ")");
            this.groupComboBox.setEnabled(false);
            this.IDTextField.setText("" + this.item.get("id"));
            this.isEnableCheckBox.setSelected(this.item.get("is_enabled").equals(1));
            this.selfUnlockCheckBox.setSelected((Integer)this.item.get("self_unlock") == 1);
            this.minDurationTextField.setText("" + (Integer)this.item.get("min_duration"));
            this.maxDurationTextField.setText("" + (Integer)this.item.get("max_duration"));
            this.intervalDurationTextField.setText("" + (Integer)this.item.get("interval_duration"));
            this.minBalanceTextField.setText("" + this.item.get("min_balance"));
            this.useMinBalanceCheckBox.setSelected(this.item.get("use_min_balance").equals(1));
            this.freeBalanceTextField.setText("" + this.item.get("free_balance"));
            this.useFreeBalanceCheckBox.setSelected(this.item.get("use_free_balance").equals(1));
            if ((Integer)this.item.get("service_id") != 0) {
                for (String string : this.servicesMap.keySet()) {
                    if (!this.servicesMap.get(string).equals((Integer)this.item.get("service_id"))) continue;
                    this.serviceComboBox.setSelectedItem(string);
                }
            }
        }
    }

    private void loadGroups() throws UrfaException {
        UrfaGetGroupsList urfaGetGroupsList = new UrfaGetGroupsList(UrfaManagerImpl.getInstance());
        urfaGetGroupsList.call();
        this.groupsMap = new LinkedHashMap<String, Integer>();
        this.groupComboBox.removeAllItems();
        for (int i = 0; i < urfaGetGroupsList.getGroupsCount(); ++i) {
            if (((Set)this.item.get("groups")).contains(urfaGetGroupsList.getGroupId1()[i])) continue;
            this.groupsMap.put(urfaGetGroupsList.getGroupName1()[i] + " (" + urfaGetGroupsList.getGroupId1()[i] + ")", urfaGetGroupsList.getGroupId1()[i]);
        }
        for (String string : this.groupsMap.keySet()) {
            this.groupComboBox.addItem(string);
        }
        if (this.groupsMap.isEmpty()) {
            this.buttonOK.setEnabled(false);
        }
    }

    @Override
    protected void saveInfo() throws UrfaException {
        if (this.isAddMode()) {
            UrfaAddVoluntarySuspensionSettings urfaAddVoluntarySuspensionSettings = new UrfaAddVoluntarySuspensionSettings(UrfaManagerImpl.getInstance());
            urfaAddVoluntarySuspensionSettings.setGroupId(this.groupsMap.get(this.groupComboBox.getSelectedItem()));
            urfaAddVoluntarySuspensionSettings.setIsEnabled(this.isEnableCheckBox.isSelected() ? 1 : 0);
            urfaAddVoluntarySuspensionSettings.setPriopity((Integer)this.item.get("priority"));
            urfaAddVoluntarySuspensionSettings.setBlockType(0);
            urfaAddVoluntarySuspensionSettings.setSelfUnlock(this.selfUnlockCheckBox.isSelected() ? 1 : 0);
            urfaAddVoluntarySuspensionSettings.setMinDuration(Integer.parseInt(this.minDurationTextField.getText()) * 86400);
            urfaAddVoluntarySuspensionSettings.setMaxDuration(Integer.parseInt(this.maxDurationTextField.getText()) * 86400);
            urfaAddVoluntarySuspensionSettings.setIntervalDuration(Integer.parseInt(this.intervalDurationTextField.getText()) * 86400);
            urfaAddVoluntarySuspensionSettings.setMinBalance(Double.parseDouble(this.minBalanceTextField.getText()));
            urfaAddVoluntarySuspensionSettings.setFreeBalance(Double.parseDouble(this.freeBalanceTextField.getText()));
            urfaAddVoluntarySuspensionSettings.setUseMinBalance(this.useMinBalanceCheckBox.isSelected() ? 1 : 0);
            urfaAddVoluntarySuspensionSettings.setUseFreeBalance(this.useFreeBalanceCheckBox.isSelected() ? 1 : 0);
            urfaAddVoluntarySuspensionSettings.setServiceId(this.servicesMap.get(this.serviceComboBox.getSelectedItem()));
            urfaAddVoluntarySuspensionSettings.call();
            if (urfaAddVoluntarySuspensionSettings.getResult() <= 0) {
                throw new UrfaException(this.resource.getString(this.getItemName()) + ": " + this.resource.getString("Cannot save details"));
            }
        } else {
            UrfaEditVoluntarySuspensionSettings urfaEditVoluntarySuspensionSettings = new UrfaEditVoluntarySuspensionSettings(UrfaManagerImpl.getInstance());
            urfaEditVoluntarySuspensionSettings.setId((Integer)this.item.get("id"));
            urfaEditVoluntarySuspensionSettings.setGroupId((Integer)this.item.get("group_id"));
            urfaEditVoluntarySuspensionSettings.setIsEnabled(this.isEnableCheckBox.isSelected() ? 1 : 0);
            urfaEditVoluntarySuspensionSettings.setPriopity((Integer)this.item.get("priority"));
            urfaEditVoluntarySuspensionSettings.setBlockType(0);
            urfaEditVoluntarySuspensionSettings.setSelfUnlock(this.selfUnlockCheckBox.isSelected() ? 1 : 0);
            urfaEditVoluntarySuspensionSettings.setMinDuration(Integer.parseInt(this.minDurationTextField.getText()) * 86400);
            urfaEditVoluntarySuspensionSettings.setMaxDuration(Integer.parseInt(this.maxDurationTextField.getText()) * 86400);
            urfaEditVoluntarySuspensionSettings.setIntervalDuration(Integer.parseInt(this.intervalDurationTextField.getText()) * 86400);
            urfaEditVoluntarySuspensionSettings.setMinBalance(Double.parseDouble(this.minBalanceTextField.getText()));
            urfaEditVoluntarySuspensionSettings.setFreeBalance(Double.parseDouble(this.freeBalanceTextField.getText()));
            urfaEditVoluntarySuspensionSettings.setUseMinBalance(this.useMinBalanceCheckBox.isSelected() ? 1 : 0);
            urfaEditVoluntarySuspensionSettings.setUseFreeBalance(this.useFreeBalanceCheckBox.isSelected() ? 1 : 0);
            urfaEditVoluntarySuspensionSettings.setServiceId(this.servicesMap.get(this.serviceComboBox.getSelectedItem()));
            urfaEditVoluntarySuspensionSettings.call();
            if (urfaEditVoluntarySuspensionSettings.getResult() <= 0) {
                throw new UrfaException(this.resource.getString(this.getItemName()) + ": " + this.resource.getString("Cannot save details"));
            }
        }
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
        this.checkInt(this.minDurationTextField, "Min duration");
        this.checkInt(this.maxDurationTextField, "Max duration");
        this.checkInt(this.intervalDurationTextField, "Interval duration");
        this.checkDouble(this.minBalanceTextField, "Min balance");
        this.checkDouble(this.freeBalanceTextField, "Free balance");
    }

    private void createUIComponents() {
        this.serviceComboBox = new PermissionComboBox(new int[]{8449});
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setMinimumSize(new Dimension(550, 283));
        this.mainPanel.setPreferredSize(new Dimension(550, 283));
        jPanel.add((Component)this.mainPanel, "Center");
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("ID"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel, gridBagConstraints);
        this.IDTextField = new JTextField();
        this.IDTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.IDTextField, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Group"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel2, gridBagConstraints);
        this.groupComboBox = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.groupComboBox, gridBagConstraints);
        this.isEnableCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.isEnableCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Is enable"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.isEnableCheckBox, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Min duration"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel3, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Max duration"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel4, gridBagConstraints);
        this.maxDurationTextField = new JTextField();
        this.maxDurationTextField.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.maxDurationTextField, gridBagConstraints);
        this.minDurationTextField = new JTextField();
        this.minDurationTextField.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.minDurationTextField, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Interval duration"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel5, gridBagConstraints);
        this.selfUnlockCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.selfUnlockCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Self unlock"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.selfUnlockCheckBox, gridBagConstraints);
        this.intervalDurationTextField = new JTextField();
        this.intervalDurationTextField.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.intervalDurationTextField, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel8, gridBagConstraints);
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Min balance"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel6, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel9, gridBagConstraints);
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Free balance"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel7, gridBagConstraints);
        this.minBalanceTextField = new JTextField();
        this.minBalanceTextField.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.minBalanceTextField, gridBagConstraints);
        this.freeBalanceTextField = new JTextField();
        this.freeBalanceTextField.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.freeBalanceTextField, gridBagConstraints);
        this.useMinBalanceCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.useMinBalanceCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Use"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.useMinBalanceCheckBox, gridBagConstraints);
        this.useFreeBalanceCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.useFreeBalanceCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Use"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.useFreeBalanceCheckBox, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel10, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel11, gridBagConstraints);
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Service"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel8, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel12, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.serviceComboBox, gridBagConstraints);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

