/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.usersettings.switchtariff;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetServicesList;
import biz.netup.control.transport.urfa.functions.UrfaGetTariffsList;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.utmutils.control.permissions.PermissionComboBox;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialog.DialogModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SwitchTariffDataDialog
extends DialogModel {
    private JPanel mainPanel;
    private JTextField minBalanceTextField;
    private JTextField freeBalanceTextField;
    private JCheckBox useMinBalanceCheckBox;
    private JCheckBox useFreeBalanceCheckBox;
    private PermissionComboBox serviceComboBox;
    private JComboBox tariffComboBox;
    private Map<String, Integer> servicesMap;
    private Map<String, Integer> tariffsMap;

    private void createUIComponents() {
        this.serviceComboBox = new PermissionComboBox(new int[]{8449});
    }

    public SwitchTariffDataDialog() {
        this.$$$setupUI$$$();
    }

    public SwitchTariffDataDialog(Map<String, Object> map) {
        super(map);
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        return this.mainPanel;
    }

    @Override
    public String getItemName() {
        return "Tariff";
    }

    private void fillServices() throws UrfaException {
        this.serviceComboBox.removeAllItems();
        this.servicesMap = new LinkedHashMap<String, Integer>();
        this.servicesMap.put("---", 0);
        if (UrfaManagerImpl.getInstance().isPermitted(8449)) {
            UrfaGetServicesList urfaGetServicesList = new UrfaGetServicesList(UrfaManagerImpl.getInstance());
            urfaGetServicesList.setWhichService(1);
            urfaGetServicesList.call();
            for (int i = 0; i < urfaGetServicesList.getServicesCount(); ++i) {
                if (urfaGetServicesList.getServiceTypeArray1()[i] != 1 || urfaGetServicesList.getServiceStatusArray1()[i] != 0) continue;
                this.servicesMap.put(urfaGetServicesList.getServiceNameArray1()[i] + " (" + urfaGetServicesList.getServiceIdArray1()[i] + ")", urfaGetServicesList.getServiceIdArray1()[i]);
            }
            for (String string : this.servicesMap.keySet()) {
                this.serviceComboBox.addItem(string);
            }
        }
    }

    private void fillTariffs() throws UrfaException {
        this.tariffComboBox.removeAllItems();
        this.tariffsMap = new LinkedHashMap<String, Integer>();
        UrfaGetTariffsList urfaGetTariffsList = new UrfaGetTariffsList(UrfaManagerImpl.getInstance());
        urfaGetTariffsList.call();
        for (int i = 0; i < urfaGetTariffsList.getTariffsCount(); ++i) {
            this.tariffsMap.put(urfaGetTariffsList.getName1()[i] + " (" + urfaGetTariffsList.getId1()[i] + ")", urfaGetTariffsList.getId1()[i]);
        }
        for (String string : this.tariffsMap.keySet()) {
            this.tariffComboBox.addItem(string);
        }
    }

    @Override
    protected void loadInfo() throws UrfaException {
        this.fillServices();
        this.fillTariffs();
        this.setAddMode(this.item.get("id") == null);
        if (!this.isAddMode()) {
            this.minBalanceTextField.setText("" + this.item.get("min_balance"));
            this.useMinBalanceCheckBox.setSelected(this.item.get("use_min_balance").equals(1));
            this.freeBalanceTextField.setText("" + this.item.get("free_balance"));
            this.useFreeBalanceCheckBox.setSelected(this.item.get("use_free_balance").equals(1));
            if ((Integer)this.item.get("service_id") != 0) {
                for (String string : this.servicesMap.keySet()) {
                    if (this.servicesMap.get(string) != (Integer)this.item.get("service_id")) continue;
                    this.serviceComboBox.setSelectedItem(string);
                }
            }
            if ((Integer)this.item.get("id") != 0) {
                for (String string : this.tariffsMap.keySet()) {
                    if (this.tariffsMap.get(string) != (Integer)this.item.get("id")) continue;
                    this.tariffComboBox.setSelectedItem(string);
                }
            }
        }
    }

    @Override
    protected void saveInfo() throws UrfaException {
        this.item = new HashMap();
        this.item.put("id", this.tariffsMap.get(this.tariffComboBox.getSelectedItem()));
        this.item.put("name", Resolve.getTPName(this.tariffsMap.get(this.tariffComboBox.getSelectedItem())));
        this.item.put("service_id", this.servicesMap.get(this.serviceComboBox.getSelectedItem()));
        this.item.put("service_name", Resolve.getServiceName(this.servicesMap.get(this.serviceComboBox.getSelectedItem())));
        this.item.put("min_balance", Double.parseDouble(this.minBalanceTextField.getText()));
        this.item.put("free_balance", Double.parseDouble(this.freeBalanceTextField.getText()));
        this.item.put("use_min_balance", this.useMinBalanceCheckBox.isSelected() ? 1 : 0);
        this.item.put("use_free_balance", this.useFreeBalanceCheckBox.isSelected() ? 1 : 0);
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
        this.checkDouble(this.minBalanceTextField, "Min balance");
        this.checkDouble(this.freeBalanceTextField, "Free balance");
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setMinimumSize(new Dimension(550, 125));
        this.mainPanel.setPreferredSize(new Dimension(550, 125));
        jPanel.add((Component)this.mainPanel, "Center");
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Min balance"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel2, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Free balance"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel2, gridBagConstraints);
        this.minBalanceTextField = new JTextField();
        this.minBalanceTextField.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.minBalanceTextField, gridBagConstraints);
        this.freeBalanceTextField = new JTextField();
        this.freeBalanceTextField.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.freeBalanceTextField, gridBagConstraints);
        this.useMinBalanceCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.useMinBalanceCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Use"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.useMinBalanceCheckBox, gridBagConstraints);
        this.useFreeBalanceCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.useFreeBalanceCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Use"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.useFreeBalanceCheckBox, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Service"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel3, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.serviceComboBox, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel5, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Tariff"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel4, gridBagConstraints);
        this.tariffComboBox = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.tariffComboBox, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel6, gridBagConstraints);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

