/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.usersettings.fundsflow;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaDeleteFundsFlowSettings;
import biz.netup.control.transport.urfa.functions.UrfaEditFundsFlowSettings;
import biz.netup.control.transport.urfa.functions.UrfaGetFundsFlowSettings;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.usersettings.UpDownButtons;
import biz.netup.projects.utmadmin.gui.mainframe.forms.usersettings.fundsflow.FundsFlowDialog;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class FundsFlowTab
extends TabPanelWithTable {
    private int priority = 0;
    private Set<Integer> groups;

    public FundsFlowTab() {
        this.setRefreshPermission(new int[]{86052});
        this.setAddPermission(new int[]{1376849, 9216});
        this.setEditPermission(new int[]{86054});
        this.setDeletePermission(new int[]{86055});
    }

    @Override
    public String getTabName() {
        return "Funds Flow";
    }

    @Override
    public int getTabType() {
        return 1;
    }

    @Override
    public String getGroupName() {
        return "User settings";
    }

    @Override
    public int getMode() {
        return 1;
    }

    @Override
    public Map<String, String> getColumnNames() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("id", "ID");
        hashMap.put("group_id", "Group ID");
        hashMap.put("group_name", "Group name");
        hashMap.put("priority", "Priority");
        hashMap.put("is_enabled", "Is enabled");
        return hashMap;
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        this.priority = 0;
        UrfaGetFundsFlowSettings urfaGetFundsFlowSettings = new UrfaGetFundsFlowSettings(UrfaManagerImpl.getInstance());
        urfaGetFundsFlowSettings.call();
        this.groups = new HashSet<Integer>();
        for (int n : urfaGetFundsFlowSettings.getGroupId1()) {
            this.groups.add(n);
        }
        for (int i = 0; i < urfaGetFundsFlowSettings.getCount(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", urfaGetFundsFlowSettings.getId1()[i]);
            hashMap.put("group_id", urfaGetFundsFlowSettings.getGroupId1()[i]);
            if (urfaGetFundsFlowSettings.getGroupId1()[i] != 0) {
                hashMap.put("group_name", Resolve.getGroupName(urfaGetFundsFlowSettings.getGroupId1()[i]));
                hashMap.put("delete", 1);
            } else {
                hashMap.put("group_name", this.resource.getString("All"));
                hashMap.put("delete", 0);
            }
            hashMap.put("is_enabled", urfaGetFundsFlowSettings.getIsEnabled1()[i]);
            hashMap.put("priority", urfaGetFundsFlowSettings.getPriopity1()[i]);
            if (i < urfaGetFundsFlowSettings.getCount() - 2) {
                hashMap.put("down", 1);
            } else {
                hashMap.put("down", 0);
            }
            if (i < urfaGetFundsFlowSettings.getCount() - 1 && i != 0) {
                hashMap.put("up", 1);
            } else {
                hashMap.put("up", 0);
            }
            if (this.priority < urfaGetFundsFlowSettings.getPriopity1()[i] + 1) {
                this.priority = urfaGetFundsFlowSettings.getPriopity1()[i] + 1;
            }
            vector.add(hashMap);
        }
        return vector;
    }

    @Override
    protected void init() {
        super.init();
        UpDownButtons upDownButtons = new UpDownButtons();
        this.getAdditionalButtonPanel2().add(upDownButtons.getButtonPanel());
        this.mainTablePanel.registerFieldButtonBlock(this.deleteButton, "delete", 0);
        this.mainTablePanel.registerFieldButtonBlock(upDownButtons.getUpButton(), "up", 0);
        this.mainTablePanel.registerFieldButtonBlock(upDownButtons.getDownButton(), "down", 0);
        this.mainTablePanel.registerOneRowButton(upDownButtons.getUpButton());
        this.mainTablePanel.registerOneRowButton(upDownButtons.getDownButton());
        upDownButtons.getUpButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FundsFlowTab.this.up();
            }
        });
        upDownButtons.getDownButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FundsFlowTab.this.down();
            }
        });
    }

    private void change(Map<String, Object> map, Map<String, Object> map2) {
        try {
            UrfaEditFundsFlowSettings urfaEditFundsFlowSettings = new UrfaEditFundsFlowSettings(UrfaManagerImpl.getInstance());
            urfaEditFundsFlowSettings.setId((Integer)map.get("id"));
            urfaEditFundsFlowSettings.setGroupId((Integer)map.get("group_id"));
            urfaEditFundsFlowSettings.setIsEnabled((Integer)map.get("is_enabled"));
            urfaEditFundsFlowSettings.setPriopity((Integer)map2.get("priority"));
            urfaEditFundsFlowSettings.call();
            urfaEditFundsFlowSettings = new UrfaEditFundsFlowSettings(UrfaManagerImpl.getInstance());
            urfaEditFundsFlowSettings.setId((Integer)map2.get("id"));
            urfaEditFundsFlowSettings.setGroupId((Integer)map2.get("group_id"));
            urfaEditFundsFlowSettings.setIsEnabled((Integer)map2.get("is_enabled"));
            urfaEditFundsFlowSettings.setPriopity((Integer)map.get("priority"));
            urfaEditFundsFlowSettings.call();
        }
        catch (UrfaException urfaException) {
            // empty catch block
        }
    }

    private void up() {
        Map<String, Object> map = this.mainTablePanel.getSelectedTableRows()[0];
        Map<String, Object> map2 = null;
        for (int i = 0; i < this.mainTablePanel.getTableModel().data.size(); ++i) {
            if (this.mainTablePanel.getTableModel().data.get(i) != map || i <= 0) continue;
            map2 = this.mainTablePanel.getTableModel().data.get(i - 1);
        }
        if (map2 == null) {
            return;
        }
        this.change(map, map2);
        this.refresh();
    }

    private void down() {
        Map<String, Object> map = this.mainTablePanel.getSelectedTableRows()[0];
        Map<String, Object> map2 = null;
        for (int i = 0; i < this.mainTablePanel.getTableModel().data.size(); ++i) {
            if (this.mainTablePanel.getTableModel().data.get(i) != map || i >= this.mainTablePanel.getTableModel().data.size() - 2) continue;
            map2 = this.mainTablePanel.getTableModel().data.get(i + 1);
        }
        if (map2 == null) {
            return;
        }
        this.change(map, map2);
        this.refresh();
    }

    @Override
    protected void add() {
        this.log.log(10, "Add element - " + this.getTabName());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("groups", this.groups);
        hashMap.put("priority", this.priority);
        this.getItemDialog(hashMap).run(this);
    }

    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
        UrfaDeleteFundsFlowSettings urfaDeleteFundsFlowSettings = new UrfaDeleteFundsFlowSettings(UrfaManagerImpl.getInstance());
        urfaDeleteFundsFlowSettings.setId((Integer)map.get("id"));
        urfaDeleteFundsFlowSettings.call();
        if (urfaDeleteFundsFlowSettings.getResult() == -1) {
            throw new UrfaException(this.resource.getString(this.getTabName()) + ": " + this.resource.getString("Cannot delete item(s)"));
        }
    }

    @Override
    public DFModel getItemDialog(Map<String, Object> map) {
        return new FundsFlowDialog(map);
    }
}

