/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.usersandgroups.staff;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaAddSysUser;
import biz.netup.control.transport.urfa.functions.UrfaEditSysUser;
import biz.netup.control.transport.urfa.functions.UrfaGetSysUser;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.objects.AddressWithMask;
import biz.netup.projects.utmadmin.gui.mainframe.forms.usersandgroups.sysgroups.MainSysGroupsTab;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.TablePanelAdapter;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.control.ArrayFromVector;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialog.FrameModel;
import biz.netup.utmutils.swing.dialog.SelectFromTableDialogModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class SysUserDialog
extends FrameModel {
    private JPanel contentPane;
    private JTextField uidTextField;
    private JButton addButton;
    private JButton deleteButton;
    private JTextField loginTextField;
    private JPasswordField passwordTextField;
    private TablePanelImpl mainTable;
    private JPanel mPanel;
    private JPasswordField passwordTextField2;
    private JTextField ip4TextField;
    private JTextField ip6TextField;

    public SysUserDialog() {
        this.$$$setupUI$$$();
    }

    public SysUserDialog(Map<String, Object> map) {
        super(map);
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        return this.mPanel;
    }

    @Override
    public String getItemName() {
        return "System user";
    }

    @Override
    protected void loadInfo() throws UrfaException {
        if (!this.isAddMode()) {
            this.log.log(10, "#System User Debug# Loading started");
            UrfaGetSysUser urfaGetSysUser = new UrfaGetSysUser(UrfaManagerImpl.getInstance());
            urfaGetSysUser.setUserId((Integer)this.item.get("id"));
            urfaGetSysUser.call();
            this.uidTextField.setText("" + this.item.get("id"));
            this.loginTextField.setText(urfaGetSysUser.getLogin());
            this.ip4TextField.setText(Resolve.SubnetToView(urfaGetSysUser.getIp4(), urfaGetSysUser.getMask4()));
            this.ip6TextField.setText(Resolve.SubnetToView(urfaGetSysUser.getIp6(), urfaGetSysUser.getMask6()));
            for (int i = 0; i < urfaGetSysUser.getGroupsSize(); ++i) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("id", urfaGetSysUser.getGroupId1()[i]);
                hashMap.put("name", urfaGetSysUser.getGroupName1()[i]);
                hashMap.put("info", urfaGetSysUser.getGroupInfo1()[i]);
                this.mainTable.getTableModel().addRow(hashMap);
            }
        } else {
            this.log.log(10, "#System User Debug# New system user");
        }
        this.log.log(10, "#System User Debug# Urfa calls complete");
        this.log.log(10, "#System User Debug# Action listeners");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SysUserDialog.this.deleteGroup();
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SysUserDialog.this.addGroup();
            }
        });
        this.mainTable.registerMultiRowButton(this.deleteButton);
        this.log.log(10, "#System User Debug# Action listeners finished");
    }

    @Override
    protected void saveInfo() throws UrfaException {
        this.log.log(10, "#System User Debug# Saving started");
        if (this.isAddMode()) {
            this.log.log(10, "#System User Debug# New system user");
            UrfaAddSysUser urfaAddSysUser = new UrfaAddSysUser(UrfaManagerImpl.getInstance());
            urfaAddSysUser.setLogin(this.loginTextField.getText());
            urfaAddSysUser.setPassword(this.passwordTextField.getText());
            this.log.log(10, "#System User Debug# 1");
            try {
                AddressWithMask addressWithMask = Resolve.SubnetFromView(this.ip4TextField.getText());
                urfaAddSysUser.setAddress4(addressWithMask.address);
                urfaAddSysUser.setMask4(addressWithMask.mask);
                AddressWithMask addressWithMask2 = Resolve.SubnetFromView(this.ip6TextField.getText());
                urfaAddSysUser.setAddress6(addressWithMask2.address);
                urfaAddSysUser.setMask6(addressWithMask2.mask);
                this.log.log(10, "#System User Debug# 2");
            }
            catch (Exception exception) {
                return;
            }
            urfaAddSysUser.setGroupsSize(this.mainTable.getTableModel().getRowCount());
            urfaAddSysUser.setGroupId1(ArrayFromVector.getIntArrayFromData(this.mainTable.getTableModel().data, "id"));
            this.log.log(10, "#System User Debug# 3");
            urfaAddSysUser.call();
            if (urfaAddSysUser.getResult() == 0) {
                Dialogs.showErrorDialog(Utils.getResource().getString("Login is incorrect"));
            }
            this.log.log(10, "#System User Debug# 4");
        } else {
            this.log.log(10, "#System User Debug# Old system user");
            UrfaEditSysUser urfaEditSysUser = new UrfaEditSysUser(UrfaManagerImpl.getInstance());
            urfaEditSysUser.setUserId((Integer)this.item.get("id"));
            urfaEditSysUser.setLogin(this.loginTextField.getText());
            this.log.log(10, "#System User Debug# 1");
            if (!this.passwordTextField.getText().isEmpty()) {
                urfaEditSysUser.setPassword(this.passwordTextField.getText());
            }
            try {
                AddressWithMask addressWithMask = Resolve.SubnetFromView(this.ip4TextField.getText());
                urfaEditSysUser.setAddress4(addressWithMask.address);
                urfaEditSysUser.setMask4(addressWithMask.mask);
                AddressWithMask addressWithMask3 = Resolve.SubnetFromView(this.ip6TextField.getText());
                urfaEditSysUser.setAddress6(addressWithMask3.address);
                urfaEditSysUser.setMask6(addressWithMask3.mask);
                this.log.log(10, "#System User Debug# 2");
            }
            catch (Exception exception) {
                return;
            }
            urfaEditSysUser.setGroupId1(ArrayFromVector.getIntArrayFromData(this.mainTable.getTableModel().data, "id"));
            this.log.log(10, "#System User Debug# 3");
            urfaEditSysUser.call();
            this.log.log(10, "#System User Debug# 4");
        }
        this.log.log(10, "#System User Debug# Save finished");
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
        this.log.log(10, "#System User Debug# Checking");
        if (!this.settingListeners && !this.passwordTextField.getText().equals(this.passwordTextField2.getText())) {
            Dialogs.showErrorDialog("Password doesn't match");
            throw new IllegalArgumentException();
        }
        this.checkLogin(this.loginTextField, "Login");
        if (this.isAddMode()) {
            this.checkName(this.passwordTextField, "Password");
        }
        this.checkIPAndType(this.ip4TextField, "IP4", 4);
        this.checkIPAndType(this.ip6TextField, "IP6", 6);
        this.log.log(10, "#System User Debug# Checking finished");
    }

    private void createUIComponents() {
        this.createTable();
    }

    private void createTable() {
        this.mainTable = new TablePanelImpl(this.getClass().getName() + "_sys_users", true);
        MapTableModel mapTableModel = this.mainTable.getTableModel();
        mapTableModel.addColumn("id", "Group ID", true, false);
        mapTableModel.addColumn("name", "Group name", true, false);
        mapTableModel.addColumn("info", "Info", true, false);
        this.mainTable.setEditable(false);
        this.mainTable.setAppendable(false);
        this.mainTable.setTablePanelListener(new TablePanelAdapter(){

            @Override
            public JMenuItem[] getTableContextMenuItems(Map<String, Object>[] mapArray) {
                JMenuItem jMenuItem = new JMenuItem(SysUserDialog.this.resource.getString("Remove"));
                JMenuItem jMenuItem2 = new JMenuItem(SysUserDialog.this.resource.getString("Add"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SysUserDialog.this.deleteGroup();
                    }
                });
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SysUserDialog.this.addGroup();
                    }
                });
                if (mapArray.length < 1) {
                    return new JMenuItem[0];
                }
                if (mapArray.length > 1) {
                    return new JMenuItem[]{jMenuItem};
                }
                ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
                arrayList.add(jMenuItem);
                return arrayList.toArray(new JMenuItem[arrayList.size()]);
            }

            @Override
            public void performTableRowDoubleClicked(Map<String, Object> map) {
            }

            @Override
            public void performSelectionChanged(Map<String, Object>[] mapArray) {
            }

            @Override
            public void performRowModified(Map<String, Object> map) {
            }

            @Override
            public void performColumnVisibilityChanged(String string, boolean bl) {
            }
        });
        this.mainTable.applyTableSettings();
    }

    private void addGroup() {
        SelectFromTableDialogModel selectFromTableDialogModel = new SelectFromTableDialogModel(new MainSysGroupsTab());
        selectFromTableDialogModel.setVisible(true);
        if (selectFromTableDialogModel.isOkPressed()) {
            this.mainTable.getTableModel().addRow(selectFromTableDialogModel.getItem());
        }
    }

    private void deleteGroup() {
        for (Map<String, Object> map : this.mainTable.getSelectedTableRows()) {
            this.mainTable.getTableModel().removeRow(map);
        }
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new GridBagLayout());
        this.mPanel = new JPanel();
        this.mPanel.setLayout(new GridBagLayout());
        this.mPanel.setMinimumSize(new Dimension(450, 400));
        this.mPanel.setPreferredSize(new Dimension(450, 400));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.contentPane.add((Component)this.mPanel, gridBagConstraints);
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("UID"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.mPanel.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Login"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.mPanel.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("IP6"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        this.mPanel.add((Component)jLabel3, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("IP4"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        this.mPanel.add((Component)jLabel4, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Password"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.mPanel.add((Component)jLabel5, gridBagConstraints);
        this.uidTextField = new JTextField();
        this.uidTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mPanel.add((Component)this.uidTextField, gridBagConstraints);
        this.loginTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mPanel.add((Component)this.loginTextField, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mPanel.add((Component)jPanel, gridBagConstraints);
        jPanel.add((Component)this.mainTable, "Center");
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("System Groups"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 17;
        this.mPanel.add((Component)jLabel6, gridBagConstraints);
        this.addButton = new JButton();
        this.$$$loadButtonText$$$(this.addButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        this.mPanel.add((Component)this.addButton, gridBagConstraints);
        this.deleteButton = new JButton();
        this.$$$loadButtonText$$$(this.deleteButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Remove"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        this.mPanel.add((Component)this.deleteButton, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.mPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.mPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        this.mPanel.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        this.mPanel.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        this.mPanel.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        this.mPanel.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.mPanel.add((Component)jPanel8, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 3;
        this.mPanel.add((Component)jPanel9, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.mPanel.add((Component)jPanel10, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        this.mPanel.add((Component)jPanel11, gridBagConstraints);
        this.passwordTextField2 = new JPasswordField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mPanel.add((Component)this.passwordTextField2, gridBagConstraints);
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Password confirm"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.mPanel.add((Component)jLabel7, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.mPanel.add((Component)jPanel12, gridBagConstraints);
        this.passwordTextField = new JPasswordField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mPanel.add((Component)this.passwordTextField, gridBagConstraints);
        this.ip4TextField = new JTextField();
        this.ip4TextField.setText("0.0.0.0/32");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.mPanel.add((Component)this.ip4TextField, gridBagConstraints);
        this.ip6TextField = new JTextField();
        this.ip6TextField.setText("0::/128");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.mPanel.add((Component)this.ip6TextField, gridBagConstraints);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

