/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.teldirections;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetFoundedTelDirsCount;
import biz.netup.control.transport.urfa.functions.UrfaGetTelDirecetionsCount;
import biz.netup.control.transport.urfa.functions.UrfaGetTelDirection;
import biz.netup.control.transport.urfa.functions.UrfaRemoveTelDirection;
import biz.netup.control.transport.urfa.functions.UrfaSearchTelDirs;
import biz.netup.control.transport.urfa.functions.UrfaTelDirectionsList;
import biz.netup.control.transport.urfa.functions.UrfaTelZonesList;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.custom.PagesPanel;
import biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.teldirections.DirectionForm;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.filter.FilterForm;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.dialog.DialogModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;

public class MainTDTab
extends TabPanelWithTable {
    private PagesPanel pages;
    private boolean searching;
    private FilterOrder filterOrder;
    private Set<Integer> filterIds;

    public void setFilterOrder(FilterOrder filterOrder) {
        this.filterOrder = filterOrder;
        if (this.filterOrder == FilterOrder.INVERCE) {
            this.pages.getPanel().setVisible(false);
            this.getFilterPanel().setVisible(false);
        }
    }

    public void setFilterIds(Set<Integer> set) {
        this.filterIds = set;
    }

    @Override
    public int getTabType() {
        return 1;
    }

    @Override
    public String getHelpTarget() {
        return "direction";
    }

    @Override
    protected boolean useFilter() {
        return true;
    }

    @Override
    protected FilterForm setNewFilterForm() {
        return new CustomFilterForm(this);
    }

    @Override
    public String getTabName() {
        return "Telephone Directions";
    }

    @Override
    public String getGroupName() {
        return "Tariffication";
    }

    @Override
    public int getMode() {
        return 1;
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("id", "ID");
        linkedHashMap.put("name", "Name");
        linkedHashMap.put("created_on", "Created on");
        linkedHashMap.put("updated_on", "Updated on");
        linkedHashMap.put("zone", "Zone");
        linkedHashMap.put("calling_prefix", "Calling Prefix");
        linkedHashMap.put("called_prefix", "Called Prefix");
        return linkedHashMap;
    }

    public void setSearchState(boolean bl) {
        this.searching = bl;
    }

    private void construct() {
        final MainTDTab mainTDTab = this;
        this.pages = new PagesPanel(100, "Directions per page");
        this.pages.addListener(new PagesPanel.PageChangeListener(){

            @Override
            public void onPageChange(int n) {
                mainTDTab.refresh();
            }
        });
        if (UrfaManagerImpl.getInstance().isPermitted(new int[]{66334})) {
            this.getPanel().add((Component)this.pages.getPanel(), "South");
            this.setDataCount();
        }
    }

    public MainTDTab() {
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/tariff/telephone_directions_24.png")));
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/tariff/telephone_directions.png")));
        this.setRefreshPermission(new int[]{66310, 66334});
        this.setReadPermission(new int[]{66333});
        this.setAddPermission(new int[]{66304});
        this.setEditPermission(new int[]{66305});
        this.setDeletePermission(new int[]{66306});
        this.searching = false;
        this.filterOrder = FilterOrder.NORMAL;
        this.filterIds = new HashSet<Integer>();
        this.construct();
    }

    public void setDataCount() {
        UrfaGetTelDirecetionsCount urfaGetTelDirecetionsCount = new UrfaGetTelDirecetionsCount(UrfaManagerImpl.getInstance());
        try {
            urfaGetTelDirecetionsCount.setSkipIdsCount(this.filterIds.size());
            int[] nArray = new int[this.filterIds.size()];
            int n = 0;
            for (int n2 : this.filterIds) {
                nArray[n++] = n2;
            }
            urfaGetTelDirecetionsCount.setSkipIds(nArray);
            urfaGetTelDirecetionsCount.call();
            int n3 = urfaGetTelDirecetionsCount.getCount();
            if (n3 < 0) {
                Dialogs.showErrorDialog("cant get drections count");
            }
            this.pages.setCount(n3);
        }
        catch (UrfaException urfaException) {
            Dialogs.showErrorDialog("cant get drections count");
        }
    }

    private SearchParameters getSearchParamters() {
        FilterForm filterForm = this.getFilterForm();
        TablePanelImpl tablePanelImpl = filterForm.getCustomSearchTablePanel();
        Vector<Map<String, Object>> vector = tablePanelImpl.getTableModel().data;
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.criterias = new int[vector.size()];
        searchParameters.fields = new int[vector.size()];
        searchParameters.values = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            Map<String, Object> map = vector.get(i);
            String string = (String)map.get("field");
            if (string.equals(Utils.getResource().getString("ID"))) {
                searchParameters.fields[i] = Field.ID.ordinal();
            } else if (string.equals(Utils.getResource().getString("Name"))) {
                searchParameters.fields[i] = Field.NAME.ordinal();
            } else if (string.equals(Utils.getResource().getString("Created on"))) {
                searchParameters.fields[i] = Field.CREATED_ON.ordinal();
            } else if (string.equals(Utils.getResource().getString("Updated on"))) {
                searchParameters.fields[i] = Field.UPDATED_ON.ordinal();
            } else if (string.equals(Utils.getResource().getString("Zone"))) {
                searchParameters.fields[i] = Field.ZONE.ordinal();
            } else if (string.equals(Utils.getResource().getString("Calling Prefix"))) {
                searchParameters.fields[i] = Field.CALLING_PREFIX.ordinal();
            } else if (string.equals(Utils.getResource().getString("Called Prefix"))) {
                searchParameters.fields[i] = Field.CALLED_PREFIX.ordinal();
            }
            switch (filterForm.getCriteriaData().get(map.get("condition"))) {
                case 1: {
                    searchParameters.criterias[i] = Criteria.LIKE.ordinal();
                    break;
                }
                case 11: {
                    searchParameters.criterias[i] = Criteria.NOT_LIKE.ordinal();
                    break;
                }
                case 3: {
                    searchParameters.criterias[i] = Criteria.EQUAL.ordinal();
                    break;
                }
                case 4: {
                    searchParameters.criterias[i] = Criteria.NOT_EQUAL.ordinal();
                    break;
                }
                case 7: {
                    searchParameters.criterias[i] = Criteria.MORE.ordinal();
                    break;
                }
                case 9: {
                    searchParameters.criterias[i] = Criteria.MORE_EQUAL.ordinal();
                    break;
                }
                case 8: {
                    searchParameters.criterias[i] = Criteria.LESS.ordinal();
                    break;
                }
                case 10: {
                    searchParameters.criterias[i] = Criteria.LESS_EQUAL.ordinal();
                }
            }
            searchParameters.values[i] = map.get("value").toString();
        }
        searchParameters.status = filterForm.getAndOrComboBox() == 0 ? Status.SUCCESS_ALL.ordinal() : Status.SUCCESS_AT_LEAST_ONE.ordinal();
        return searchParameters;
    }

    public void setSearchedDataCount() {
        SearchParameters searchParameters = this.getSearchParamters();
        try {
            int n;
            int[] nArray = new int[this.filterIds.size()];
            int n2 = 0;
            Object object = this.filterIds.iterator();
            while (object.hasNext()) {
                n = object.next();
                nArray[n2++] = n;
            }
            object = new UrfaGetFoundedTelDirsCount(UrfaManagerImpl.getInstance());
            ((UrfaGetFoundedTelDirsCount)object).setCriteria1(searchParameters.criterias);
            ((UrfaGetFoundedTelDirsCount)object).setField1(searchParameters.fields);
            ((UrfaGetFoundedTelDirsCount)object).setValue1(searchParameters.values);
            ((UrfaGetFoundedTelDirsCount)object).setParamsCnt(searchParameters.values.length);
            ((UrfaGetFoundedTelDirsCount)object).setStatus(searchParameters.status);
            ((UrfaGetFoundedTelDirsCount)object).setSkipIds(nArray);
            ((UrfaGetFoundedTelDirsCount)object).setSkipIdsCnt(nArray.length);
            ((UrfaGetFoundedTelDirsCount)object).call();
            n = ((UrfaGetFoundedTelDirsCount)object).getCount();
            if (n < 0) {
                Dialogs.showErrorDialog("cant search directions");
                return;
            }
            this.pages.setCount(n);
            if (n == 0) {
                this.mainTablePanel.getTableModel().removeAllRows();
            }
        }
        catch (UrfaException urfaException) {
            Dialogs.showErrorDialog("cant search directions");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        int n;
        UrfaTelZonesList urfaTelZonesList = new UrfaTelZonesList(UrfaManagerImpl.getInstance());
        urfaTelZonesList.call();
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        for (int i = 0; i < urfaTelZonesList.getZoneCount(); ++i) {
            hashMap.put(urfaTelZonesList.getZoneIdArray1()[i], urfaTelZonesList.getNameArray1()[i]);
        }
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        if (this.filterOrder == FilterOrder.INVERCE) {
            if (this.filterIds.size() == 0) return vector;
            for (Integer n2 : this.filterIds) {
                UrfaGetTelDirection urfaGetTelDirection = new UrfaGetTelDirection(UrfaManagerImpl.getInstance());
                urfaGetTelDirection.setDirId(n2);
                urfaGetTelDirection.call();
                HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                if (urfaGetTelDirection.getDirId() == -1) continue;
                hashMap2.put("id", n2);
                hashMap2.put("name", urfaGetTelDirection.getName());
                hashMap2.put("created_on", new Date((long)urfaGetTelDirection.getCreateDate() * 1000L));
                hashMap2.put("updated_on", new Date((long)urfaGetTelDirection.getUpdateDate() * 1000L));
                hashMap2.put("calling_prefix", urfaGetTelDirection.getCallingPrefix());
                hashMap2.put("called_prefix", urfaGetTelDirection.getCalledPrefix());
                int n3 = urfaGetTelDirection.getZoneId();
                if (n3 != 0 && hashMap.get(n3) != null) {
                    hashMap2.put("zone", (String)hashMap.get(n3) + "(" + n3 + ")");
                } else {
                    hashMap2.put("zone", "");
                }
                vector.add(hashMap2);
            }
            return vector;
        }
        int[] nArray = new int[this.filterIds.size()];
        int n4 = 0;
        Object object = this.filterIds.iterator();
        while (object.hasNext()) {
            n = object.next();
            nArray[n4++] = n;
        }
        if (this.searching) {
            object = this.getSearchParamters();
            UrfaSearchTelDirs urfaSearchTelDirs = new UrfaSearchTelDirs(UrfaManagerImpl.getInstance());
            urfaSearchTelDirs.setStatus(((SearchParameters)object).status);
            urfaSearchTelDirs.setCriteria1(((SearchParameters)object).criterias);
            urfaSearchTelDirs.setField1(((SearchParameters)object).fields);
            urfaSearchTelDirs.setValue1(((SearchParameters)object).values);
            urfaSearchTelDirs.setParamsCnt(((SearchParameters)object).values.length);
            urfaSearchTelDirs.setStatus(((SearchParameters)object).status);
            urfaSearchTelDirs.setSkipIds(nArray);
            urfaSearchTelDirs.setSkipIdsCount(nArray.length);
            urfaSearchTelDirs.setOffset(this.pages.getPerPageCount() * this.pages.getPage());
            urfaSearchTelDirs.setLen(this.pages.getPerPageCount());
            urfaSearchTelDirs.call();
            for (int i = 0; i < urfaSearchTelDirs.getDirCount(); ++i) {
                HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
                int n5 = urfaSearchTelDirs.getDirIdArray1()[i];
                hashMap3.put("id", n5);
                hashMap3.put("name", urfaSearchTelDirs.getDirNameArray1()[i]);
                hashMap3.put("created_on", new Date((long)urfaSearchTelDirs.getCreateDateArray1()[i] * 1000L));
                hashMap3.put("updated_on", new Date((long)urfaSearchTelDirs.getUpdateDateArray1()[i] * 1000L));
                hashMap3.put("calling_prefix", urfaSearchTelDirs.getCallingPrefixArray1()[i]);
                hashMap3.put("called_prefix", urfaSearchTelDirs.getCalledPrefixArray1()[i]);
                int n6 = urfaSearchTelDirs.getZoneIdArray1()[i];
                if (n6 != 0 && hashMap.get(n6) != null) {
                    hashMap3.put("zone", (String)hashMap.get(n6) + "(" + n6 + ")");
                } else {
                    hashMap3.put("zone", "");
                }
                vector.add(hashMap3);
            }
            return vector;
        } else {
            int n7;
            Object object2;
            object = new UrfaTelDirectionsList(UrfaManagerImpl.getInstance());
            ((UrfaTelDirectionsList)object).setCount(this.pages.getPerPageCount());
            ((UrfaTelDirectionsList)object).setStart(this.pages.getPerPageCount() * this.pages.getPage());
            ((UrfaTelDirectionsList)object).setSkipIds(nArray);
            ((UrfaTelDirectionsList)object).setSkipIdsCount(nArray.length);
            ((UrfaTelDirectionsList)object).call();
            for (n = 0; n < ((UrfaTelDirectionsList)object).getDirCount(); ++n) {
                object2 = new HashMap<String, Object>();
                n7 = ((UrfaTelDirectionsList)object).getDirIdArray1()[n];
                object2.put("id", n7);
                object2.put("name", ((UrfaTelDirectionsList)object).getDirNameArray1()[n]);
                object2.put("created_on", new Date((long)((UrfaTelDirectionsList)object).getCreateDateArray1()[n] * 1000L));
                object2.put("updated_on", new Date((long)((UrfaTelDirectionsList)object).getUpdateDateArray1()[n] * 1000L));
                object2.put("calling_prefix", ((UrfaTelDirectionsList)object).getCallingPrefixArray1()[n]);
                object2.put("called_prefix", ((UrfaTelDirectionsList)object).getCalledPrefixArray1()[n]);
                int n8 = ((UrfaTelDirectionsList)object).getZoneIdArray1()[n];
                if (n8 != 0 && hashMap.get(n8) != null) {
                    object2.put("zone", (String)hashMap.get(n8) + "(" + n8 + ")");
                } else {
                    object2.put("zone", "");
                }
                vector.add((Map<String, Object>)object2);
            }
            UrfaGetTelDirecetionsCount urfaGetTelDirecetionsCount = new UrfaGetTelDirecetionsCount(UrfaManagerImpl.getInstance());
            try {
                urfaGetTelDirecetionsCount.setSkipIdsCount(this.filterIds.size());
                nArray = new int[this.filterIds.size()];
                n4 = 0;
                object2 = this.filterIds.iterator();
                while (object2.hasNext()) {
                    n7 = (Integer)object2.next();
                    nArray[n4++] = n7;
                }
                urfaGetTelDirecetionsCount.setSkipIds(nArray);
                urfaGetTelDirecetionsCount.call();
                int n9 = urfaGetTelDirecetionsCount.getCount();
                if (n9 < 0) {
                    Dialogs.showErrorDialog("cant get drections count");
                }
                if (this.pages.getCount() == n9) return vector;
                this.pages.updateCount(n9);
                return vector;
            }
            catch (UrfaException urfaException) {
                Dialogs.showErrorDialog("cant get drections count");
            }
        }
        return vector;
    }

    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
        UrfaRemoveTelDirection urfaRemoveTelDirection = new UrfaRemoveTelDirection(UrfaManagerImpl.getInstance());
        urfaRemoveTelDirection.setDirId((Integer)map.get("id"));
        urfaRemoveTelDirection.call();
        if (urfaRemoveTelDirection.getDirId() < 0) {
            String string = this.resource.getString("Direction <%direction%> already used");
            string = string.replaceAll("<%direction%>", "\"" + map.get("name") + "\"");
            this.log.log(1, string);
        }
        this.pages.updateCount(this.pages.getCount() - 1);
    }

    @Override
    public DFModel getItemDialog(Map<String, Object> map) {
        DirectionForm directionForm = new DirectionForm(map);
        directionForm.addListener(new DialogModel.DialogEventListener(){

            @Override
            public void onSave(Map<String, Object> map) {
                MainTDTab.this.pages.updateCount(MainTDTab.this.pages.getCount() + 1);
            }
        });
        return directionForm;
    }

    public static enum FilterOrder {
        NORMAL,
        INVERCE;

    }

    private class SearchParameters {
        public int status;
        public int[] fields;
        public int[] criterias;
        public String[] values;

        private SearchParameters() {
        }
    }

    static enum Field {
        ID,
        NAME,
        CREATED_ON,
        UPDATED_ON,
        ZONE,
        CALLING_PREFIX,
        CALLED_PREFIX;

    }

    static enum Criteria {
        LIKE,
        NOT_LIKE,
        EQUAL,
        NOT_EQUAL,
        MORE,
        LESS,
        MORE_EQUAL,
        LESS_EQUAL;

    }

    static enum Status {
        SUCCESS_AT_LEAST_ONE,
        SUCCESS_ALL;

    }

    private class CustomFilterForm
    extends FilterForm {
        public CustomFilterForm(final MainTDTab mainTDTab2) {
            super(mainTDTab2.getMainTablePanel(), null, null);
            this.getClearButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    mainTDTab2.setSearchState(false);
                    mainTDTab2.setDataCount();
                }
            });
            for (ActionListener actionListener : this.getFilterButton().getActionListeners()) {
                this.getFilterButton().removeActionListener(actionListener);
            }
            this.getFilterButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    mainTDTab2.setSearchState(true);
                    mainTDTab2.setSearchedDataCount();
                }
            });
        }

        @Override
        public void filter() {
        }
    }
}

