/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.reports;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetGraphDataDialup;
import biz.netup.control.transport.urfa.functions.UrfaGetGraphDataIptraffic;
import biz.netup.control.transport.urfa.functions.UrfaGetGraphDataTelephony;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.swing.table.MapTableModel;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.tab.ReportTab;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Hour;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;

public class GraphReport
extends ReportTab {
    private ChartPanel chp;
    private String cur_report;
    public TreeMap report_data;
    private JComboBox typeComboBox;
    private String y_label;
    private Map time_series_numeration = new TreeMap();
    private Map tclass_colors = new TreeMap();

    public GraphReport(int n) {
        super(n);
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/graph_report_24.png")));
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/graph_report.png")));
        this.setRefreshPermission(new int[]{20626, 20625, 20627});
    }

    public GraphReport() {
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/graph_report_24.png")));
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/graph_report.png")));
        this.setRefreshPermission(new int[]{20626, 20625, 20627});
    }

    @Override
    public int getMode() {
        return 1;
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        switch (this.getType()) {
            case 0: {
                linkedHashMap.put("id", "Traffic class ID");
                linkedHashMap.put("name", "Traffic class name");
                linkedHashMap.put("minimum", "Minimum");
                linkedHashMap.put("average", "Average");
                linkedHashMap.put("maximum", "Maximum value");
                break;
            }
            case 1: {
                linkedHashMap.put("minimum", "Minimum");
                linkedHashMap.put("average", "Average");
                linkedHashMap.put("maximum", "Maximum value");
                break;
            }
            case 2: {
                linkedHashMap.put("minimum", "Minimum");
                linkedHashMap.put("average", "Average");
                linkedHashMap.put("maximum", "Maximum value");
                break;
            }
            default: {
                linkedHashMap.put("minimum", "Minimum");
                linkedHashMap.put("average", "Average");
                linkedHashMap.put("maximum", "Maximum value");
            }
        }
        return linkedHashMap;
    }

    @Override
    public void setTableData() throws UrfaException {
    }

    @Override
    protected void init() {
        super.init();
        this.getGraphPanel().setVisible(true);
        this.getApPanel().setVisible(false);
        this.getExportButton().setVisible(false);
        this.typeComboBox = new JComboBox();
        this.getAdditionalButtonsPanel().add((Component)this.typeComboBox, "South");
        this.getAdditionalButtonsPanel().add((Component)new JLabel(this.resource.getString("Service type")), "North");
        this.typeComboBox.addItem(this.resource.getString("IP-Traffic gr"));
        this.typeComboBox.addItem(this.resource.getString("Dial-UP gr"));
        this.typeComboBox.addItem(this.resource.getString("Telephony gr"));
        this.typeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MapTableModel mapTableModel = GraphReport.this.getReportTablePanel().getTableModel();
                mapTableModel.removeAllRows();
                for (int i = mapTableModel.getColumnCount() - 1; i >= 0; --i) {
                    mapTableModel.removeColumn(mapTableModel.getColumnId(i));
                }
                for (String string : GraphReport.this.getColumnNames().keySet()) {
                    mapTableModel.addColumn(string, GraphReport.this.getColumnNames().get(string), true, false);
                }
                GraphReport.this.getReportTablePanel().repaint();
                GraphReport.this.getGraphPanel().removeAll();
                GraphReport.this.getGraphPanel().revalidate();
            }
        });
    }

    @Override
    public int getType() {
        if (this.typeComboBox != null) {
            return this.typeComboBox.getSelectedIndex();
        }
        return -1;
    }

    @Override
    public String getTabName() {
        return "Graphic Report";
    }

    public void goReport() {
        this.getGraphPanel().removeAll();
        if (this.report_data.size() == 0) {
            System.out.println("Empty report data. Continue ... ");
            this.getGraphPanel().add((Component)new JLabel(this.resource.getString("No data")), "Center");
            return;
        }
        if (this.getType() == 0) {
            this.CreateIPTrafficReport();
        } else if (this.getType() == 1) {
            this.CreateDialupReport();
        } else if (this.getType() == 2) {
            this.CreateTelephonyReport();
        }
    }

    private void CreateDialupReport() {
        this.y_label = "Count";
        try {
            XYDataset xYDataset = this.createDataset(this.report_data);
            JFreeChart jFreeChart = this.createChart(xYDataset, "Dialup report");
            this.chp = new ChartPanel(jFreeChart, false);
            this.chp.setPreferredSize(new Dimension(500, 270));
            this.chp.setMouseZoomable(true, false);
            this.chp.setVisible(true);
            this.getGraphPanel().add((Component)this.chp, "Center");
            this.getGraphPanel().revalidate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void CreateTelephonyReport() {
        this.y_label = "Calls";
        if (this.report_data.size() == 0) {
            System.out.println("Empty report data. Continue ... ");
            return;
        }
        try {
            XYDataset xYDataset = this.createDataset(this.report_data);
            JFreeChart jFreeChart = this.createChart(xYDataset, "Telephony report");
            this.chp = new ChartPanel(jFreeChart, false);
            this.chp.setPreferredSize(new Dimension(500, 270));
            this.chp.setMouseZoomable(true, false);
            this.chp.setVisible(true);
            this.getGraphPanel().add((Component)this.chp);
            this.getGraphPanel().revalidate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void CreateIPTrafficReport() {
        this.y_label = "Mbit/sec";
        if (this.report_data.size() == 0) {
            System.out.println("Empty report data. Continue ... ");
            return;
        }
        try {
            XYDataset xYDataset = this.createDataset(this.report_data);
            JFreeChart jFreeChart = this.createChart(xYDataset, "IP-traffic report");
            this.chp = new ChartPanel(jFreeChart, false);
            this.chp.setPreferredSize(new Dimension(500, 270));
            this.chp.setMouseZoomable(true, false);
            Font font = new Font("Serif", 0, 23);
            XYPlot xYPlot = jFreeChart.getXYPlot();
            XYItemRenderer xYItemRenderer = xYPlot.getRenderer();
            Set set = this.time_series_numeration.entrySet();
            for (Map.Entry entry : set) {
                int n = 0;
                int n2 = (Integer)entry.getKey();
                String string = (String)entry.getValue();
                if (this.tclass_colors.containsKey(string)) {
                    n = (Integer)this.tclass_colors.get(string);
                }
                Color color = new Color(n);
                xYItemRenderer.setSeriesPaint(n2, (Paint)color);
                xYItemRenderer.setSeriesItemLabelFont(n2, font);
                System.out.println("SERIE:" + n2 + " COLOR:" + n + " FONT:" + xYItemRenderer.getSeriesItemLabelFont(n2));
            }
            this.chp.setVisible(true);
            this.getGraphPanel().add((Component)this.chp);
            this.getGraphPanel().revalidate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    protected void refreshTab() throws UrfaException {
        this.getGraphPanel().removeAll();
        this.getGraphPanel().repaint();
        this.getReportTablePanel().getTableModel().removeAllRows();
        new ObtainReportFromCore();
    }

    private XYDataset createDataset(TreeMap treeMap) {
        TreeMap<String, TimeSeries> treeMap2 = new TreeMap<String, TimeSeries>();
        int n = 0;
        System.out.println("CreateDataset called. Generating chart ... ");
        Set set = treeMap.entrySet();
        for (Map.Entry timeSeriesCollection2 : set) {
            Set set2 = ((TreeMap)timeSeriesCollection2.getValue()).entrySet();
            for (Map.Entry entry : set2) {
                TimeSeries timeSeries;
                double d = (Double)entry.getValue();
                if (treeMap2.containsKey(entry.getKey())) {
                    timeSeries = (TimeSeries)treeMap2.get(entry.getKey());
                    timeSeries.addOrUpdate((RegularTimePeriod)new Hour((Date)timeSeriesCollection2.getKey()), d);
                    continue;
                }
                timeSeries = new TimeSeries((Comparable)((Object)((String)entry.getKey())), Hour.class);
                timeSeries.addOrUpdate((RegularTimePeriod)new Hour((Date)timeSeriesCollection2.getKey()), d);
                treeMap2.put((String)entry.getKey(), timeSeries);
                System.out.println("Adding timeserie. Name:" + (String)entry.getKey());
                this.time_series_numeration.put(new Integer(n), (String)entry.getKey());
                ++n;
            }
        }
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        set = treeMap2.entrySet();
        for (Map.Entry entry : set) {
            timeSeriesCollection.addSeries((TimeSeries)entry.getValue());
        }
        timeSeriesCollection.setDomainIsPointsInTime(true);
        return timeSeriesCollection;
    }

    private JFreeChart createChart(XYDataset xYDataset, String string) {
        XYLineAndShapeRenderer xYLineAndShapeRenderer;
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart((String)string, (String)"Date", (String)this.y_label, (XYDataset)xYDataset, (boolean)true, (boolean)true, (boolean)false);
        jFreeChart.setBackgroundPaint((Paint)Color.white);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setBackgroundPaint((Paint)Color.lightGray);
        xYPlot.setDomainGridlinePaint((Paint)Color.white);
        xYPlot.setRangeGridlinePaint((Paint)Color.white);
        xYPlot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        xYPlot.setDomainCrosshairVisible(true);
        xYPlot.setRangeCrosshairVisible(true);
        XYItemRenderer xYItemRenderer = xYPlot.getRenderer();
        if (xYItemRenderer instanceof XYLineAndShapeRenderer) {
            xYLineAndShapeRenderer = (XYLineAndShapeRenderer)xYItemRenderer;
        }
        xYLineAndShapeRenderer = (DateAxis)xYPlot.getDomainAxis();
        xYLineAndShapeRenderer.setDateFormatOverride((DateFormat)new SimpleDateFormat("kk:mm dd-MM-yyyy"));
        return jFreeChart;
    }

    class AVG {
        double mbytes;
        double avg;
        double min;
        double max;
        int count;

        AVG() {
        }
    }

    class ObtainReportFromCore
    implements Runnable {
        byte[] imageData;
        int image_size;

        ObtainReportFromCore() {
            new Thread((Runnable)this, "create image").start();
        }

        private void urfa_traffic() {
            try {
                Object object;
                UrfaGetGraphDataIptraffic urfaGetGraphDataIptraffic = new UrfaGetGraphDataIptraffic(UrfaManagerImpl.getInstance());
                urfaGetGraphDataIptraffic.setAid(GraphReport.this.aid);
                urfaGetGraphDataIptraffic.setUid(GraphReport.this.uid);
                urfaGetGraphDataIptraffic.setTStart(GraphReport.this.getStartTime());
                urfaGetGraphDataIptraffic.setTEnd(GraphReport.this.getEndTime());
                urfaGetGraphDataIptraffic.call();
                TreeMap<Integer, AVG> treeMap = new TreeMap<Integer, AVG>();
                for (int i = 0; i < urfaGetGraphDataIptraffic.getTrafficDiscountSize(); ++i) {
                    TreeMap treeMap2 = new TreeMap();
                    int n = urfaGetGraphDataIptraffic.getTime1()[i];
                    for (int j = 0; j < urfaGetGraphDataIptraffic.getSizeArray1()[i]; ++j) {
                        int n2 = urfaGetGraphDataIptraffic.getTclass2()[i][j];
                        object = Resolve.getTCname(n2) + " (" + n2 + ")";
                        double d = urfaGetGraphDataIptraffic.getBytes2()[i][j];
                        treeMap2.put(object, new Double(d * 8.0 / 3600.0));
                        if (!GraphReport.this.tclass_colors.containsKey(object)) {
                            GraphReport.this.tclass_colors.put(object, new Integer(Resolve.getTCColour(n2)));
                        }
                        if (treeMap.containsKey(new Integer(n2))) {
                            ((AVG)treeMap.get((Object)new Integer((int)n2))).mbytes += d;
                            ++((AVG)treeMap.get((Object)new Integer((int)n2))).count;
                            Integer n3 = new Integer(n2);
                            if (d < ((AVG)treeMap.get((Object)n3)).min) {
                                ((AVG)treeMap.get((Object)new Integer((int)n2))).min = d;
                            }
                            Integer n4 = new Integer(n2);
                            if (!(d > ((AVG)treeMap.get((Object)n4)).max)) continue;
                            ((AVG)treeMap.get((Object)new Integer((int)n2))).max = d;
                            continue;
                        }
                        AVG aVG = new AVG();
                        aVG.mbytes = d;
                        aVG.min = d;
                        aVG.max = d;
                        aVG.count = 1;
                        treeMap.put(new Integer(n2), aVG);
                    }
                    Date date = new Date((long)n * 1000L);
                    GraphReport.this.report_data.put(date, treeMap2);
                }
                GraphReport.this.getReportTablePanel().getTableModel().removeAllRows();
                Set set = treeMap.entrySet();
                for (Map.Entry entry : set) {
                    int n = (Integer)entry.getKey();
                    AVG aVG = (AVG)entry.getValue();
                    aVG.avg = aVG.mbytes * 8.0 / (double)(3600 * aVG.count);
                    aVG.min = aVG.min * 8.0 / 3600.0;
                    aVG.max = aVG.max * 8.0 / 3600.0;
                    object = new HashMap();
                    String string = Resolve.getTCname(n);
                    object.put("id", new Integer(n).toString());
                    object.put("name", string);
                    object.put("minimum", new Double((double)Math.round(aVG.min * 1000.0) / 1000.0).toString());
                    object.put("average", new Double((double)Math.round(aVG.avg * 1000.0) / 1000.0).toString());
                    object.put("maximum", new Double((double)Math.round(aVG.max * 1000.0) / 1000.0).toString());
                    GraphReport.this.getReportTablePanel().getTableModel().addRow((Map<String, Object>)object);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void urfa_dialup() {
            try {
                UrfaGetGraphDataDialup urfaGetGraphDataDialup = new UrfaGetGraphDataDialup(UrfaManagerImpl.getInstance());
                urfaGetGraphDataDialup.setAid(GraphReport.this.aid);
                urfaGetGraphDataDialup.setUid(GraphReport.this.uid);
                urfaGetGraphDataDialup.setTStart(GraphReport.this.getStartTime());
                urfaGetGraphDataDialup.setTEnd(GraphReport.this.getEndTime());
                urfaGetGraphDataDialup.call();
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                for (int i = 0; i < urfaGetGraphDataDialup.getGdataSize(); ++i) {
                    TreeMap<String, Double> treeMap = new TreeMap<String, Double>();
                    int n = urfaGetGraphDataDialup.getDate1()[i];
                    for (int j = 0; j < urfaGetGraphDataDialup.getSizeArray1()[i]; ++j) {
                        String string = urfaGetGraphDataDialup.getName2()[i][j];
                        double d4 = urfaGetGraphDataDialup.getBytes2()[i][j];
                        if (i == 0) {
                            d = d4;
                            d2 = d4;
                        } else {
                            if (d4 > d) {
                                d = d4;
                            }
                            if (d4 < d2) {
                                d2 = d4;
                            }
                        }
                        d3 += d4 / (double)urfaGetGraphDataDialup.getGdataSize();
                        treeMap.put(string, new Double(d4));
                    }
                    Date date = new Date((long)n * 1000L);
                    GraphReport.this.report_data.put(date, treeMap);
                }
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("minimum", d2);
                hashMap.put("average", d3);
                hashMap.put("maximum", d);
                GraphReport.this.getReportTablePanel().getTableModel().addRow(hashMap);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void urfa_telephony() {
            try {
                UrfaGetGraphDataTelephony urfaGetGraphDataTelephony = new UrfaGetGraphDataTelephony(UrfaManagerImpl.getInstance());
                urfaGetGraphDataTelephony.setAid(GraphReport.this.aid);
                urfaGetGraphDataTelephony.setUid(GraphReport.this.uid);
                urfaGetGraphDataTelephony.setTStart(GraphReport.this.getStartTime());
                urfaGetGraphDataTelephony.setTEnd(GraphReport.this.getEndTime());
                urfaGetGraphDataTelephony.call();
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                for (int i = 0; i < urfaGetGraphDataTelephony.getGdataSize(); ++i) {
                    TreeMap<String, Double> treeMap = new TreeMap<String, Double>();
                    int n = urfaGetGraphDataTelephony.getDate1()[i];
                    for (int j = 0; j < urfaGetGraphDataTelephony.getSizeArray1()[i]; ++j) {
                        String string = urfaGetGraphDataTelephony.getName2()[i][j];
                        double d4 = urfaGetGraphDataTelephony.getBytes2()[i][j];
                        if (i == 0) {
                            d = d4;
                            d2 = d4;
                        } else {
                            if (d4 > d) {
                                d = d4;
                            }
                            if (d4 < d2) {
                                d2 = d4;
                            }
                        }
                        d3 += d4 / (double)urfaGetGraphDataTelephony.getGdataSize();
                        treeMap.put(string, new Double(d4));
                    }
                    Date date = new Date((long)n * 1000L);
                    GraphReport.this.report_data.put(date, treeMap);
                }
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("minimum", d2);
                hashMap.put("average", d3);
                hashMap.put("maximum", d);
                GraphReport.this.getReportTablePanel().getTableModel().addRow(hashMap);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        @Override
        public void run() {
            try {
                GraphReport.this.report_data = new TreeMap();
                GraphReport.this.time_series_numeration = new TreeMap();
                GraphReport.this.tclass_colors = new TreeMap();
                if (GraphReport.this.getType() == 0) {
                    this.urfa_traffic();
                } else if (GraphReport.this.getType() == 1) {
                    this.urfa_dialup();
                } else if (GraphReport.this.getType() == 2) {
                    this.urfa_telephony();
                }
                GraphReport.this.goReport();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

