/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.reports;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetTrafficCollectorsList;
import biz.netup.control.transport.urfa.functions.UrfaGetTrafficDetailed;
import biz.netup.control.transport.urfa.functions.UrfaRequestTrafficDetailed;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.tab.ReportTab;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DetailedTrafficReportAdmin
extends ReportTab {
    private JComboBox collectorComboBox;
    private JButton stopButton;
    private boolean stop;
    private Map<String, Integer> collectorsMap;

    @Override
    public int getMode() {
        return 3;
    }

    public DetailedTrafficReportAdmin() {
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/detailed_traffic_report_24.png")));
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/detailed_traffic_report.png")));
        this.setRefreshPermission(new int[]{8960, 20522, 20523});
    }

    public DetailedTrafficReportAdmin(int n) {
        super(n);
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/detailed_traffic_report_24.png")));
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/detailed_traffic_report.png")));
        this.setRefreshPermission(new int[]{8960, 20522, 20523});
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("date", "Date");
        linkedHashMap.put("slink_id", "Slink_ID");
        linkedHashMap.put("account_id", "Account_ID");
        linkedHashMap.put("tclass", "TClass");
        linkedHashMap.put("srcaddr", "Srcaddr");
        linkedHashMap.put("dstaddr", "Dstaddr");
        linkedHashMap.put("packets", "Packets");
        linkedHashMap.put("bytes", "Bytes");
        linkedHashMap.put("srcport", "Srcport");
        linkedHashMap.put("dstport", "Dstport");
        linkedHashMap.put("tcpflags", "TCPFlags");
        linkedHashMap.put("proto", "Proto");
        linkedHashMap.put("tos", "Tos");
        return linkedHashMap;
    }

    @Override
    public void setTableData() throws UrfaException {
        this.stop = false;
        this.stopButton.setEnabled(true);
        UrfaRequestTrafficDetailed urfaRequestTrafficDetailed = new UrfaRequestTrafficDetailed(UrfaManagerImpl.getInstance());
        urfaRequestTrafficDetailed.setCollectorId(this.collectorsMap.get(this.collectorComboBox.getSelectedItem()));
        urfaRequestTrafficDetailed.setUserId(this.uid);
        urfaRequestTrafficDetailed.setTimeStart(this.getStartTime());
        urfaRequestTrafficDetailed.setTimeEnd(this.getEndTime());
        urfaRequestTrafficDetailed.call();
        if (urfaRequestTrafficDetailed.getIsImmediate() == 0 && !Dialogs.showYesNoDialog("Another report in process. Wish you wait?")) {
            UrfaGetTrafficDetailed urfaGetTrafficDetailed = new UrfaGetTrafficDetailed(UrfaManagerImpl.getInstance(), this);
            urfaGetTrafficDetailed.setApid(this.getDiscountPeriodID());
            urfaGetTrafficDetailed.setStop(1);
            urfaGetTrafficDetailed.call();
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        while (!bl) {
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            UrfaGetTrafficDetailed urfaGetTrafficDetailed = new UrfaGetTrafficDetailed(UrfaManagerImpl.getInstance(), this);
            urfaGetTrafficDetailed.setApid(this.getDiscountPeriodID());
            urfaGetTrafficDetailed.setStop(this.stop || bl2 ? 1 : 0);
            urfaGetTrafficDetailed.call();
            bl = 0 != urfaGetTrafficDetailed.getIsFinish();
            bl2 = urfaGetTrafficDetailed.exit;
        }
        this.stopButton.setEnabled(false);
        this.stop = false;
    }

    @Override
    public String getTabName() {
        return "Detailed traffic report";
    }

    private void fillComboBox() throws UrfaException {
        UrfaGetTrafficCollectorsList urfaGetTrafficCollectorsList = new UrfaGetTrafficCollectorsList(UrfaManagerImpl.getInstance());
        urfaGetTrafficCollectorsList.call();
        this.collectorsMap = new HashMap<String, Integer>();
        this.collectorComboBox.removeAllItems();
        this.collectorComboBox.addItem("System collector (default)");
        this.collectorsMap.put("System collector (default)", 0);
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < urfaGetTrafficCollectorsList.getSize(); ++i) {
            this.collectorsMap.put(urfaGetTrafficCollectorsList.getName1()[i], urfaGetTrafficCollectorsList.getId1()[i]);
            treeSet.add(urfaGetTrafficCollectorsList.getName1()[i]);
        }
        for (String string : treeSet) {
            this.collectorComboBox.addItem(string);
        }
        this.collectorComboBox.setSelectedItem("System collector (default)");
    }

    @Override
    protected void init() {
        super.init();
        this.getApPanel().setVisible(false);
        this.getGroupAndTypePanel().removeAll();
        this.stopButton = new JButton();
        this.stopButton.setEnabled(false);
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DetailedTrafficReportAdmin.this.stop = true;
                DetailedTrafficReportAdmin.this.stopButton.setEnabled(false);
            }
        });
        this.collectorComboBox = new JComboBox();
        try {
            this.fillComboBox();
        }
        catch (UrfaException urfaException) {
            urfaException.printStackTrace();
        }
        JLabel jLabel = new JLabel();
        this.loadLabelText(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Traffic Collector"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.getGroupAndTypePanel().add((Component)jLabel, gridBagConstraints);
        JPanel jPanel = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.getGroupAndTypePanel().add((Component)jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.getGroupAndTypePanel().add((Component)this.collectorComboBox, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.getGroupAndTypePanel().add((Component)jPanel2, gridBagConstraints);
        this.loadButtonText(this.stopButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Stop"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.getGroupAndTypePanel().add((Component)this.stopButton, gridBagConstraints);
    }

    private void loadLabelText(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void loadButtonText(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

