/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.options.templates;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaCreateDocumentTemplate;
import biz.netup.control.transport.urfa.functions.UrfaEditDocumentTemplate;
import biz.netup.control.transport.urfa.functions.UrfaGetDocumentTemplate;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.dealer.user.doc.DocFunctions;
import biz.netup.utmutils.swing.dialog.DialogModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class DocumentTemplateDialog
extends DialogModel
implements ActionListener {
    private JTextField nameField;
    private JComboBox docTypeCb;
    private JTextField fileField;
    private JButton chooseButton;
    private JButton saveButton;
    private JPanel mainPanel;
    private JFileChooser fc;
    private byte[] odtData;
    private String fileName;
    private Map<Integer, String> typeList;

    public DocumentTemplateDialog() {
        this.$$$setupUI$$$();
    }

    public DocumentTemplateDialog(Map<String, Object> map) {
        super(map);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.chooseButton) {
            this.fc.setAcceptAllFileFilterUsed(false);
            this.fc.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String string = file.getName();
                    return file.canRead() && file.length() > 0L && string.length() > 4 && string.substring(string.length() - 4, string.length()).toLowerCase().compareTo(".odt") == 0;
                }

                @Override
                public String getDescription() {
                    return "*.odt";
                }
            });
            if (this.fc.showOpenDialog(this) == 0) {
                File file = this.fc.getSelectedFile();
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.log.error(fileNotFoundException);
                }
                try {
                    this.odtData = new byte[fileInputStream.available()];
                    fileInputStream.read(this.odtData);
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    this.log.error(iOException);
                    this.saveButton.setEnabled(false);
                }
                this.fileName = file.getName();
                this.fileField.setText(this.fileName + " (" + this.odtData.length + ")");
                this.saveButton.setEnabled(true);
            }
        } else if (actionEvent.getSource() == this.saveButton) {
            this.fc.setSelectedFile(new File(this.fileName));
            if (this.fc.showSaveDialog(this) == 0) {
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(this.fc.getSelectedFile());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.log.error(fileNotFoundException);
                    return;
                }
                try {
                    fileOutputStream.write(this.odtData);
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    this.log.error(iOException);
                }
            }
        }
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        this.mainPanel.setPreferredSize(new Dimension(450, 100));
        return this.mainPanel;
    }

    @Override
    public String getItemName() {
        return "Template";
    }

    @Override
    protected void loadInfo() throws UrfaException {
        this.fc = new JFileChooser();
        this.chooseButton.addActionListener(this);
        this.saveButton.addActionListener(this);
        this.typeList = DocFunctions.getDocTypeList();
        for (Map.Entry<Integer, String> entry : this.typeList.entrySet()) {
            this.docTypeCb.addItem(this.resource.getString(entry.getValue()));
        }
        if (!this.isAddMode()) {
            UrfaGetDocumentTemplate urfaGetDocumentTemplate = new UrfaGetDocumentTemplate(UrfaManagerImpl.getInstance());
            urfaGetDocumentTemplate.setTemplateId1((Integer)this.item.get("template_id"));
            urfaGetDocumentTemplate.call();
            if (urfaGetDocumentTemplate.getResult() == 0) {
                this.log.log(1, this.resource.getString("Unable to load template data"));
                return;
            }
            this.odtData = urfaGetDocumentTemplate.getOdtData();
            this.nameField.setText(urfaGetDocumentTemplate.getName());
            this.fileName = urfaGetDocumentTemplate.getPath();
            this.fileField.setText(this.fileName + " (" + this.odtData.length + ")");
            this.docTypeCb.setSelectedItem(this.resource.getString(this.typeList.get(urfaGetDocumentTemplate.getDocType())));
            this.docTypeCb.setEnabled(false);
        } else {
            this.saveButton.setEnabled(false);
        }
    }

    @Override
    protected void saveInfo() throws UrfaException {
        Object object;
        int n = 0;
        for (Map.Entry<Integer, String> entry : this.typeList.entrySet()) {
            if (this.resource.getString(entry.getValue()).compareTo((String)this.docTypeCb.getSelectedItem()) != 0) continue;
            n = entry.getKey();
            break;
        }
        if (!this.isAddMode()) {
            object = new UrfaEditDocumentTemplate(UrfaManagerImpl.getInstance());
            ((UrfaEditDocumentTemplate)object).setTemplateId((Integer)this.item.get("template_id"));
            ((UrfaEditDocumentTemplate)object).setName(this.nameField.getText());
            ((UrfaEditDocumentTemplate)object).setOdtData(this.odtData);
            ((UrfaEditDocumentTemplate)object).setDocType(n);
            ((UrfaEditDocumentTemplate)object).call();
            if (((UrfaEditDocumentTemplate)object).getResult() == 0) {
                this.log.log(1, this.resource.getString("Unable to edit document template"));
            }
        } else {
            object = new UrfaCreateDocumentTemplate(UrfaManagerImpl.getInstance());
            ((UrfaCreateDocumentTemplate)object).setName(this.nameField.getText());
            ((UrfaCreateDocumentTemplate)object).setOdtData(this.odtData);
            ((UrfaCreateDocumentTemplate)object).setDocType(n);
            ((UrfaCreateDocumentTemplate)object).call();
            if (((UrfaCreateDocumentTemplate)object).getResult() == 0) {
                this.log.log(1, this.resource.getString("Unable to create document template"));
            }
        }
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
        this.checkName(this.nameField, "Name");
        if (!this.settingListeners) {
            if (this.fileName == null || this.fileName.length() == 0 || this.odtData == null || this.odtData.length == 0) {
                this.log.log(1, this.resource.getString("Template file not chosen"));
                throw new IllegalArgumentException("Template file not chosen");
            }
            if (this.odtData.length < 32 || this.odtData[0] != 80 || this.odtData[1] != 75) {
                throw new IllegalArgumentException(this.resource.getString("Invalid template file"));
            }
        }
    }

    private void $$$setupUI$$$() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel2, gridBagConstraints);
        this.nameField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.nameField, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("File"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel2, gridBagConstraints);
        this.fileField = new JTextField();
        this.fileField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.fileField, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel3, gridBagConstraints);
        this.chooseButton = new JButton();
        this.$$$loadButtonText$$$(this.chooseButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Choose"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.chooseButton, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel4, gridBagConstraints);
        this.saveButton = new JButton();
        this.$$$loadButtonText$$$(this.saveButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Save"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.saveButton, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel8, gridBagConstraints);
        this.docTypeCb = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.docTypeCb, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel3, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel9, gridBagConstraints);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

