/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.options.templates;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaCreateDocumentProfile;
import biz.netup.control.transport.urfa.functions.UrfaEditDocumentProfile;
import biz.netup.control.transport.urfa.functions.UrfaGetDocumentProfile;
import biz.netup.control.transport.urfa.functions.UrfaGetDocumentTemplatesList;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.dealer.user.doc.DocFunctions;
import biz.netup.utmutils.swing.dialog.FrameModel;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DocumentProfileDialog
extends FrameModel {
    JPanel mainPanel;
    JTextField nameField;
    Map<Integer, String> docTypes;
    Map<Integer, JComboBox> comboList;
    Map<Integer, String> comboItems;

    DocumentProfileDialog(Map<String, Object> map) {
        super(map);
    }

    @Override
    public Component getForm() {
        this.createUI();
        return this.mainPanel;
    }

    @Override
    public String getItemName() {
        return "Profile of documents";
    }

    @Override
    protected void loadInfo() throws UrfaException {
        Object object;
        this.comboItems = new HashMap<Integer, String>();
        UrfaGetDocumentTemplatesList urfaGetDocumentTemplatesList = new UrfaGetDocumentTemplatesList(UrfaManagerImpl.getInstance());
        urfaGetDocumentTemplatesList.call();
        for (int i = 0; i < urfaGetDocumentTemplatesList.getCnt(); ++i) {
            JComboBox jComboBox = this.comboList.get(urfaGetDocumentTemplatesList.getDocTypeArray1()[i]);
            if (jComboBox == null) continue;
            object = "(" + urfaGetDocumentTemplatesList.getTemplateIdArray1()[i] + ") " + urfaGetDocumentTemplatesList.getNameArray1()[i];
            jComboBox.addItem(object);
            this.comboItems.put(urfaGetDocumentTemplatesList.getTemplateIdArray1()[i], (String)object);
        }
        if (!this.isAddMode()) {
            UrfaGetDocumentProfile urfaGetDocumentProfile = new UrfaGetDocumentProfile(UrfaManagerImpl.getInstance());
            urfaGetDocumentProfile.setProfileId((Integer)this.item.get("profile_id"));
            urfaGetDocumentProfile.call();
            if (urfaGetDocumentProfile.getResult() <= 0) {
                this.log.log(1, this.resource.getString("Unable to get profile of documents"));
                return;
            }
            this.nameField.setText(urfaGetDocumentProfile.getName());
            for (int i = 0; i < urfaGetDocumentProfile.getCount(); ++i) {
                String string;
                object = this.comboList.get(urfaGetDocumentProfile.getDocTypeArray1()[i]);
                if (object == null || (string = this.comboItems.get(urfaGetDocumentProfile.getTemplateIdArray1()[i])) == null) continue;
                ((JComboBox)object).setSelectedItem(string);
            }
        }
    }

    @Override
    protected void saveInfo() throws UrfaException {
        Object object;
        Map.Entry<Integer, JComboBox> entry22;
        HashMap hashMap = new HashMap();
        for (Map.Entry<Integer, JComboBox> entry22 : this.comboList.entrySet()) {
            JComboBox jComboBox = entry22.getValue();
            if (jComboBox.getSelectedIndex() == 0) continue;
            for (Map.Entry<Object, Object> entry3 : this.comboItems.entrySet()) {
                if (((String)entry3.getValue()).compareTo((String)jComboBox.getSelectedItem()) != 0) continue;
                hashMap.put(entry22.getKey(), entry3.getKey());
            }
        }
        Object object2 = new int[hashMap.size()];
        entry22 = (Map.Entry<Integer, JComboBox>)new int[hashMap.size()];
        int n = 0;
        for (Map.Entry<Object, Object> entry : hashMap.entrySet()) {
            object2[n] = (Integer)entry.getKey();
            entry22[n] = (Integer)entry.getValue();
            ++n;
        }
        if (!this.isAddMode()) {
            object = new UrfaEditDocumentProfile(UrfaManagerImpl.getInstance());
            ((UrfaEditDocumentProfile)object).setName(this.nameField.getText());
            ((UrfaEditDocumentProfile)object).setProfileId((Integer)this.item.get("profile_id"));
            ((UrfaEditDocumentProfile)object).setCount(((Object)object2).length);
            ((UrfaEditDocumentProfile)object).setDocTypeArray1((int[])object2);
            ((UrfaEditDocumentProfile)object).setTemplateIdArray1((int[])entry22);
            ((UrfaEditDocumentProfile)object).call();
        } else {
            object = new UrfaCreateDocumentProfile(UrfaManagerImpl.getInstance());
            ((UrfaCreateDocumentProfile)object).setName(this.nameField.getText());
            ((UrfaCreateDocumentProfile)object).setCount(((Object)object2).length);
            ((UrfaCreateDocumentProfile)object).setDocTypeArray1((int[])object2);
            ((UrfaCreateDocumentProfile)object).setTemplateIdArray1((int[])entry22);
            ((UrfaCreateDocumentProfile)object).call();
        }
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
        this.checkName(this.nameField, "Name");
    }

    private void createUI() {
        this.docTypes = DocFunctions.getDocTypeList();
        this.mainPanel = new JPanel();
        this.nameField = new JTextField();
        GridLayout gridLayout = new GridLayout();
        gridLayout.setColumns(2);
        gridLayout.setRows(this.docTypes.size());
        gridLayout.setHgap(10);
        gridLayout.setVgap(10);
        this.mainPanel.setLayout(gridLayout);
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalAlignment(4);
        jLabel.setText(this.resource.getString("Name"));
        this.mainPanel.add(jLabel);
        this.mainPanel.add(this.nameField);
        this.comboList = new HashMap<Integer, JComboBox>();
        for (Map.Entry<Integer, String> entry : this.docTypes.entrySet()) {
            if (entry.getKey() == 6) continue;
            JLabel jLabel2 = new JLabel();
            jLabel2.setText(this.resource.getString(entry.getValue()));
            jLabel2.setHorizontalAlignment(4);
            this.mainPanel.add(jLabel2);
            JComboBox<String> jComboBox = new JComboBox<String>();
            jComboBox.addItem("[" + this.resource.getString("Template not set") + "]");
            this.mainPanel.add(jComboBox);
            this.comboList.put(entry.getKey(), jComboBox);
        }
    }
}

