/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.options.registrysettings;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetRegistryForm;
import biz.netup.control.transport.urfa.functions.UrfaSetRegistrySetting;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.registrysettings.BoolContainer;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.registrysettings.ItemContainer;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.registrysettings.SizeInBytesContainer;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.registrysettings.StringContainer;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.registrysettings.TextContainer;
import biz.netup.utmutils.swing.dialog.DialogModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;

public class RegistrySettingsDialog
extends DialogModel {
    private JPanel mainPanel;
    private Map<Integer, ItemHolder> widgetMap;
    private Map<Integer, Checker> checkerMap;

    private void $$$setupUI$$$() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    @Override
    protected String getConstraint() {
        return "North";
    }

    public RegistrySettingsDialog() {
        this.$$$setupUI$$$();
    }

    public RegistrySettingsDialog(Map<String, Object> map) {
        super(map);
        this.getSurroundPanel().setBorder(BorderFactory.createEmptyBorder());
        Dimension dimension = new Dimension(350, 100);
        this.setSize(dimension);
        this.setMinimumSize(dimension);
        Dimension dimension2 = new Dimension(600, 600);
        this.setMaximumSize(dimension2);
        this.checkerMap = new HashMap<Integer, Checker>();
        this.checkerMap.put(1, new NotEmpty());
        this.checkerMap.put(2, new Natural());
        this.checkerMap.put(4, new Positive());
        this.checkerMap.put(8, new Boolean());
        this.checkerMap.put(128, new SizeInBytes());
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        return this.mainPanel;
    }

    @Override
    public String getItemName() {
        return (String)this.item.get("description");
    }

    @Override
    protected void loadInfo() throws UrfaException {
        this.widgetMap = new HashMap<Integer, ItemHolder>();
        int[] nArray = (int[])this.item.get("ids");
        int n = 0;
        for (int n2 : nArray) {
            UrfaGetRegistryForm urfaGetRegistryForm = new UrfaGetRegistryForm(UrfaManagerImpl.getInstance());
            urfaGetRegistryForm.setGroupId(n2);
            urfaGetRegistryForm.setObjectId((Integer)this.item.get("object_id"));
            urfaGetRegistryForm.call();
            for (int i = 0; i < urfaGetRegistryForm.getCount(); ++i) {
                Object object;
                Serializable serializable;
                int n3 = urfaGetRegistryForm.getSettingIdArray1()[i];
                int n4 = urfaGetRegistryForm.getAttrArray1()[i];
                ItemHolder itemHolder = new ItemHolder();
                itemHolder.attributes = n4;
                itemHolder.description = this.resource.getString(urfaGetRegistryForm.getDescriptionArray1()[i]);
                switch (urfaGetRegistryForm.getValueTypeArray1()[i]) {
                    case 1: {
                        if ((n4 & 8) != 0) {
                            itemHolder.container = new BoolContainer();
                            break;
                        }
                    }
                    case 2: 
                    case 3: {
                        if ((n4 & 0x80) != 0) {
                            itemHolder.container = new SizeInBytesContainer();
                            break;
                        }
                        itemHolder.container = new StringContainer();
                        break;
                    }
                    case 4: {
                        if ((n4 & 0x10) != 0) {
                            itemHolder.container = new TextContainer();
                            break;
                        }
                        itemHolder.container = new StringContainer();
                        break;
                    }
                    default: {
                        itemHolder.container = new StringContainer();
                    }
                }
                this.widgetMap.put(n3, itemHolder);
                String string = this.resource.getString("tooltip:" + urfaGetRegistryForm.getDescriptionArray1()[i]);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                JLabel jLabel = new JLabel();
                jLabel.setPreferredSize(new Dimension(350, 20));
                jLabel.setMaximumSize(new Dimension(650, 20));
                jLabel.setMinimumSize(new Dimension(150, 20));
                jLabel.setText(this.widgetMap.get((Object)Integer.valueOf((int)n3)).description);
                if (!string.isEmpty()) {
                    jLabel.setToolTipText(string);
                    serializable = jLabel.getFont();
                    object = serializable.getAttributes();
                    object.put((TextAttribute)TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_DOTTED);
                    jLabel.setFont(serializable.deriveFont((Map<? extends AttributedCharacterIterator.Attribute, ?>)object));
                }
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = 2 * i + n;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 2;
                this.mainPanel.add((Component)jLabel, gridBagConstraints);
                serializable = new JPanel();
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = 2 * i + n;
                gridBagConstraints.gridx = 1;
                gridBagConstraints.fill = 2;
                this.mainPanel.add((Component)serializable, gridBagConstraints);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = 2 * i + n;
                gridBagConstraints.gridx = 2;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 3;
                gridBagConstraints.ipadx = 50;
                this.widgetMap.get((Object)Integer.valueOf((int)n3)).container.init();
                this.widgetMap.get((Object)Integer.valueOf((int)n3)).container.setValue(urfaGetRegistryForm.getValueArray2()[i]);
                this.mainPanel.add(this.widgetMap.get((Object)Integer.valueOf((int)n3)).container.getForm(), gridBagConstraints);
                object = new JPanel();
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 2 * i + n + 1;
                gridBagConstraints.fill = 3;
                this.mainPanel.add((Component)object, gridBagConstraints);
            }
            n += 2 * urfaGetRegistryForm.getCount() + 2;
        }
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.setMinimumSize(dimension2);
        this.setMaximumSize(new Dimension(dimension.width, dimension2.height));
        ToolTipManager.sharedInstance().setDismissDelay(15000);
    }

    @Override
    protected void saveInfo() throws UrfaException {
        for (Map.Entry<Integer, ItemHolder> entry : this.widgetMap.entrySet()) {
            UrfaSetRegistrySetting urfaSetRegistrySetting = new UrfaSetRegistrySetting(UrfaManagerImpl.getInstance());
            urfaSetRegistrySetting.setValueSize(entry.getValue().container.getValue().length);
            if (!entry.getValue().container.isChanged()) continue;
            urfaSetRegistrySetting.setObjectId((Integer)this.item.get("object_id"));
            urfaSetRegistrySetting.setSettingId(entry.getKey());
            urfaSetRegistrySetting.setValueArray1(entry.getValue().container.getValue());
            urfaSetRegistrySetting.call();
        }
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
        if (this.settingListeners) {
            return;
        }
        Object var1_1 = null;
        for (Map.Entry<Integer, ItemHolder> entry : this.widgetMap.entrySet()) {
            for (Map.Entry<Integer, Checker> entry2 : this.checkerMap.entrySet()) {
                if ((entry.getValue().attributes & entry2.getKey()) != 0 && !entry2.getValue().check(entry.getValue().container)) {
                    this.log.log(1, this.resource.getString("Error") + " " + this.resource.getString("field is invalid") + ". " + this.resource.getString("It must be") + " " + this.resource.getString(entry2.getValue().message()));
                    entry.getValue().container.set_incorrect();
                    entry.getValue().container.getForm().requestFocus();
                    throw new IllegalArgumentException(this.resource.getString("field is invalid") + ". " + this.resource.getString("It must be") + " " + this.resource.getString(entry2.getValue().message()));
                }
                entry.getValue().container.set_correct();
            }
            if (!entry.getValue().container.isChanged() || (entry.getValue().attributes & 0x20) == 0) continue;
            entry.getValue().container.set_incorrect();
            int n = JOptionPane.showConfirmDialog(this, this.resource.getString("Changed value") + " " + entry.getValue().description + ". " + this.resource.getString("You doing it at own risk! Continue?"), this.resource.getString("Unsafe changing!"), 2);
            if (n == 0) continue;
            throw new IllegalArgumentException(this.resource.getString("Abort by user") + this.resource.getString("Changes not saved") + ".");
        }
    }

    private class SizeInBytes
    extends Checker {
        private SizeInBytes() {
        }

        @Override
        public boolean check(ItemContainer itemContainer) {
            return ((SizeInBytesContainer)itemContainer).check();
        }

        @Override
        public String message() {
            return "correct size. Example '1G 20M 30K 40B' '1024'";
        }
    }

    private class Boolean
    extends Checker {
        private Boolean() {
        }

        @Override
        public boolean check(ItemContainer itemContainer) {
            try {
                int n = Integer.parseInt(itemContainer.getValue()[0]);
                return n == 0 || n == 1;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }

        @Override
        public String message() {
            return "boolean, 0 or 1.";
        }
    }

    private class Positive
    extends Checker {
        private Positive() {
        }

        @Override
        public boolean check(ItemContainer itemContainer) {
            try {
                double d = Double.parseDouble(itemContainer.getValue()[0]);
                return d > 0.0;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }

        @Override
        public String message() {
            return "positive.";
        }
    }

    private class Natural
    extends Checker {
        private Natural() {
        }

        @Override
        public boolean check(ItemContainer itemContainer) {
            try {
                int n = Integer.parseInt(itemContainer.getValue()[0]);
                return n >= 0;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }

        @Override
        public String message() {
            return "natural, i.e. 0, 1, 2, etc.";
        }
    }

    private class NotEmpty
    extends Checker {
        private NotEmpty() {
        }

        @Override
        public boolean check(ItemContainer itemContainer) {
            return !itemContainer.getValue()[0].isEmpty();
        }

        @Override
        public String message() {
            return "not empty.";
        }
    }

    private abstract class Checker {
        private Checker() {
        }

        public abstract boolean check(ItemContainer var1);

        public abstract String message();
    }

    private static class Attributes {
        public static final int ATTR_NOT_EMPTY = 1;
        public static final int ATTR_NATURAL = 2;
        public static final int ATTR_POSITIVE = 4;
        public static final int ATTR_BOOLEAN = 8;
        public static final int ATTR_LONG_TEXT = 16;
        public static final int ATTR_UNSAFE = 32;
        public static final int ATTR_SIZE_IN_BYTES = 128;

        private Attributes() {
        }
    }

    private static class RegistryTypes {
        public static final int INT = 1;
        public static final int LONG = 2;
        public static final int DOUBLE = 3;
        public static final int STRING = 4;
        public static final int STRING_ARRAY = 10;

        private RegistryTypes() {
        }
    }

    private class ItemHolder {
        public ItemContainer container;
        public int attributes;
        public String description;

        private ItemHolder() {
        }
    }
}

