/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.options.provider;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetCurrencyList;
import biz.netup.control.transport.urfa.functions.UrfaTelSupplierPaymentsReport;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.utmutils.swing.tab.ReportTab;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public class SupplierPaymentsReport
extends ReportTab {
    private Map<Integer, String> currencies;
    private int supplierId;

    @Override
    public String getTabName() {
        return "Supplier payments report";
    }

    @Override
    public int getMode() {
        return 2;
    }

    public SupplierPaymentsReport(int n) throws IllegalStateException {
        super(0);
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/general_report_24.png")));
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/general_report.png")));
        this.supplierId = n;
        UrfaGetCurrencyList urfaGetCurrencyList = new UrfaGetCurrencyList(UrfaManagerImpl.getInstance());
        try {
            urfaGetCurrencyList.call();
        }
        catch (UrfaException urfaException) {
            throw new IllegalStateException("cannot get currencies list");
        }
        this.currencies = new HashMap<Integer, String>();
        for (int i = 0; i < urfaGetCurrencyList.getCurrencySize(); ++i) {
            this.currencies.put(urfaGetCurrencyList.getId1()[i], urfaGetCurrencyList.getCurrencyBriefName1()[i]);
        }
    }

    @Override
    protected void init() {
        super.init();
        this.getApPanel().setVisible(false);
        this.getGroupAndTypePanel().setVisible(false);
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("payment summ", "Payment summ");
        linkedHashMap.put("currency type", "Currency type");
        linkedHashMap.put("payment date", "Payment date");
        linkedHashMap.put("payment comment", "Payment comment");
        return linkedHashMap;
    }

    @Override
    public void setTableData() throws UrfaException {
        UrfaTelSupplierPaymentsReport urfaTelSupplierPaymentsReport = new UrfaTelSupplierPaymentsReport(UrfaManagerImpl.getInstance(), this);
        urfaTelSupplierPaymentsReport.setCurrencyMap(this.currencies);
        urfaTelSupplierPaymentsReport.setSupplierId(this.supplierId);
        urfaTelSupplierPaymentsReport.setStartDate(this.getStartTime());
        urfaTelSupplierPaymentsReport.setEndDate(this.getEndTime());
        urfaTelSupplierPaymentsReport.call();
    }

    @Override
    public void addSummaryRows() {
    }
}

