/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.options.provider;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.SupTelServiceAddEditIter;
import biz.netup.control.transport.urfa.functions.TelServiceAddEditIter;
import biz.netup.control.transport.urfa.functions.UrfaAddTelSupplierService;
import biz.netup.control.transport.urfa.functions.UrfaEditTelSupplierService;
import biz.netup.control.transport.urfa.functions.UrfaGetSupplier;
import biz.netup.control.transport.urfa.functions.UrfaGetTelDirection;
import biz.netup.control.transport.urfa.functions.UrfaGetTelSupplierService;
import biz.netup.control.transport.urfa.functions.UrfaGetTelSuppliersDirections;
import biz.netup.control.transport.urfa.functions.UrfaGetTelSuppliersZones;
import biz.netup.control.transport.urfa.functions.UrfaGetTelZone;
import biz.netup.control.transport.urfa.functions.UrfaValidateTelSupplierDirs;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.provider.SupplierBalanceTab;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.provider.SupplierChargesReport;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.provider.SupplierDetailsTab;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.provider.SupplierInvoicesReport;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.provider.SupplierPaymentsReport;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.provider.SupplierTelTab;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.provider.SupplierUsersReport;
import biz.netup.projects.utmadmin.gui.serviceframe.forms.FullTelServiceTab;
import biz.netup.projects.utmadmin.gui.serviceframe.forms.ServiceMainTab;
import biz.netup.projects.utmadmin.gui.serviceframe.forms.ServiceTelFixedCostTab;
import biz.netup.projects.utmadmin.gui.serviceframe.forms.ServiceTelTBTab;
import biz.netup.projects.utmadmin.gui.serviceframe.forms.TelServiceComponentInt;
import biz.netup.projects.utmadmin.gui.userframe.BottomButtons;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.tab.TabPanel;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import biz.netup.utmutils.swing.tabbedwindow.TabbedWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

public class SupplierFrame
extends TabbedWindow {
    private SupplierDetailsTab details;
    private SupplierBalanceTab balance;
    private BottomButtons buttonsPanel;
    private TabPanelWithTable owner;
    private Map<Component, String> editMap;
    private SupplierCommonServiceTab commonServiceData;
    private SupplierTelServiceTab TSData;
    private SupplierFullTelData TSOtherData;
    private SupplierPaymentsReport paymentsRep;
    private SupplierChargesReport chargesReport;
    private SupplierUsersReport usersReport;
    private SupplierInvoicesReport invoicesReport;
    private int telServiceId;
    private final int SystemSupplierId = 1;
    private SupplierType type;

    @Override
    public String getWindowTitle() {
        return this.type == SupplierType.TelOperator ? this.resource.getString("Telephone Operator") : this.resource.getString("Jur Face");
    }

    SupplierFrame(int n, TabPanelWithTable tabPanelWithTable, SupplierType supplierType) {
        super(n);
        this.owner = tabPanelWithTable;
        this.type = supplierType;
        if (this.id != 1 && this.type != SupplierType.LegalEntity) {
            this.loadData();
        }
        this.setTabPanels(this.getTabPanels());
        this.setTitle(this.getWindowTitle());
        if (this.type == SupplierType.LegalEntity) {
            this.details.taxRateTextField.setVisible(false);
            this.details.taxRateLabel.setVisible(false);
        }
    }

    protected void SetButtonsReactionToElements(Vector<Component> vector) {
        for (int i = 0; i < vector.size(); ++i) {
            final Component component = vector.get(i);
            if (!(component instanceof JTextComponent)) continue;
            ((JTextComponent)component).addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent caretEvent) {
                    if (!SupplierFrame.this.editMap.containsKey(component)) {
                        SupplierFrame.this.editMap.put(component, ((JTextComponent)component).getText());
                    }
                    if (((String)SupplierFrame.this.editMap.get(component)).equals(((JTextComponent)component).getText())) {
                        return;
                    }
                    SupplierFrame.this.setButtonsState(true, true, SupplierFrame.this.resource.getString("Cancel"));
                    SupplierFrame.this.editMap.put(component, ((JTextComponent)component).getText());
                }
            });
        }
    }

    private void RefreshEditMap(Vector<Component> vector) {
        this.editMap.clear();
        for (int i = 0; i < vector.size(); ++i) {
            Component component = vector.get(i);
            if (!(component instanceof JTextComponent)) continue;
            this.editMap.put(component, ((JTextComponent)component).getText());
        }
    }

    private void buttonsStart() {
        this.buttonsPanel.getButtonOK().setEnabled(false);
        this.buttonsPanel.getApplyButton().setEnabled(false);
        this.buttonsPanel.getButtonCancel().setText(this.resource.getString("Close"));
    }

    public void setButtonsState(boolean bl, boolean bl2, String string) {
        this.buttonsPanel.getButtonOK().setEnabled(bl);
        this.buttonsPanel.getApplyButton().setEnabled(bl2);
        this.buttonsPanel.getButtonCancel().setText(string);
    }

    @Override
    protected Dimension getWindowSize() {
        return new Dimension(1080, 650);
    }

    @Override
    protected void init() {
        try {
            this.paymentsRep = new SupplierPaymentsReport(this.id);
        }
        catch (IllegalStateException illegalStateException) {
            Dialogs.showErrorDialog(illegalStateException.getMessage());
            return;
        }
        this.chargesReport = new SupplierChargesReport(this.id);
        this.usersReport = new SupplierUsersReport(this.id);
        this.invoicesReport = new SupplierInvoicesReport(this.id);
        this.balance = new SupplierBalanceTab(this.id);
        this.details = new SupplierDetailsTab(this.id, this.balance);
        this.buttonsPanel = new BottomButtons();
        this.buttonsPanel.getButtonOK().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SupplierFrame.this.SaveData()) {
                    SupplierFrame.this.dispose();
                }
            }
        });
        this.buttonsPanel.getButtonCancel().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SupplierFrame.this.dispose();
            }
        });
        this.buttonsPanel.getApplyButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SupplierFrame.this.SaveData();
            }
        });
        this.buttonsPanel.getRefreshButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!Dialogs.showYesNoDialog("All changes will be lost. Are you sure?")) {
                    return;
                }
                SupplierFrame.this.details.refresh();
                SupplierFrame.this.setButtonsState(false, false, SupplierFrame.this.resource.getString("Close"));
            }
        });
        this.mainPanel.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SupplierFrame.this.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.details.setButtonReactionToElements(this);
        this.setButtonsState(false, false, this.resource.getString("Close"));
        this.editMap = new HashMap<Component, String>();
    }

    private void loadData() {
        this.commonServiceData = new SupplierCommonServiceTab(this, this.id);
        this.TSData = new SupplierTelServiceTab(this);
        try {
            this.TSOtherData = new SupplierFullTelData(this);
        }
        catch (UrfaException urfaException) {
            Dialogs.showErrorDialog("can't get other suppliers zones");
            return;
        }
        if (this.type != SupplierType.LegalEntity) {
            UrfaGetTelSupplierService urfaGetTelSupplierService = new UrfaGetTelSupplierService(UrfaManagerImpl.getInstance());
            urfaGetTelSupplierService.setSupplierId(this.id);
            try {
                urfaGetTelSupplierService.call();
            }
            catch (UrfaException urfaException) {
                Dialogs.showErrorDialog(urfaException.getMessage());
                return;
            }
            this.telServiceId = urfaGetTelSupplierService.getSupplierId();
            if (this.telServiceId != -1) {
                this.commonServiceData.Load(urfaGetTelSupplierService);
                this.TSData.Load(urfaGetTelSupplierService);
                try {
                    this.TSOtherData.Load(urfaGetTelSupplierService);
                }
                catch (UrfaException urfaException) {
                    Dialogs.showErrorDialog(urfaException.getMessage());
                    return;
                }
            }
        }
    }

    private boolean SaveData() {
        SupTelServiceAddEditIter supTelServiceAddEditIter = null;
        if (this.id != 1 && this.type != SupplierType.LegalEntity) {
            if (this.telServiceId == -1) {
                if (!this.TSOtherData.isPricesTableFill()) {
                    Dialogs.showErrorDialog(this.resource.getString(this.resource.getString("Price editor") + " " + this.resource.getString("table is empty")));
                    return true;
                }
                supTelServiceAddEditIter = new UrfaAddTelSupplierService(UrfaManagerImpl.getInstance());
            } else {
                supTelServiceAddEditIter = new UrfaEditTelSupplierService(UrfaManagerImpl.getInstance());
            }
            this.commonServiceData.Save(supTelServiceAddEditIter);
            try {
                this.TSOtherData.Save(supTelServiceAddEditIter);
            }
            catch (IllegalStateException illegalStateException) {
                this.setTab(this.TSOtherData.GetPricesTab(), this.TSOtherData.GetPricesTab().getSideMenuItem());
                Dialogs.showErrorDialog(this.resource.getString(illegalStateException.getMessage()));
                return false;
            }
            this.TSData.Save(supTelServiceAddEditIter);
        }
        this.details.SetSupplierType(this.type);
        try {
            this.details.save();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Dialogs.showErrorDialog(this.resource.getString(illegalArgumentException.getMessage()));
            return false;
        }
        this.owner.refresh();
        if (this.id != 1 && this.type != SupplierType.LegalEntity) {
            supTelServiceAddEditIter.setSupplierId(this.details.getSupplierId());
            try {
                supTelServiceAddEditIter.call();
            }
            catch (UrfaException urfaException) {
                Dialogs.showErrorDialog(this.resource.getString(urfaException.getMessage()));
                return false;
            }
            int n = -1;
            n = this.telServiceId == -1 ? ((UrfaAddTelSupplierService)supTelServiceAddEditIter).getServiceId() : supTelServiceAddEditIter.getSupplierId();
            if (n == -1) {
                Dialogs.showErrorDialog(this.resource.getString("can't save tel data"));
            }
            this.id = this.details.getSupplierId();
            if (n != -1) {
                this.buttonsStart();
            }
            return n != -1;
        }
        return true;
    }

    @Override
    protected Vector<TabPanel> getTabPanels() {
        Vector<TabPanel> vector = new Vector<TabPanel>();
        vector.add(this.details);
        if (this.type == SupplierType.TelOperator) {
            vector.add(this.balance);
            vector.add(this.TSData);
            this.TSOtherData.AddToPanels(vector);
            if (this.id != -1) {
                vector.add(this.paymentsRep);
                vector.add(this.chargesReport);
                vector.add(this.usersReport);
                vector.add(this.invoicesReport);
            }
        }
        return vector;
    }

    @Override
    protected Component getBottomPanel() {
        return this.buttonsPanel.getPanel();
    }

    public static enum SupplierType {
        TelOperator(1),
        LegalEntity(0);

        private final int value;

        private SupplierType(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }

    private class SupplierTelServiceTab
    extends SupplierTelTab {
        Vector<Component> components = new Vector();

        @Override
        public String getTabName() {
            return "Telephony main parameters";
        }

        @Override
        public int getTabType() {
            return 1;
        }

        @Override
        public String getGroupName() {
            return "Service";
        }

        SupplierTelServiceTab(final SupplierFrame supplierFrame2) {
            this.components.add(this.freeTimeTextField);
            this.components.add(this.startingPeriodLenthTextField);
            this.components.add(this.startingPeriodStepTextField);
            this.components.add(this.nextPeriodStepTextField);
            this.components.add(this.tunitSizeTextField);
            this.cbDiscountFreeTime.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    supplierFrame2.setButtonsState(true, true, SupplierTelServiceTab.this.resource.getString("Cancel"));
                }
            });
            this.cbDiscountFreeTime.setVisible(false);
            this.lblDiscountFreeTime.setVisible(false);
            supplierFrame2.SetButtonsReactionToElements(this.components);
        }

        public void Load(UrfaGetTelSupplierService urfaGetTelSupplierService) {
            this.setFreeTimeSpinner(urfaGetTelSupplierService.getFreeTime());
            this.setNextPeriodStepSpinner(urfaGetTelSupplierService.getSecondPeriodStep());
            this.setStartingPeriodLenghtSpinner(urfaGetTelSupplierService.getFirstPeriodLength());
            this.setStartingPeriodStepSpinner(urfaGetTelSupplierService.getFirstPeriodStep());
            this.setTunitSizeSpinner(urfaGetTelSupplierService.getTimeUnitSize());
            this.setDiscountFreeTime(urfaGetTelSupplierService.getDiscountFreeTime() == 1);
        }

        public void Save(TelServiceAddEditIter telServiceAddEditIter) {
            if (this.getFreeTimeSpinner() < 0L || this.getNextPeriodStepSpinner() < 0L || this.getStartingPeriodLenghtSpinner() < 0L || this.getStartingPeriodStepSpinner() < 0L || this.getTunitSizeSpinner() < 0L) {
                Dialogs.showErrorDialog("Illegal number format");
                return;
            }
            telServiceAddEditIter.setFreeTime((int)this.getFreeTimeSpinner());
            telServiceAddEditIter.setFirstPeriodLength((int)this.getStartingPeriodLenghtSpinner());
            telServiceAddEditIter.setFirstPeriodStep((int)this.getStartingPeriodStepSpinner());
            telServiceAddEditIter.setSecondPeriodStep((int)this.getNextPeriodStepSpinner());
            telServiceAddEditIter.setTimeUnitSize((int)this.getTunitSizeSpinner());
            telServiceAddEditIter.setDiscountFreeTime(this.getDiscountFreeTime() ? 1 : 0);
        }
    }

    private class SupplierCommonServiceTab
    extends ServiceMainTab {
        private int supplierId;

        SupplierCommonServiceTab(SupplierFrame supplierFrame2, int n) {
            super(null);
            this.supplierId = n;
            Vector<Component> vector = new Vector<Component>();
            vector.add(this.commentTextField);
            vector.add(this.nameTextField);
            supplierFrame2.SetButtonsReactionToElements(vector);
            String string = this.resource.getString("Suppliers calculations");
            this.typeComboBox.addItem(string);
            this.typeComboBox.setSelectedItem(string);
            this.setEdit();
        }

        @Override
        public String getTabName() {
            return "Main service";
        }

        @Override
        public int getTabType() {
            return 1;
        }

        @Override
        public String getGroupName() {
            return "Service";
        }

        public void Load(UrfaGetTelSupplierService urfaGetTelSupplierService) {
            this.setCommentTextField(urfaGetTelSupplierService.getComment());
            this.setNameTextField(urfaGetTelSupplierService.getServiceName());
        }

        public void Save(TelServiceAddEditIter telServiceAddEditIter) {
            telServiceAddEditIter.setComment("Supplier" + this.supplierId + "TelServiceComment");
            telServiceAddEditIter.setServiceName("Supplier" + this.supplierId + "TelServiceName");
        }
    }

    private class SupplierFullTelData
    extends FullTelServiceTab {
        private SupplierFrame owner;
        private ServiceTelTBTab tariffBorders;
        private ServiceTelFixedCostTab fixedCosts;

        private void processPanels(JPanel jPanel) {
            Component[] componentArray = jPanel.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Component component = componentArray[i];
                if (component instanceof JPanel) {
                    this.processPanels((JPanel)component);
                    continue;
                }
                if (!(component instanceof JButton)) continue;
                JButton jButton = (JButton)component;
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SupplierFullTelData.this.owner.setButtonsState(true, true, SupplierFrame.this.resource.getString("Cancel"));
                    }
                });
            }
        }

        public SupplierFullTelData(final SupplierFrame supplierFrame2) throws UrfaException {
            Map.Entry<Integer, Integer> entry2;
            super(true, true);
            this.owner = supplierFrame2;
            this.tariffBorders = new ServiceTelTBTab(true, true);
            this.fixedCosts = new ServiceTelFixedCostTab(true, true);
            this.fixedCosts.Init(this.prices);
            this.tariffBorders.Init(this.prices);
            Vector<TablePanelImpl> vector = new Vector<TablePanelImpl>();
            vector.add(this.prices.getPricesTablePanel());
            vector.add(this.tariffBorders.getTelTBTablePanel());
            vector.add(this.fixedCosts.getFixedCostPanel());
            for (int i = 0; i < vector.size(); ++i) {
                ((TablePanelImpl)vector.get(i)).addCellEditListeners(new TablePanelImpl.CellEditingListener(){

                    @Override
                    public void BeginCellEditing(int n, int n2, TableCellEditor tableCellEditor) {
                        supplierFrame2.setButtonsState(true, true, SupplierFrame.this.resource.getString("Cancel"));
                    }

                    @Override
                    public void EndCellEditing(int n, int n2, Object object) {
                    }
                });
            }
            this.processPanels((JPanel)this.tariffBorders.getMainPanel());
            this.processPanels((JPanel)this.fixedCosts.getMainPanel());
            this.processPanels((JPanel)this.prices.getMainPanel());
            Vector<TelServiceComponentInt> vector2 = new Vector<TelServiceComponentInt>();
            vector2.add(this.tariffBorders);
            vector2.add(this.fixedCosts);
            this.SetComponents(vector2);
            HashSet<Integer> hashSet = new HashSet<Integer>();
            UrfaGetTelSuppliersZones urfaGetTelSuppliersZones = new UrfaGetTelSuppliersZones(UrfaManagerImpl.getInstance());
            urfaGetTelSuppliersZones.call();
            Map<Integer, Integer> map = urfaGetTelSuppliersZones.getSuppliersZones();
            for (Map.Entry<Integer, Integer> entry2 : map.entrySet()) {
                if (entry2.getValue() == supplierFrame2.id) continue;
                hashSet.add((Integer)entry2.getKey());
            }
            UrfaGetTelSuppliersDirections urfaGetTelSuppliersDirections = new UrfaGetTelSuppliersDirections(UrfaManagerImpl.getInstance());
            urfaGetTelSuppliersDirections.call();
            entry2 = urfaGetTelSuppliersDirections.getSuppliersDirs();
            for (Map.Entry entry3 : entry2.entrySet()) {
                if ((Integer)entry3.getValue() == supplierFrame2.id) continue;
                hashSet.add((Integer)entry3.getKey());
            }
            this.prices.setExternalZdMap(hashSet);
        }

        @Override
        public void Save(TelServiceAddEditIter telServiceAddEditIter) throws IllegalStateException {
            UrfaGetTelSuppliersZones urfaGetTelSuppliersZones = new UrfaGetTelSuppliersZones(UrfaManagerImpl.getInstance());
            try {
                urfaGetTelSuppliersZones.call();
            }
            catch (UrfaException urfaException) {
                throw new IllegalStateException("can't get other suppliers zones");
            }
            Map<Integer, Integer> map = urfaGetTelSuppliersZones.getSuppliersZones();
            Set<Integer> set = this.prices.getZdMap();
            for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
                if (!set.contains(entry.getKey()) || entry.getValue() == SupplierFrame.this.id) continue;
                throw new IllegalStateException("zone " + entry.getKey() + " is used by another supplier (" + entry.getValue() + ")");
            }
            try {
                super.Save(telServiceAddEditIter);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException(SupplierFrame.this.resource.getString("Price editor") + " " + SupplierFrame.this.resource.getString("table is empty"));
            }
            Object object2 = new int[set.size()];
            int n = 0;
            for (Integer object3 : set) {
                object2[n++] = object3;
            }
            UrfaValidateTelSupplierDirs urfaValidateTelSupplierDirs = new UrfaValidateTelSupplierDirs(UrfaManagerImpl.getInstance());
            urfaValidateTelSupplierDirs.setSupplierId(this.owner.id);
            urfaValidateTelSupplierDirs.setDir1((int[])object2);
            urfaValidateTelSupplierDirs.setDirsCnt(n);
            try {
                urfaValidateTelSupplierDirs.call();
            }
            catch (UrfaException urfaException) {
                throw new IllegalStateException("Directions validation error");
            }
            if (urfaValidateTelSupplierDirs.getResult() == 0) {
                String string;
                String string2;
                String string3;
                Object urfaException;
                int n2 = urfaValidateTelSupplierDirs.getFoundedDirId();
                int n3 = urfaValidateTelSupplierDirs.getFoundedZoneId();
                int n4 = urfaValidateTelSupplierDirs.getFoundedSupplierId();
                try {
                    urfaException = new UrfaGetSupplier(UrfaManagerImpl.getInstance());
                    ((UrfaGetSupplier)urfaException).setId(n4);
                    ((UrfaGetSupplier)urfaException).call();
                    string3 = ((UrfaGetSupplier)urfaException).getName();
                    UrfaGetTelDirection urfaGetTelDirection = new UrfaGetTelDirection(UrfaManagerImpl.getInstance());
                    urfaGetTelDirection.setDirId(n2);
                    urfaGetTelDirection.call();
                    string2 = urfaGetTelDirection.getName();
                    UrfaGetTelZone urfaGetTelZone = new UrfaGetTelZone(UrfaManagerImpl.getInstance());
                    urfaGetTelZone.setZoneId(n3);
                    urfaGetTelZone.call();
                    string = urfaGetTelZone.getName();
                }
                catch (UrfaException urfaException2) {
                    throw new IllegalStateException("Directions validation error");
                }
                urfaException = SupplierFrame.this.resource.getString("Direction %dir_name% is included in zone %zone_name% of supplier %supplier_name%");
                urfaException = ((String)urfaException).replace("%dir_name%", "" + string2);
                urfaException = ((String)urfaException).replace("%zone_name%", "" + string);
                urfaException = ((String)urfaException).replace("%supplier_name%", string3);
                throw new IllegalStateException((String)urfaException);
            }
            int[] nArray = new int[this.prices.getPricesTablePanel().getTable().getRowCount()];
            telServiceAddEditIter.setPrepaidArray1(nArray);
        }

        public boolean isPricesTableFill() {
            return this.prices.getRowCount() != 0;
        }
    }
}

