/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.options.provider;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.TelSupplierAddEditIter;
import biz.netup.control.transport.urfa.functions.UrfaAddSupplier;
import biz.netup.control.transport.urfa.functions.UrfaEditSupplier;
import biz.netup.control.transport.urfa.functions.UrfaGetBanks;
import biz.netup.control.transport.urfa.functions.UrfaGetSupplier;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.custom.bank.SelectBankDialog;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.provider.SupplierBalanceTab;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.provider.SupplierFrame;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.tab.TabPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class SupplierDetailsTab
extends TabPanel {
    private JPanel panel;
    private JTextField nameTextField;
    private JTextField shortNameTextField;
    private JTextField legalAddressTextField;
    private JTextField regCodeTextField;
    private JTextField ITINTextField;
    private JTextField actualAddressTextField;
    private JTextField CEOTextField;
    private JTextField shortNameTextField3;
    private JTextField shortNameTextField1;
    private JTextField accountantTextField;
    private JTextField accountTextField;
    private JButton selectBankButton;
    private JTextField nameTextField2;
    private JTextField cityTextField;
    private JTextField corrTextField;
    private JTextField BINTextField;
    public JTextField taxRateTextField;
    public JLabel taxRateLabel;
    private JTextField contractNumberTextField;
    private JTextField contractPlaceTextField;
    private JTextField clientPrefixTextField;
    private JTextField servicePlaceTextField;
    private JTextField numberFormatTextField;
    private int bankId;
    private int id;
    private SupplierFrame.SupplierType type;
    private SupplierBalanceTab balance;

    SupplierDetailsTab(int n, SupplierBalanceTab supplierBalanceTab) {
        this.$$$setupUI$$$();
        this.id = n;
        this.balance = supplierBalanceTab;
    }

    public void SetSupplierType(SupplierFrame.SupplierType supplierType) {
        this.type = supplierType;
    }

    @Override
    protected void init() {
        super.init();
        this.selectBankButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SupplierDetailsTab.this.selectBank();
            }
        });
    }

    public void save() throws IllegalArgumentException {
        TelSupplierAddEditIter telSupplierAddEditIter;
        double d = 0.0;
        if (this.taxRateTextField.getText().equals("")) {
            this.taxRateTextField.setText("0");
        } else {
            try {
                d = Double.parseDouble(this.taxRateTextField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("invalid tax rate value. must be numeric");
            }
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("invalid tax rate value. must be positive");
        }
        if ("".equals(this.nameTextField.getText())) {
            throw new IllegalArgumentException("name of supplier must be not empty");
        }
        if (this.id != -1) {
            UrfaEditSupplier urfaEditSupplier = new UrfaEditSupplier(UrfaManagerImpl.getInstance());
            urfaEditSupplier.setId(this.id);
            telSupplierAddEditIter = urfaEditSupplier;
        } else {
            telSupplierAddEditIter = new UrfaAddSupplier(UrfaManagerImpl.getInstance());
        }
        telSupplierAddEditIter.setAccount(this.accountTextField.getText());
        telSupplierAddEditIter.setActAdress(this.actualAddressTextField.getText());
        telSupplierAddEditIter.setBankId(this.bankId);
        telSupplierAddEditIter.setBookeeper(this.accountantTextField.getText());
        telSupplierAddEditIter.setShortBookeeper(this.shortNameTextField1.getText());
        telSupplierAddEditIter.setHeadman(this.CEOTextField.getText());
        telSupplierAddEditIter.setShortHeadman(this.shortNameTextField3.getText());
        telSupplierAddEditIter.setInn(this.ITINTextField.getText());
        telSupplierAddEditIter.setKpp(this.regCodeTextField.getText());
        telSupplierAddEditIter.setName(this.nameTextField.getText());
        telSupplierAddEditIter.setShortName(this.shortNameTextField.getText());
        telSupplierAddEditIter.setJurAdress(this.legalAddressTextField.getText());
        telSupplierAddEditIter.setContractNumber(this.contractNumberTextField.getText());
        telSupplierAddEditIter.setClientPrefix(this.clientPrefixTextField.getText());
        telSupplierAddEditIter.setContractPlace(this.contractPlaceTextField.getText());
        telSupplierAddEditIter.setServicePlace(this.servicePlaceTextField.getText());
        telSupplierAddEditIter.setNumberFormat(this.numberFormatTextField.getText());
        if (this.type == SupplierFrame.SupplierType.TelOperator) {
            telSupplierAddEditIter.setTaxRate(d / 100.0);
        }
        telSupplierAddEditIter.setType(this.type == SupplierFrame.SupplierType.TelOperator ? 1 : 0);
        try {
            telSupplierAddEditIter.call();
        }
        catch (UrfaException urfaException) {
            Dialogs.showErrorDialog("Cannot save data");
            this.log.error(this.resource.getString(this.getTabName()) + ": " + this.resource.getString("Cannot save data"), urfaException);
        }
        this.id = telSupplierAddEditIter.getId();
        if (this.id == -1) {
            Dialogs.showErrorDialog("Cannot save data");
        }
    }

    private void selectBank() {
        SelectBankDialog selectBankDialog = new SelectBankDialog(null);
        selectBankDialog.load();
        if (selectBankDialog.isOkPressed()) {
            this.bankId = (Integer)selectBankDialog.getItem().get("id");
            this.nameTextField2.setText((String)selectBankDialog.getItem().get("name"));
            this.BINTextField.setText((String)selectBankDialog.getItem().get("bin"));
            this.corrTextField.setText((String)selectBankDialog.getItem().get("correspondent_account"));
            this.cityTextField.setText((String)selectBankDialog.getItem().get("city"));
        }
    }

    @Override
    protected void refreshTab() throws UrfaException {
        if (this.id == -1) {
            return;
        }
        UrfaGetSupplier urfaGetSupplier = new UrfaGetSupplier(UrfaManagerImpl.getInstance());
        try {
            urfaGetSupplier.setId(this.id);
            urfaGetSupplier.call();
            if (urfaGetSupplier.getId() == -1) {
                throw new UrfaException("error in UrfaGetSupplier()");
            }
            this.type = urfaGetSupplier.getType() == 1 ? SupplierFrame.SupplierType.TelOperator : SupplierFrame.SupplierType.LegalEntity;
            this.bankId = urfaGetSupplier.getBankId();
            this.accountTextField.setText(urfaGetSupplier.getAccount());
            this.actualAddressTextField.setText(urfaGetSupplier.getActAdress());
            this.accountantTextField.setText(urfaGetSupplier.getBookeeper());
            this.shortNameTextField1.setText(urfaGetSupplier.getShortBookeeper());
            this.CEOTextField.setText(urfaGetSupplier.getHeadman());
            this.shortNameTextField3.setText(urfaGetSupplier.getShortHeadman());
            this.ITINTextField.setText(urfaGetSupplier.getInn());
            this.regCodeTextField.setText(urfaGetSupplier.getKpp());
            this.nameTextField.setText(urfaGetSupplier.getName());
            this.shortNameTextField.setText(urfaGetSupplier.getShortName());
            this.legalAddressTextField.setText(urfaGetSupplier.getJurAdress());
            this.contractNumberTextField.setText(urfaGetSupplier.getContractNumber());
            this.clientPrefixTextField.setText(urfaGetSupplier.getClientPrefix());
            this.contractPlaceTextField.setText(urfaGetSupplier.getContractPlace());
            this.servicePlaceTextField.setText(urfaGetSupplier.getServicePlace());
            this.numberFormatTextField.setText(urfaGetSupplier.getNumberFormat());
            if (this.type == SupplierFrame.SupplierType.TelOperator) {
                this.taxRateTextField.setText("" + urfaGetSupplier.getTaxRate() * 100.0);
            }
            this.balance.setBalance(urfaGetSupplier.getBalance());
            this.balance.setName(urfaGetSupplier.getName());
            if (this.bankId != 0) {
                UrfaGetBanks urfaGetBanks = new UrfaGetBanks(UrfaManagerImpl.getInstance());
                urfaGetBanks.call();
                for (int i = 0; i < urfaGetBanks.getBanksSize(); ++i) {
                    if (urfaGetBanks.getId1()[i] != this.bankId) continue;
                    this.nameTextField2.setText(urfaGetBanks.getName1()[i]);
                    this.BINTextField.setText(urfaGetBanks.getBic1()[i]);
                    this.corrTextField.setText(urfaGetBanks.getKschet1()[i]);
                    this.cityTextField.setText(urfaGetBanks.getCity1()[i]);
                }
            }
        }
        catch (UrfaException urfaException) {
            this.log.error(this.resource.getString(this.getTabName()) + ": " + this.resource.getString("Cannot get data"), urfaException);
        }
    }

    public int getSupplierId() {
        return this.id;
    }

    @Override
    public int getTabType() {
        return 1;
    }

    @Override
    public String getTabName() {
        return "Supplier Details";
    }

    @Override
    public String getGroupName() {
        return "Details";
    }

    @Override
    protected Component getMainPanel() {
        return this.panel;
    }

    private void processPanel(final SupplierFrame supplierFrame, JPanel jPanel) {
        Component[] componentArray = jPanel.getComponents();
        Vector<Component> vector = new Vector<Component>();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (component instanceof JPanel) {
                this.processPanel(supplierFrame, (JPanel)component);
                continue;
            }
            if (component instanceof JButton) {
                JButton jButton = (JButton)component;
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        supplierFrame.setButtonsState(true, true, SupplierDetailsTab.this.resource.getString("Cancel"));
                    }
                });
                continue;
            }
            if (!(component instanceof JTextComponent)) continue;
            vector.add(component);
        }
        supplierFrame.SetButtonsReactionToElements(vector);
    }

    public Vector<Component> getAllEditComponents() {
        Vector<Component> vector = new Vector<Component>();
        Component[] componentArray = ((JPanel)this.panel.getComponents()[0]).getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component[] componentArray2 = ((JPanel)componentArray[i]).getComponents();
            for (int j = 0; j < componentArray2.length; ++j) {
                vector.add(componentArray2[j]);
            }
        }
        return vector;
    }

    public void setButtonReactionToElements(SupplierFrame supplierFrame) {
        this.processPanel(supplierFrame, this.panel);
    }

    private void $$$setupUI$$$() {
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout(0, 0));
        this.panel.setEnabled(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.panel.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel2.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Company")));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.nameTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.nameTextField, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Short name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        this.shortNameTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.shortNameTextField, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Legal Address"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        this.legalAddressTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.legalAddressTextField, gridBagConstraints);
        this.regCodeTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.regCodeTextField, gridBagConstraints);
        this.ITINTextField = new JTextField();
        this.ITINTextField.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.ITINTextField, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("ITIN"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)jLabel4, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel8, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel9, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Actual address"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)jLabel5, gridBagConstraints);
        this.actualAddressTextField = new JTextField();
        this.actualAddressTextField.setInheritsPopupMenu(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.actualAddressTextField, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel10, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel11, gridBagConstraints);
        this.taxRateLabel = new JLabel();
        this.taxRateLabel.setText("Tax Rate(%)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)this.taxRateLabel, gridBagConstraints);
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Reg Code"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)jLabel6, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel12, gridBagConstraints);
        this.taxRateTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.taxRateTextField, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel13, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel14, gridBagConstraints);
        jPanel14.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Executive managers")));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("CEO"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel14.add((Component)jLabel7, gridBagConstraints);
        this.CEOTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel14.add((Component)this.CEOTextField, gridBagConstraints);
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Short name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel14.add((Component)jLabel8, gridBagConstraints);
        this.shortNameTextField3 = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel14.add((Component)this.shortNameTextField3, gridBagConstraints);
        this.shortNameTextField1 = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel14.add((Component)this.shortNameTextField1, gridBagConstraints);
        this.accountantTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel14.add((Component)this.accountantTextField, gridBagConstraints);
        JLabel jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Accountant"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel14.add((Component)jLabel9, gridBagConstraints);
        JLabel jLabel10 = new JLabel();
        this.$$$loadLabelText$$$(jLabel10, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Short name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel14.add((Component)jLabel10, gridBagConstraints);
        JPanel jPanel15 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        jPanel14.add((Component)jPanel15, gridBagConstraints);
        JPanel jPanel16 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel14.add((Component)jPanel16, gridBagConstraints);
        JPanel jPanel17 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel14.add((Component)jPanel17, gridBagConstraints);
        JPanel jPanel18 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel14.add((Component)jPanel18, gridBagConstraints);
        JPanel jPanel19 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel14.add((Component)jPanel19, gridBagConstraints);
        JPanel jPanel20 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel14.add((Component)jPanel20, gridBagConstraints);
        JPanel jPanel21 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel14.add((Component)jPanel21, gridBagConstraints);
        JPanel jPanel22 = new JPanel();
        jPanel22.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel22, gridBagConstraints);
        jPanel22.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Bank")));
        JLabel jLabel11 = new JLabel();
        this.$$$loadLabelText$$$(jLabel11, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel22.add((Component)jLabel11, gridBagConstraints);
        JLabel jLabel12 = new JLabel();
        this.$$$loadLabelText$$$(jLabel12, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("BIN"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel22.add((Component)jLabel12, gridBagConstraints);
        this.accountTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel22.add((Component)this.accountTextField, gridBagConstraints);
        this.selectBankButton = new JButton();
        this.selectBankButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/configure16.png")));
        this.$$$loadButtonText$$$(this.selectBankButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Select bank"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel22.add((Component)this.selectBankButton, gridBagConstraints);
        this.nameTextField2 = new JTextField();
        this.nameTextField2.setEditable(false);
        this.nameTextField2.setEnabled(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel22.add((Component)this.nameTextField2, gridBagConstraints);
        JLabel jLabel13 = new JLabel();
        this.$$$loadLabelText$$$(jLabel13, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("City"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel22.add((Component)jLabel13, gridBagConstraints);
        this.cityTextField = new JTextField();
        this.cityTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel22.add((Component)this.cityTextField, gridBagConstraints);
        this.corrTextField = new JTextField();
        this.corrTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel22.add((Component)this.corrTextField, gridBagConstraints);
        JLabel jLabel14 = new JLabel();
        this.$$$loadLabelText$$$(jLabel14, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Correspondent account"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel22.add((Component)jLabel14, gridBagConstraints);
        this.BINTextField = new JTextField();
        this.BINTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel22.add((Component)this.BINTextField, gridBagConstraints);
        JLabel jLabel15 = new JLabel();
        this.$$$loadLabelText$$$(jLabel15, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Account"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel22.add((Component)jLabel15, gridBagConstraints);
        JPanel jPanel23 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        jPanel22.add((Component)jPanel23, gridBagConstraints);
        JPanel jPanel24 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel22.add((Component)jPanel24, gridBagConstraints);
        JPanel jPanel25 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        jPanel22.add((Component)jPanel25, gridBagConstraints);
        JPanel jPanel26 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        jPanel22.add((Component)jPanel26, gridBagConstraints);
        JPanel jPanel27 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel22.add((Component)jPanel27, gridBagConstraints);
        JPanel jPanel28 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel22.add((Component)jPanel28, gridBagConstraints);
        JPanel jPanel29 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel22.add((Component)jPanel29, gridBagConstraints);
        JPanel jPanel30 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel22.add((Component)jPanel30, gridBagConstraints);
        JPanel jPanel31 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel22.add((Component)jPanel31, gridBagConstraints);
        JPanel jPanel32 = new JPanel();
        jPanel32.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel32, gridBagConstraints);
        jPanel32.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Contract")));
        JLabel jLabel16 = new JLabel();
        this.$$$loadLabelText$$$(jLabel16, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Contract place"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel32.add((Component)jLabel16, gridBagConstraints);
        JLabel jLabel17 = new JLabel();
        this.$$$loadLabelText$$$(jLabel17, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Client prefix"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel32.add((Component)jLabel17, gridBagConstraints);
        JLabel jLabel18 = new JLabel();
        this.$$$loadLabelText$$$(jLabel18, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Service place"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel32.add((Component)jLabel18, gridBagConstraints);
        JPanel jPanel33 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        jPanel32.add((Component)jPanel33, gridBagConstraints);
        JPanel jPanel34 = new JPanel();
        jPanel34.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        jPanel32.add((Component)jPanel34, gridBagConstraints);
        JPanel jPanel35 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel34.add((Component)jPanel35, gridBagConstraints);
        JPanel jPanel36 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel34.add((Component)jPanel36, gridBagConstraints);
        JLabel jLabel19 = new JLabel();
        this.$$$loadLabelText$$$(jLabel19, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Contract number"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel32.add((Component)jLabel19, gridBagConstraints);
        JPanel jPanel37 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel32.add((Component)jPanel37, gridBagConstraints);
        JPanel jPanel38 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel32.add((Component)jPanel38, gridBagConstraints);
        JPanel jPanel39 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel32.add((Component)jPanel39, gridBagConstraints);
        JPanel jPanel40 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel32.add((Component)jPanel40, gridBagConstraints);
        this.clientPrefixTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel32.add((Component)this.clientPrefixTextField, gridBagConstraints);
        this.contractNumberTextField = new JTextField();
        this.contractNumberTextField.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel32.add((Component)this.contractNumberTextField, gridBagConstraints);
        this.contractPlaceTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel32.add((Component)this.contractPlaceTextField, gridBagConstraints);
        this.servicePlaceTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel32.add((Component)this.servicePlaceTextField, gridBagConstraints);
        JPanel jPanel41 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel32.add((Component)jPanel41, gridBagConstraints);
        JPanel jPanel42 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel32.add((Component)jPanel42, gridBagConstraints);
        JLabel jLabel20 = new JLabel();
        this.$$$loadLabelText$$$(jLabel20, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Number format"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel32.add((Component)jLabel20, gridBagConstraints);
        this.numberFormatTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel32.add((Component)this.numberFormatTextField, gridBagConstraints);
        JPanel jPanel43 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        jPanel32.add((Component)jPanel43, gridBagConstraints);
        JPanel jPanel44 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 3;
        jPanel32.add((Component)jPanel44, gridBagConstraints);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

