/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.options.nfproviders;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaDelNfProvider;
import biz.netup.control.transport.urfa.functions.UrfaGetNfProvidersList;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.nfproviders.NFProviderDialog;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;

public class MainNFProvidersTab
extends TabPanelWithTable {
    public MainNFProvidersTab() {
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/settings/firewalls.png")));
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/settings/firewalls_24.png")));
        this.setRefreshPermission(new int[]{20577});
        this.setRefreshPermission(new int[]{20580});
        this.setAddPermission(new int[]{20578});
        this.setEditPermission(new int[]{20578});
        this.setDeletePermission(new int[]{20579});
    }

    @Override
    public int getTabType() {
        return 1;
    }

    @Override
    public String getTabName() {
        return "NetFlow Providers";
    }

    @Override
    public String getGroupName() {
        return "Options";
    }

    @Override
    public int getMode() {
        return 1;
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("id", "ID");
        linkedHashMap.put("collector_id", "Traffic Collector");
        linkedHashMap.put("name", "Name");
        linkedHashMap.put("comments", "Comments");
        linkedHashMap.put("ip", "IP");
        return linkedHashMap;
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        UrfaGetNfProvidersList urfaGetNfProvidersList = new UrfaGetNfProvidersList(UrfaManagerImpl.getInstance());
        urfaGetNfProvidersList.call();
        for (int i = 0; i < urfaGetNfProvidersList.getSize(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", urfaGetNfProvidersList.getId1()[i]);
            hashMap.put("collector_id", urfaGetNfProvidersList.getCollectorId1()[i]);
            InetAddress inetAddress = urfaGetNfProvidersList.getAddress1()[i];
            hashMap.put("name", urfaGetNfProvidersList.getName1()[i]);
            hashMap.put("comments", urfaGetNfProvidersList.getComments1()[i]);
            hashMap.put("ip", inetAddress != null ? inetAddress.getHostAddress() : "");
            vector.add(hashMap);
        }
        return vector;
    }

    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
        UrfaDelNfProvider urfaDelNfProvider = new UrfaDelNfProvider(UrfaManagerImpl.getInstance());
        urfaDelNfProvider.setId((Integer)map.get("id"));
        urfaDelNfProvider.call();
        String string = urfaDelNfProvider.getErrorMessage();
        if (!string.isEmpty()) {
            Dialogs.showErrorDialog(this.resource.getString(string));
        }
    }

    @Override
    public DFModel getItemDialog(Map<String, Object> map) {
        return new NFProviderDialog(map);
    }
}

