/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.options.buildings;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaAddHouse;
import biz.netup.control.transport.urfa.functions.UrfaGetHouse;
import biz.netup.control.transport.urfa.functions.UrfaGetStreet;
import biz.netup.control.transport.urfa.functions.UrfaGetStreetsList;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.buildings.AutoCompletionFiltering;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.ipzones.MainIPZonesTab;
import biz.netup.swing.datetime.JDateTime;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.control.ArrayFromVector;
import biz.netup.utmutils.swing.dialog.DialogModel;
import biz.netup.utmutils.swing.dialog.SelectFromTableDialogModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BuildingDialog
extends DialogModel {
    private JTextField postCodeTextField;
    private JTextField countryTextField;
    private JTextField provinceStateTextField;
    private JTextField cityTextField;
    private JTextField buildingTextField;
    private JTextField constrTextField;
    private JPanel mainPanel;
    private JButton deleteButton;
    private JButton addButton;
    private TablePanelImpl ipZonesTablePanel;
    private JDateTime connectedDateDateTime;
    private JTextField IDTextField;
    private JLabel IDLabel;
    private JComboBox streetComboBox;
    private Map<String, Integer> streetsMap;
    private AutoCompletionFiltering autoCompletionFiltering;

    public BuildingDialog() {
        this.$$$setupUI$$$();
    }

    public BuildingDialog(Map<String, Object> map) {
        super(map);
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        return this.mainPanel;
    }

    @Override
    public String getItemName() {
        return "House";
    }

    private void fillComboBox() throws UrfaException {
        UrfaGetStreetsList urfaGetStreetsList = new UrfaGetStreetsList(UrfaManagerImpl.getInstance());
        urfaGetStreetsList.call();
        this.streetsMap = new HashMap<String, Integer>();
        this.streetComboBox.removeAllItems();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < urfaGetStreetsList.getStreetsSize(); ++i) {
            String string = urfaGetStreetsList.getStreet1()[i] + ", " + urfaGetStreetsList.getCountry1()[i] + ", " + urfaGetStreetsList.getRegion1()[i] + ", " + urfaGetStreetsList.getCity1()[i];
            this.streetsMap.put(string, urfaGetStreetsList.getStreetId1()[i]);
            treeSet.add(string);
        }
        for (String string : treeSet) {
            this.streetComboBox.addItem(string);
        }
    }

    @Override
    protected void loadInfo() throws UrfaException {
        Serializable serializable;
        Object object;
        if (!this.isAddMode()) {
            object = new UrfaGetHouse(UrfaManagerImpl.getInstance());
            ((UrfaGetHouse)object).setHouseId((Integer)this.item.get("id"));
            ((UrfaGetHouse)object).call();
            this.IDTextField.setText("" + ((UrfaGetHouse)object).getHouseId());
            this.connectedDateDateTime.setDate(new Date((long)((UrfaGetHouse)object).getConnectDate() * 1000L));
            this.postCodeTextField.setText(((UrfaGetHouse)object).getPostCode());
            this.provinceStateTextField.setText(((UrfaGetHouse)object).getRegion());
            this.countryTextField.setText(((UrfaGetHouse)object).getCountry());
            this.cityTextField.setText(((UrfaGetHouse)object).getCity());
            this.buildingTextField.setText(((UrfaGetHouse)object).getNumber());
            this.constrTextField.setText(((UrfaGetHouse)object).getBuilding());
            for (int i = 0; i < ((UrfaGetHouse)object).getCount(); ++i) {
                serializable = new HashMap();
                serializable.put("id", ((UrfaGetHouse)object).getIpzoneId1()[i]);
                serializable.put("name", ((UrfaGetHouse)object).getIpzoneName1()[i]);
                this.ipZonesTablePanel.getTableModel().addRow((Map<String, Object>)((Object)serializable));
            }
            if (!this.streetsMap.containsKey(((UrfaGetHouse)object).getStreet())) {
                this.streetsMap.put(((UrfaGetHouse)object).getStreet(), 0);
                this.streetComboBox.addItem(((UrfaGetHouse)object).getStreet());
            }
            for (String string : this.streetsMap.keySet()) {
                if (!string.equals(((UrfaGetHouse)object).getStreet())) continue;
                this.streetComboBox.setSelectedItem(string);
            }
        } else {
            this.IDLabel.setVisible(false);
            this.IDTextField.setVisible(false);
            this.streetComboBox.setSelectedItem("");
        }
        this.ipZonesTablePanel.registerMultiRowButton(this.deleteButton);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BuildingDialog.this.addIPZone();
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BuildingDialog.this.deleteIPZone();
            }
        });
        this.streetComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BuildingDialog.this.setStreetCompletition();
            }
        });
        object = this.streetComboBox.getEditor().getEditorComponent();
        if (object instanceof JTextField) {
            serializable = (JTextField)object;
            ((Component)serializable).addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    BuildingDialog.this.setStreetCompletition();
                }
            });
        }
    }

    private void addIPZone() {
        SelectFromTableDialogModel selectFromTableDialogModel = new SelectFromTableDialogModel(new MainIPZonesTab());
        selectFromTableDialogModel.setVisible(true);
        if (selectFromTableDialogModel.isOkPressed()) {
            boolean bl = false;
            for (Map<String, Object> map : this.ipZonesTablePanel.getTableModel().data) {
                if (!map.get("id").equals(selectFromTableDialogModel.getItem().get("id"))) continue;
                bl = true;
            }
            if (!bl) {
                this.ipZonesTablePanel.getTableModel().addRow(selectFromTableDialogModel.getItem());
            }
        }
    }

    private void deleteIPZone() {
        for (Map<String, Object> map : this.ipZonesTablePanel.getSelectedTableRows()) {
            this.ipZonesTablePanel.getTableModel().removeRow(map);
        }
    }

    private void setStreetCompletition() {
        String string = (String)this.streetComboBox.getSelectedItem();
        if (!this.streetsMap.containsKey(string)) {
            return;
        }
        int n = this.streetsMap.get(string);
        if (n == 0) {
            return;
        }
        try {
            UrfaGetStreet urfaGetStreet = new UrfaGetStreet(UrfaManagerImpl.getInstance());
            urfaGetStreet.setStreetId(n);
            urfaGetStreet.call();
            if (this.provinceStateTextField.getText().isEmpty()) {
                this.provinceStateTextField.setText(urfaGetStreet.getRegion());
            }
            if (this.countryTextField.getText().isEmpty()) {
                this.countryTextField.setText(urfaGetStreet.getCountry());
            }
            if (this.cityTextField.getText().isEmpty()) {
                this.cityTextField.setText(urfaGetStreet.getCity());
            }
            if (!this.streetsMap.containsKey(urfaGetStreet.getStreet())) {
                this.streetsMap.put(urfaGetStreet.getStreet(), 0);
                this.streetComboBox.addItem(urfaGetStreet.getStreet());
            }
            for (String string2 : this.streetsMap.keySet()) {
                if (!string2.equals(urfaGetStreet.getStreet())) continue;
                this.streetComboBox.setSelectedItem(string2);
            }
        }
        catch (UrfaException urfaException) {
            // empty catch block
        }
    }

    @Override
    protected void saveInfo() throws UrfaException {
        UrfaAddHouse urfaAddHouse = new UrfaAddHouse(UrfaManagerImpl.getInstance());
        if (!this.isAddMode()) {
            urfaAddHouse.setHouseId((Integer)this.item.get("id"));
        }
        urfaAddHouse.setBuilding(this.constrTextField.getText());
        urfaAddHouse.setCity(this.cityTextField.getText());
        urfaAddHouse.setConnectDate((int)(this.connectedDateDateTime.getDate().getTime() / 1000L));
        urfaAddHouse.setCountry(this.countryTextField.getText());
        urfaAddHouse.setNumber(this.buildingTextField.getText());
        urfaAddHouse.setPostCode(this.postCodeTextField.getText());
        urfaAddHouse.setRegion(this.provinceStateTextField.getText());
        urfaAddHouse.setStreet(this.streetComboBox.getSelectedItem().toString());
        urfaAddHouse.setCount(this.ipZonesTablePanel.getTable().getRowCount());
        urfaAddHouse.setIpzoneId1(ArrayFromVector.getIntArrayFromData(this.ipZonesTablePanel.getTableModel().data, "id"));
        urfaAddHouse.call();
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
        this.checkTablePanel(this.ipZonesTablePanel, "IP zones");
    }

    private void createUIComponents() {
        this.connectedDateDateTime = new JDateTime(false);
        this.streetComboBox = new JComboBox();
        this.streetComboBox.setEditable(true);
        try {
            this.fillComboBox();
        }
        catch (UrfaException urfaException) {
            urfaException.printStackTrace();
        }
        this.autoCompletionFiltering = new AutoCompletionFiltering(this.streetComboBox, true);
        this.createTable();
    }

    private void createTable() {
        this.ipZonesTablePanel = new TablePanelImpl(this.getClass().getName() + "_ipzone", true);
        MapTableModel mapTableModel = this.ipZonesTablePanel.getTableModel();
        mapTableModel.addColumn("id", "ID", true, false);
        mapTableModel.addColumn("name", "Name", true, false);
        this.ipZonesTablePanel.setEditable(false);
        this.ipZonesTablePanel.setAppendable(false);
        this.ipZonesTablePanel.applyTableSettings();
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setFocusCycleRoot(true);
        this.mainPanel.setMinimumSize(new Dimension(450, 400));
        this.mainPanel.setPreferredSize(new Dimension(450, 400));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Connected on"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Building #"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Street"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel3, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("City"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel4, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("State"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel5, gridBagConstraints);
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Post code"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel6, gridBagConstraints);
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Country"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel7, gridBagConstraints);
        this.postCodeTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.postCodeTextField, gridBagConstraints);
        this.countryTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.countryTextField, gridBagConstraints);
        this.cityTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.cityTextField, gridBagConstraints);
        this.buildingTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.buildingTextField, gridBagConstraints);
        this.constrTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.constrTextField, gridBagConstraints);
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Constr #"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel8, gridBagConstraints);
        this.provinceStateTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.provinceStateTextField, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mainPanel.add((Component)jPanel, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("IP zones")));
        this.deleteButton = new JButton();
        this.deleteButton.setEnabled(true);
        this.$$$loadButtonText$$$(this.deleteButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Delete"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.deleteButton, gridBagConstraints);
        this.addButton = new JButton();
        this.$$$loadButtonText$$$(this.addButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.addButton, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel2.add((Component)this.ipZonesTablePanel, "Center");
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel8, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel9, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel10, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel11, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel12, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel13, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel14, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.connectedDateDateTime, gridBagConstraints);
        this.IDLabel = new JLabel();
        this.$$$loadLabelText$$$(this.IDLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("ID"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)this.IDLabel, gridBagConstraints);
        JPanel jPanel15 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel15, gridBagConstraints);
        this.IDTextField = new JTextField();
        this.IDTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.IDTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.streetComboBox, gridBagConstraints);
        jLabel2.setLabelFor(this.buildingTextField);
        jLabel4.setLabelFor(this.cityTextField);
        jLabel5.setLabelFor(this.provinceStateTextField);
        jLabel6.setLabelFor(this.postCodeTextField);
        jLabel7.setLabelFor(this.countryTextField);
        jLabel8.setLabelFor(this.constrTextField);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

