/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.options.buildings;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class AutoCompletionFiltering
extends PlainDocument {
    JComboBox comboBox;
    DefaultComboBoxModel model;
    DefaultComboBoxModel item_model;
    JTextComponent editor;
    boolean isAppendable = true;
    boolean selecting = false;
    boolean hidePopupOnFocusLoss;
    boolean hitBackspace = false;
    boolean hitBackspaceOnSelection;
    boolean hitArrow = false;
    boolean listenersIsRemoved = false;
    KeyListener editorKeyListener;
    FocusListener editorFocusListener;
    MouseListener mouseListener;
    ActionListener[] als;

    public AutoCompletionFiltering(JComboBox jComboBox) {
        this(jComboBox, true);
    }

    public AutoCompletionFiltering(final JComboBox jComboBox, boolean bl) {
        this.comboBox = jComboBox;
        this.isAppendable = bl;
        this.model = (DefaultComboBoxModel)jComboBox.getModel();
        this.item_model = new DefaultComboBoxModel();
        int n = this.model.getSize();
        for (int i = 0; i < n; ++i) {
            this.item_model.addElement(new String(this.model.getElementAt(i).toString()));
        }
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AutoCompletionFiltering.this.selecting) {
                    AutoCompletionFiltering.this.highlightCompletedText(0);
                }
            }
        });
        jComboBox.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("editor")) {
                    AutoCompletionFiltering.this.configureEditor((ComboBoxEditor)propertyChangeEvent.getNewValue());
                }
                if (propertyChangeEvent.getPropertyName().equals("model")) {
                    AutoCompletionFiltering.this.model = (DefaultComboBoxModel)propertyChangeEvent.getNewValue();
                }
            }
        });
        this.editorKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (jComboBox.isDisplayable()) {
                    jComboBox.setPopupVisible(true);
                }
                AutoCompletionFiltering.this.hitBackspace = false;
                AutoCompletionFiltering.this.hitArrow = false;
                AutoCompletionFiltering.this.addActionListeners();
                switch (keyEvent.getKeyCode()) {
                    case 8: {
                        AutoCompletionFiltering.this.hitBackspace = true;
                        AutoCompletionFiltering.this.hitBackspaceOnSelection = AutoCompletionFiltering.this.editor.getSelectionStart() != AutoCompletionFiltering.this.editor.getSelectionEnd();
                        break;
                    }
                    case 127: {
                        if (AutoCompletionFiltering.this.isAppendable) break;
                        keyEvent.consume();
                        jComboBox.getToolkit().beep();
                        break;
                    }
                    case 38: 
                    case 40: {
                        AutoCompletionFiltering.this.removeActionListeners();
                        AutoCompletionFiltering.this.hitArrow = true;
                    }
                }
            }
        };
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                AutoCompletionFiltering.this.hitArrow = false;
                AutoCompletionFiltering.this.addActionListeners();
                super.mousePressed(mouseEvent);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                AutoCompletionFiltering.this.hitArrow = false;
                AutoCompletionFiltering.this.addActionListeners();
                super.mouseMoved(mouseEvent);
            }
        };
        this.hidePopupOnFocusLoss = System.getProperty("java.version").startsWith("1.5");
        this.editorFocusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                AutoCompletionFiltering.this.highlightCompletedText(0);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (AutoCompletionFiltering.this.hidePopupOnFocusLoss) {
                    jComboBox.setPopupVisible(false);
                }
            }
        };
        this.configureEditor(jComboBox.getEditor());
        Object object = jComboBox.getSelectedItem();
        if (object != null) {
            this.setText(object.toString());
        }
        this.als = jComboBox.getActionListeners();
        this.highlightCompletedText(0);
    }

    public static void enable(JComboBox jComboBox) {
        AutoCompletionFiltering.enable(jComboBox, true);
    }

    public static void enable(JComboBox jComboBox, boolean bl) {
        jComboBox.setEditable(true);
        new AutoCompletionFiltering(jComboBox, bl);
    }

    void configureEditor(ComboBoxEditor comboBoxEditor) {
        if (this.editor != null) {
            this.editor.removeKeyListener(this.editorKeyListener);
            this.editor.removeFocusListener(this.editorFocusListener);
            this.editor.removeMouseListener(this.mouseListener);
        }
        if (comboBoxEditor != null) {
            this.editor = (JTextComponent)comboBoxEditor.getEditorComponent();
            this.editor.addKeyListener(this.editorKeyListener);
            this.editor.addFocusListener(this.editorFocusListener);
            this.editor.addMouseListener(this.mouseListener);
            this.editor.setDocument(this);
        }
    }

    @Override
    public void remove(int n, int n2) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        if (this.hitBackspace) {
            Object object;
            if (n > 0) {
                if (this.hitBackspaceOnSelection) {
                    --n;
                }
            } else {
                if (n2 == this.getLength()) {
                    this.setText("");
                    return;
                }
                this.comboBox.getToolkit().beep();
            }
            if ((object = this.lookupItem(this.getText(0, n))) != null) {
                this.setText(object.toString());
                this.highlightCompletedText(n);
            } else {
                super.remove(n, n2);
                object = this.lookupItem(this.getText(0, this.getLength()));
                if (object != null) {
                    this.setText(object.toString());
                    this.highlightCompletedText(n);
                }
            }
        } else {
            super.remove(n, n2);
        }
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        super.insertString(n, string, attributeSet);
        String string2 = this.getText(0, this.getLength());
        Object object = this.lookupItem(this.getText(0, this.getLength()));
        if (object != null) {
            this.setSelectedItem(object);
        } else {
            if (this.isAppendable) {
                this.setText(string2);
                return;
            }
            object = this.comboBox.getSelectedItem();
            n -= string.length();
            this.comboBox.getToolkit().beep();
        }
        this.setText(object.toString());
        this.highlightCompletedText(n + string.length());
    }

    private void setText(String string) {
        try {
            super.remove(0, this.getLength());
            super.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException(badLocationException.toString());
        }
    }

    private void highlightCompletedText(int n) {
        if (null == this.editor) {
            return;
        }
        this.editor.setCaretPosition(this.getLength());
        this.editor.moveCaretPosition(n);
    }

    private void setSelectedItem(Object object) {
        this.selecting = true;
        this.removeActionListeners();
        this.model.setSelectedItem(object);
        this.setText(object.toString());
        this.addActionListeners();
        this.selecting = false;
    }

    private void removeActionListeners() {
        if (this.listenersIsRemoved) {
            return;
        }
        for (ActionListener actionListener : this.als = this.comboBox.getActionListeners()) {
            this.comboBox.removeActionListener(actionListener);
        }
        this.listenersIsRemoved = true;
    }

    private void addActionListeners() {
        if (!this.listenersIsRemoved || this.hitArrow) {
            return;
        }
        for (ActionListener actionListener : this.als) {
            this.comboBox.addActionListener(actionListener);
        }
        this.listenersIsRemoved = false;
    }

    private Object lookupItem(String string) {
        Object object = this.model.getSelectedItem();
        Object object2 = null;
        if (object != null && this.startsWithIgnoreCase(object.toString(), string)) {
            object2 = object;
        }
        int n = this.item_model.getSize();
        for (int i = 0; i < n; ++i) {
            Object e = this.item_model.getElementAt(i);
            if (e == object2) {
                if (-1 != this.model.getIndexOf(e)) continue;
                this.model.addElement(e);
                continue;
            }
            if (!this.hitArrow) {
                this.model.removeElement(e);
            }
            if (e == null || !this.startsWithIgnoreCase(e.toString(), string)) continue;
            if (object2 == null) {
                object2 = e;
            }
            if (this.hitArrow) continue;
            this.model.addElement(e);
        }
        if (this.comboBox.isPopupVisible()) {
            this.comboBox.setPopupVisible(false);
            this.comboBox.setPopupVisible(true);
        }
        return object2;
    }

    private boolean startsWithIgnoreCase(String string, String string2) {
        return null != string && string.toUpperCase().startsWith(string2.toUpperCase());
    }
}

