/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.options.archiv;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaArchivate;
import biz.netup.control.transport.urfa.functions.UrfaGetArchiveList;
import biz.netup.control.transport.urfa.functions.UrfaRefreshArchives;
import biz.netup.control.transport.urfa.functions.UrfaVerifyArchives;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.utmutils.swing.tab.ArchiveTab;
import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class MainArchiveTab
extends ArchiveTab {
    private Map<Integer, String> statusDictionary;
    private boolean renderersSet;

    public MainArchiveTab() {
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/settings/NAS_list.png")));
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/settings/NAS_list_24.png")));
        this.setRefreshPermission(new int[]{253, 251, 252});
        this.statusDictionary = new HashMap<Integer, String>();
        this.statusDictionary.put(0, "State OK");
        this.statusDictionary.put(1, "State under verifying");
        this.statusDictionary.put(2, "State unable to verify");
        this.renderersSet = false;
    }

    @Override
    public int getTabType() {
        return 1;
    }

    @Override
    public String getTabName() {
        return "Archive DB";
    }

    @Override
    public String getGroupName() {
        return "Options";
    }

    @Override
    public int getMode() {
        return 4;
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("id", "ID");
        linkedHashMap.put("begin_date", "Start time");
        linkedHashMap.put("end_date", "End time");
        linkedHashMap.put("status", "Status");
        return linkedHashMap;
    }

    private Date parseTimestamp(String string) {
        long l = Integer.parseInt(string);
        return new Date(l * 1000L);
    }

    @Override
    public void setTableData() throws UrfaException {
        UrfaGetArchiveList urfaGetArchiveList = new UrfaGetArchiveList(UrfaManagerImpl.getInstance());
        urfaGetArchiveList.call();
        for (int i = 0; i < urfaGetArchiveList.getSize(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", urfaGetArchiveList.getId1()[i]);
            hashMap.put("begin_date", this.parseTimestamp(urfaGetArchiveList.getBeginDate1()[i]));
            hashMap.put("end_date", this.parseTimestamp(urfaGetArchiveList.getEndDate1()[i]));
            hashMap.put("statusCode", urfaGetArchiveList.getStatus1()[i]);
            hashMap.put("status", this.resource.getString(this.statusDictionary.get(urfaGetArchiveList.getStatus1()[i])));
            this.getReportTablePanel().getTableModel().addRow(hashMap);
        }
        if (urfaGetArchiveList.getSize() > 0) {
            Date date = new Date();
            Date date2 = this.parseTimestamp(urfaGetArchiveList.getEndDate1()[0]);
            this.getCreateButton().setEnabled(true);
        } else {
            this.getCreateButton().setEnabled(true);
        }
        if (!this.renderersSet) {
            this.getReportTablePanel().setCellRenderer("id", new CustomCellRenderer());
            this.renderersSet = true;
        }
    }

    @Override
    public void checkTableData() throws UrfaException {
        UrfaRefreshArchives urfaRefreshArchives = new UrfaRefreshArchives(UrfaManagerImpl.getInstance());
        urfaRefreshArchives.call();
    }

    @Override
    public void verifyTableData() throws UrfaException {
        UrfaVerifyArchives urfaVerifyArchives = new UrfaVerifyArchives(UrfaManagerImpl.getInstance());
        urfaVerifyArchives.call();
    }

    @Override
    public void createTableItem() throws UrfaException {
        UrfaArchivate urfaArchivate = new UrfaArchivate(UrfaManagerImpl.getInstance());
        urfaArchivate.call();
    }

    class CustomCellRenderer
    extends DefaultTableCellRenderer {
        CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.setForeground(Color.BLACK);
            int n3 = (Integer)MainArchiveTab.this.getReportTablePanel().getTableModel().getRow(n).get("statusCode");
            if (n3 == 1) {
                super.setBackground(new Color(203, 203, 203));
            } else if (n3 == 0) {
                super.setBackground(new Color(153, 255, 153));
            } else if (n3 == 2) {
                super.setBackground(new Color(60, 250, 255));
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        @Override
        public void setBackground(Color color) {
        }

        @Override
        public void setForeground(Color color) {
        }
    }

    private static class ArchiveState {
        public static final int STATE_OK = 0;
        public static final int STATE_UNDER_VERIFYING = 1;
        public static final int STATE_UNABLE_TO_VERIFY = 2;

        private ArchiveState() {
        }
    }
}

