/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.ic;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaIcUsersList;
import biz.netup.control.transport.urfa.functions.UrfaSetIcStatus;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.dealer.main.usersandgroups.users.UsersFunctions;
import biz.netup.projects.utmadmin.gui.mainframe.forms.ic.ICDialog;
import biz.netup.projects.utmadmin.gui.userframe.UserFrame;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.TablePanelAdapter;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.control.Settings;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.tab.TabPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;

public class ICUsersTab
extends TabPanel {
    private JPanel mainPanel;
    private JComboBox pageComboBox;
    private JTextField usersPerPageTextField;
    private JLabel ofLabel;
    private TablePanelImpl mainTable;
    private JButton refreshButton;
    private int usersCount = 0;
    private Integer usersPerPage;
    private int usersFrom = 0;
    private int usersTo = 99;

    public ICUsersTab() {
        this.setRefreshPermission(new int[]{81923, 81926});
        this.$$$setupUI$$$();
        this.usersPerPageTextField.setText("100");
        this.usersPerPage = 100;
    }

    @Override
    public int getTabType() {
        return 1;
    }

    private void createUIComponents() {
        this.createTable();
    }

    private void changePage() {
        try {
            if (this.pageComboBox.getSelectedIndex() >= 0) {
                this.usersFrom = this.pageComboBox.getSelectedIndex() * this.usersPerPage;
                this.usersTo = this.usersFrom + this.usersPerPage - 1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Incorrect number");
        }
    }

    private void generatePagePanel() {
        try {
            ActionListener[] actionListenerArray = this.pageComboBox.getActionListeners();
            int n = actionListenerArray.length;
            for (int i = 0; i < n; ++i) {
                ActionListener actionListener = actionListenerArray[i];
                this.pageComboBox.removeActionListener(actionListener);
            }
            this.usersCount = UsersFunctions.getUsersCount(false);
            int n2 = this.usersCount % this.usersPerPage == 0 ? this.usersCount / this.usersPerPage : this.usersCount / this.usersPerPage + 1;
            this.pageComboBox.removeAllItems();
            for (n = 0; n < n2; ++n) {
                this.pageComboBox.addItem(n + 1);
            }
            this.usersFrom = 0;
            this.usersTo = this.usersPerPage - 1;
            this.ofLabel.setText(" " + n2);
            this.pageComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ICUsersTab.this.changePage();
                    ICUsersTab.this.refresh();
                }
            });
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Incorrect number");
        }
    }

    private void createTable() {
        this.mainTable = new TablePanelImpl(this.getClass().getName() + "_users", true);
        MapTableModel mapTableModel = this.mainTable.getTableModel();
        mapTableModel.addColumn("uid", "UID", true, false);
        mapTableModel.addColumn("login", "Login", true, false);
        mapTableModel.addColumn("full_name", "Full name", true, false);
        mapTableModel.addColumn("last_sync_date", "Last sync time", true, false);
        mapTableModel.addColumn("1c_id", "1C ID", true, false);
        mapTableModel.addColumn("1c_status_name", "1C Status", true, false);
        this.mainTable.setEditable(false);
        this.mainTable.setAppendable(false);
        this.mainTable.setTablePanelListener(new TablePanelAdapter(){

            @Override
            public JMenuItem[] getTableContextMenuItems(Map<String, Object>[] mapArray) {
                JMenuItem jMenuItem = new JMenuItem(ICUsersTab.this.resource.getString("Refresh"));
                JMenuItem jMenuItem2 = new JMenuItem(ICUsersTab.this.resource.getString("Edit"));
                JMenuItem jMenuItem3 = new JMenuItem(ICUsersTab.this.resource.getString("Syncronize"));
                JMenuItem jMenuItem4 = new JMenuItem(ICUsersTab.this.resource.getString("Set Not syncronized status"));
                jMenuItem3.setVisible(UrfaManagerImpl.getInstance().isPermitted(81926));
                jMenuItem4.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ICUsersTab.this.unsync();
                    }
                });
                jMenuItem3.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ICUsersTab.this.sync();
                    }
                });
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ICUsersTab.this.refresh();
                    }
                });
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ICUsersTab.this.editUser();
                    }
                });
                if (mapArray.length < 1) {
                    return new JMenuItem[]{jMenuItem};
                }
                if (mapArray.length > 1) {
                    return new JMenuItem[]{jMenuItem4, jMenuItem};
                }
                HashSet<JMenuItem> hashSet = new HashSet<JMenuItem>();
                hashSet.add(jMenuItem2);
                hashSet.add(jMenuItem3);
                hashSet.add(jMenuItem4);
                hashSet.add(jMenuItem);
                return hashSet.toArray(new JMenuItem[hashSet.size()]);
            }

            @Override
            public void performTableRowDoubleClicked(Map<String, Object> map) {
                ICUsersTab.this.editUser();
            }

            @Override
            public void performSelectionChanged(Map<String, Object>[] mapArray) {
            }

            @Override
            public void performRowModified(Map<String, Object> map) {
            }

            @Override
            public void performColumnVisibilityChanged(String string, boolean bl) {
            }
        });
        this.mainTable.applyTableSettings();
        this.mainTable.setCellRenderer("uid", new CustomCellRenderer());
    }

    private void sync() {
        if (Dialogs.showYesNoDialog("ic_warning")) {
            Map<String, Object> map = this.mainTable.getSelectedTableRows()[0];
            map.put("id", map.get("uid"));
            map.put("type", 1);
            new ICDialog(map).run(this);
        }
    }

    private void unsync() {
        if (Dialogs.showYesNoDialog("ic_warning")) {
            try {
                for (Map<String, Object> map : this.mainTable.getSelectedTableRows()) {
                    UrfaSetIcStatus urfaSetIcStatus = new UrfaSetIcStatus(UrfaManagerImpl.getInstance());
                    urfaSetIcStatus.setEntityId((Integer)map.get("uid"));
                    urfaSetIcStatus.setEntityType(1);
                    urfaSetIcStatus.setIcId("");
                    urfaSetIcStatus.setIcStatus(1);
                    urfaSetIcStatus.call();
                }
                this.refreshTab();
            }
            catch (UrfaException urfaException) {
                this.log.error(urfaException);
            }
        }
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout(0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        this.mainPanel.add((Component)jPanel, "South");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel.add((Component)jPanel2, "West");
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Users per page"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Page"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("of"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        this.pageComboBox = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.pageComboBox, gridBagConstraints);
        this.usersPerPageTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 30;
        jPanel2.add((Component)this.usersPerPageTextField, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel8, gridBagConstraints);
        this.ofLabel = new JLabel();
        this.ofLabel.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.ofLabel, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel9, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel10, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BorderLayout(0, 0));
        this.mainPanel.add((Component)jPanel11, "Center");
        jPanel11.add((Component)this.mainTable, "Center");
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new GridBagLayout());
        jPanel11.add((Component)jPanel12, "North");
        this.refreshButton = new JButton();
        this.refreshButton.setEnabled(true);
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/refresh16.png")));
        this.$$$loadButtonText$$$(this.refreshButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Refresh"));
        this.refreshButton.setVisible(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel12.add((Component)this.refreshButton, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel12.add((Component)jPanel13, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel12.add((Component)jPanel14, gridBagConstraints);
        JPanel jPanel15 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel12.add((Component)jPanel15, gridBagConstraints);
        JPanel jPanel16 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel12.add((Component)jPanel16, gridBagConstraints);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    @Override
    public String getTabName() {
        return "1C Syncronized Users";
    }

    @Override
    public String getGroupName() {
        return "1C";
    }

    @Override
    protected void refreshTab() throws UrfaException {
        this.refreshTable();
    }

    @Override
    protected void init() {
        super.init();
        this.generatePagePanel();
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ICUsersTab.this.generatePagePanel();
                ICUsersTab.this.refresh();
            }
        });
        this.usersPerPageTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ICUsersTab.this.changeUsersPerPage();
            }
        });
        this.usersPerPageTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ICUsersTab.this.changeUsersPerPage();
            }
        });
        this.pageComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ICUsersTab.this.changePage();
                ICUsersTab.this.refresh();
            }
        });
    }

    @Override
    protected Component getMainPanel() {
        return this.mainPanel;
    }

    private void changeUsersPerPage() {
        int n;
        try {
            n = Integer.parseInt(this.usersPerPageTextField.getText());
            if (n <= 0) {
                throw new NumberFormatException("value <= 0");
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.usersPerPageTextField.setText(this.usersPerPage.toString());
            this.usersPerPageTextField.repaint();
            numberFormatException.printStackTrace();
            return;
        }
        if (n == this.usersPerPage) {
            return;
        }
        this.usersPerPage = n;
        if (this.usersPerPage > 0) {
            Settings.writeValueToPerst("UsersPerPage", "" + this.usersPerPage);
        }
        this.generatePagePanel();
        this.refresh();
    }

    public void refreshTable() throws UrfaException {
        this.mainTable.getTableModel().removeAllRows();
        UrfaIcUsersList urfaIcUsersList = new UrfaIcUsersList(UrfaManagerImpl.getInstance());
        urfaIcUsersList.setFrom(this.usersFrom);
        urfaIcUsersList.setTo(this.usersTo);
        urfaIcUsersList.call();
        for (int i = 0; i < urfaIcUsersList.getCount(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("uid", urfaIcUsersList.getId1()[i]);
            hashMap.put("login", urfaIcUsersList.getLogin1()[i]);
            hashMap.put("full_name", urfaIcUsersList.getFullname1()[i]);
            if (urfaIcUsersList.getLastSyncDate1()[i] == 0) {
                hashMap.put("last_sync_date", this.resource.getString("Not defined"));
            } else {
                hashMap.put("last_sync_date", new Date((long)urfaIcUsersList.getLastSyncDate1()[i] * 1000L));
            }
            hashMap.put("1c_id", urfaIcUsersList.getIcId1()[i]);
            hashMap.put("1c_status", urfaIcUsersList.getIcStatus1()[i]);
            hashMap.put("1c_status_name", Resolve.getICUserStatus(urfaIcUsersList.getIcStatus1()[i]));
            this.mainTable.getTableModel().addRow(hashMap);
        }
    }

    private void editUser() {
        UserFrame userFrame = new UserFrame((Integer)this.mainTable.getSelectedTableRows()[0].get("uid"));
        userFrame.setVisible(true);
    }

    class CustomCellRenderer
    extends DefaultTableCellRenderer {
        CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Integer n3 = (Integer)ICUsersTab.this.mainTable.getTableModel().getRow(n).get("1c_status");
            if (2 == n3) {
                super.setBackground(new Color(255, 255, 153));
            } else if (0 == n3) {
                super.setBackground(new Color(255, 153, 153));
            } else if (1 == n3) {
                super.setBackground(new Color(153, 255, 153));
            }
            return component;
        }

        @Override
        public void setBackground(Color color) {
        }
    }
}

