/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.cards.pc;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaAddCardOwner;
import biz.netup.control.transport.urfa.functions.UrfaBlockCard;
import biz.netup.control.transport.urfa.functions.UrfaCardList;
import biz.netup.control.transport.urfa.functions.UrfaDeleteCardOwner;
import biz.netup.control.transport.urfa.functions.UrfaUnblockCard;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.cards.pc.AddPC;
import biz.netup.projects.utmadmin.gui.mainframe.forms.usersandgroups.staff.MainStaffTab;
import biz.netup.swing.table.CheckboxCellRenderer;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.TablePanelAdapter;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.control.TZ;
import biz.netup.utmutils.control.export.ExportClass;
import biz.netup.utmutils.control.permissions.Permissions;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialog.DialogModel;
import biz.netup.utmutils.swing.dialog.SelectFromTableDialogModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;

public class MoreInfoDialog
extends DialogModel {
    private TablePanelImpl cardsTablePanel;
    private JButton refreshButton;
    private JButton addButton;
    private TablePanelImpl ownerTablePanel;
    private JButton deleteButton;
    private JButton addButton2;
    private JPanel mainPanel;
    private JButton blockButton;
    private JButton unblockButton;
    private JButton exportButton;
    private int curTime = 0;

    private void createUIComponents() {
        this.createCardsTable();
        this.createOwnersTable();
    }

    private void createOwnersTable() {
        this.ownerTablePanel = new TablePanelImpl(this.getClass().getName() + "_owners", true);
        MapTableModel mapTableModel = this.ownerTablePanel.getTableModel();
        mapTableModel.addColumn("id", "Owner ID", true, false);
        mapTableModel.addColumn("name", "Owner name", true, false);
        this.ownerTablePanel.setEditable(false);
        this.ownerTablePanel.setAppendable(false);
        this.ownerTablePanel.applyTableSettings();
    }

    private void createCardsTable() {
        this.cardsTablePanel = new TablePanelImpl(this.getClass().getName() + "_cards", true);
        MapTableModel mapTableModel = this.cardsTablePanel.getTableModel();
        mapTableModel.addColumn("id", "Card ID", true, false);
        mapTableModel.addColumn("blocked", "Blocked", true, false);
        mapTableModel.addColumn("password", "PIN code", true, false);
        mapTableModel.addColumn("balance", "Balance", true, false);
        mapTableModel.addColumn("currency", "Currency", true, false);
        mapTableModel.addColumn("use_before", "Activate before", true, false);
        mapTableModel.addColumn("period_of_use", "Period of validity", true, false);
        mapTableModel.addColumn("used_at", "Activated", true, false);
        mapTableModel.addColumn("tariff", "Tariff", true, false);
        this.cardsTablePanel.setEditable(false);
        this.cardsTablePanel.setAppendable(false);
        this.cardsTablePanel.applyTableSettings();
        CheckboxCellRenderer checkboxCellRenderer = new CheckboxCellRenderer(false);
        this.cardsTablePanel.setCellRenderer("blocked", checkboxCellRenderer);
        this.cardsTablePanel.setCellRenderer("id", new CustomCellRendererBlocked());
        this.cardsTablePanel.setCellRenderer("use_before", new CustomCellRendererUsed());
    }

    public MoreInfoDialog() {
        this.$$$setupUI$$$();
    }

    public MoreInfoDialog(Map<String, Object> map) {
        super(map);
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        return this.mainPanel;
    }

    @Override
    public String getItemName() {
        return "Cards pool";
    }

    @Override
    protected void loadInfo() throws UrfaException {
        if (!this.isAddMode()) {
            this.refreshTables();
        }
        Permissions.apply((JComponent)this.addButton2, "add_card_owner");
        Permissions.apply((JComponent)this.deleteButton, "remove_card_owner");
        Permissions.apply((JComponent)this.addButton, "add_card");
        this.curTime = (int)(TZ.getCoreTime().getTime() / 1000L);
        this.cardsTablePanel.registerMultiRowButton(this.blockButton);
        this.cardsTablePanel.registerMultiRowButton(this.unblockButton);
        this.ownerTablePanel.registerOneRowButton(this.deleteButton);
        this.blockButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MoreInfoDialog.this.block();
            }
        });
        this.unblockButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MoreInfoDialog.this.unblock();
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("id", MoreInfoDialog.this.getItem().get("id"));
                AddPC addPC = new AddPC(hashMap);
                addPC.load();
                if (addPC.isOkPressed()) {
                    try {
                        MoreInfoDialog.this.refreshTables();
                    }
                    catch (UrfaException urfaException) {
                        MoreInfoDialog.this.log.error("Cannot load data", urfaException);
                    }
                }
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    UrfaDeleteCardOwner urfaDeleteCardOwner = new UrfaDeleteCardOwner(UrfaManagerImpl.getInstance());
                    urfaDeleteCardOwner.setPoolId((Integer)MoreInfoDialog.this.item.get("id"));
                    urfaDeleteCardOwner.setOwnedId((Integer)MoreInfoDialog.this.ownerTablePanel.getSelectedTableRows()[0].get("id"));
                    urfaDeleteCardOwner.call();
                    try {
                        MoreInfoDialog.this.refreshTables();
                    }
                    catch (UrfaException urfaException) {
                        MoreInfoDialog.this.log.error("Cannot load data", urfaException);
                    }
                }
                catch (UrfaException urfaException) {
                    urfaException.printStackTrace();
                }
            }
        });
        this.addButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectFromTableDialogModel selectFromTableDialogModel = new SelectFromTableDialogModel(new MainStaffTab());
                selectFromTableDialogModel.setVisible(true);
                if (selectFromTableDialogModel.isOkPressed()) {
                    try {
                        UrfaAddCardOwner urfaAddCardOwner = new UrfaAddCardOwner(UrfaManagerImpl.getInstance());
                        urfaAddCardOwner.setPoolId((Integer)MoreInfoDialog.this.item.get("id"));
                        urfaAddCardOwner.setOwnedId((Integer)selectFromTableDialogModel.getItem().get("id"));
                        urfaAddCardOwner.call();
                        try {
                            MoreInfoDialog.this.refreshTables();
                        }
                        catch (UrfaException urfaException) {
                            MoreInfoDialog.this.log.error("Cannot load data", urfaException);
                        }
                    }
                    catch (UrfaException urfaException) {
                        urfaException.printStackTrace();
                    }
                }
            }
        });
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MoreInfoDialog.this.refreshTables();
                }
                catch (UrfaException urfaException) {
                    MoreInfoDialog.this.log.error("Cannot load data", urfaException);
                }
            }
        });
        this.cardsTablePanel.setTablePanelListener(new TablePanelAdapter(){

            @Override
            public JMenuItem[] getTableContextMenuItems(final Map<String, Object>[] mapArray) {
                JMenuItem jMenuItem = new JMenuItem(MoreInfoDialog.this.resource.getString("Block"));
                JMenuItem jMenuItem2 = new JMenuItem(MoreInfoDialog.this.resource.getString("Copy password"));
                JMenuItem jMenuItem3 = new JMenuItem(MoreInfoDialog.this.resource.getString("Unblock"));
                Permissions.apply(jMenuItem, "block_card");
                Permissions.apply(jMenuItem3, "unblock_card");
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MoreInfoDialog.this.block();
                    }
                });
                jMenuItem3.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MoreInfoDialog.this.unblock();
                    }
                });
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JTextField jTextField = new JTextField(mapArray[0].get("password").toString());
                        jTextField.selectAll();
                        jTextField.copy();
                    }
                });
                if (mapArray.length == 1) {
                    return new JMenuItem[]{jMenuItem, jMenuItem3, jMenuItem2};
                }
                return new JMenuItem[]{jMenuItem, jMenuItem3};
            }
        });
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportClass.exportToCsv(MoreInfoDialog.this.cardsTablePanel, "cardpool" + MoreInfoDialog.this.item.get("id") + ".csv");
            }
        });
    }

    private void block() {
        try {
            for (Map<String, Object> map : this.cardsTablePanel.getSelectedTableRows()) {
                UrfaBlockCard urfaBlockCard = new UrfaBlockCard(UrfaManagerImpl.getInstance());
                urfaBlockCard.setCardId((Integer)map.get("id"));
                urfaBlockCard.call();
            }
            this.refreshTables();
        }
        catch (UrfaException urfaException) {
            urfaException.printStackTrace();
        }
    }

    private void unblock() {
        try {
            for (Map<String, Object> map : this.cardsTablePanel.getSelectedTableRows()) {
                UrfaUnblockCard urfaUnblockCard = new UrfaUnblockCard(UrfaManagerImpl.getInstance());
                urfaUnblockCard.setCardId((Integer)map.get("id"));
                urfaUnblockCard.call();
            }
            this.refreshTables();
        }
        catch (UrfaException urfaException) {
            urfaException.printStackTrace();
        }
    }

    private void refreshTables() throws UrfaException {
        HashMap<String, Object> hashMap;
        int n;
        Resolve.updateCurList();
        UrfaCardList urfaCardList = new UrfaCardList(UrfaManagerImpl.getInstance());
        urfaCardList.setPoolId((Integer)this.item.get("id"));
        urfaCardList.call();
        this.ownerTablePanel.getTableModel().removeAllRows();
        this.cardsTablePanel.getTableModel().removeAllRows();
        for (n = 0; n < urfaCardList.getCpiOwnersSize(); ++n) {
            hashMap = new HashMap<String, Object>();
            hashMap.put("id", urfaCardList.getOwners1()[n]);
            hashMap.put("name", Resolve.getUserName(urfaCardList.getOwners1()[n]));
            this.ownerTablePanel.getTableModel().addRow(hashMap);
        }
        for (n = 0; n < urfaCardList.getInfoSize(); ++n) {
            hashMap = new HashMap();
            hashMap.put("id", urfaCardList.getCardId1()[n]);
            hashMap.put("blocked", urfaCardList.getIsBlocked1()[n]);
            hashMap.put("password", urfaCardList.getSecret1()[n]);
            hashMap.put("balance", urfaCardList.getBalance1()[n]);
            hashMap.put("currency", Resolve.getCurrencyName(urfaCardList.getCurrency1()[n]));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
            simpleDateFormat.applyPattern("dd.MM.yyyy");
            hashMap.put("use_before", simpleDateFormat.format(new Date((long)urfaCardList.getExpire1()[n] * 1000L)));
            hashMap.put("use_before_int", urfaCardList.getExpire1()[n]);
            hashMap.put("period_of_use", urfaCardList.getDays1()[n]);
            if (urfaCardList.getIsUsed1()[n] > 0) {
                hashMap.put("used_at", new Date((long)urfaCardList.getIsUsed1()[n] * 1000L));
            } else {
                hashMap.put("used_at", this.resource.getString("No"));
            }
            hashMap.put("tariff", urfaCardList.getTpId1()[n]);
            this.cardsTablePanel.getTableModel().addRow(hashMap);
        }
    }

    @Override
    protected void saveInfo() throws UrfaException {
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setMinimumSize(new Dimension(500, 450));
        this.mainPanel.setPreferredSize(new Dimension(500, 450));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mainPanel.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.addButton = new JButton();
        this.$$$loadButtonText$$$(this.addButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.addButton, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel6, gridBagConstraints);
        this.unblockButton = new JButton();
        this.unblockButton.setEnabled(true);
        this.$$$loadButtonText$$$(this.unblockButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Unblock"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.unblockButton, gridBagConstraints);
        this.blockButton = new JButton();
        this.blockButton.setEnabled(true);
        this.$$$loadButtonText$$$(this.blockButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Block"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.blockButton, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel7, gridBagConstraints);
        this.refreshButton = new JButton();
        this.$$$loadButtonText$$$(this.refreshButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Refresh"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.refreshButton, gridBagConstraints);
        this.exportButton = new JButton();
        this.$$$loadButtonText$$$(this.exportButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Export"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.exportButton, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel8, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel9, gridBagConstraints);
        jPanel9.add((Component)this.cardsTablePanel, "Center");
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mainPanel.add((Component)jPanel10, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        jPanel10.add((Component)jPanel11, gridBagConstraints);
        this.deleteButton = new JButton();
        this.deleteButton.setEnabled(true);
        this.$$$loadButtonText$$$(this.deleteButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Delete"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel11.add((Component)this.deleteButton, gridBagConstraints);
        this.addButton2 = new JButton();
        this.$$$loadButtonText$$$(this.addButton2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add owner"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel11.add((Component)this.addButton2, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel11.add((Component)jPanel12, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel11.add((Component)jPanel13, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel11.add((Component)jPanel14, gridBagConstraints);
        JPanel jPanel15 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel11.add((Component)jPanel15, gridBagConstraints);
        JPanel jPanel16 = new JPanel();
        jPanel16.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel10.add((Component)jPanel16, gridBagConstraints);
        jPanel16.add((Component)this.ownerTablePanel, "Center");
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    class CustomCellRendererUsed
    extends DefaultTableCellRenderer {
        CustomCellRendererUsed() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Integer n3 = (Integer)MoreInfoDialog.this.cardsTablePanel.getTableModel().getRow(n).get("use_before_int");
            if (n3 < MoreInfoDialog.this.curTime && MoreInfoDialog.this.curTime != 0) {
                super.setForeground(Color.BLACK);
                super.setBackground(new Color(255, 153, 153));
            } else {
                super.setForeground(Color.BLACK);
                super.setBackground(new Color(153, 255, 153));
            }
            return component;
        }

        @Override
        public void setBackground(Color color) {
        }

        @Override
        public void setForeground(Color color) {
        }
    }

    class CustomCellRendererBlocked
    extends DefaultTableCellRenderer {
        CustomCellRendererBlocked() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Integer n3 = (Integer)MoreInfoDialog.this.cardsTablePanel.getTableModel().getRow(n).get("blocked");
            if (1 == n3) {
                super.setBackground(new Color(255, 153, 153));
                super.setForeground(Color.BLACK);
            } else {
                super.setForeground(Color.BLACK);
                super.setBackground(new Color(153, 255, 153));
            }
            return component;
        }

        @Override
        public void setBackground(Color color) {
        }

        @Override
        public void setForeground(Color color) {
        }
    }
}

