/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.additional.messages;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetMessagesList;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.additional.messages.AdditionalButtons;
import biz.netup.projects.utmadmin.gui.mainframe.forms.additional.messages.MessageDialog;
import biz.netup.swing.table.TablePanelAdapter;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.tab.ReportTab;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

public class MainMessagesTab
extends ReportTab {
    public MainMessagesTab() {
        this.setBigIcon(new ImageIcon(this.getClass().getResource("messages.png")));
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("messages_24.png")));
        this.setRefreshPermission(new int[]{20480, 20481, 17428});
    }

    @Override
    public int getTabType() {
        return 1;
    }

    @Override
    public String getHelpTarget() {
        return "message";
    }

    @Override
    public String getGroupName() {
        return "Users and groups";
    }

    @Override
    public int getMode() {
        return 1;
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("sent", "Sent");
        linkedHashMap.put("received", "Received");
        linkedHashMap.put("from", "From");
        linkedHashMap.put("subject", "Subject");
        linkedHashMap.put("message", "Message");
        return linkedHashMap;
    }

    @Override
    protected JMenuItem[] getMenuItems(Map<String, Object>[] mapArray) {
        JMenuItem jMenuItem = new JMenuItem(this.resource.getString("Add"));
        JMenuItem jMenuItem2 = new JMenuItem(this.resource.getString("Read"));
        JMenuItem jMenuItem3 = new JMenuItem(this.resource.getString("Reply"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainMessagesTab.this.add();
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainMessagesTab.this.read();
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainMessagesTab.this.reply();
            }
        });
        if (mapArray.length == 1) {
            return new JMenuItem[]{jMenuItem, jMenuItem2, jMenuItem3};
        }
        return new JMenuItem[]{jMenuItem};
    }

    @Override
    public void setTableData() throws UrfaException {
        UrfaGetMessagesList urfaGetMessagesList = new UrfaGetMessagesList(UrfaManagerImpl.getInstance());
        urfaGetMessagesList.setTimeStart(this.getStartTime());
        urfaGetMessagesList.setTimeEnd(this.getEndTime());
        urfaGetMessagesList.setFilter(-1);
        urfaGetMessagesList.call();
        for (int i = 0; i < urfaGetMessagesList.getMessageSize(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", urfaGetMessagesList.getId1()[i]);
            hashMap.put("sent", new Date((long)urfaGetMessagesList.getSendDate1()[i] * 1000L));
            hashMap.put("received", new Date((long)urfaGetMessagesList.getRecvDate1()[i] * 1000L));
            hashMap.put("from", Resolve.getUserName(urfaGetMessagesList.getSenderId1()[i]));
            hashMap.put("from_int", urfaGetMessagesList.getSenderId1()[i]);
            hashMap.put("subject", urfaGetMessagesList.getSubject1()[i]);
            hashMap.put("message", urfaGetMessagesList.getMessage1()[i]);
            this.getReportTablePanel().getTableModel().addRow(hashMap);
            this.getDataTable().add(hashMap);
        }
    }

    @Override
    protected void init() {
        super.init();
        this.getApPanel().setVisible(false);
        AdditionalButtons additionalButtons = new AdditionalButtons();
        this.getAdditionalButtonsPanel().add((Component)additionalButtons.getButtonPanel(), "Center");
        this.getReportTablePanel().registerOneRowButton(additionalButtons.getReplyButton());
        this.getReportTablePanel().registerOneRowButton(additionalButtons.getReadButton());
        additionalButtons.getAddButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainMessagesTab.this.add();
            }
        });
        additionalButtons.getReplyButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainMessagesTab.this.reply();
            }
        });
        additionalButtons.getReadButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainMessagesTab.this.read();
            }
        });
        this.getReportTablePanel().setTablePanelListener(new TablePanelAdapter(){

            @Override
            public JMenuItem[] getTableContextMenuItems(Map<String, Object>[] mapArray) {
                JMenuItem jMenuItem = new JMenuItem(MainMessagesTab.this.resource.getString("Refresh"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MainMessagesTab.this.refresh();
                    }
                });
                Vector<JMenuItem> vector = new Vector<JMenuItem>();
                vector.add(jMenuItem);
                for (JMenuItem jMenuItem2 : MainMessagesTab.this.getMenuItems(mapArray)) {
                    vector.add(jMenuItem2);
                }
                return vector.toArray(new JMenuItem[vector.size()]);
            }

            @Override
            public void performTableRowDoubleClicked(Map<String, Object> map) {
                MainMessagesTab.this.read();
            }
        });
    }

    private void reply() {
        Map<String, Object> map = this.getReportTablePanel().getSelectedTableRows()[0];
        map.put("subject", "Re: " + map.get("subject"));
        map.put("message", ">> " + map.get("message"));
        MessageDialog messageDialog = new MessageDialog(map);
        messageDialog.load();
    }

    private void add() {
        new MessageDialog(null).run(this);
    }

    private void read() {
        Map<String, Object> map = this.getReportTablePanel().getSelectedTableRows()[0];
        MessageDialog messageDialog = new MessageDialog(map);
        messageDialog.setReadOnly();
        messageDialog.load();
    }

    @Override
    public String getTabName() {
        return "Messages";
    }
}

