/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.additional.hotspotsessions;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaHotspotClose;
import biz.netup.control.transport.urfa.functions.UrfaHotspotSessionsList;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.additional.hotspotsessions.AdditionalButtons;
import biz.netup.utmutils.control.permissions.Permissions;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;

public class MainHotspotSessionsTab
extends TabPanelWithTable {
    public MainHotspotSessionsTab() {
        this.setRefreshPermission(new int[]{17160});
    }

    @Override
    protected void init() {
        super.init();
        AdditionalButtons additionalButtons = new AdditionalButtons();
        this.getAdditionalButtonsPanel().add((Component)additionalButtons.getPanel1(), "Center");
        Permissions.apply((JComponent)additionalButtons.getDropButton(), "hotspot_drop_session");
        additionalButtons.getDropButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MainHotspotSessionsTab.this.drop();
                }
                catch (UrfaException urfaException) {
                    // empty catch block
                }
            }
        });
        this.getMainTablePanel().registerMultiRowButton(additionalButtons.getDropButton());
    }

    @Override
    public String getTabName() {
        return "Hotspot Sessions";
    }

    @Override
    public int getTabType() {
        return 1;
    }

    @Override
    public String getGroupName() {
        return "Additional features";
    }

    @Override
    public int getMode() {
        return 2;
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("dhs_sess_id", "DHS session ID");
        linkedHashMap.put("nas_sess_id", "NAS Session ID");
        linkedHashMap.put("web_sess_id", "Web session ID");
        linkedHashMap.put("start_date", "Start date");
        linkedHashMap.put("end_date", "End date");
        linkedHashMap.put("slink_id", "Slink ID");
        linkedHashMap.put("ip", "IP");
        linkedHashMap.put("login", "Login");
        linkedHashMap.put("balance", "Balance");
        return linkedHashMap;
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        UrfaHotspotSessionsList urfaHotspotSessionsList = new UrfaHotspotSessionsList(UrfaManagerImpl.getInstance());
        urfaHotspotSessionsList.call();
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        for (int i = 0; i < urfaHotspotSessionsList.getSessCount(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("dhs_sess_id", urfaHotspotSessionsList.getDhsSessId1()[i]);
            hashMap.put("nas_sess_id", urfaHotspotSessionsList.getNasSessId1()[i]);
            hashMap.put("web_sess_id", urfaHotspotSessionsList.getWebSessId1()[i]);
            hashMap.put("start_date", new Date((long)urfaHotspotSessionsList.getStartDate1()[i] * 1000L));
            hashMap.put("end_date", new Date((long)urfaHotspotSessionsList.getEndDate1()[i] * 1000L));
            hashMap.put("slink_id", urfaHotspotSessionsList.getSlinkId1()[i]);
            hashMap.put("ip", Resolve.ip_toString(urfaHotspotSessionsList.getIp1()[i]));
            hashMap.put("login", urfaHotspotSessionsList.getLogin1()[i]);
            hashMap.put("balance", urfaHotspotSessionsList.getBanalce1()[i]);
            vector.add(hashMap);
        }
        return vector;
    }

    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
    }

    @Override
    public DFModel getItemDialog(Map<String, Object> map) {
        return null;
    }

    private void drop() throws UrfaException {
        try {
            for (Map<String, Object> map : this.mainTablePanel.getSelectedTableRows()) {
                UrfaHotspotClose urfaHotspotClose = new UrfaHotspotClose(UrfaManagerImpl.getInstance());
                urfaHotspotClose.setWebSessionId((String)map.get("web_sess_id"));
                urfaHotspotClose.setIP(Resolve.parse_ip((String)map.get("ip")));
                urfaHotspotClose.call();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

