/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.Inventory;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.UrfaInvocation;
import biz.netup.control.transport.urfa.functions.UrfaGetSwitchTypesList;
import biz.netup.control.transport.urfa.functions.UrfaGetSwitchesCount;
import biz.netup.control.transport.urfa.functions.UrfaGetSwitchesList;
import biz.netup.control.transport.urfa.functions.UrfaRemoveSwitch;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.custom.PagesPanel;
import biz.netup.projects.utmadmin.gui.mainframe.forms.Inventory.SwitchFrame;
import biz.netup.projects.utmadmin.gui.mainframe.forms.Inventory.SwitchSearchFrame;
import biz.netup.utmutils.control.permissions.Permissions;
import biz.netup.utmutils.control.trayicon.UTMTrayIcon;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;

public class SwitchesTab
extends TabPanelWithTable {
    private JButton searchButton;
    private PagesPanel pages;

    @Override
    public int getTabType() {
        return 1;
    }

    @Override
    public int getMode() {
        return 1;
    }

    @Override
    public String getTabName() {
        return "Switches";
    }

    @Override
    public String getGroupName() {
        return "Inventory";
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("id", "ID");
        linkedHashMap.put("name", "Name");
        return linkedHashMap;
    }

    public void addCount() {
        this.pages.updateCount(this.pages.getCount() + 1);
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        UrfaGetSwitchesList urfaGetSwitchesList = new UrfaGetSwitchesList(UrfaManagerImpl.getInstance());
        urfaGetSwitchesList.setCount(this.pages.getPerPageCount());
        urfaGetSwitchesList.setOffset(this.pages.getPerPageCount() * this.pages.getPage());
        urfaGetSwitchesList.call();
        int n = urfaGetSwitchesList.getSize();
        for (int i = 0; i < n; ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", urfaGetSwitchesList.getId1()[i]);
            hashMap.put("name", urfaGetSwitchesList.getName1()[i]);
            vector.add(hashMap);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
        int n = (Integer)map.get("id");
        UrfaRemoveSwitch urfaRemoveSwitch = new UrfaRemoveSwitch(UrfaManagerImpl.getInstance());
        urfaRemoveSwitch.setId(n);
        urfaRemoveSwitch.call();
        if (n != urfaRemoveSwitch.getId()) {
            Dialogs.showErrorDialog("cant delete switch. Maybe it is used");
            return;
        }
        UrfaManagerImpl urfaManagerImpl = UrfaManagerImpl.getInstance();
        if (!urfaManagerImpl.isPermitted(4451)) {
            Dialogs.showErrorDialog("You don't have permissions to edit switch-dhcp links");
            return;
        }
        UrfaInvocation urfaInvocation = urfaManagerImpl.startInvocation(4451);
        try {
            urfaInvocation.putInt(n);
            urfaInvocation.putInt(0);
            urfaInvocation.invoke();
        }
        finally {
            urfaInvocation.close();
        }
        this.pages.updateCount(this.pages.getCount() - 1);
    }

    @Override
    public DFModel getItemDialog(Map<String, Object> map) {
        return null;
    }

    public SwitchesTab() {
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/settings/NAS_list.png")));
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/settings/NAS_list_24.png")));
        this.setRefreshPermission(new int[]{4436, 4437});
        this.setAddPermission(new int[]{4433});
        this.setReadPermission(new int[]{4432});
        this.setEditPermission(new int[]{4435});
        this.setDeletePermission(new int[]{4434});
        final SwitchesTab switchesTab = this;
        this.pages = new PagesPanel(100, "Switches per page");
        this.pages.addListener(new PagesPanel.PageChangeListener(){

            @Override
            public void onPageChange(int n) {
                switchesTab.refresh();
            }
        });
        this.getPanel().add((Component)this.pages.getPanel(), "South");
        this.searchButton = new JButton();
        this.searchButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/find16.png")));
        this.searchButton.setText(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Search"));
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwitchSearchFrame switchSearchFrame = new SwitchSearchFrame();
                switchSearchFrame.setVisible(true);
            }
        });
        this.getAdditionalButtonPanel2().add(this.searchButton);
        if (Permissions.getInstance().isAvailable(new Integer[]{4437})) {
            try {
                UrfaGetSwitchesCount urfaGetSwitchesCount = new UrfaGetSwitchesCount(UrfaManagerImpl.getInstance());
                urfaGetSwitchesCount.call();
                int n = urfaGetSwitchesCount.getCount();
                if (n == -1) {
                    throw new UrfaException("cant get switches count");
                }
                this.pages.setCount(n);
            }
            catch (UrfaException urfaException) {
                Dialogs.showErrorDialog("cant set switches count");
            }
        }
    }

    @Override
    protected void edit() {
        final int n = (Integer)this.mainTablePanel.getSelectedTableRows()[0].get("id");
        final SwitchesTab switchesTab = this;
        Thread thread = new Thread(){

            @Override
            public void run() {
                UTMTrayIcon.getInstance().addProcess(this);
                SwitchFrame switchFrame = new SwitchFrame(n, switchesTab);
                UTMTrayIcon.getInstance().removeProcess(this);
                switchFrame.setVisible(true);
            }
        };
        thread.start();
    }

    @Override
    protected void add() {
        UrfaGetSwitchTypesList urfaGetSwitchTypesList = new UrfaGetSwitchTypesList(UrfaManagerImpl.getInstance());
        try {
            urfaGetSwitchTypesList.call();
        }
        catch (UrfaException urfaException) {
            Dialogs.showErrorDialog("cant get switch types");
            return;
        }
        if (urfaGetSwitchTypesList.getSize() == 0) {
            Dialogs.showErrorDialog("you need to add at least one switch type");
            return;
        }
        final SwitchesTab switchesTab = this;
        Thread thread = new Thread(){

            @Override
            public void run() {
                UTMTrayIcon.getInstance().addProcess(this);
                SwitchFrame switchFrame = new SwitchFrame(-1, switchesTab);
                UTMTrayIcon.getInstance().removeProcess(this);
                switchFrame.setVisible(true);
            }
        };
        thread.start();
    }

    @Override
    protected JMenuItem[] getMenuItems(Map<String, Object>[] mapArray) {
        return null;
    }
}

