/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.Inventory;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.UrfaInvocation;
import biz.netup.control.transport.urfa.functions.UrfaGetSwitchDhcpPoolLinks;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.Inventory.DhcpPoolsTab;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.swing.dialog.SelectFromTableDialogModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.tab.TabPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class SwitchesDhcpPoolLinks
extends TabPanel {
    private Set<Integer> dhcp_pools;
    private TablePanelImpl linksTablePanel;
    private JPanel mainPanel;
    private JButton deleteButton;
    private JButton addButton;
    private String groupName;
    private boolean isPermitted;
    private int switch_id = 0;
    private String switch_name;

    public SwitchesDhcpPoolLinks(String string) {
        this.groupName = string;
        this.dhcp_pools = new HashSet<Integer>();
        this.setupUI();
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DhcpPoolsTab dhcpPoolsTab = new DhcpPoolsTab();
                SelectFromTableDialogModel selectFromTableDialogModel = new SelectFromTableDialogModel(dhcpPoolsTab);
                selectFromTableDialogModel.setTitle(SwitchesDhcpPoolLinks.this.resource.getString(dhcpPoolsTab.getTabName()));
                selectFromTableDialogModel.setVisible(true);
                if (selectFromTableDialogModel.isOkPressed()) {
                    int n = (Integer)selectFromTableDialogModel.getItem().get("id");
                    if (SwitchesDhcpPoolLinks.this.dhcp_pools.contains(n)) {
                        Dialogs.showErrorDialog(SwitchesDhcpPoolLinks.this.resource.getString("This link already exists"));
                    } else {
                        String string = (String)selectFromTableDialogModel.getItem().get("name");
                        SwitchesDhcpPoolLinks.this.dhcp_pools.add(n);
                        MapTableModel mapTableModel = SwitchesDhcpPoolLinks.this.linksTablePanel.getTableModel();
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        hashMap.put("dhcp_pool_id", n);
                        hashMap.put("dhcp_pool_name", string);
                        mapTableModel.addRow(hashMap);
                    }
                }
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (Map<String, Object> map : SwitchesDhcpPoolLinks.this.linksTablePanel.getSelectedTableRows()) {
                    MapTableModel mapTableModel = SwitchesDhcpPoolLinks.this.linksTablePanel.getTableModel();
                    mapTableModel.removeRow(map);
                    int n = (Integer)map.get("dhcp_pool_id");
                    SwitchesDhcpPoolLinks.this.dhcp_pools.remove(n);
                }
            }
        });
        this.isPermitted = UrfaManagerImpl.getInstance().isPermitted(4448);
    }

    public void setId(int n) {
        this.switch_id = n;
    }

    public void setName(String string) {
        this.switch_name = string;
    }

    public void addToTabPanels(Vector<TabPanel> vector) {
        if (this.isPermitted) {
            vector.add(this);
        }
    }

    @Override
    public int getTabType() {
        return 4;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    protected void refreshTab() throws UrfaException {
        this.load();
    }

    @Override
    protected Component getMainPanel() {
        return this.mainPanel;
    }

    @Override
    public String getTabName() {
        return "DHCP POOL LINKS";
    }

    public Component getTab() {
        return this.mainPanel;
    }

    private void setupUI() {
        this.createUIComponents();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout(0, 0));
        this.mainPanel.add((Component)this.linksTablePanel, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.mainPanel.add((Component)jPanel, "North");
        this.deleteButton = new JButton();
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/delete16.png")));
        this.loadButtonText(this.deleteButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Delete"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.deleteButton, gridBagConstraints);
        this.addButton = new JButton();
        this.addButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/add16.png")));
        this.loadButtonText(this.addButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.addButton, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel6, gridBagConstraints);
    }

    private void loadButtonText(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private void createUIComponents() {
        this.linksTablePanel = new TablePanelImpl("DhcpPoolLinks", true);
        this.linksTablePanel.getTable().getTableHeader().setReorderingAllowed(false);
        this.linksTablePanel.setSortingEnabled(false);
        MapTableModel mapTableModel = this.linksTablePanel.getTableModel();
        mapTableModel.addColumn("dhcp_pool_id", "Dhcp_Pool_id", true, true);
        mapTableModel.addColumn("dhcp_pool_name", "Dhcp_Pool_Name", true, true);
        this.linksTablePanel.setEditable(true);
        this.linksTablePanel.setAppendable(false);
        this.linksTablePanel.setColumnsMenuEnabled(true);
        this.linksTablePanel.configureTable();
    }

    public void load() throws UrfaException {
        this.linksTablePanel.getTableModel().removeAllRows();
        this.dhcp_pools.clear();
        UrfaGetSwitchDhcpPoolLinks urfaGetSwitchDhcpPoolLinks = new UrfaGetSwitchDhcpPoolLinks(UrfaManagerImpl.getInstance());
        urfaGetSwitchDhcpPoolLinks.setSwitchId(this.switch_id);
        urfaGetSwitchDhcpPoolLinks.call();
        int n = urfaGetSwitchDhcpPoolLinks.getNumberPools();
        for (int i = 0; i < n; ++i) {
            int n2 = urfaGetSwitchDhcpPoolLinks.getPoolId()[i];
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("dhcp_pool_id", n2);
            String string = urfaGetSwitchDhcpPoolLinks.getNameOfPool(i);
            hashMap.put("dhcp_pool_name", string);
            this.dhcp_pools.add(n2);
            this.linksTablePanel.getTableModel().addRow(hashMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws UrfaException {
        if (!this.isPermitted) {
            return;
        }
        if (this.switch_id == 0) {
            return;
        }
        UrfaManagerImpl urfaManagerImpl = UrfaManagerImpl.getInstance();
        if (!urfaManagerImpl.isPermitted(4451)) {
            Dialogs.showErrorDialog("You don't have permissions to edit switch-dhcp links");
            return;
        }
        MapTableModel mapTableModel = this.linksTablePanel.getTableModel();
        int n = mapTableModel.getRowCount();
        UrfaInvocation urfaInvocation = urfaManagerImpl.startInvocation(4451);
        try {
            int n2;
            urfaInvocation.putInt(this.switch_id);
            urfaInvocation.putInt(n);
            for (n2 = 0; n2 < n; ++n2) {
                Map<String, Object> map = mapTableModel.getRow(n2);
                int n3 = (Integer)map.get("dhcp_pool_id");
                urfaInvocation.putInt(n3);
            }
            urfaInvocation.invoke();
            n2 = urfaInvocation.getInt();
            if (n2 != 0) {
                throw new UrfaException("Any link already exists");
            }
        }
        finally {
            urfaInvocation.close();
        }
    }
}

