/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.Inventory;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.projects.utmadmin.gui.userframe.UserFrame;
import biz.netup.utmutils.control.trayicon.UTMTrayIcon;
import biz.netup.utmutils.swing.tab.TabPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;

public class SwitchVisualInfo
extends TabPanel {
    private JPanel mainPanel;
    private JPanel PortsDetaisBorder;
    private JPanel PortsDetails;
    private JTextField usedPortsCntTf;
    private JTextField freePortsCntTf;
    private PortsTable portsTable;

    public SwitchVisualInfo() {
        this.$$$setupUI$$$();
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/inventory/rg45.png")));
        this.setBigIcon(null);
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.PortsDetaisBorder = new JPanel();
        this.PortsDetaisBorder.setLayout(new BorderLayout(0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.fill = 1;
        this.mainPanel.add((Component)this.PortsDetaisBorder, gridBagConstraints);
        this.PortsDetaisBorder.add((Component)this.PortsDetails, "Center");
        JPanel jPanel = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel3, gridBagConstraints);
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Used ports count"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel4, gridBagConstraints);
        this.usedPortsCntTf = new JTextField();
        this.usedPortsCntTf.setEditable(false);
        this.usedPortsCntTf.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.usedPortsCntTf, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel7, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Free ports count"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel2, gridBagConstraints);
        this.freePortsCntTf = new JTextField();
        this.freePortsCntTf.setEditable(false);
        this.freePortsCntTf.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.freePortsCntTf, gridBagConstraints);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private void createUIComponents() {
        this.portsTable = new PortsTable();
        this.PortsDetails = this.portsTable;
    }

    @Override
    public int getTabType() {
        return 4;
    }

    @Override
    public String getGroupName() {
        return "Switch";
    }

    @Override
    public String getTabName() {
        return "Port usage";
    }

    @Override
    protected Component getMainPanel() {
        return this.mainPanel;
    }

    public void updatePortsCount(int n) throws IllegalArgumentException {
        try {
            int n2 = n - this.portsTable.getPortsCount();
            this.portsTable.setPortsCount(n);
            if (!this.freePortsCntTf.getText().equals("")) {
                int n3 = Integer.parseInt(this.freePortsCntTf.getText());
                this.freePortsCntTf.setText("" + (n3 + n2));
            }
        }
        catch (Exception exception) {
            this.mainPanel.setEnabled(false);
        }
    }

    public void setData(Map<Integer, Vector<Map<String, Object>>> map, int n) {
        try {
            this.portsTable.setPortsCount(n);
            for (Map.Entry<Integer, Vector<Map<String, Object>>> entry : map.entrySet()) {
                this.portsTable.setPortInfo(entry.getKey(), entry.getValue());
            }
            this.freePortsCntTf.setText("" + (n - map.size()));
            this.usedPortsCntTf.setText("" + map.size());
        }
        catch (Exception exception) {
            this.mainPanel.setEnabled(false);
        }
    }

    @Override
    protected void refreshTab() throws UrfaException {
    }

    private class PortsTable
    extends JPanel {
        private Dimension ceilSize = new Dimension(20, 20);
        private Dimension minAreaSize;
        private Dimension maxAreaSize;
        private Dimension areaSize;
        private boolean dontDraw;
        private int portsCount;
        private Map<Integer, Vector<Map<String, Object>>> portsInfo;
        private PortInfo portInfo;
        Point mouseCoords;
        BufferedImage usedSwitchPortImg;
        BufferedImage freeSwitchPortImg;
        boolean dontDrawImages;

        public PortsTable() {
            this.minAreaSize = new Dimension(this.ceilSize.width * 24, this.ceilSize.height * 12);
            this.maxAreaSize = new Dimension(this.ceilSize.width * 24, this.ceilSize.height * 24);
            this.areaSize = this.minAreaSize;
            this.dontDraw = false;
            this.dontDrawImages = false;
            this.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    PortsTable.this.mouseCoords = mouseEvent.getPoint();
                }
            });
            this.portInfo = new PortInfo();
            this.add(this.portInfo);
            this.setComponentPopupMenu(this.portInfo);
            this.portsInfo = new HashMap<Integer, Vector<Map<String, Object>>>();
            try {
                URL uRL = this.getClass().getResource("/biz/netup/utmutils/swing/resourses/inventory/used_switch_port.png");
                this.usedSwitchPortImg = ImageIO.read(uRL);
                uRL = this.getClass().getResource("/biz/netup/utmutils/swing/resourses/inventory/free_switch_port.png");
                this.freeSwitchPortImg = ImageIO.read(uRL);
            }
            catch (IOException iOException) {
                this.dontDrawImages = true;
            }
        }

        private void AdjustCeilSize() throws IllegalArgumentException {
            int n;
            int n2;
            do {
                --this.ceilSize.width;
                --this.ceilSize.height;
                if (this.ceilSize.width != 0 && this.ceilSize.height != 0) continue;
                this.dontDraw = true;
                throw new IllegalArgumentException("Invalid ports count");
            } while ((n2 = this.areaSize.width / this.ceilSize.width) * (n = this.areaSize.height / this.ceilSize.height) < this.portsCount);
            this.areaSize.width = n2 * this.ceilSize.width;
            this.areaSize.height = n * this.ceilSize.height;
        }

        private boolean AdjustAreaSize() {
            int n;
            int n2;
            do {
                this.areaSize.width += this.ceilSize.width;
                if (this.areaSize.width <= this.maxAreaSize.width) continue;
                return false;
            } while ((n2 = this.areaSize.width / this.ceilSize.width) * (n = this.areaSize.height / this.ceilSize.height) < this.portsCount);
            this.areaSize.height = n * this.ceilSize.height;
            return true;
        }

        public void setPortsCount(int n) throws IllegalArgumentException {
            if (n < 0) {
                this.dontDraw = true;
                throw new IllegalArgumentException("invalid ports count");
            }
            this.portsCount = n;
            this.areaSize = this.minAreaSize;
            int n2 = this.areaSize.width / this.ceilSize.width;
            int n3 = n / n2 + 1;
            if (n3 * this.ceilSize.height > this.maxAreaSize.height) {
                if (!this.AdjustAreaSize()) {
                    this.AdjustCeilSize();
                }
            } else {
                this.areaSize.height = n3 * this.ceilSize.height;
            }
            this.setSize(this.areaSize);
        }

        public int getPortsCount() {
            return this.portsCount;
        }

        public void setPortInfo(int n, Vector<Map<String, Object>> vector) {
            this.portsInfo.put(n - 1, vector);
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            int n;
            int n2;
            int n3;
            FontMetrics fontMetrics;
            Font font;
            super.paintComponent(graphics);
            if (this.dontDraw) {
                return;
            }
            int n4 = 10;
            String string = this.portsCount + "";
            while (true) {
                if (n4 <= 0) {
                    n4 = 1;
                    break;
                }
                font = new Font("TimesRoman", 0, n4);
                fontMetrics = this.getGraphics().getFontMetrics(font);
                if (fontMetrics.stringWidth(string) <= this.ceilSize.width) break;
                --n4;
            }
            font = new Font("TimesRoman", 0, n4);
            fontMetrics = graphics.getFontMetrics(font);
            graphics.setFont(font);
            int n5 = this.areaSize.width / this.ceilSize.width;
            for (n3 = 0; n3 < this.portsCount; ++n3) {
                Object object;
                n2 = this.portsInfo.containsKey(n3);
                Point point = new Point(n3 % n5, n3 / n5);
                Point point2 = new Point(point.x * this.ceilSize.width, point.y * this.ceilSize.height);
                Color color = n2 != 0 ? Color.WHITE : new Color(220, 220, 220);
                color = color;
                if (this.dontDrawImages) {
                    object = n2 != 0 ? new Color(153, 255, 153) : Color.WHITE;
                    graphics.setColor((Color)object);
                    graphics.fillRect(point2.x, point2.y, this.ceilSize.width, this.ceilSize.height);
                } else {
                    object = n2 != 0 ? this.usedSwitchPortImg : this.freeSwitchPortImg;
                    double d = ((Image)object).getWidth(null);
                    double d2 = ((Image)object).getHeight(null);
                    double d3 = (double)this.ceilSize.width / d;
                    double d4 = (double)this.ceilSize.height / d2;
                    graphics.drawImage((Image)object, point2.x, point2.y, (int)(d * d3), (int)(d2 * d4), null);
                }
                object = "" + (n3 + 1);
                Dimension dimension = new Dimension(fontMetrics.stringWidth((String)object), fontMetrics.getHeight());
                int n6 = (this.ceilSize.width - dimension.width) / 2;
                int n7 = (this.ceilSize.height - dimension.height) / 2;
                graphics.setColor(color);
                graphics.drawString((String)object, point2.x + n6, point2.y + n7 + fontMetrics.getHeight() - 2);
            }
            graphics.setColor(new Color(220, 220, 220));
            n3 = (this.portsCount - 1) / n5 + 2;
            n2 = this.ceilSize.width * n5;
            for (n = 0; n < n3; ++n) {
                int n8 = n * this.ceilSize.height;
                graphics.drawLine(0, n8, n2, n8);
            }
            n = n5 + 1;
            int n9 = this.ceilSize.height * (n3 - 1);
            for (int i = 0; i < n; ++i) {
                int n10 = i * this.ceilSize.width;
                graphics.drawLine(n10, 0, n10, n9);
            }
        }

        private class PortInfo
        extends JPopupMenu {
            private PortInfo() {
            }

            @Override
            public void setVisible(boolean bl) {
                if (bl) {
                    if (PortsTable.this.mouseCoords.getX() < 0.0 || PortsTable.this.mouseCoords.getX() > (double)((PortsTable)PortsTable.this).areaSize.width || PortsTable.this.mouseCoords.getY() < 0.0 || PortsTable.this.mouseCoords.getY() > (double)((PortsTable)PortsTable.this).areaSize.height) {
                        super.setVisible(false);
                        return;
                    }
                    int n = ((PortsTable)PortsTable.this).areaSize.width / ((PortsTable)PortsTable.this).ceilSize.width;
                    int n2 = (int)PortsTable.this.mouseCoords.getX() / ((PortsTable)PortsTable.this).ceilSize.width;
                    int n3 = (int)PortsTable.this.mouseCoords.getY() / ((PortsTable)PortsTable.this).ceilSize.height;
                    int n4 = n3 * n + n2;
                    if (!PortsTable.this.portsInfo.containsKey(n4)) {
                        super.setVisible(false);
                        return;
                    }
                    this.removeAll();
                    Vector vector = (Vector)PortsTable.this.portsInfo.get(n4);
                    for (int i = 0; i < vector.size(); ++i) {
                        final Map map = (Map)vector.get(i);
                        JMenuItem jMenuItem = new JMenuItem(map.get("login").toString());
                        jMenuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                Thread thread = new Thread(){

                                    @Override
                                    public void run() {
                                        UTMTrayIcon.getInstance().addProcess(this, "Dialog - " + SwitchVisualInfo.this.resource.getString("User"));
                                        UserFrame userFrame = new UserFrame((Integer)map.get("id"));
                                        UTMTrayIcon.getInstance().removeProcess(this);
                                        userFrame.setVisible(true);
                                    }
                                };
                                thread.start();
                            }
                        });
                        this.add(jMenuItem);
                    }
                    super.setVisible(true);
                } else {
                    super.setVisible(bl);
                }
            }
        }
    }
}

