/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.Inventory;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetLeasesList;
import biz.netup.control.transport.urfa.functions.UrfaMakeLeaseExpired;
import biz.netup.control.transport.urfa.functions.UrfaRemoveLease;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class LeasesTab
extends TabPanelWithTable {
    private JButton makeExpiredButton;
    private JButton dropButton;

    @Override
    protected boolean useFilter() {
        return true;
    }

    @Override
    public int getTabType() {
        return 1;
    }

    @Override
    public int getMode() {
        return 2;
    }

    @Override
    public String getTabName() {
        return "DHCP lease";
    }

    @Override
    public String getGroupName() {
        return "Inventory";
    }

    public LeasesTab() {
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/settings/IP_pools.png")));
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/settings/IP_pools_24.png")));
        this.setRefreshPermission(new int[]{4944});
        final LeasesTab leasesTab = this;
        this.makeExpiredButton = new JButton();
        this.makeExpiredButton.setText(this.resource.getString("Make expired"));
        this.makeExpiredButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Map<String, Object>[] mapArray = LeasesTab.this.getMainTablePanel().getSelectedTableRows();
                for (int i = 0; i < mapArray.length; ++i) {
                    UrfaMakeLeaseExpired urfaMakeLeaseExpired = new UrfaMakeLeaseExpired(UrfaManagerImpl.getInstance());
                    try {
                        urfaMakeLeaseExpired.setId((Integer)mapArray[i].get("id"));
                        urfaMakeLeaseExpired.call();
                        leasesTab.refresh();
                        continue;
                    }
                    catch (UrfaException urfaException) {
                        Dialogs.showErrorDialog("cant make expired");
                    }
                }
            }
        });
        if (!UrfaManagerImpl.getInstance().isPermitted(new int[]{4945})) {
            this.makeExpiredButton.setEnabled(true);
        }
        this.dropButton = new JButton();
        this.dropButton.setText(this.resource.getString("Drop"));
        this.dropButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Dialogs.showYesNoDialog(LeasesTab.this.resource.getString("delete_warn") + " \"" + LeasesTab.this.resource.getString(LeasesTab.this.getTabName()) + "\"?")) {
                    Map<String, Object>[] mapArray = LeasesTab.this.getMainTablePanel().getSelectedTableRows();
                    for (int i = 0; i < mapArray.length; ++i) {
                        UrfaRemoveLease urfaRemoveLease = new UrfaRemoveLease(UrfaManagerImpl.getInstance());
                        try {
                            urfaRemoveLease.setId((Integer)mapArray[i].get("id"));
                            urfaRemoveLease.call();
                            leasesTab.refresh();
                            continue;
                        }
                        catch (UrfaException urfaException) {
                            Dialogs.showErrorDialog("cant delete");
                        }
                    }
                }
            }
        });
        if (!UrfaManagerImpl.getInstance().isPermitted(new int[]{4946})) {
            this.makeExpiredButton.setEnabled(true);
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.makeExpiredButton, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.dropButton, gridBagConstraints);
        this.getAdditionalButtonPanel2().add(jPanel);
        ValidateCellRenderer validateCellRenderer = new ValidateCellRenderer(this);
        this.getMainTablePanel().setCellRenderer("id", validateCellRenderer);
        this.getMainTablePanel().setCellRenderer("value", validateCellRenderer);
        this.getMainTablePanel().setCellRenderer("ip", validateCellRenderer);
        this.getMainTablePanel().setCellRenderer("mac", validateCellRenderer);
        this.getMainTablePanel().setCellRenderer("server_id", validateCellRenderer);
        this.getMainTablePanel().setCellRenderer("client_id", validateCellRenderer);
        this.getMainTablePanel().setCellRenderer("expired", validateCellRenderer);
        this.getMainTablePanel().setCellRenderer("updated", validateCellRenderer);
        this.getMainTablePanel().setCellRenderer("flags", validateCellRenderer);
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("id", "ID");
        linkedHashMap.put("ip", "IP");
        linkedHashMap.put("mac", "MAC");
        linkedHashMap.put("server_id", "Server id");
        linkedHashMap.put("client_id", "Client id");
        linkedHashMap.put("expired", "Expired");
        linkedHashMap.put("updated", "Updated");
        linkedHashMap.put("flags", "Flags");
        return linkedHashMap;
    }

    private String flag_to_string(Integer n) {
        String string = "Static";
        if ((n & 3) != 0) {
            string = "Dynamic";
        }
        if ((n & 4) != 0) {
            string = string + ",Modified";
        }
        return string;
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        UrfaGetLeasesList urfaGetLeasesList = new UrfaGetLeasesList(UrfaManagerImpl.getInstance());
        urfaGetLeasesList.call();
        int n = urfaGetLeasesList.getSize();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        for (int i = 0; i < n; ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", urfaGetLeasesList.getId1()[i]);
            hashMap.put("ip", urfaGetLeasesList.getIp1()[i].getHostAddress().toString());
            hashMap.put("mac", urfaGetLeasesList.getMac1()[i]);
            hashMap.put("server_id", urfaGetLeasesList.getServerId1()[i]);
            hashMap.put("client_id", urfaGetLeasesList.getClientId1()[i]);
            hashMap.put("expired", simpleDateFormat.format(new Date((long)urfaGetLeasesList.getExpired1()[i] * 1000L)));
            hashMap.put("updated", simpleDateFormat.format(new Date((long)urfaGetLeasesList.getUpdated1()[i] * 1000L)));
            hashMap.put("flags", this.flag_to_string(urfaGetLeasesList.getFlags1()[i]));
            hashMap.put("expired_unix_time", (long)urfaGetLeasesList.getExpired1()[i] * 1000L);
            vector.add(hashMap);
        }
        return vector;
    }

    @Override
    public DFModel getItemDialog(Map<String, Object> map) {
        return null;
    }

    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
    }

    class ValidateCellRenderer
    extends DefaultTableCellRenderer {
        private LeasesTab leasesTab;

        public ValidateCellRenderer(LeasesTab leasesTab2) {
            this.leasesTab = leasesTab2;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Date date;
            Date date2 = new Date((Long)this.leasesTab.getMainTablePanel().getTableModel().getRow(n).get("expired_unix_time"));
            super.setBackground(date2.before(date = new Date()) ? new Color(255, 204, 204) : Color.WHITE);
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        @Override
        public void setBackground(Color color) {
        }

        @Override
        public void setForeground(Color color) {
        }
    }
}

