/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.dealerframe.forms.permissions;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.projects.utmadmin.functions.dealer.dealer.permissions.PermissionFunctions;
import biz.netup.swing.table.CheckboxCellEditor;
import biz.netup.swing.table.CheckboxCellRenderer;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.TablePanelAdapter;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.swing.tab.TabPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class DealerDiscountPeriodPermissionsTab
extends TabPanel {
    private JPanel panel;
    private TablePanelImpl dpTablePanel;
    private int did;

    @Override
    public int getTabType() {
        return 3;
    }

    @Override
    public String getGroupName() {
        return "Permissions";
    }

    @Override
    public String getTabName() {
        return "Permissions over periods";
    }

    @Override
    protected void refreshTab() throws UrfaException {
    }

    @Override
    protected Component getMainPanel() {
        return this.panel;
    }

    public DealerDiscountPeriodPermissionsTab(int n) {
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/dealer/accounting_periods_24.png")));
        this.$$$setupUI$$$();
        this.did = n;
    }

    @Override
    protected void init() {
        super.init();
        this.refreshTable();
    }

    private void createUIComponents() {
        this.createTable();
    }

    private void refreshTable() {
        this.dpTablePanel.getTableModel().removeAllRows();
        for (Map<String, Object> map : PermissionFunctions.getDPPerms(this.did)) {
            this.dpTablePanel.getTableModel().addRow(map);
        }
    }

    private void createTable() {
        this.dpTablePanel = new TablePanelImpl(this.getClass().getName() + "_userperms", true);
        MapTableModel mapTableModel = this.dpTablePanel.getTableModel();
        mapTableModel.addColumn("id", "ID", true, false);
        mapTableModel.addColumn("static_id", "Static ID", true, false);
        mapTableModel.addColumn("start_date", "Start date", true, false);
        mapTableModel.addColumn("end_date", "End date", true, false);
        mapTableModel.addColumn("type", "Type", true, false);
        mapTableModel.addColumn("check", "Permissions granted", true, true);
        this.dpTablePanel.setEditable(true);
        this.dpTablePanel.setAppendable(false);
        this.dpTablePanel.setTablePanelListener(new TablePanelAdapter(){

            @Override
            public JMenuItem[] getTableContextMenuItems(Map<String, Object>[] mapArray) {
                JMenuItem jMenuItem = new JMenuItem(DealerDiscountPeriodPermissionsTab.this.resource.getString("Refresh"));
                JMenuItem jMenuItem2 = new JMenuItem(DealerDiscountPeriodPermissionsTab.this.resource.getString("Check"));
                JMenuItem jMenuItem3 = new JMenuItem(DealerDiscountPeriodPermissionsTab.this.resource.getString("Uncheck"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DealerDiscountPeriodPermissionsTab.this.refreshTable();
                    }
                });
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DealerDiscountPeriodPermissionsTab.this.check();
                    }
                });
                jMenuItem3.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DealerDiscountPeriodPermissionsTab.this.uncheck();
                    }
                });
                if (mapArray.length < 1) {
                    return new JMenuItem[]{jMenuItem};
                }
                if (mapArray.length > 1) {
                    return new JMenuItem[]{jMenuItem2, jMenuItem3, jMenuItem};
                }
                Map<String, Object> map = mapArray[0];
                Integer n = (Integer)map.get("check");
                ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
                if (null != n && n == 0) {
                    arrayList.add(jMenuItem2);
                }
                if (null != n && n == 1) {
                    arrayList.add(jMenuItem3);
                }
                arrayList.add(jMenuItem);
                return arrayList.toArray(new JMenuItem[arrayList.size()]);
            }

            @Override
            public void performTableRowDoubleClicked(Map<String, Object> map) {
                Integer n = (Integer)map.get("check");
                ArrayList arrayList = new ArrayList();
                if (null != n && n == 0) {
                    DealerDiscountPeriodPermissionsTab.this.check();
                }
                if (null != n && n != 0) {
                    DealerDiscountPeriodPermissionsTab.this.uncheck();
                }
            }

            @Override
            public void performSelectionChanged(Map<String, Object>[] mapArray) {
            }

            @Override
            public void performRowModified(Map<String, Object> map) {
                map.put("X-STATUS", null);
                PermissionFunctions.changePerm(DealerDiscountPeriodPermissionsTab.this.did, 4, new int[]{(Integer)map.get("static_id")}, (Integer)map.get("check"));
            }

            @Override
            public void performColumnVisibilityChanged(String string, boolean bl) {
            }
        });
        this.dpTablePanel.applyTableSettings();
        this.dpTablePanel.setCellRenderer("check", new CheckboxCellRenderer());
        this.dpTablePanel.setCellEditor("check", new CheckboxCellEditor());
    }

    private void check() {
        for (Map<String, Object> map : this.dpTablePanel.getSelectedTableRows()) {
            map.put("check", 1);
            PermissionFunctions.changePerm(this.did, 4, new int[]{(Integer)map.get("static_id")}, (Integer)map.get("check"));
            this.dpTablePanel.getTableModel().fireTableDataChanged();
        }
    }

    private void uncheck() {
        for (Map<String, Object> map : this.dpTablePanel.getSelectedTableRows()) {
            map.put("check", 0);
            PermissionFunctions.changePerm(this.did, 4, new int[]{(Integer)map.get("static_id")}, (Integer)map.get("check"));
            this.dpTablePanel.getTableModel().fireTableDataChanged();
        }
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout(0, 0));
        this.panel.add((Component)this.dpTablePanel, "Center");
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

