/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.custom.subnet;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialog.DialogModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SubnetDialog
extends DialogModel {
    private JPanel mPanel;
    private JTextField networkTextField;
    private JTextField gatewayTextField;
    private boolean listenersSet = false;

    public SubnetDialog() {
        this.$$$setupUI$$$();
    }

    public SubnetDialog(Map<String, Object> map) {
        super(map);
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        return this.mPanel;
    }

    @Override
    public String getItemName() {
        return "Subnet";
    }

    @Override
    protected void loadInfo() throws UrfaException {
        if (!this.isAddMode()) {
            this.networkTextField.setText((String)this.item.get("network"));
            this.gatewayTextField.setText((String)this.item.get("gateway"));
        }
    }

    @Override
    protected void saveInfo() throws UrfaException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("network", this.networkTextField.getText());
        hashMap.put("gateway", this.gatewayTextField.getText());
        try {
            hashMap.put("network_ip", this.networkTextField.getText());
            hashMap.put("gateway_ip", this.gatewayTextField.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setItem(hashMap);
    }

    protected void checkIpRange(JTextField jTextField, String string) throws IllegalArgumentException {
        jTextField.setBackground(Color.WHITE);
        try {
            Resolve.getIpAddressWithMask(jTextField.getText());
            if (jTextField.getText().isEmpty()) {
                throw new IllegalArgumentException("field is empty");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string2 = this.resource.getString(string) + " " + this.resource.getString("field is invalid");
            jTextField.requestFocus();
            jTextField.setBackground(new Color(255, 204, 204));
            this.log.log(1, string2);
            throw illegalArgumentException;
        }
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
        if (!this.listenersSet) {
            Vector<JTextField> vector = new Vector<JTextField>();
            vector.add(this.networkTextField);
            vector.add(this.gatewayTextField);
            this.SetIetAddressValidator(this.networkTextField, vector);
            this.SetIetAddressValidator(this.gatewayTextField, vector);
            this.listenersSet = true;
        } else {
            this.checkIpRange(this.networkTextField, "Network");
        }
    }

    private void $$$setupUI$$$() {
        this.mPanel = new JPanel();
        this.mPanel.setLayout(new GridBagLayout());
        this.mPanel.setMinimumSize(new Dimension(240, 90));
        this.mPanel.setPreferredSize(new Dimension(240, 90));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Network"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mPanel.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Gateway"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mPanel.add((Component)jLabel2, gridBagConstraints);
        JPanel jPanel = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.mPanel.add((Component)jPanel, gridBagConstraints);
        this.networkTextField = new JTextField();
        this.networkTextField.setText("0.0.0.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 75;
        this.mPanel.add((Component)this.networkTextField, gridBagConstraints);
        this.gatewayTextField = new JTextField();
        this.gatewayTextField.setText("0.0.0.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 75;
        this.mPanel.add((Component)this.gatewayTextField, gridBagConstraints);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.mPanel;
    }
}

