/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.custom.newpayment;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetCurrencyList;
import biz.netup.control.transport.urfa.functions.UrfaGetAccountExternalId;
import biz.netup.control.transport.urfa.functions.UrfaGetCurrencyList;
import biz.netup.control.transport.urfa.functions.UrfaGetSetting;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.dealer.custom.PaymentsFunctions;
import biz.netup.projects.utmadmin.functions.dealer.user.doc.DocFunctions;
import biz.netup.projects.utmadmin.functions.dealer.user.user.UserFunctions;
import biz.netup.projects.utmadmin.functions.objects.Payment;
import biz.netup.projects.utmadmin.functions.objects.PaymentMethod;
import biz.netup.projects.utmadmin.functions.objects.UTMUser;
import biz.netup.projects.utmadmin.gui.custom.newpayment.Invoices;
import biz.netup.projects.utmadmin.gui.mainframe.MainFrame;
import biz.netup.swing.datetime.JDateTime;
import biz.netup.utmutils.control.Logger;
import biz.netup.utmutils.control.Settings;
import biz.netup.utmutils.control.TZ;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.permissions.Permissions;
import biz.netup.utmutils.swing.dialog.SelectFromTableDialogModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class NewPaymentDialog
extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JTextField loginTextField;
    private JCheckBox switchInternetOnCheckBox;
    private JComboBox accountComboBox;
    private JTextField sumTextField;
    private JComboBox currencyComboBox;
    private JTextField commentForAdministratorTextField;
    private JTextField commentForUserTextField;
    private JTextField paymentDocumentNumberTextField;
    private JComboBox paymentMethodComboBox;
    private JDateTime paymentDateDate;
    private JDateTime expireOnDate;
    private JTextField paymentToInvoiceTextField;
    private JButton cancelButton;
    private JButton selectButton;
    private JCheckBox writeOutAReceiptCheckBox;
    private JCheckBox sendEmailNotificationCheckBox;
    private JPanel adminPanel;
    private int uid;
    private int aid;
    private boolean isPaymentToInvoice = false;
    private Map<String, Integer> accountMap = new HashMap<String, Integer>();
    Logger log = Utils.getLogger();
    UTMUser user;
    PaymentMethod[] paymentMethodList;
    boolean okPressed = false;
    private Map<Integer, String> currencyMap;

    public NewPaymentDialog(int n, int n2) {
        this.uid = n;
        this.aid = n2;
        this.$$$setupUI$$$();
        if (!Utils.isAdmin()) {
            this.adminPanel.setVisible(false);
        } else {
            Permissions.apply(this.writeOutAReceiptCheckBox, "generate_doc");
            Permissions.apply((JComponent)this.selectButton, "payment_for_invoice");
            Permissions.apply((JComponent)this.cancelButton, "payment_for_invoice");
        }
        URL uRL = this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/logo32.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        if (Utils.isAdmin()) {
            this.setSize(500, 490);
        } else {
            this.setSize(500, 390);
        }
        this.setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.setTitle(Utils.getResource().getString("New payment"));
        this.setIconImage(imageIcon.getImage());
        this.fillFields();
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewPaymentDialog.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewPaymentDialog.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                NewPaymentDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewPaymentDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewPaymentDialog.this.selectInvoice();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewPaymentDialog.this.paymentToInvoiceTextField.setText("");
                NewPaymentDialog.this.accountComboBox.setEnabled(true);
                NewPaymentDialog.this.sumTextField.setText("");
                NewPaymentDialog.this.sumTextField.setEnabled(true);
                NewPaymentDialog.this.currencyComboBox.setEnabled(true);
            }
        });
        this.switchInternetOnCheckBox.setSelected("0".compareToIgnoreCase(Settings.getValueFromPerst("TurnInternetOn")) != 0);
    }

    private void selectInvoice() {
        SelectFromTableDialogModel selectFromTableDialogModel = new SelectFromTableDialogModel(new Invoices(this.uid, this.aid));
        selectFromTableDialogModel.setVisible(true);
        if (selectFromTableDialogModel.isOkPressed()) {
            this.paymentToInvoiceTextField.setText("" + selectFromTableDialogModel.getItem().get("invoice_number"));
            this.accountComboBox.setEnabled(false);
            this.sumTextField.setText("" + selectFromTableDialogModel.getItem().get("sum_in_currency"));
            this.sumTextField.setEditable(false);
            this.currencyComboBox.setSelectedItem(selectFromTableDialogModel.getItem().get("currency"));
            this.currencyComboBox.setEnabled(false);
        }
    }

    public void setPaidToInvoice(int n) {
        Invoices invoices = new Invoices(this.uid, this.aid);
        try {
            Vector<Map<String, Object>> vector = invoices.setTableData();
            for (Map<String, Object> map : vector) {
                if (!map.get("invoice_number").equals(n)) continue;
                this.paymentToInvoiceTextField.setText("" + map.get("invoice_number"));
                this.accountComboBox.setEnabled(false);
                this.sumTextField.setText("" + map.get("sum_in_currency"));
                this.sumTextField.setEditable(false);
                this.currencyComboBox.setSelectedItem(map.get("currency"));
                this.currencyComboBox.setEnabled(false);
            }
        }
        catch (UrfaException urfaException) {
            // empty catch block
        }
    }

    private void fillFields() {
        try {
            this.user = UserFunctions.getUser(this.uid);
            this.loginTextField.setText(this.user.getLogin());
            for (int n : this.user.getAccountIdArray1()) {
                String missingResourceException = "";
                if (Utils.isAdmin()) {
                    UrfaGetAccountExternalId urfaGetAccountExternalId = new UrfaGetAccountExternalId(UrfaManagerImpl.getInstance());
                    urfaGetAccountExternalId.setAid(n);
                    urfaGetAccountExternalId.call();
                    missingResourceException = urfaGetAccountExternalId.getExternalId();
                }
                if (missingResourceException.isEmpty()) {
                    this.accountMap.put("" + n, n);
                    this.accountComboBox.addItem("" + n);
                    if (this.aid != n) continue;
                    this.accountComboBox.setSelectedItem("" + n);
                    continue;
                }
                this.accountMap.put(n + " (" + missingResourceException + ")", n);
                this.accountComboBox.addItem(n + " (" + missingResourceException + ")");
                if (this.aid != n) continue;
                this.accountComboBox.setSelectedItem(n + " (" + missingResourceException + ")");
            }
            this.fillComboBoxes();
            for (PaymentMethod paymentMethod : this.paymentMethodList = PaymentsFunctions.getPMList()) {
                try {
                    this.paymentMethodComboBox.addItem(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString(paymentMethod.getName()));
                }
                catch (MissingResourceException missingResourceException) {
                    this.paymentMethodComboBox.addItem(paymentMethod.getName());
                }
            }
        }
        catch (UrfaException urfaException) {
            this.log.log(1, urfaException.getMessage());
        }
        if (Utils.isAdmin()) {
            this.selectDefaulCurrency();
        }
    }

    private void selectDefaulCurrency() {
        if (UrfaManagerImpl.getInstance().isPermitted(17412)) {
            UrfaGetSetting urfaGetSetting = new UrfaGetSetting(UrfaManagerImpl.getInstance());
            urfaGetSetting.setVariable("system_currency");
            try {
                urfaGetSetting.call();
                if (urfaGetSetting.getValuesCount() > 0) {
                    this.currencyComboBox.setSelectedItem(this.currencyMap.get(Integer.parseInt(urfaGetSetting.getValue()[0])));
                }
            }
            catch (UrfaException urfaException) {
                // empty catch block
            }
        }
    }

    private void fillComboBoxes() throws UrfaException {
        if (Utils.isAdmin()) {
            UrfaGetCurrencyList urfaGetCurrencyList = new UrfaGetCurrencyList(UrfaManagerImpl.getInstance());
            urfaGetCurrencyList.call();
            this.currencyMap = new HashMap<Integer, String>();
            this.currencyComboBox.removeAllItems();
            for (int i = 0; i < urfaGetCurrencyList.getCurrencySize(); ++i) {
                this.currencyMap.put(urfaGetCurrencyList.getId1()[i], urfaGetCurrencyList.getCurrencyBriefName1()[i]);
                this.currencyComboBox.addItem(urfaGetCurrencyList.getCurrencyBriefName1()[i]);
            }
        } else {
            UrfaDealerGetCurrencyList urfaDealerGetCurrencyList = new UrfaDealerGetCurrencyList(UrfaManagerImpl.getInstance());
            urfaDealerGetCurrencyList.call();
            this.currencyMap = new HashMap<Integer, String>();
            this.currencyComboBox.removeAllItems();
            for (int i = 0; i < urfaDealerGetCurrencyList.getCurrencySize(); ++i) {
                this.currencyMap.put(urfaDealerGetCurrencyList.getId1()[i], urfaDealerGetCurrencyList.getCurrencyBriefName1()[i]);
                this.currencyComboBox.addItem(urfaDealerGetCurrencyList.getCurrencyBriefName1()[i]);
            }
        }
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    private void onOK() {
        this.okPressed = true;
        Payment payment = new Payment();
        payment.setAccountId(this.accountMap.get(this.accountComboBox.getSelectedItem()));
        payment.setAdminComment(this.commentForAdministratorTextField.getText());
        if (this.expireOnDate.getInfinityComboBox()) {
            payment.setBurnDate(0);
        } else {
            payment.setBurnDate((int)(this.expireOnDate.getDate().getTime() / 1000L));
        }
        payment.setComment(this.commentForUserTextField.getText());
        for (int n : this.currencyMap.keySet()) {
            if (!this.currencyComboBox.getSelectedItem().equals(this.currencyMap.get(n))) continue;
            payment.setCurrencyId(n);
        }
        try {
            payment.setPayment(Double.parseDouble(this.sumTextField.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            Dialogs.showErrorDialog("Incorrect payment value");
            this.sumTextField.requestFocus();
            return;
        }
        payment.setPaymentDate((int)(this.paymentDateDate.getDate().getTime() / 1000L));
        payment.setPaymentExtNumber(this.paymentDocumentNumberTextField.getText());
        if (this.paymentMethodList[this.paymentMethodComboBox.getSelectedIndex()].getId() == 7) {
            if (this.expireOnDate.getDate().getTime() <= this.paymentDateDate.getDate().getTime()) {
                Dialogs.showErrorDialog("Expire date must be after payment date");
                return;
            }
            if (this.expireOnDate.getDate().getTime() == 2000000000000L) {
                Dialogs.showErrorDialog("Select correct expire date");
                return;
            }
        }
        payment.setPaymentMethod(this.paymentMethodList[this.paymentMethodComboBox.getSelectedIndex()].getId());
        payment.setPaymentToInvoice(this.isPaymentToInvoice ? 1 : 0);
        payment.setTurnOnInet(this.switchInternetOnCheckBox.isSelected() ? 1 : 0);
        if (Utils.isAdmin()) {
            payment.setSendToEmail(this.sendEmailNotificationCheckBox.isSelected());
            if (!this.paymentToInvoiceTextField.getText().isEmpty()) {
                payment.setPaymentToInvoice(Integer.parseInt(this.paymentToInvoiceTextField.getText()));
            }
        }
        int n = PaymentsFunctions.newPayment(payment);
        MainFrame.getInstance().refreshUsers();
        this.dispose();
        if (this.writeOutAReceiptCheckBox.isSelected() && n > 0) {
            this.receipt(n);
        }
    }

    private void receipt(int n) {
        try {
            DocFunctions.openDocument(this.uid, 5, n);
        }
        catch (UrfaException urfaException) {
            this.log.error(urfaException);
        }
    }

    private void onCancel() {
        this.dispose();
    }

    private void createUIComponents() {
        this.paymentDateDate = new JDateTime();
        this.paymentDateDate.setDate(TZ.getCoreTime());
        this.expireOnDate = new JDateTime();
        this.expireOnDate.setDate(new Date(2000000000000L));
        this.expireOnDate.setInfinity(true);
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new GridBagLayout());
        this.contentPane.setMinimumSize(new Dimension(477, 490));
        this.contentPane.setPreferredSize(new Dimension(477, 490));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.contentPane.add((Component)jPanel, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Payment details")));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Login"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Payment document number"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Payment method"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel3, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Expire on"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel4, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Payment date"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel5, gridBagConstraints);
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Sum"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel6, gridBagConstraints);
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Account"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel7, gridBagConstraints);
        this.loginTextField = new JTextField();
        this.loginTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.loginTextField, gridBagConstraints);
        this.switchInternetOnCheckBox = new JCheckBox();
        this.switchInternetOnCheckBox.setSelected(false);
        this.$$$loadButtonText$$$(this.switchInternetOnCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Switch Internet on"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.switchInternetOnCheckBox, gridBagConstraints);
        this.accountComboBox = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.accountComboBox, gridBagConstraints);
        this.sumTextField = new JTextField();
        this.sumTextField.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.sumTextField, gridBagConstraints);
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Currency"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jLabel8, gridBagConstraints);
        this.currencyComboBox = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.currencyComboBox, gridBagConstraints);
        this.paymentDocumentNumberTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.paymentDocumentNumberTextField, gridBagConstraints);
        this.paymentMethodComboBox = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.paymentMethodComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.paymentDateDate, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.expireOnDate, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel8, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel9, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel10, gridBagConstraints);
        this.writeOutAReceiptCheckBox = new JCheckBox();
        this.writeOutAReceiptCheckBox.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.writeOutAReceiptCheckBox, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel11, gridBagConstraints);
        JLabel jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Write out a receipt"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel9, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel12, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel13, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel14, gridBagConstraints);
        JPanel jPanel15 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.contentPane.add((Component)jPanel15, gridBagConstraints);
        JPanel jPanel16 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.contentPane.add((Component)jPanel16, gridBagConstraints);
        JPanel jPanel17 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.contentPane.add((Component)jPanel17, gridBagConstraints);
        JPanel jPanel18 = new JPanel();
        jPanel18.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.contentPane.add((Component)jPanel18, gridBagConstraints);
        JPanel jPanel19 = new JPanel();
        jPanel19.setLayout(new GridBagLayout());
        jPanel18.add((Component)jPanel19, "East");
        this.buttonOK = new JButton();
        this.buttonOK.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/ok16.png")));
        this.buttonOK.setText("OK");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel19.add((Component)this.buttonOK, gridBagConstraints);
        this.buttonCancel = new JButton();
        this.buttonCancel.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/cancel16.png")));
        this.$$$loadButtonText$$$(this.buttonCancel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Cancel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel19.add((Component)this.buttonCancel, gridBagConstraints);
        JPanel jPanel20 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        jPanel19.add((Component)jPanel20, gridBagConstraints);
        JPanel jPanel21 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        jPanel19.add((Component)jPanel21, gridBagConstraints);
        JPanel jPanel22 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel19.add((Component)jPanel22, gridBagConstraints);
        this.adminPanel = new JPanel();
        this.adminPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.contentPane.add((Component)this.adminPanel, gridBagConstraints);
        this.adminPanel.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Bill")));
        JLabel jLabel10 = new JLabel();
        this.$$$loadLabelText$$$(jLabel10, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Payment to invoice"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.adminPanel.add((Component)jLabel10, gridBagConstraints);
        this.paymentToInvoiceTextField = new JTextField();
        this.paymentToInvoiceTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.adminPanel.add((Component)this.paymentToInvoiceTextField, gridBagConstraints);
        this.cancelButton = new JButton();
        this.$$$loadButtonText$$$(this.cancelButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Cancel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.adminPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.selectButton = new JButton();
        this.$$$loadButtonText$$$(this.selectButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Select"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.adminPanel.add((Component)this.selectButton, gridBagConstraints);
        JPanel jPanel23 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.adminPanel.add((Component)jPanel23, gridBagConstraints);
        JPanel jPanel24 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.adminPanel.add((Component)jPanel24, gridBagConstraints);
        JPanel jPanel25 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.adminPanel.add((Component)jPanel25, gridBagConstraints);
        JPanel jPanel26 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.adminPanel.add((Component)jPanel26, gridBagConstraints);
        JPanel jPanel27 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.adminPanel.add((Component)jPanel27, gridBagConstraints);
        this.sendEmailNotificationCheckBox = new JCheckBox();
        this.sendEmailNotificationCheckBox.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.adminPanel.add((Component)this.sendEmailNotificationCheckBox, gridBagConstraints);
        JLabel jLabel11 = new JLabel();
        this.$$$loadLabelText$$$(jLabel11, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Send email notification"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.adminPanel.add((Component)jLabel11, gridBagConstraints);
        JPanel jPanel28 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.adminPanel.add((Component)jPanel28, gridBagConstraints);
        JPanel jPanel29 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.adminPanel.add((Component)jPanel29, gridBagConstraints);
        JPanel jPanel30 = new JPanel();
        jPanel30.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.contentPane.add((Component)jPanel30, gridBagConstraints);
        jPanel30.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Comment")));
        this.commentForAdministratorTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel30.add((Component)this.commentForAdministratorTextField, gridBagConstraints);
        JPanel jPanel31 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel30.add((Component)jPanel31, gridBagConstraints);
        JPanel jPanel32 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel30.add((Component)jPanel32, gridBagConstraints);
        JLabel jLabel12 = new JLabel();
        this.$$$loadLabelText$$$(jLabel12, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Comment for administrator"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel30.add((Component)jLabel12, gridBagConstraints);
        JPanel jPanel33 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel30.add((Component)jPanel33, gridBagConstraints);
        this.commentForUserTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel30.add((Component)this.commentForUserTextField, gridBagConstraints);
        JLabel jLabel13 = new JLabel();
        this.$$$loadLabelText$$$(jLabel13, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Comment for user"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel30.add((Component)jLabel13, gridBagConstraints);
        JPanel jPanel34 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel30.add((Component)jPanel34, gridBagConstraints);
        JPanel jPanel35 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        jPanel30.add((Component)jPanel35, gridBagConstraints);
        jLabel.setLabelFor(this.loginTextField);
        jLabel2.setLabelFor(this.paymentDocumentNumberTextField);
        jLabel3.setLabelFor(this.paymentMethodComboBox);
        jLabel6.setLabelFor(this.sumTextField);
        jLabel7.setLabelFor(this.accountComboBox);
        jLabel8.setLabelFor(this.currencyComboBox);
        jLabel9.setLabelFor(this.paymentDocumentNumberTextField);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

