/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.adddealerframe;

import biz.netup.projects.utmadmin.functions.dealer.adddealer.adddealer.AddDealerFunction;
import biz.netup.projects.utmadmin.functions.objects.AddressWithMask;
import biz.netup.projects.utmadmin.functions.objects.UTMDealer;
import biz.netup.projects.utmadmin.gui.adddealerframe.BottomButtons;
import biz.netup.projects.utmadmin.gui.dealerframe.DealerFrame;
import biz.netup.projects.utmadmin.gui.dealerframe.forms.dealer.DealerAdditionalTab;
import biz.netup.projects.utmadmin.gui.dealerframe.forms.dealer.DealerContactsTab;
import biz.netup.projects.utmadmin.gui.dealerframe.forms.dealer.DealerMainTab;
import biz.netup.projects.utmadmin.gui.mainframe.MainFrame;
import biz.netup.utmutils.control.Checkers;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.tab.TabPanel;
import biz.netup.utmutils.swing.tabbedwindow.TabbedWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.KeyStroke;

public class AddDealerDialog
extends TabbedWindow {
    private JButton buttonOK;
    private JButton buttonCancel;
    private JButton applyButton;
    private BottomButtons bb;
    private DealerMainTab main;
    private DealerAdditionalTab additional;
    private DealerContactsTab contacts;

    public AddDealerDialog() {
        this.main.setIP6AddressTextField("0::/128");
        this.main.setIP4AddressTextField("0.0.0.0/32");
        this.main.addDealerModeOn();
        String string = Resolve.getPassword();
        this.main.setGenPassTextField(string);
        this.main.setPasswordField(string);
        this.main.setConfirmPasswordField(string);
        this.additional = new DealerAdditionalTab();
        this.contacts = new DealerContactsTab();
    }

    private void applyDealer() {
        int n = 0;
        if (this.propertiesIsOk()) {
            n = AddDealerFunction.addDealer(this.getDealerData());
        }
        if (n != 0) {
            this.dispose();
            DealerFrame dealerFrame = new DealerFrame(n);
            dealerFrame.setVisible(true);
        }
    }

    private void onOK() {
        if (this.propertiesIsOk() && AddDealerFunction.addDealer(this.getDealerData()) != 0) {
            MainFrame.getInstance().refreshDealers();
            this.dispose();
        }
    }

    private UTMDealer getDealerData() {
        AddressWithMask addressWithMask;
        UTMDealer uTMDealer = new UTMDealer();
        uTMDealer.login = this.main.getLogin();
        uTMDealer.password = this.main.getPassword();
        uTMDealer.fullName = this.main.getFullName();
        uTMDealer.actAddress = this.contacts.getActualAddress();
        uTMDealer.passport = this.additional.getPassport();
        uTMDealer.workTel = this.contacts.getWorkPhone();
        uTMDealer.homeTel = this.contacts.getHomePhone();
        uTMDealer.mobTel = this.contacts.getMobilePhone();
        uTMDealer.webPage = this.contacts.getWebPage();
        uTMDealer.icqNumber = this.contacts.getIcqNumber();
        uTMDealer.email = this.contacts.getEmail();
        uTMDealer.comments = this.additional.getComments();
        try {
            addressWithMask = Resolve.SubnetFromView(this.main.getIP4AddressTextField());
            uTMDealer.ipAddress4 = addressWithMask.address;
            uTMDealer.mask4 = addressWithMask.mask;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            addressWithMask = Resolve.SubnetFromView(this.main.getIP6AddressTextField());
            uTMDealer.ipAddress6 = addressWithMask.address;
            uTMDealer.mask6 = addressWithMask.mask;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return uTMDealer;
    }

    private boolean propertiesIsOk() {
        if (!this.loginIsOk()) {
            Dialogs.showErrorDialog("Login is incorrect");
            this.setTab(this.main, this.main.getSideMenuItem());
            return false;
        }
        if (this.main.getPassword().compareTo(this.main.getConfirmPassword()) != 0) {
            Dialogs.showErrorDialog("Password doesn't match");
            this.setTab(this.main, this.main.getSideMenuItem());
            return false;
        }
        return true;
    }

    private boolean loginIsOk() {
        if (this.main.getLogin().length() == 0) {
            return false;
        }
        return Checkers.loginOk(this.main.getLogin());
    }

    private void onCancel() {
        this.dispose();
    }

    @Override
    protected Component getBottomPanel() {
        return this.bb.getPanel();
    }

    private void initButtons() {
        this.buttonOK = this.bb.getButtonOK();
        this.buttonCancel = this.bb.getButtonCancel();
        this.applyButton = this.bb.getApplyButton();
    }

    @Override
    protected void init() {
        this.bb = new BottomButtons();
        this.initButtons();
        this.main = new DealerMainTab();
        this.additional = new DealerAdditionalTab();
        this.contacts = new DealerContactsTab();
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddDealerDialog.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddDealerDialog.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AddDealerDialog.this.onCancel();
            }
        });
        this.mainPanel.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddDealerDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddDealerDialog.this.applyDealer();
            }
        });
    }

    @Override
    protected Dimension getWindowSize() {
        return new Dimension(950, 600);
    }

    @Override
    protected String getWindowTitle() {
        return "Add dealer";
    }

    @Override
    protected Vector<TabPanel> getTabPanels() {
        Vector<TabPanel> vector = new Vector<TabPanel>();
        vector.add(this.main);
        vector.add(this.additional);
        vector.add(this.contacts);
        return vector;
    }
}

