/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.functions.dealer.user.doc;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetDocument;
import biz.netup.control.transport.urfa.functions.UrfaGetDocument;
import biz.netup.control.transport.urfa.functions.UrfaRemoveDocument;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.utmutils.control.Logger;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.localization.ResourceBundleWrapper;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DocFunctions {
    public static final int BILL = 1;
    public static final int INVOICE = 2;
    public static final int USER_INFO = 3;
    public static final int CERTIFICATE_OF_COMPLETION = 4;
    public static final int RECEIPT = 5;
    public static final int CONTRACT = 6;
    public static final int BILL_DETAILS = 7;
    public static final int FILE_ODT = 0;
    public static final int FILE_PDF = 1;
    private static final Logger logger = Utils.getLogger();
    private static final ResourceBundleWrapper resource = Utils.getResource();

    private static boolean runCommand(String string, String string2) {
        String[] stringArray = new String[]{string, string2};
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            if (process == null) {
                return false;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private static String getDocPrefix(int n) {
        switch (n) {
            case 1: {
                return "bill_";
            }
            case 2: {
                return "invoice_";
            }
            case 3: {
                return "info_";
            }
            case 4: {
                return "completion_";
            }
            case 5: {
                return "receipt_";
            }
            case 6: {
                return "contract_";
            }
            case 7: {
                return "details_";
            }
        }
        return "doc_";
    }

    private static void openDocument(int n, byte[] byArray) {
        String string;
        if (byArray.length < 16) {
            logger.log(1, resource.getString("Invalid document format"));
        }
        if (byArray[0] == 80 && byArray[1] == 75) {
            string = ".odt";
        } else if (byArray[0] == 37 && byArray[1] == 80 && byArray[2] == 68 && byArray[3] == 70) {
            string = ".pdf";
        } else {
            logger.log(1, resource.getString("Unsupported document format"));
            return;
        }
        try {
            File file = File.createTempFile(DocFunctions.getDocPrefix(n), string);
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().open(file);
            } else {
                if (DocFunctions.runCommand("kde-open", file.getAbsolutePath())) {
                    return;
                }
                if (DocFunctions.runCommand("gnome-open", file.getAbsolutePath())) {
                    return;
                }
                if (DocFunctions.runCommand("xdg-open", file.getAbsolutePath())) {
                    return;
                }
                Dialogs.showErrorDialog("Cant open file");
            }
        }
        catch (IOException iOException) {
            logger.error(iOException);
        }
    }

    public static void openDocument(byte[] byArray) {
        DocFunctions.openDocument(6, byArray);
    }

    public static void openDocument(int n, int n2, int n3) throws UrfaException {
        if (UrfaManagerImpl.getInstance().isPermitted(17952)) {
            UrfaGetDocument urfaGetDocument = new UrfaGetDocument(UrfaManagerImpl.getInstance());
            urfaGetDocument.setUserId(n);
            urfaGetDocument.setDocType(n2);
            urfaGetDocument.setBaseId(n3);
            urfaGetDocument.setFileType(1);
            urfaGetDocument.call();
            if (urfaGetDocument.getResult() != 0) {
                throw new UrfaException(resource.getString("Unable to create document"));
            }
            DocFunctions.openDocument(n2, urfaGetDocument.getDocData());
        } else if (UrfaManagerImpl.getInstance().isPermitted(0x7000007B)) {
            UrfaDealerGetDocument urfaDealerGetDocument = new UrfaDealerGetDocument(UrfaManagerImpl.getInstance());
            urfaDealerGetDocument.setUserId(n);
            urfaDealerGetDocument.setDocType(n2);
            urfaDealerGetDocument.setBaseId(n3);
            urfaDealerGetDocument.setFileType(1);
            urfaDealerGetDocument.call();
            if (urfaDealerGetDocument.getResult() != 0) {
                throw new UrfaException(resource.getString("Unable to create document"));
            }
            DocFunctions.openDocument(n2, urfaDealerGetDocument.getDocData());
        } else {
            throw new UrfaException(resource.getString("Not permitted to create document"));
        }
    }

    public static void openDocument(int n, int n2, int n3, int n4) throws UrfaException {
        if (UrfaManagerImpl.getInstance().isPermitted(17952)) {
            UrfaGetDocument urfaGetDocument = new UrfaGetDocument(UrfaManagerImpl.getInstance());
            urfaGetDocument.setUserId(n);
            urfaGetDocument.setDocType(n2);
            urfaGetDocument.setBaseId(n3);
            urfaGetDocument.setFileType(n4);
            urfaGetDocument.call();
            if (urfaGetDocument.getResult() != 0) {
                throw new UrfaException(resource.getString("Unable to create document"));
            }
            DocFunctions.openDocument(n2, urfaGetDocument.getDocData());
        } else if (UrfaManagerImpl.getInstance().isPermitted(0x7000007B)) {
            UrfaDealerGetDocument urfaDealerGetDocument = new UrfaDealerGetDocument(UrfaManagerImpl.getInstance());
            urfaDealerGetDocument.setUserId(n);
            urfaDealerGetDocument.setDocType(n2);
            urfaDealerGetDocument.setBaseId(n3);
            urfaDealerGetDocument.setFileType(n4);
            urfaDealerGetDocument.call();
            if (urfaDealerGetDocument.getResult() != 0) {
                throw new UrfaException(resource.getString("Unable to create document"));
            }
            DocFunctions.openDocument(n2, urfaDealerGetDocument.getDocData());
        } else {
            throw new UrfaException(resource.getString("Not permitted to create document"));
        }
    }

    public static void deleteDocument(int n, int n2, int n3) throws UrfaException {
        if (UrfaManagerImpl.getInstance().isPermitted(17954)) {
            UrfaRemoveDocument urfaRemoveDocument = new UrfaRemoveDocument(UrfaManagerImpl.getInstance());
            urfaRemoveDocument.setUserId(n);
            urfaRemoveDocument.setDocType(n2);
            urfaRemoveDocument.setBaseId(n3);
            urfaRemoveDocument.call();
            if (urfaRemoveDocument.getResult() != 0) {
                throw new UrfaException(resource.getString("Unable to remove document"));
            }
        } else {
            throw new UrfaException(resource.getString("Not permitted to create document"));
        }
    }

    public static void saveDocument(File file, int n, int n2, int n3, int n4) throws UrfaException {
        if (UrfaManagerImpl.getInstance().isPermitted(17952)) {
            String string;
            UrfaGetDocument urfaGetDocument = new UrfaGetDocument(UrfaManagerImpl.getInstance());
            urfaGetDocument.setUserId(n);
            urfaGetDocument.setDocType(n2);
            urfaGetDocument.setBaseId(n3);
            urfaGetDocument.setFileType(n4);
            urfaGetDocument.call();
            if (urfaGetDocument.getResult() != 0) {
                throw new UrfaException(resource.getString("Unable to create document"));
            }
            byte[] byArray = urfaGetDocument.getDocData();
            if (byArray[0] == 80 && byArray[1] == 75) {
                string = ".odt";
            } else if (byArray[0] == 37 && byArray[1] == 80 && byArray[2] == 68 && byArray[3] == 70) {
                string = ".pdf";
            } else {
                return;
            }
            File file2 = new File(file, DocFunctions.getDocPrefix(n2) + n3 + string);
            if (file2.exists() && !Dialogs.showYesNoDialog(resource.getString("File") + " " + file2.getPath() + " " + resource.getString("exists. Rewrite?"))) {
                return;
            }
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                fileOutputStream.write(byArray);
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
        } else {
            throw new UrfaException(resource.getString("Not permitted to create document"));
        }
    }

    public static Map<Integer, String> getDocTypeList() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(1, "Bill");
        hashMap.put(7, "Bill details");
        hashMap.put(4, "Certificate of completion");
        hashMap.put(6, "Contract");
        hashMap.put(2, "TAX invoice");
        hashMap.put(5, "Receipt");
        hashMap.put(3, "User info sheet");
        return hashMap;
    }
}

