/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.functions.dealer.custom;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaDealerDeleteServiceLink;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetAllServicesForUser;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetDialupService;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetHotspotService;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetIptrafficService;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetIptvService;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetOnceService;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetPeriodicService;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetServicesList;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetTariffServicesForUser;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetTelephonyService;
import biz.netup.control.transport.urfa.functions.UrfaDeleteSlink;
import biz.netup.control.transport.urfa.functions.UrfaDeleteSlinkRadiusSession;
import biz.netup.control.transport.urfa.functions.UrfaGetAllServicesForUser;
import biz.netup.control.transport.urfa.functions.UrfaGetDialupServiceEx;
import biz.netup.control.transport.urfa.functions.UrfaGetHotspotServiceEx;
import biz.netup.control.transport.urfa.functions.UrfaGetIptrafficServiceEx;
import biz.netup.control.transport.urfa.functions.UrfaGetIptvService;
import biz.netup.control.transport.urfa.functions.UrfaGetOnceServiceNew;
import biz.netup.control.transport.urfa.functions.UrfaGetPeriodicServiceEx;
import biz.netup.control.transport.urfa.functions.UrfaGetServicesList;
import biz.netup.control.transport.urfa.functions.UrfaGetTelService;
import biz.netup.control.transport.urfa.functions.UrfaGetTpsForUser;
import biz.netup.control.transport.urfa.functions.UrfaGetVodService;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.objects.SLink;
import biz.netup.projects.utmadmin.functions.objects.UTMService;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.types.ServiceType;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JOptionPane;

public class ServiceFunctions {
    public static UTMService[] getServicesList(int n) throws UrfaException {
        if (Utils.isAdmin()) {
            UrfaGetServicesList urfaGetServicesList = new UrfaGetServicesList(UrfaManagerImpl.getInstance());
            urfaGetServicesList.setWhichService(-1);
            urfaGetServicesList.call();
            UTMService[] uTMServiceArray = new UTMService[urfaGetServicesList.getServicesCount()];
            for (int i = 0; i < urfaGetServicesList.getServicesCount(); ++i) {
                uTMServiceArray[i] = new UTMService();
                uTMServiceArray[i].setServiceComment(urfaGetServicesList.getServiceCommentArray1()[i]);
                uTMServiceArray[i].setServiceId(urfaGetServicesList.getServiceIdArray1()[i]);
                uTMServiceArray[i].setServiceName(urfaGetServicesList.getServiceNameArray1()[i]);
                uTMServiceArray[i].setServiceStatus(urfaGetServicesList.getServiceStatusArray1()[i]);
                uTMServiceArray[i].setServiceType(urfaGetServicesList.getServiceTypeArray1()[i]);
                uTMServiceArray[i].setTariffName(urfaGetServicesList.getTariffNameArray1()[i]);
            }
            return uTMServiceArray;
        }
        UrfaDealerGetServicesList urfaDealerGetServicesList = new UrfaDealerGetServicesList(UrfaManagerImpl.getInstance());
        urfaDealerGetServicesList.setServiceType(n);
        urfaDealerGetServicesList.call();
        UTMService[] uTMServiceArray = new UTMService[urfaDealerGetServicesList.getServicesCount()];
        for (int i = 0; i < urfaDealerGetServicesList.getServicesCount(); ++i) {
            uTMServiceArray[i] = new UTMService();
            uTMServiceArray[i].setServiceComment(urfaDealerGetServicesList.getServiceCommentArray1()[i]);
            uTMServiceArray[i].setServiceId(urfaDealerGetServicesList.getServiceIdArray1()[i]);
            uTMServiceArray[i].setServiceName(urfaDealerGetServicesList.getServiceNameArray1()[i]);
            uTMServiceArray[i].setServiceStatus(urfaDealerGetServicesList.getServiceStatusArray1()[i]);
            uTMServiceArray[i].setServiceType(urfaDealerGetServicesList.getServiceTypeArray1()[i]);
            uTMServiceArray[i].setTariffName(urfaDealerGetServicesList.getTariffNameArray1()[i]);
        }
        return uTMServiceArray;
    }

    public static SLink[] getSLinksList(int n) throws UrfaException {
        if (Utils.isAdmin()) {
            UrfaGetAllServicesForUser urfaGetAllServicesForUser = new UrfaGetAllServicesForUser(UrfaManagerImpl.getInstance());
            urfaGetAllServicesForUser.setAccountId(n);
            urfaGetAllServicesForUser.call();
            SLink[] sLinkArray = new SLink[urfaGetAllServicesForUser.getSlinkIdCount()];
            for (int i = 0; i < urfaGetAllServicesForUser.getSlinkIdCount(); ++i) {
                sLinkArray[i] = new SLink();
                sLinkArray[i].setDiscountPeriodId(urfaGetAllServicesForUser.getDiscountPeriodIdArray1()[i]);
                sLinkArray[i].setServiceCost(urfaGetAllServicesForUser.getServiceCostArray1()[i]);
                sLinkArray[i].setServiceId(urfaGetAllServicesForUser.getServiceIdArray1()[i]);
                sLinkArray[i].setServiceName(urfaGetAllServicesForUser.getServiceNameArray1()[i]);
                sLinkArray[i].setServiceType(urfaGetAllServicesForUser.getServiceTypeArray1()[i]);
                sLinkArray[i].setSlinkId(urfaGetAllServicesForUser.getSlinkIdArray1()[i]);
                sLinkArray[i].setTariffName(urfaGetAllServicesForUser.getTariffNameArray1()[i]);
            }
            return sLinkArray;
        }
        UrfaDealerGetAllServicesForUser urfaDealerGetAllServicesForUser = new UrfaDealerGetAllServicesForUser(UrfaManagerImpl.getInstance());
        urfaDealerGetAllServicesForUser.setAccountId(n);
        urfaDealerGetAllServicesForUser.call();
        SLink[] sLinkArray = new SLink[urfaDealerGetAllServicesForUser.getSlinkIdCount()];
        for (int i = 0; i < urfaDealerGetAllServicesForUser.getSlinkIdCount(); ++i) {
            sLinkArray[i] = new SLink();
            sLinkArray[i].setDiscountPeriodId(urfaDealerGetAllServicesForUser.getDiscountPeriodIdArray1()[i]);
            sLinkArray[i].setServiceCost(urfaDealerGetAllServicesForUser.getServiceCostArray1()[i]);
            sLinkArray[i].setServiceId(urfaDealerGetAllServicesForUser.getServiceIdArray1()[i]);
            sLinkArray[i].setServiceName(urfaDealerGetAllServicesForUser.getServiceNameArray1()[i]);
            sLinkArray[i].setServiceType(urfaDealerGetAllServicesForUser.getServiceTypeArray1()[i]);
            sLinkArray[i].setSlinkId(urfaDealerGetAllServicesForUser.getSlinkIdArray1()[i]);
            sLinkArray[i].setTariffName(urfaDealerGetAllServicesForUser.getTariffNameArray1()[i]);
        }
        return sLinkArray;
    }

    public static Vector<Map<String, Object>> getSLinksListForTable(int n) throws UrfaException {
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        SLink[] sLinkArray = ServiceFunctions.getSLinksList(n);
        for (int i = 0; i < sLinkArray.length; ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("service_id", sLinkArray[i].getServiceId());
            hashMap.put("service_name", sLinkArray[i].getServiceName());
            hashMap.put("service_type", ServiceType.getName(sLinkArray[i].getServiceType()));
            hashMap.put("service_type_id", sLinkArray[i].getServiceType());
            switch (sLinkArray[i].getServiceType()) {
                case 1: 
                case 2: 
                case 4: {
                    hashMap.put("radius", 0);
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    hashMap.put("radius", 1);
                }
            }
            hashMap.put("in_tariff_plan", sLinkArray[i].getTariffName());
            hashMap.put("basic_price", sLinkArray[i].getServiceCost());
            hashMap.put("slink_id", sLinkArray[i].getSlinkId());
            hashMap.put("accounting_period_id", sLinkArray[i].getDiscountPeriodId());
            vector.add(hashMap);
        }
        return vector;
    }

    public static Vector<Map<String, Object>> getServicesListForTable(int n) {
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        try {
            UTMService[] uTMServiceArray = ServiceFunctions.getServicesList(n);
            for (int i = 0; i < uTMServiceArray.length; ++i) {
                if (uTMServiceArray[i].getServiceStatus() != 0) continue;
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("service_id", uTMServiceArray[i].getServiceId());
                hashMap.put("service_name", uTMServiceArray[i].getServiceName());
                hashMap.put("service_type", ServiceType.getName(uTMServiceArray[i].getServiceType()));
                hashMap.put("comment", uTMServiceArray[i].getServiceComment());
                hashMap.put("tariff_name", uTMServiceArray[i].getTariffName());
                vector.add(hashMap);
            }
        }
        catch (UrfaException urfaException) {
            urfaException.printStackTrace();
        }
        return vector;
    }

    public static void deleteSlink(Integer n, String string) {
        if (Utils.isAdmin()) {
            Object object;
            if (string.equals("IP traffic")) {
                object = new UrfaDeleteSlinkRadiusSession(UrfaManagerImpl.getInstance());
                ((UrfaDeleteSlinkRadiusSession)object).setSlinkId(n);
                try {
                    ((UrfaDeleteSlinkRadiusSession)object).call();
                }
                catch (UrfaException urfaException) {
                    // empty catch block
                }
            }
            object = new UrfaDeleteSlink(UrfaManagerImpl.getInstance());
            ((UrfaDeleteSlink)object).setSlinkId(n);
            try {
                ((UrfaDeleteSlink)object).call();
            }
            catch (UrfaException urfaException) {
                JOptionPane.showMessageDialog(null, "Error deleting slink SlinkID = " + n + ": \n" + urfaException.getMessage(), "Error", 0);
            }
        } else {
            UrfaDealerDeleteServiceLink urfaDealerDeleteServiceLink = new UrfaDealerDeleteServiceLink(UrfaManagerImpl.getInstance());
            urfaDealerDeleteServiceLink.setSlinkId(n);
            try {
                urfaDealerDeleteServiceLink.call();
            }
            catch (UrfaException urfaException) {
                JOptionPane.showMessageDialog(null, "Error deleting slink SlinkID = " + n + ": \n" + urfaException.getMessage(), "Error", 0);
            }
        }
    }

    public static Vector<Map<String, Object>> getTlinkServicesList(int n, int n2, int n3) {
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        if (Utils.isAdmin()) {
            UrfaGetTpsForUser urfaGetTpsForUser = new UrfaGetTpsForUser(UrfaManagerImpl.getInstance());
            urfaGetTpsForUser.setUid(n);
            urfaGetTpsForUser.setAid(n2);
            urfaGetTpsForUser.setTplink(n3);
            try {
                urfaGetTpsForUser.call();
                for (int i = 0; i < urfaGetTpsForUser.getServiceSize(); ++i) {
                    if (urfaGetTpsForUser.getSlink1()[i] != 0) continue;
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("service_id", urfaGetTpsForUser.getSid1()[i]);
                    hashMap.put("service_name", urfaGetTpsForUser.getServiceName1()[i]);
                    hashMap.put("service_type", ServiceType.getName(urfaGetTpsForUser.getServiceType1()[i]));
                    hashMap.put("comment", urfaGetTpsForUser.getComment1()[i]);
                    vector.add(hashMap);
                }
            }
            catch (UrfaException urfaException) {
                urfaException.printStackTrace();
            }
        } else {
            UrfaDealerGetTariffServicesForUser urfaDealerGetTariffServicesForUser = new UrfaDealerGetTariffServicesForUser(UrfaManagerImpl.getInstance());
            urfaDealerGetTariffServicesForUser.setUserId(n);
            urfaDealerGetTariffServicesForUser.setAccountId(n2);
            urfaDealerGetTariffServicesForUser.setTplinkId(n3);
            try {
                urfaDealerGetTariffServicesForUser.call();
                for (int i = 0; i < urfaDealerGetTariffServicesForUser.getServicesArraySize(); ++i) {
                    if (urfaDealerGetTariffServicesForUser.getIsLinkedArray1()[i] != 0 || urfaDealerGetTariffServicesForUser.getSlinkIdArray1()[i] != 0) continue;
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("service_id", urfaDealerGetTariffServicesForUser.getServiceIdArray1()[i]);
                    hashMap.put("service_name", urfaDealerGetTariffServicesForUser.getServiceNameArray1()[i]);
                    hashMap.put("service_type", ServiceType.getName(urfaDealerGetTariffServicesForUser.getServiceTypeArray1()[i]));
                    hashMap.put("comment", urfaDealerGetTariffServicesForUser.getServiceCommentArray1()[i]);
                    vector.add(hashMap);
                }
            }
            catch (UrfaException urfaException) {
                urfaException.printStackTrace();
            }
        }
        return vector;
    }

    public static boolean isLinkByDefault(int n, int n2) {
        if (Utils.isAdmin()) {
            try {
                if (n2 == 1) {
                    UrfaGetOnceServiceNew urfaGetOnceServiceNew = new UrfaGetOnceServiceNew(UrfaManagerImpl.getInstance());
                    urfaGetOnceServiceNew.setSid(n);
                    urfaGetOnceServiceNew.call();
                    return urfaGetOnceServiceNew.getLinkByDefault() == 1;
                }
                if (n2 == 2) {
                    UrfaGetPeriodicServiceEx urfaGetPeriodicServiceEx = new UrfaGetPeriodicServiceEx(UrfaManagerImpl.getInstance());
                    urfaGetPeriodicServiceEx.setSid(n);
                    urfaGetPeriodicServiceEx.call();
                    return urfaGetPeriodicServiceEx.getLinkByDefault() == 1;
                }
                if (n2 == 3) {
                    UrfaGetIptrafficServiceEx urfaGetIptrafficServiceEx = new UrfaGetIptrafficServiceEx(UrfaManagerImpl.getInstance());
                    urfaGetIptrafficServiceEx.setSid(n);
                    urfaGetIptrafficServiceEx.call();
                    return urfaGetIptrafficServiceEx.getLinkByDefault() == 1;
                }
                if (n2 == 4) {
                    UrfaGetHotspotServiceEx urfaGetHotspotServiceEx = new UrfaGetHotspotServiceEx(UrfaManagerImpl.getInstance());
                    urfaGetHotspotServiceEx.setSid(n);
                    urfaGetHotspotServiceEx.call();
                    return urfaGetHotspotServiceEx.getLinkByDefault() == 1;
                }
                if (n2 == 5) {
                    UrfaGetDialupServiceEx urfaGetDialupServiceEx = new UrfaGetDialupServiceEx(UrfaManagerImpl.getInstance());
                    urfaGetDialupServiceEx.setSid(n);
                    urfaGetDialupServiceEx.call();
                    return urfaGetDialupServiceEx.getLinkByDefault() == 1;
                }
                if (n2 == 6) {
                    UrfaGetTelService urfaGetTelService = new UrfaGetTelService(UrfaManagerImpl.getInstance());
                    urfaGetTelService.setServiceId(n);
                    urfaGetTelService.call();
                    return urfaGetTelService.getLinkByDefault() == 1;
                }
                if (n2 == 8) {
                    UrfaGetIptvService urfaGetIptvService = new UrfaGetIptvService(UrfaManagerImpl.getInstance());
                    urfaGetIptvService.setServiceId(n);
                    urfaGetIptvService.call();
                    return urfaGetIptvService.getLinkByDefault() == 1;
                }
                if (n2 == 9) {
                    UrfaGetVodService urfaGetVodService = new UrfaGetVodService(UrfaManagerImpl.getInstance());
                    urfaGetVodService.setServiceId(n);
                    urfaGetVodService.call();
                    return urfaGetVodService.getLinkByDefault() == 1;
                }
            }
            catch (UrfaException urfaException) {
                // empty catch block
            }
            return false;
        }
        try {
            if (n2 == 1) {
                UrfaDealerGetOnceService urfaDealerGetOnceService = new UrfaDealerGetOnceService(UrfaManagerImpl.getInstance());
                urfaDealerGetOnceService.setServiceId(n);
                urfaDealerGetOnceService.call();
                return urfaDealerGetOnceService.getLinkByDefault() == 1;
            }
            if (n2 == 2) {
                UrfaDealerGetPeriodicService urfaDealerGetPeriodicService = new UrfaDealerGetPeriodicService(UrfaManagerImpl.getInstance());
                urfaDealerGetPeriodicService.setServiceId(n);
                urfaDealerGetPeriodicService.call();
                return urfaDealerGetPeriodicService.getLinkByDefault() == 1;
            }
            if (n2 == 3) {
                UrfaDealerGetIptrafficService urfaDealerGetIptrafficService = new UrfaDealerGetIptrafficService(UrfaManagerImpl.getInstance());
                urfaDealerGetIptrafficService.setServiceId(n);
                urfaDealerGetIptrafficService.call();
                return urfaDealerGetIptrafficService.getLinkByDefault() == 1;
            }
            if (n2 == 4) {
                UrfaDealerGetHotspotService urfaDealerGetHotspotService = new UrfaDealerGetHotspotService(UrfaManagerImpl.getInstance());
                urfaDealerGetHotspotService.setServiceId(n);
                urfaDealerGetHotspotService.call();
                return urfaDealerGetHotspotService.getLinkByDefault() == 1;
            }
            if (n2 == 5) {
                UrfaDealerGetDialupService urfaDealerGetDialupService = new UrfaDealerGetDialupService(UrfaManagerImpl.getInstance());
                urfaDealerGetDialupService.setServiceId(n);
                urfaDealerGetDialupService.call();
                return urfaDealerGetDialupService.getLinkByDefault() == 1;
            }
            if (n2 == 6) {
                UrfaDealerGetTelephonyService urfaDealerGetTelephonyService = new UrfaDealerGetTelephonyService(UrfaManagerImpl.getInstance());
                urfaDealerGetTelephonyService.setServiceId(n);
                urfaDealerGetTelephonyService.call();
                return urfaDealerGetTelephonyService.getLinkByDefault() == 1;
            }
            if (n2 == 8) {
                UrfaDealerGetIptvService urfaDealerGetIptvService = new UrfaDealerGetIptvService(UrfaManagerImpl.getInstance());
                urfaDealerGetIptvService.setServiceId(n);
                urfaDealerGetIptvService.call();
                return urfaDealerGetIptvService.getLinkByDefault() == 1;
            }
        }
        catch (UrfaException urfaException) {
            // empty catch block
        }
        return false;
    }
}

