/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.xml.parser.impl;

import biz.netup.control.event.Transaction;
import biz.netup.control.handler.TransactionListenerException;
import biz.netup.control.xml.parser.AbstractXMLParser;
import biz.netup.control.xml.parser.XMLParserException;
import biz.netup.control.xml.parser.impl.TransactionParser;
import biz.netup.control.xml.parser.impl.XmlInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class TransactionStreamParser
extends AbstractXMLParser {
    @Override
    public void parse(InputStream inputStream) throws IOException {
        XmlInputStream xmlInputStream = new XmlInputStream(inputStream);
        while (xmlInputStream.valid()) {
            TransactionParser transactionParser = null;
            try {
                transactionParser = new TransactionParser();
            }
            catch (SAXException sAXException) {
                throw new RuntimeException(sAXException);
            }
            xmlInputStream.resetEos();
            try {
                Transaction transaction = transactionParser.getTransaction(xmlInputStream);
                if (transaction.getTransactionSize() == 0) {
                    this.fireException(new XMLParserException("Transaction is empty"));
                    continue;
                }
                if (this.transactionListener == null) continue;
                try {
                    this.transactionListener.onTransaction(transaction);
                }
                catch (TransactionListenerException transactionListenerException) {
                    this.fireException(new XMLParserException(transactionListenerException));
                }
            }
            catch (SAXException sAXException) {
                this.fireException(new XMLParserException(sAXException));
            }
            catch (UTFDataFormatException uTFDataFormatException) {
                this.fireException(new XMLParserException(uTFDataFormatException));
            }
        }
    }

    private void fireException(XMLParserException xMLParserException) {
        if (null != this.exceptionListener) {
            this.exceptionListener.onException(xMLParserException);
        } else {
            Logger.getLogger(TransactionStreamParser.class).error(xMLParserException);
        }
    }

    @Override
    protected AbstractXMLParser newXMLParser() {
        return new TransactionStreamParser();
    }
}

